/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctf.formplugin.regulatorylibrary;

import java.util.EventObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctf.business.groupknowledge.GroupKnowledgeBusinessImpl;
import org.apache.commons.lang3.ObjectUtils;

public class GroupKnowledgePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static String LARGETEXT_TAG = "largetext_tag";
    private static String TEXT = "text";
    private static String ORG = "org";
    private static String ORGFIELD = "orgfield";
    private static String ORGAN = "organ";
    private static String KNOWLEDGETAGS = "mulknowledgetags";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit knowledgetagsEdit = (BasedataEdit)this.getView().getControl(KNOWLEDGETAGS);
        knowledgetagsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
        edit.setText((String)this.getModel().getValue(LARGETEXT_TAG));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object org = this.getModel().getValue(ORG);
        this.getModel().setValue(ORGFIELD, org);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String key = operate.getOperateKey();
        if (key.equalsIgnoreCase("save") || key.equalsIgnoreCase("submit")) {
            RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
            this.getModel().setValue(LARGETEXT_TAG, (Object)edit.getText());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ORGFIELD.equalsIgnoreCase(name)) {
            Object org = this.getModel().getValue(ORGFIELD);
            this.getModel().setValue(ORG, org);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String name;
        Long orgId;
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject dyo = GroupKnowledgeBusinessImpl.queryUserOrgIdByUserId(currUserId);
        if (ObjectUtils.isEmpty((Object)dyo)) {
            dyo = GroupKnowledgeBusinessImpl.setDefaltOrg();
            orgId = dyo.getLong("id");
            name = dyo.getString("name");
        } else {
            orgId = dyo.getLong("dpt.id");
            name = dyo.getString("dpt.name");
        }
        this.getModel().setValue(ORG, (Object)orgId);
        this.getModel().setValue(ORGAN, (Object)name);
        this.getModel().setValue(ORGFIELD, (Object)orgId);
        this.getModel().setValue(ORGAN, (Object)name);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (fieldKey.equalsIgnoreCase(KNOWLEDGETAGS)) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("longnumber", "like", (Object)"taxfile%"));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.longnumber", "like", (Object)"taxfile%"));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        }
    }
}

