/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AnalysisSchemeSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String msg;
            DynamicObject currentObj = dataEntity.getDataEntity();
            Date startdate = currentObj.getDate("startdate");
            Date enddate = currentObj.getDate("enddate");
            if (startdate == null || enddate == null) {
                String msg2 = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisSchemeSaveValidator_0", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg2);
                return;
            }
            DynamicObjectCollection colls = this.querySchemeObj(currentObj.getLong("id"), startdate, enddate);
            if (colls != null && colls.size() > 0) {
                String msg3 = ResManager.loadKDString((String)"\u540c\u4e00\u6709\u6548\u671f\u5185\u4e0d\u80fd\u5b58\u5728\u4e24\u6761\u542f\u7528\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"AnalysisSchemeSaveValidator_1", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg3);
                return;
            }
            DynamicObjectCollection entryentity = (DynamicObjectCollection)currentObj.get("entryentity");
            if (entryentity == null || entryentity.size() == 0) {
                String msg4 = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u4e0e\u98ce\u9669\u5f97\u5206\u5206\u6790\u7684\u6307\u6807\u3002", (String)"AnalysisSchemeSaveValidator_2", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg4);
                return;
            }
            BigDecimal sumvalue = BigDecimal.ZERO;
            BigDecimal maxvalue = new BigDecimal(100);
            ArrayList<String> unsetrows = new ArrayList<String>();
            HashMap<String, String> riskmap = new HashMap<String, String>(entryentity.size());
            for (DynamicObject entry : entryentity) {
                BigDecimal percent = entry.getBigDecimal("percent");
                String risknumber = entry.getString("riskdefinition.number");
                String riskname = entry.getString("riskdefinition.name");
                if (riskmap.containsKey(risknumber)) {
                    String msg5 = String.format(ResManager.loadKDString((String)"%s: \u98ce\u9669\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"AnalysisSchemeSaveValidator_3", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]), risknumber);
                    this.addErrorMessage(dataEntity, msg5);
                    return;
                }
                riskmap.put(risknumber, riskname);
                if (percent.compareTo(BigDecimal.ZERO) == 0) {
                    unsetrows.add(entry.getString("riskdefinition.id"));
                    continue;
                }
                sumvalue = sumvalue.add(percent);
            }
            if (sumvalue.compareTo(maxvalue) > 0) {
                msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u6743\u91cd\u4e4b\u548c\u5927\u4e8e100%\u3002", (String)"AnalysisSchemeSaveValidator_4", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            if (sumvalue.compareTo(maxvalue) == 0 && unsetrows.size() > 0) {
                msg = ResManager.loadKDString((String)"\u6743\u91cd\u5408\u8ba1\u5df2\u4e3a100%\uff0c\u4e0d\u518d\u5141\u8bb8\u5b58\u5728\u6743\u91cd\u4e3a\u7a7a\u7684\u8bb0\u5f55\u3002", (String)"AnalysisSchemeSaveValidator_5", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            if (unsetrows.size() > 0) {
                BigDecimal unsetsize;
                BigDecimal othervalue = maxvalue.subtract(sumvalue).setScale(2, 4);
                BigDecimal itempercent = othervalue.divide(unsetsize = new BigDecimal(unsetrows.size()).setScale(2, 4), 2, 4).setScale(2, 4);
                if (itempercent.compareTo(BigDecimal.ZERO) != 0 && this.setItemPercent(itempercent, unsetrows, entryentity, othervalue)) continue;
                String msg6 = ResManager.loadKDString((String)"\u98ce\u9669\u6307\u6807\u6743\u91cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AnalysisSchemeSaveValidator_7", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg6);
                return;
            }
            if (sumvalue.compareTo(maxvalue) == 0) continue;
            msg = ResManager.loadKDString((String)"\u6743\u91cd\u4e4b\u548c\u9700\u4e3a100%\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"AnalysisSchemeSaveValidator_6", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, msg);
            return;
        }
    }

    private boolean setItemPercent(BigDecimal itempercent, List<String> unsetrows, DynamicObjectCollection entryentity, BigDecimal othervalue) {
        BigDecimal lastrow = itempercent;
        int size = unsetrows.size();
        BigDecimal sum = itempercent.multiply(new BigDecimal(size));
        if (othervalue.compareTo(sum) != 0) {
            lastrow = itempercent.add(othervalue.subtract(sum)).setScale(2, 4);
        }
        if (lastrow.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        for (DynamicObject entry : entryentity) {
            String index = entry.getString("riskdefinition.id");
            if (unsetrows.get(size - 1).equalsIgnoreCase(index)) {
                entry.set("percent", (Object)lastrow);
                continue;
            }
            if (!unsetrows.contains(index)) continue;
            entry.set("percent", (Object)itempercent);
        }
        return true;
    }

    private DynamicObjectCollection querySchemeObj(Long id, Date startdate, Date enddate) {
        QFilter idFilter = new QFilter("id", "!=", (Object)id);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)enddate).and(new QFilter("enddate", ">=", (Object)startdate));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctrc_analysis_scheme", (String)"id", (QFilter[])new QFilter[]{idFilter, enableFilter, dateFilter});
        return collection;
    }
}

