/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class RiskCheckListSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection colls;
            DynamicObject currentObj = dataEntity.getDataEntity();
            Date startdate = currentObj.getDate("startdate");
            Date enddate = currentObj.getDate("enddate");
            if (startdate == null || enddate == null) {
                String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RiskCheckListSaveValidator_0", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            if (null != enddate && startdate.compareTo(enddate) >= 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"RiskCheckListSaveValidator_1", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]));
                return;
            }
            List<Object> orgidList = new ArrayList(16);
            DynamicObjectCollection entryentity1Colls = currentObj.getDynamicObjectCollection("entryentity1");
            if (entryentity1Colls != null && entryentity1Colls.size() > 0) {
                orgidList = entryentity1Colls.stream().filter(s -> EmptyCheckUtils.isNotEmpty((Object)s.getLong("orgid.id"))).map(s -> s.getLong("orgid.id")).collect(Collectors.toList());
            }
            if ((colls = HealthUtil.querySchemeObj((Long)currentObj.getLong("id"), (Date)startdate, (Date)enddate, orgidList)) != null && colls.size() > 0) {
                String msg = ResManager.loadKDString((String)"\u540c\u4e00\u7ec4\u7ec7\u540c\u4e00\u6709\u6548\u671f\u5185\u4e0d\u80fd\u5b58\u5728\u4e24\u6761\u542f\u7528\u72b6\u6001\u7684\u6570\u636e\u3002", (String)"RiskCheckListSaveValidator_2", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            DynamicObjectCollection entryentity = (DynamicObjectCollection)currentObj.get("entryentity");
            if (entryentity == null || entryentity.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53c2\u4e0e\u5065\u5eb7\u68c0\u67e5\u6e05\u5355\u7684\u6307\u6807\u3002", (String)"RiskCheckListSaveValidator_3", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                return;
            }
            HashMap<String, String> riskmap = new HashMap<String, String>(entryentity.size());
            for (DynamicObject entry : entryentity) {
                String risknumber = entry.getString("riskdefinition.number");
                String riskname = entry.getString("riskdefinition.name");
                if (riskmap.containsKey(risknumber)) {
                    String msg = String.format(ResManager.loadKDString((String)"%s: \u98ce\u9669\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"RiskCheckListSaveValidator_4", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]), risknumber);
                    this.addErrorMessage(dataEntity, msg);
                    return;
                }
                riskmap.put(risknumber, riskname);
            }
        }
    }
}

