/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.enums.ProcessStateEnum;
import org.apache.commons.collections.CollectionUtils;

public class RiskEvalationOp
extends AbstractOperationServicePlugIn {
    private static final String USER = "dealingrid";
    private static final String RISK_EVALUATION_ENTITY = "tctrc_risk_evaluation_new";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>();
        Arrays.stream(dataEntities).forEach(a -> ids.add(a.getLong("id")));
        if ("donothingriskresult".equals(operationKey)) {
            if (ids.size() > 1) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RiskEvalationOp_0", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]), new Object[0]);
                args.setCancel(true);
                args.setCancelMessage(msg);
                return;
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)RISK_EVALUATION_ENTITY, (String)"id,datasource", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                DynamicObject dynobj = (DynamicObject)list.get(0);
                List<String> idList = Arrays.asList("0", "1");
                if (!idList.contains(dynobj.getString("datasource"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u98ce\u9669\u7ed3\u679c\u8be6\u60c5\u3002", (String)"RiskEvalationOp_1", (String)"taxc-tctrc-opplugin", (Object[])new Object[0]), new Object[0]);
                    args.setCancel(true);
                    args.setCancelMessage(msg);
                    return;
                }
            }
        } else if ("donothingcanceldeal".equals(operationKey)) {
            this.donothingCancelDeal(ids);
        }
    }

    private void donothingCancelDeal(List<Long> idsList) {
        DynamicObject dynamicObject = null;
        for (Long id : idsList) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)RISK_EVALUATION_ENTITY);
            dynamicObject.set("processresult", null);
            dynamicObject.set("processstate", (Object)ProcessStateEnum.PROCESS_1.getCode());
            dynamicObject.set(USER, (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("dealdate", (Object)new Date());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

