/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationBusiness;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.RiskEvalutionUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public class TctrcEvalutionFramePlugin
extends AbstractFormPlugin {
    private static final String CREATOR = "creator";
    private static final String TCTRC_RISK_EVALUATION_NEW = "tctrc_risk_evaluation_new";
    private static final String EVALUATION = "evaluation";
    private static final String STARS = "stars";
    private static final String FEEBACK = "feeback";
    private static final String RISKCODE = "riskcode";
    private static final String ADVICE_INPUT = "adviceinput";
    private static final String NUMBER = "number";
    private static final String BTN_CONCEL = "btncancel";
    private static final String BTN_SUBMIT = "btnsubmit";
    private static final String CREATE_TIME = "createdatefield";
    private static final String DATASOURCE = "datasource";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CONCEL, BTN_SUBMIT, "vectorap11", "vectorap12", "vectorap13", "vectorap14", "vectorap15", "vectorap_l11", "vectorap_l12", "vectorap_l13", "vectorap_l14", "vectorap_l15", "labelap1", "labelap2", "labelap3"});
    }

    public void afterCreateNewData(EventObject e) {
        String userId = RequestContext.get().getUserId();
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        List numberList = (List)customMap.get(NUMBER);
        String star = (String)customMap.get(STARS);
        Long riskResultId = (Long)customMap.get("resultid");
        if (null != star) {
            this.getView().getModel().setValue(STARS, (Object)star);
            this.displayStar(Integer.parseInt(star) + 1);
            this.getPageCache().put("star", star);
        }
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            return;
        }
        QFilter q = new QFilter(CREATOR, "=", (Object)Long.parseLong(userId)).and(new QFilter(RISKCODE, "in", (Object)numberList)).and(new QFilter("riskresultfid", "=", (Object)String.valueOf(riskResultId))).and(new QFilter("processstate", "!=", (Object)"2"));
        DynamicObjectCollection dynamicObjectCollection = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluation3((QFilter)q);
        if (null != dynamicObjectCollection && dynamicObjectCollection.size() == 0) {
            return;
        }
        if (null != dynamicObjectCollection) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
            String processstate = dynamicObject.getString("processstate");
            if ("1".equals(processstate)) {
                this.getPageCache().put("ids", String.valueOf(dynamicObject.get("id")));
            }
            this.getModel().setValue(ADVICE_INPUT, (Object)dynamicObject.getString(FEEBACK));
            String evaluation = dynamicObject.getString(EVALUATION);
            this.displayStar(Integer.parseInt(evaluation) + 1);
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        String star = this.getPageCache().get("star");
        switch (key) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnsubmit": {
                this.btnSubmit();
                break;
            }
            case "vectorap11": 
            case "vectorap_l11": {
                if (StringUtil.isNotEmpty((CharSequence)star) && "1".equals(star)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7684\u8bc4\u4ef7\u7ed3\u679c\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"TctrcEvalutionFramePlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.displayStar(1);
                break;
            }
            case "vectorap12": 
            case "vectorap_l12": {
                if (StringUtil.isNotEmpty((CharSequence)star) && "0".equals(star)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u7684\u8bc4\u4ef7\u7ed3\u679c\u4e0d\u80fd\u53d8\u66f4\u3002", (String)"TctrcEvalutionFramePlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.displayStar(2);
                break;
            }
            case "labelap1": {
                String adviceInput = String.format(ResManager.loadKDString((String)"%s\u6709\u7528", (String)"TctrcEvalutionFramePlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput);
                break;
            }
            case "labelap2": {
                String adviceInput2 = String.format(ResManager.loadKDString((String)"%s\u4e0d\u591f\u660e\u786e", (String)"TctrcEvalutionFramePlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput2);
                break;
            }
            case "labelap3": {
                String adviceInput3 = String.format(ResManager.loadKDString((String)"%s\u5e2e\u52a9\u4e0d\u5927", (String)"TctrcEvalutionFramePlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput3);
            }
        }
    }

    public void displayStar(int star) {
        IDataModel model = this.getModel();
        switch (star) {
            case 1: {
                model.setValue(STARS, (Object)"0");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap_l12"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap12"});
                break;
            }
            case 2: {
                model.setValue(STARS, (Object)"1");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_l11", "vectorap12"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap11", "vectorap_l12"});
            }
        }
    }

    private void btnSubmit() {
        IDataModel model = this.getModel();
        String starLevel = (String)model.getValue(STARS);
        String advice = (String)model.getValue(ADVICE_INPUT);
        if ("1".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u610f\u89c1\u53cd\u9988\u5185\u5bb9\u3002", (String)"TctrcEvalutionFramePlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isEmpty((CharSequence)starLevel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u51fa\u8bc4\u4ef7\u548c\u5efa\u8bae\u518d\u63d0\u4ea4\u3002", (String)"TctrcEvalutionFramePlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String ids = this.getPageCache().get("ids");
        List idList = ListUtils.stringToList((String)ids);
        DynamicObject dynamicObject = null;
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        List numberList = (List)customMap.get(NUMBER);
        String datasource = (String)customMap.get(DATASOURCE);
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u98ce\u9669\u518d\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"TctrcEvalutionFramePlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            String id = null;
            if (idList != null && i < idList.size()) {
                id = (String)idList.get(i);
            }
            Long numberId = (Long)numberList.get(i);
            String number = "";
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                dynamicObject = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationBusSin((Object)id);
            } else {
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCTRC_RISK_EVALUATION_NEW);
                number = RiskEvalutionUtils.getCodeRuleNumber();
                dynamicObject.set(NUMBER, (Object)number);
            }
            String orgid = (String)customMap.get("orgid");
            String riskname = (String)customMap.get("riskname");
            Long riskResultId = (Long)customMap.get("resultid");
            dynamicObject.set("orgid", (Object)Long.parseLong(orgid));
            dynamicObject.set(CREATOR, (Object)RequestContext.get().getUserId());
            dynamicObject.set(FEEBACK, (Object)advice);
            dynamicObject.set(EVALUATION, (Object)starLevel);
            String processstate = "";
            if ("0".equals(starLevel) && StringUtils.isEmpty((CharSequence)advice)) {
                processstate = "0";
            } else if ("0".equals(starLevel) && StringUtils.isNotEmpty((CharSequence)advice) || "1".equals(starLevel)) {
                processstate = "1";
            }
            dynamicObject.set("processstate", (Object)processstate);
            dynamicObject.set(DATASOURCE, (Object)datasource);
            dynamicObject.set(RISKCODE, (Object)numberId);
            dynamicObject.set("riskname", (Object)riskname);
            dynamicObject.set("modifytime", this.getModel().getValue(CREATE_TIME));
            dynamicObject.set("riskresultfid", (Object)riskResultId);
            DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("starLevel", starLevel);
        map.put("submited", Boolean.TRUE);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

