/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationDbBusiness;
import kd.taxc.tctrc.common.util.ListUtils;
import org.apache.commons.collections.CollectionUtils;

public class TctrcRiskEvalutionPlugin
extends AbstractFormPlugin {
    private static final String USER = "user";
    private static final String TYPE = "type";
    private static final String RISK_EVALUATION_ENTITY = "tctrc_risk_evaluation_db";
    private static final String STAR_LEVEL = "starlevel";
    private static final String STARS = "stars";
    private static final String ADVICE = "advice";
    private static final String ADVICE_INPUT = "adviceinput";
    private static final String NUMBER = "number";
    private static final String BTN_CONCEL = "btncancel";
    private static final String BTN_SUBMIT = "btnsubmit";
    private static final String MODIFY_TIME = "modifydatefield";
    private static final String CREATE_TIME = "createdatefield";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CONCEL, BTN_SUBMIT, "vectorap11", "vectorap12", "vectorap13", "vectorap14", "vectorap15", "vectorap_l11", "vectorap_l12", "vectorap_l13", "vectorap_l14", "vectorap_l15", "labelap1", "labelap2", "labelap3"});
    }

    public void afterCreateNewData(EventObject e) {
        String userId = RequestContext.get().getUserId();
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        List numberList = (List)customMap.get(NUMBER);
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            return;
        }
        QFilter q = new QFilter(USER, "=", (Object)Long.parseLong(userId)).and(new QFilter(TYPE, "=", (Object)"1")).and(new QFilter(NUMBER, "in", (Object)numberList));
        DynamicObjectCollection dynamicObjectCollection = TctrcRiskEvaluationDbBusiness.getTctrcRiskEvaluation((QFilter)q);
        if (dynamicObjectCollection == null) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            idList.add(dynamicObject.getString("id"));
        }
        String ids = String.join((CharSequence)",", idList);
        this.getPageCache().put("ids", ids);
        if (numberList.size() == 1 && dynamicObjectCollection.size() == 1) {
            DynamicObject dynamicObject;
            dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
            String starLevel = dynamicObject.getString(STAR_LEVEL);
            String advice = dynamicObject.getString(ADVICE);
            this.displayStar(Integer.parseInt(starLevel));
            this.getModel().setValue(ADVICE_INPUT, (Object)advice);
            Label label = (Label)this.getView().getControl("tipstext");
            label.setText(ResManager.loadKDString((String)"\u4f60\u5bf9\u8be5\u98ce\u9669\u8fd8\u6709\u54ea\u4e9b\u8bc4\u4ef7\u548c\u5efa\u8bae\uff1f", (String)"TctrcRiskEvalutionPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            Label label2 = (Label)this.getView().getControl("advicetips");
            label2.setText(ResManager.loadKDString((String)"\u4f60\u5bf9\u8be5\u98ce\u9669\u8fd8\u6709\u54ea\u4e9b\u8bc4\u4ef7\u548c\u5efa\u8bae\uff1f", (String)"TctrcRiskEvalutionPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else {
            Label label = (Label)this.getView().getControl("tipstext");
            label.setText(String.format(ResManager.loadKDString((String)"\u8bf7\u4f60\u4e3a\u8fd9%s\u6761\u98ce\u9669\u8fdb\u884c\u8bc4\u7ea7\u3002", (String)"TctrcRiskEvalutionPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), numberList.size()));
            Label label2 = (Label)this.getView().getControl("advicetips");
            label2.setText(ResManager.loadKDString((String)"\u4f60\u5bf9\u4ee5\u4e0a\u98ce\u9669\u8fd8\u6709\u54ea\u4e9b\u8bc4\u4ef7\u548c\u5efa\u8bae\uff1f", (String)"TctrcRiskEvalutionPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnsubmit": {
                this.btnSubmit();
                break;
            }
            case "vectorap11": 
            case "vectorap_l11": {
                this.displayStar(1);
                break;
            }
            case "vectorap12": 
            case "vectorap_l12": {
                this.displayStar(2);
                break;
            }
            case "vectorap13": 
            case "vectorap_l13": {
                this.displayStar(3);
                break;
            }
            case "vectorap14": 
            case "vectorap_l14": {
                this.displayStar(4);
                break;
            }
            case "vectorap15": 
            case "vectorap_l15": {
                this.displayStar(5);
                break;
            }
            case "labelap1": {
                String adviceInput = String.format(ResManager.loadKDString((String)"%s\u6709\u7528", (String)"TctrcRiskEvalutionPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput);
                break;
            }
            case "labelap2": {
                String adviceInput2 = String.format(ResManager.loadKDString((String)"%s\u4e0d\u591f\u660e\u786e", (String)"TctrcRiskEvalutionPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput2);
                break;
            }
            case "labelap3": {
                String adviceInput3 = String.format(ResManager.loadKDString((String)"%s\u5e2e\u52a9\u4e0d\u5927", (String)"TctrcRiskEvalutionPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), this.getModel().getValue(ADVICE_INPUT));
                this.getModel().setValue(ADVICE_INPUT, (Object)adviceInput3);
            }
        }
    }

    public void displayStar(int star) {
        IDataModel model = this.getModel();
        switch (star) {
            case 1: {
                model.setValue(STARS, (Object)"1");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap_l12", "vectorap_l13", "vectorap_l14", "vectorap_l15"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap12", "vectorap13", "vectorap14", "vectorap15"});
                break;
            }
            case 2: {
                model.setValue(STARS, (Object)"2");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap12", "vectorap_l13", "vectorap_l14", "vectorap_l15"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap_l12", "vectorap13", "vectorap14", "vectorap15"});
                break;
            }
            case 3: {
                model.setValue(STARS, (Object)"3");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap12", "vectorap13", "vectorap_l14", "vectorap_l15"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap_l12", "vectorap_l13", "vectorap14", "vectorap15"});
                break;
            }
            case 4: {
                model.setValue(STARS, (Object)"4");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap12", "vectorap13", "vectorap14", "vectorap_l15"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap_l12", "vectorap_l13", "vectorap_l14", "vectorap15"});
                break;
            }
            case 5: {
                model.setValue(STARS, (Object)"5");
                this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap11", "vectorap12", "vectorap13", "vectorap14", "vectorap15"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"vectorap_l11", "vectorap_l12", "vectorap_l13", "vectorap_l14", "vectorap_l15"});
                break;
            }
        }
    }

    private void btnSubmit() {
        IDataModel model = this.getModel();
        String starLevel = (String)model.getValue(STARS);
        String advice = (String)model.getValue(ADVICE_INPUT);
        if (StringUtils.isEmpty((CharSequence)advice) || StringUtils.isEmpty((CharSequence)starLevel)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ed9\u51fa\u8bc4\u4ef7\u548c\u5efa\u8bae\u518d\u63d0\u4ea4\u3002", (String)"TctrcRiskEvalutionPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String ids = this.getPageCache().get("ids");
        List idList = ListUtils.stringToList((String)ids);
        DynamicObject dynamicObject = null;
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        List numberList = (List)customMap.get(NUMBER);
        if (CollectionUtils.isEmpty((Collection)numberList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u98ce\u9669\u518d\u8fdb\u884c\u8bc4\u4ef7\u3002", (String)"TctrcRiskEvalutionPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < numberList.size(); ++i) {
            String id = null;
            if (idList != null && i < idList.size()) {
                id = (String)idList.get(i);
            }
            String number = (String)numberList.get(i);
            dynamicObject = StringUtils.isNotEmpty(id) ? TctrcRiskEvaluationDbBusiness.getTctrcRiskEvaluationBusSin((Object)id) : BusinessDataServiceHelper.newDynamicObject((String)RISK_EVALUATION_ENTITY);
            dynamicObject.set(USER, (Object)RequestContext.get().getUserId());
            dynamicObject.set(ADVICE, (Object)advice);
            dynamicObject.set(STAR_LEVEL, (Object)starLevel);
            dynamicObject.set(TYPE, (Object)"1");
            dynamicObject.set(NUMBER, (Object)number);
            dynamicObject.set(MODIFY_TIME, this.getModel().getValue(CREATE_TIME));
            DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("starLevel", starLevel);
        map.put("submited", Boolean.TRUE);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

