/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.enums.RiskScoreEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.formplugin.analysis.RiskScoreService;

public abstract class AbstractRiskScoreService
implements RiskScoreService {
    protected static final String TCTRC_RISK_RUN_RESULT = "tctrc_risk_run_result";
    protected static final String TCTRC_RISK_LEVEL = "tctrc_risk_level";

    protected QFilter doGetBaseDataQFilter(IFormView view, String modelFlag, String queryField) {
        DynamicObjectCollection areas = (DynamicObjectCollection)view.getParentView().getModel().getValue(modelFlag);
        return EmptyCheckUtils.isEmpty((Object)areas) ? null : new QFilter(queryField, "in", areas.stream().map(v -> v.getDynamicObject("fbasedataid").get("id")).distinct().collect(Collectors.toList()));
    }

    protected QFilter getQFilter(IFormView view, int offset) {
        IFormView parentView = view.getParentView();
        if (null == parentView) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7236\u9875\u9762", (String)"AbstractRiskScoreService_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        Object startdate = parentView.getModel().getValue("startdate");
        Object enddate = parentView.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)startdate) || EmptyCheckUtils.isEmpty((Object)enddate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u65f6\u95f4\u4e0d\u6b63\u786e\u3002", (String)"AbstractRiskScoreService_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("enddate", ">=", (Object)DateUtils.addYear((Date)DateUtils.getFirstDateOfMonth((Date)((Date)startdate)), (int)offset));
        QFilter endFilter = new QFilter("enddate", "<=", (Object)DateUtils.addYear((Date)DateUtils.getLastDateOfMonth2((Date)((Date)enddate)), (int)offset));
        qFilter.and(endFilter);
        return qFilter;
    }

    protected void commonHander(IFormView view, List<RiskScoreInfoBean> list) {
        QFilter qFilter = this.getQFilter(view, 0);
        String dimension = (String)view.getParentView().getModel().getValue("dimension");
        QFilter filter = this.doGetBaseDataQFilter(view, RiskScoreEnum.getEnumByCode((String)dimension).getMetaId(), RiskScoreEnum.getEnumByCode((String)dimension).getQueryField());
        DynamicObjectCollection orgs = OrgUtils.getTaxOrgListHasPermission((QFilter)("1".equals(dimension) ? null : filter));
        DynamicObjectCollection orgcolls = (DynamicObjectCollection)view.getParentView().getModel().getValue("org");
        List orgsList = orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList());
        if ("1".equals(dimension) && orgcolls != null && orgcolls.size() > 0) {
            List selectedorgs = orgcolls.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            List selectedallorgs = OrgUtils.getChildrenIds(selectedorgs);
            orgsList = selectedallorgs.stream().filter(orgsList::contains).collect(Collectors.toList());
        }
        if (EmptyCheckUtils.isEmpty((Object)orgs)) {
            return;
        }
        qFilter.and(new QFilter("runorg", "in", orgsList));
        Date enddate = (Date)view.getParentView().getModel().getValue("enddate");
        Map percentMap = RiskScoreViewUtils.getAnalysisSchemePercent((Date)enddate);
        Set ids = percentMap.keySet();
        List rlevelIds = new ArrayList(16);
        Map<String, Object> rlevelMap = this.getRlevelIds();
        if (rlevelMap != null) {
            rlevelIds = (List)rlevelMap.get("rlevelIds");
        }
        qFilter.and(new QFilter("rlevel.id", "in", rlevelIds));
        qFilter.and(new QFilter("risk.id", "in", ids));
        DynamicObjectCollection results = QueryServiceHelper.query((String)TCTRC_RISK_RUN_RESULT, (String)"id,runorg,startdate,enddate,rlevel,riskscore,risk", (QFilter[])new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> orgmainMap = orgs.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
        list.addAll(RiskScoreViewUtils.getRiskScoreInfoList((DynamicObjectCollection)results, orgmainMap, (Map)percentMap));
    }

    protected Map<String, Object> getRlevelIds() {
        DynamicObjectCollection rlevelCollection = RiskScoreViewUtils.getRiskLevelList((String)Boolean.TRUE.toString());
        ArrayList<Long> rlevelIds = new ArrayList<Long>(16);
        HashMap<String, Object> mapKey = new HashMap<String, Object>(16);
        HashMap<Long, String> mapValue = new HashMap<Long, String>(16);
        if (rlevelCollection != null) {
            for (DynamicObject dynamicObject : rlevelCollection) {
                rlevelIds.add(dynamicObject.getLong("id"));
                mapValue.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
            }
        }
        mapKey.put("rlevelIds", rlevelIds);
        mapKey.put("rlevelIdVlue", mapValue);
        return mapKey;
    }
}

