/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctrc.common.checkup.CheckupConstant;
import kd.taxc.tctrc.common.constant.RiskConstant;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;

public class RiskEchartsHelper {
    private static Log logger = LogFactory.getLog(RiskEchartsHelper.class);
    private static final String POSITION_VALUE = "30px";

    public static Axis createCategoryAxisForRank(BarChart barChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? barChart.createXAxis(name, AxisType.category) : barChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, Integer> axisLabel = new HashMap<String, Integer>();
        axisLabel.put("interval", 0);
        axisLabel.put("rotate", 20);
        axis.setPropValue("axisLabel", axisLabel);
        RiskEchartsHelper.setLineColor(axis, "#999999");
        return axis;
    }

    private static void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    public static Axis createValueAxisForRank(BarChart barChart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? barChart.createXAxis(name, AxisType.value) : barChart.createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        RiskEchartsHelper.setLineColor(axis, "#999999");
        barChart.setShowTooltip(true);
        return axis;
    }

    public static void createBarSeries(BarChart barChart, String name, Number[] values, String color, Boolean flag) {
        BarSeries barSeries = barChart.createBarSeries(name);
        barSeries.setStack("stack");
        if (!flag.booleanValue()) {
            barSeries.setBarWidth("25px");
        } else {
            int index = values.length;
            HashMap<String, Object> dataZoom = new HashMap<String, Object>();
            dataZoom.put("show", true);
            dataZoom.put("moveOnMouseWheel", true);
            dataZoom.put("moveOnMouseMove", true);
            dataZoom.put("startValue", index - 25);
            dataZoom.put("endValue", index);
            dataZoom.put("orient", "vertical");
            barChart.addProperty("dataZoom", dataZoom);
        }
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideRight);
        label.setShow(false);
        barSeries.setLabel(label);
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n.intValue() != 0) continue;
            values[i] = null;
        }
        barSeries.setData(values);
    }

    public static void drawTrendChart(Map<String, BigDecimal> valueMap1, PointLineChart chart) {
        chart.clearData();
        List categorys = valueMap1.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        Axis xAxis = RiskEchartsHelper.createCategoryAxisForTrent(chart, ResManager.loadKDString((String)"\u6708\u4efd", (String)"RiskEchartsHelper_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        xAxis.setCategorys(categorys);
        List<BigDecimal> outputValues = valueMap1.entrySet().stream().map(e -> ((BigDecimal)e.getValue()).setScale(2, 4)).collect(Collectors.toList());
        RiskEchartsHelper.createLineForTrend(chart, outputValues);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setLegendVertical(false);
        chart.setShowLegend(false);
        chart.setMargin(Position.top, POSITION_VALUE);
        chart.setMargin(Position.right, POSITION_VALUE);
        chart.setMargin(Position.left, POSITION_VALUE);
        chart.setMargin(Position.bottom, "0px");
        chart.setName(new LocaleString(ResManager.loadKDString((String)"", (String)"RiskEchartsHelper_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        chart.setTitleAlign(XAlign.left, YAlign.top);
        chart.refresh();
    }

    private static Axis createCategoryAxisForTrent(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createXAxis(name, AxisType.category);
        axis.setPropValue("nameLocation", (Object)"end");
        axis.setPropValue("position", (Object)"bottom");
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        axis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 0, 0};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        RiskEchartsHelper.setLineColor(axis, "#999999");
        return axis;
    }

    private static void createLineForTrend(PointLineChart chart, List<BigDecimal> outputValues) {
        RiskEchartsHelper.createValueAxisForTrend(chart, ResManager.loadKDString((String)"(\u5f97\u5206)", (String)"RiskEchartsHelper_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        RiskEchartsHelper.createLineSeriesForTrend(chart, ResManager.loadKDString((String)"\u98ce\u9669\u5f97\u5206", (String)"RiskEchartsHelper_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), outputValues, "#9EB8FF");
    }

    private static Axis createValueAxisForTrend(PointLineChart pointLineChart, String name) {
        Axis axis = pointLineChart.createYAxis(name, AxisType.value);
        HashMap splitLine = Maps.newHashMap();
        HashMap lineStyle = Maps.newHashMap();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", (Object)splitLine);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 0, -20};
        map.put("padding", aa);
        axis.setPropValue("nameTextStyle", map);
        RiskEchartsHelper.setLineColor(axis, "#999999");
        pointLineChart.setShowTooltip(true);
        return axis;
    }

    private static void createLineSeriesForTrend(PointLineChart pointLineChart, String name, List<BigDecimal> values, String color) {
        LineSeries expireSeries = pointLineChart.createLineSeries(name);
        expireSeries.setItemColor(color);
        expireSeries.setData(values.toArray(new Number[0]));
    }

    public static void drawDistributeChart(Map<String, Integer> collectMap, PieChart pieChart, String useto) {
        pieChart.clearData();
        PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"", (String)"RiskEchartsHelper_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        Iterator<Map.Entry<String, Integer>> iterator = collectMap.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            if ("0".equals(useto)) {
                series.addData(new ItemValue(entry.getKey(), (Number)entry.getValue(), RiskEchartsHelper.setColor(i, false)));
            } else if ("1".equals(useto)) {
                String key = entry.getKey().split("\\|")[0];
                series.addData(new ItemValue(entry.getKey(), (Number)entry.getValue(), EmptyCheckUtils.isNotEmpty(CheckupConstant.getMap().get(key)) ? (String)CheckupConstant.getMap().get(key) : RiskEchartsHelper.setColor1(i, false)));
            }
            ++i;
        }
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Object> lableMap = new HashMap<String, Object>();
        lableMap.put("show", Boolean.TRUE);
        lableMap.put("position", "left");
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.TRUE);
        itemNormalStyle.put("labelLine", lableLineMap);
        series.setRadius("50%", "70%");
        Map<String, Object> values = RiskEchartsHelper.getValues(series);
        RiskEchartsHelper.setEmphasisLabel(values);
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        pieChart.addTooltip("trigger", (Object)"item");
        pieChart.setLegendAlign(XAlign.right, YAlign.top);
        pieChart.setLegendVertical(false);
        pieChart.setLegendPropValue("selectedMode", (Object)"onlyHover");
        pieChart.setLegendPropValue("padding", (Object)new Integer[]{80, 50, 20, 20});
        pieChart.refresh();
    }

    private static Map<String, Object> getValues(PieSeries series) {
        try {
            Class<?> clazz = Class.forName("kd.bos.form.chart.Series");
            Method getValues = clazz.getDeclaredMethod("getValues", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{getValues}, true);
            Object invoke = getValues.invoke((Object)series, (Object[])null);
            return null == invoke ? new HashMap(16) : (Map)invoke;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static void setEmphasisLabel(Map<String, Object> values) {
        if (null != values && values.size() > 0) {
            Map itemStyle = (Map)values.get("itemStyle");
            HashMap emphasisMap = new HashMap();
            HashMap<String, Serializable> labelMap = new HashMap<String, Serializable>();
            HashMap<String, String> textStyleMap = new HashMap<String, String>();
            textStyleMap.put("fontSize", "24");
            textStyleMap.put("fontWeight", "bold");
            labelMap.put("show", Boolean.TRUE);
            labelMap.put("textStyle", textStyleMap);
            emphasisMap.put("label", labelMap);
            HashMap<String, Boolean> labelLineMap = new HashMap<String, Boolean>();
            labelLineMap.put("show", Boolean.FALSE);
            emphasisMap.put("labelLine", labelLineMap);
            itemStyle.put("emphasis", emphasisMap);
        }
    }

    private static String setColor(int idx, boolean isEnd) {
        List colors = RiskConstant.getColors();
        if (idx % colors.size() == 0 && isEnd) {
            return (String)colors.get(1);
        }
        return (String)colors.get(idx % colors.size());
    }

    private static String setColor1(int idx, boolean isEnd) {
        List colors = RiskConstant.getColors1();
        if (idx % colors.size() == 0 && isEnd) {
            return (String)colors.get(1);
        }
        return (String)colors.get(idx % colors.size());
    }

    public static void drawTongbiChart(Map<String, BigDecimal> currentAmountMap, Map<String, BigDecimal> previousAmountMap, HistogramChart customchart, Date endDate, Boolean flag) {
        if (currentAmountMap == null || previousAmountMap == null) {
            return;
        }
        List<String> categorys = currentAmountMap.entrySet().stream().map(e -> (String)e.getKey()).collect(Collectors.toList());
        List<Number> currentValues = currentAmountMap.entrySet().stream().map(e -> (BigDecimal)e.getValue()).collect(Collectors.toList());
        List<Number> previousValues = previousAmountMap.entrySet().stream().map(e -> (BigDecimal)e.getValue()).collect(Collectors.toList());
        Axis xAxis = RiskEchartsHelper.createValueAxisForAnalysis(customchart, ResManager.loadKDString((String)"(\u5f97\u5206)", (String)"RiskEchartsHelper_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), false);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        RiskEchartsHelper.createCategoryAxisForAnalysis(customchart, "", categorys, true);
        int year = DateUtils.getYearOfDate((Date)endDate);
        String yearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"RiskEchartsHelper_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year);
        String previousYearName = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"RiskEchartsHelper_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year - 1);
        RiskEchartsHelper.createHistogramSeriesForAnalysis(customchart, ResManager.loadKDString((String)previousYearName, (String)"Taxanalysis_2", (String)"RiskEchartsHelper_5", (Object[])new Object[0]), previousValues.toArray(new Number[0]), "1", flag);
        RiskEchartsHelper.createHistogramSeriesForAnalysis(customchart, ResManager.loadKDString((String)yearName, (String)"Taxanalysis_taxc-tctrc-formplugin", (String)"RiskEchartsHelper_5", (Object[])new Object[0]), currentValues.toArray(new Number[0]), "2", flag);
        customchart.setName(new LocaleString(""));
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 35});
        customchart.setMargin(Position.top, "20px");
        customchart.setMargin(Position.right, POSITION_VALUE);
        customchart.setMargin(Position.left, POSITION_VALUE);
        customchart.setShowLegend(true);
        customchart.setShowTooltip(true);
        customchart.setLegendVertical(false);
        customchart.refresh();
    }

    private static Axis createValueAxisForAnalysis(HistogramChart histogramChart, String name, boolean isX) {
        Axis xaxis = null;
        xaxis = isX ? histogramChart.createXAxis(name, AxisType.value) : histogramChart.createYAxis(name, AxisType.value);
        xaxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, int[]> map = new HashMap<String, int[]>();
        int[] aa = new int[]{0, 0, 2, -20};
        map.put("padding", aa);
        xaxis.setPropValue("nameTextStyle", map);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xaxis.setPropValue("axisTick", axisTick);
        RiskEchartsHelper.setLineColor(xaxis, "#999999");
        return xaxis;
    }

    private static Axis createCategoryAxisForAnalysis(HistogramChart histogramChart, String name, List<String> demensions, boolean isX) {
        Axis axis = null;
        axis = isX ? histogramChart.createXAxis(name, AxisType.category) : histogramChart.createYAxis(name, AxisType.category);
        axis.setCategorys(demensions);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        RiskEchartsHelper.setLineColor(axis, "#999999");
        histogramChart.setShowTooltip(true);
        return axis;
    }

    private static void createHistogramSeriesForAnalysis(HistogramChart histogramChart, String name, Number[] values, String isyear, Boolean flag) {
        BarSeries histogramSeries = histogramChart.createSeries(name);
        if (!flag.booleanValue()) {
            histogramSeries.setBarWidth("25px");
        }
        HashMap dataLabels = Maps.newHashMap();
        dataLabels.put("format", "{point.y:.1f}");
        histogramSeries.setPropValue("dataLabels", (Object)dataLabels);
        histogramSeries.setAnimationDuration(2000);
        Label label = new Label();
        label.setPosition(Position.insideBottom);
        label.setShow(false);
        histogramSeries.setLabel(label);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "1".equals(isyear) ? "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#6DDBDC'}, {\"offset\": 1, \"color\": '#5CC0DA'}])" : "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#7DBFFF'}, {\"offset\": 1, \"color\": '#568DFF'}])");
        normap.put("normal", map);
        histogramSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        histogramSeries.addFuncPath(list);
        histogramSeries.setLabel((Label)null);
        for (int i = 0; i < values.length; ++i) {
            if (!((double)values[i].floatValue() < 0.001) || !((double)values[i].floatValue() > -0.001)) continue;
            values[i] = BigDecimal.ZERO;
        }
        histogramSeries.setData(values);
    }
}

