/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.formplugin.analysis.RiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskServiceFactory;

public class RiskScoreAnalysisCardPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(RiskScoreAnalysisCardPlugin.class);
    private static final String QUERYDETAILS = "querydetails";
    private static final String HISTOGRAMCHART = "histogramchartap";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        RiskScoreService serviceHelper = this.getServiceHelper();
        serviceHelper.initChat(this.getView(), "2", customParams);
    }

    private RiskScoreService getServiceHelper() {
        return RiskServiceFactory.getServiceFactory("2");
    }

    public void registerListener(EventObject e) {
        HistogramChart histogramChart = (HistogramChart)this.getView().getControl(HISTOGRAMCHART);
        histogramChart.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{QUERYDETAILS});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (QUERYDETAILS.equals(key)) {
            this.showForm();
        } else if (HISTOGRAMCHART.equals(key)) {
            String name = ((ChartClickEvent)evt).getName();
            String seriesName = ((ChartClickEvent)evt).getSeriesName();
            if (EmptyCheckUtils.isEmpty((Object)seriesName)) {
                return;
            }
            String currentpagecache = this.getPageCache().get("rankpagecacheids");
            String rankpagecacheorgids = this.getPageCache().get("rankpagecacheorgids");
            if (EmptyCheckUtils.isNotEmpty((Object)currentpagecache)) {
                Map pkidsMap = (Map)SerializationUtils.fromJsonString((String)currentpagecache, Map.class);
                Map orgidsMap = (Map)SerializationUtils.fromJsonString((String)rankpagecacheorgids, Map.class);
                if (EmptyCheckUtils.isNotEmpty((Object)pkidsMap)) {
                    this.openRiskScoreDetail((List)pkidsMap.get(name + seriesName.trim()), (List)orgidsMap.get(name + seriesName.trim()));
                }
            }
        }
    }

    private void showForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tctrc_score_analysis");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("jump", "1");
        customParams.put("tongbicurrent", this.getPageCache().get("tongbicurrentpagecache"));
        customParams.put("previous", this.getPageCache().get("previouspagecache"));
        customParams.put("enddate", this.getPageCache().get("enddatepagecache"));
        parameter.setCustomParams(customParams);
        parameter.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u5f97\u5206\u5206\u6790", (String)"RiskScoreAnalysisCardPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void openRiskScoreDetail(List<String> strings, List<String> strings1) {
    }
}

