/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.HistogramChart;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoCollBean;
import kd.taxc.tctrc.common.enums.RiskScoreEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.analysis.AbstractRiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskEchartsHelper;
import org.apache.commons.collections4.MapUtils;

public class RiskScoreAnalysisHelper
extends AbstractRiskScoreService {
    @Override
    public void initChat(IFormView view, String type, Map<String, Object> customParams) {
        LinkedHashMap<String, BigDecimal> tongbiCurrentScoreMap = new LinkedHashMap(32);
        LinkedHashMap<String, BigDecimal> AlltongbiCurrentScoreMap = new LinkedHashMap(32);
        LinkedHashMap<String, BigDecimal> previousScoreMap = new LinkedHashMap<String, BigDecimal>(32);
        Map<String, BigDecimal> newPreviousScoreMap = new LinkedHashMap<String, BigDecimal>(16);
        Map<Object, Object> AllPreviousScoreMap = new LinkedHashMap(16);
        Date enddate = new Date();
        Boolean flag = false;
        if (customParams != null && !"1".equals((String)customParams.get("jump"))) {
            view.setVisible(Boolean.FALSE, new String[]{"closeflex"});
            QFilter qFilter = this.getQFilter(view, 0);
            String dimension = (String)view.getParentView().getModel().getValue("dimension");
            QFilter filter = this.doGetBaseDataQFilter(view, RiskScoreEnum.getEnumByCode((String)dimension).getMetaId(), RiskScoreEnum.getEnumByCode((String)dimension).getQueryField());
            DynamicObjectCollection orgs = OrgUtils.getTaxOrgListHasPermission((QFilter)("1".equals(dimension) ? null : filter));
            DynamicObjectCollection orgcolls = (DynamicObjectCollection)view.getParentView().getModel().getValue("org");
            List orgsList = orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList());
            if ("1".equals(dimension) && orgcolls != null && orgcolls.size() > 0) {
                List selectedorgs = orgcolls.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                List selectedallorgs = OrgUtils.getChildrenIds(selectedorgs);
                orgsList = selectedallorgs.stream().filter(orgsList::contains).collect(Collectors.toList());
            }
            if (EmptyCheckUtils.isEmpty((Object)orgs)) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
                return;
            }
            qFilter.and(new QFilter("runorg", "in", orgsList));
            enddate = (Date)view.getParentView().getModel().getValue("enddate");
            Map percentMap = RiskScoreViewUtils.getAnalysisSchemePercent((Date)enddate);
            String maxscore = RiskScoreViewUtils.getCurrentMaxScore((Date)enddate);
            if (StringUtil.isEmpty((CharSequence)maxscore)) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
                view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u98ce\u9669\u5f97\u5206\u65b9\u6848\u6216\u5206\u6790\u65b9\u6848\u3002", (String)"RiskScoreAnalysisHelper_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            Set ids = percentMap.keySet();
            ArrayList<Long> rlevelIds = new ArrayList(16);
            Map<String, Object> rlevelMap = this.getRlevelIds();
            if (rlevelMap != null) {
                rlevelIds = (List)rlevelMap.get("rlevelIds");
            }
            qFilter.and(new QFilter("rlevel.id", "in", rlevelIds));
            qFilter.and(new QFilter("risk.id", "in", ids));
            QFilter previousqFilter = this.getQFilter(view, -1);
            previousqFilter.and(new QFilter("runorg", "in", orgs.stream().map(v -> v.getLong("orgid")).distinct().collect(Collectors.toList())));
            DynamicObjectCollection results = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id,runorg,startdate,enddate,rlevel,riskscore,risk", (QFilter[])new QFilter[]{qFilter});
            previousqFilter.and(new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3, 5)));
            previousqFilter.and(new QFilter("risk.id", "in", ids));
            DynamicObjectCollection previousResults = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id,runorg,startdate,enddate,rlevel,riskscore,risk", (QFilter[])new QFilter[]{previousqFilter});
            Map<Long, List<DynamicObject>> orgmainMap = orgs.stream().collect(Collectors.groupingBy(s -> s.getLong("orgid")));
            List riskScoreInfoList = RiskScoreViewUtils.getRiskScoreInfoList((DynamicObjectCollection)results, orgmainMap, (Map)percentMap);
            List previousRiskScoreInfoList = RiskScoreViewUtils.getRiskScoreInfoList((DynamicObjectCollection)previousResults, orgmainMap, (Map)percentMap);
            if (EmptyCheckUtils.isEmpty((Object)riskScoreInfoList)) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
                if (MapUtils.isEmpty((Map)percentMap)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u98ce\u9669\u5f97\u5206\u65b9\u6848\u6216\u5206\u6790\u65b9\u6848\u3002", (String)"RiskScoreAnalysisHelper_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            HashMap pkids = new HashMap(32);
            if (RiskScoreEnum.ORG.getCode().equals(dimension)) {
                Map<Long, List<RiskScoreInfoBean>> groupByOrgList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
                for (Map.Entry<Long, List<RiskScoreInfoBean>> entry : groupByOrgList.entrySet()) {
                    Long orgid = entry.getKey();
                    String orgName = (String)OrgUtils.getInfoByOrgIdFromErp((String)entry.getKey().toString(), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name");
                    List<RiskScoreInfoBean> beanList = entry.getValue();
                    RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList, (String)maxscore, rlevelIds);
                    tongbiCurrentScoreMap.put(orgName, new BigDecimal(bean.getRiskscore()));
                    view.getPageCache().put("rankpagecache", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
                }
                Map<Long, List<RiskScoreInfoBean>> previousGroupByOrgList = previousRiskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
                for (Map.Entry<Long, List<RiskScoreInfoBean>> entry : previousGroupByOrgList.entrySet()) {
                    Long orgid = entry.getKey();
                    String orgName = (String)OrgUtils.getInfoByOrgIdFromErp((String)entry.getKey().toString(), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name");
                    List<RiskScoreInfoBean> beanList = entry.getValue();
                    RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList, (String)maxscore, rlevelIds);
                    previousScoreMap.put(orgName, new BigDecimal(bean.getRiskscore()));
                    view.getPageCache().put("rankpagecache", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
                }
            } else if (RiskScoreEnum.TAXCAREA.getCode().equals(dimension)) {
                Map<String, List<RiskScoreInfoBean>> groupByAreaList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getArea())).collect(Collectors.groupingBy(s -> s.getArea()));
                Map<String, List<RiskScoreInfoBean>> previousGroupByOrgList = previousRiskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getArea())).collect(Collectors.groupingBy(s -> s.getArea()));
                this.setDataList(groupByAreaList, previousGroupByOrgList, tongbiCurrentScoreMap, previousScoreMap, maxscore, "1", rlevelIds);
            } else if (RiskScoreEnum.HANGYE.getCode().equals(dimension)) {
                Map<String, List<RiskScoreInfoBean>> groupByIndustryList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getIndustry())).collect(Collectors.groupingBy(s -> s.getIndustry()));
                Map<String, List<RiskScoreInfoBean>> previousGroupByIndustryList = previousRiskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getIndustry())).collect(Collectors.groupingBy(s -> s.getIndustry()));
                this.setDataList(groupByIndustryList, previousGroupByIndustryList, tongbiCurrentScoreMap, previousScoreMap, maxscore, "0", rlevelIds);
            }
            Map<String, Map<String, BigDecimal>> totalMap = this.sortMap(tongbiCurrentScoreMap);
            if (tongbiCurrentScoreMap.size() <= 5) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"detailsflex"});
            }
            tongbiCurrentScoreMap = totalMap.get("NO5");
            AlltongbiCurrentScoreMap = totalMap.get("total");
            newPreviousScoreMap = this.getPreScoreMap(tongbiCurrentScoreMap, previousScoreMap);
            AllPreviousScoreMap = this.getPreScoreMap(AlltongbiCurrentScoreMap, previousScoreMap);
            view.getPageCache().put("tongbicurrentpagecache", EmptyCheckUtils.isEmpty(AlltongbiCurrentScoreMap) ? null : SerializationUtils.toJsonString(AlltongbiCurrentScoreMap));
            view.getPageCache().put("previouspagecache", EmptyCheckUtils.isEmpty(AllPreviousScoreMap) ? null : SerializationUtils.toJsonString(AllPreviousScoreMap));
            view.getPageCache().put("enddatepagecache", EmptyCheckUtils.isEmpty((Object)enddate) ? null : SerializationUtils.toJsonString((Object)enddate));
            flag = false;
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"closeflex"});
            view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
            if (customParams != null) {
                tongbiCurrentScoreMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("tongbicurrent")), Map.class);
                newPreviousScoreMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("previous")), Map.class);
                enddate = (Date)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("enddate")), Date.class);
            }
            flag = true;
        }
        HistogramChart histogramChart = this.getMainChart(view);
        RiskEchartsHelper.drawTongbiChart(tongbiCurrentScoreMap, newPreviousScoreMap, histogramChart, enddate, flag);
    }

    private Map<String, BigDecimal> getPreScoreMap(Map<String, BigDecimal> tongbiCurrentScoreMap, Map<String, BigDecimal> previousScoreMap) {
        LinkedHashMap<String, BigDecimal> newPreviousScoreMap = new LinkedHashMap<String, BigDecimal>(16);
        for (Map.Entry<String, BigDecimal> entry : tongbiCurrentScoreMap.entrySet()) {
            newPreviousScoreMap.put(entry.getKey(), previousScoreMap.getOrDefault(entry.getKey(), new BigDecimal("0.0")));
        }
        return newPreviousScoreMap;
    }

    private void setDataList(Map<String, List<RiskScoreInfoBean>> groupList, Map<String, List<RiskScoreInfoBean>> previousGroupList, Map<String, BigDecimal> tongbiCurrentScoreMap, Map<String, BigDecimal> previousScoreMap, String maxscore, String isarea, List<Long> rlevelIds) {
        for (Map.Entry<String, List<RiskScoreInfoBean>> entry : groupList.entrySet()) {
            List<RiskScoreInfoBean> beanList = entry.getValue();
            RiskScoreResultInfoCollBean bean = RiskScoreViewUtils.createNewCollBean(beanList, (String)maxscore, rlevelIds);
            tongbiCurrentScoreMap.put("1".equals(isarea) ? bean.getArea() : bean.getIndustry(), new BigDecimal(bean.getRiskscore()));
        }
        for (Map.Entry<String, List<RiskScoreInfoBean>> entry : previousGroupList.entrySet()) {
            List<RiskScoreInfoBean> beanList = entry.getValue();
            RiskScoreResultInfoCollBean bean = RiskScoreViewUtils.createNewCollBean(beanList, (String)maxscore, rlevelIds);
            previousScoreMap.put("1".equals(isarea) ? bean.getArea() : bean.getIndustry(), new BigDecimal(bean.getRiskscore()));
        }
    }

    private HistogramChart getMainChart(IFormView view) {
        HistogramChart histogramChart = (HistogramChart)view.getControl("histogramchartap");
        return histogramChart;
    }

    public Map<String, Map<String, BigDecimal>> sortMap(Map<String, BigDecimal> map) {
        Set<Map.Entry<String, BigDecimal>> mapEntries = map.entrySet();
        LinkedList<Map.Entry<String, BigDecimal>> result = new LinkedList<Map.Entry<String, BigDecimal>>(mapEntries);
        Collections.sort(result, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        Integer sort = 1;
        LinkedHashMap linkMapNO5 = new LinkedHashMap(16);
        LinkedHashMap linkMap = new LinkedHashMap(16);
        for (Map.Entry entry : result) {
            if (sort <= 5) {
                linkMapNO5.put(entry.getKey(), entry.getValue());
                sort = sort + 1;
            }
            linkMap.put(entry.getKey(), entry.getValue());
        }
        LinkedHashMap<String, Map<String, BigDecimal>> totalMap = new LinkedHashMap<String, Map<String, BigDecimal>>(16);
        totalMap.put("NO5", linkMapNO5);
        totalMap.put("total", linkMap);
        return totalMap;
    }
}

