/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tctrc.common.enums.RiskScoreEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;

public class RiskScoreAnalysisHomePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        this.initData();
        this.putYearToCache();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
        MulBasedataEdit lables = (MulBasedataEdit)this.getView().getControl(RiskScoreEnum.TAXCAREA.getMetaId());
        lables.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        Object result;
        String itemKey = evt.getItemKey();
        if ("refresh1".equals(itemKey) && Boolean.TRUE.equals(result = this.putYearToCache())) {
            this.refreshView();
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"RiskScoreAnalysisHomePlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        List<Long> orgIds = this.getDefaultOrgIds();
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgIds);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public List<Long> getDefaultOrgIds() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            return hasPermOrgResult.getHasPermOrgs();
        }
        return null;
    }

    private boolean validateDate(Date start, Date end) {
        Date startdate;
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        return null == enddate || !(startdate = DateUtils.getFirstDateOfMonth((Date)start)).after(enddate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (date == null || dateend == null) {
            return;
        }
        Object result = this.putYearToCache();
        if (Boolean.TRUE.equals(result)) {
            this.refreshView();
        } else if (!"falseButNochange".equals(result)) {
            ChangeData[] valueSet = e.getChangeSet();
            Object propValue = valueSet[0].getOldValue();
            String propName = e.getProperty().getName();
            this.getModel().setValue(propName, propValue);
        }
    }

    private Object putYearToCache() {
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)date) || EmptyCheckUtils.isEmpty((Object)dateend)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u67e5\u8be2\u8303\u56f4\u201d\u3002", (String)"RiskScoreAnalysisHomePlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = this.validateDate(date, dateend);
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u5fc5\u987b\u2264\u7ed3\u675f\u6708\u4efd\u3002", (String)"RiskScoreAnalysisHomePlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean issame = this.validateSameDateYear(date, dateend);
        if (!issame) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u8d77\u6b62\u5e94\u8be5\u4e3a\u540c\u4e00\u5e74\u3002", (String)"RiskScoreAnalysisHomePlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return "falseButNochange";
        }
        if (date != null) {
            this.getPageCache().put("startdate", DateUtils.format((Date)date));
        } else {
            this.getPageCache().put("startdate", DateUtils.format((Date)new Date()));
        }
        if (dateend != null) {
            this.getPageCache().put("enddate", DateUtils.format((Date)dateend));
        }
        return true;
    }

    private boolean validateSameDateYear(Date date, Date dateend) {
        int dateendYear;
        int dateYear;
        return null == date || null == dateend || (dateYear = DateUtils.getYearOfDate((Date)date)) == (dateendYear = DateUtils.getYearOfDate((Date)dateend));
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    private void initData() {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth2((Date)new Date()));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (RiskScoreEnum.TAXCAREA.getMetaId().equalsIgnoreCase(key)) {
            String groupnumber = "regulated_areas";
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("number", "=", (Object)groupnumber));
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("group.number", "=", (Object)groupnumber));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        }
    }
}

