/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.PieChart;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoBean;
import kd.taxc.tctrc.common.enums.RiskScoreEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.analysis.AbstractRiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskEchartsHelper;

public class RiskScoreDistributeHelper
extends AbstractRiskScoreService {
    @Override
    public void initChat(IFormView view, String type, Map<String, Object> customParams) {
        ArrayList<RiskScoreInfoBean> riskScoreInfoList = new ArrayList<RiskScoreInfoBean>(32);
        this.commonHander(view, riskScoreInfoList);
        List<Long> rlevelIds = new ArrayList(16);
        Map<String, Object> rlevelMap = this.getRlevelIds();
        Map rlevelNameMap = new HashMap(16);
        if (rlevelMap != null) {
            rlevelIds = (List)rlevelMap.get("rlevelIds");
            rlevelNameMap = (Map)rlevelMap.get("rlevelIdVlue");
        }
        String[] riskLevelNames = new String[10];
        int i = 0;
        for (Long riskLevelId : rlevelIds) {
            riskLevelNames[i] = (String)rlevelNameMap.get(riskLevelId);
            if (++i <= 9) continue;
            break;
        }
        if (EmptyCheckUtils.isEmpty(riskScoreInfoList)) {
            return;
        }
        Date enddate = (Date)view.getParentView().getModel().getValue("enddate");
        String maxscore = RiskScoreViewUtils.getCurrentMaxScore((Date)enddate);
        if (StringUtil.isEmpty((CharSequence)maxscore)) {
            return;
        }
        ArrayList<Integer> risk0values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk1values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk2values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk3values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk4values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk5values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk6values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk7values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk8values = new ArrayList<Integer>(16);
        ArrayList<Integer> risk9values = new ArrayList<Integer>(16);
        String dimension = (String)view.getParentView().getModel().getValue("dimension");
        if (RiskScoreEnum.ORG.getCode().equals(dimension)) {
            Map<Long, List<RiskScoreInfoBean>> groupByOrgList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
            for (Map.Entry<Long, List<RiskScoreInfoBean>> entry : groupByOrgList.entrySet()) {
                List<RiskScoreInfoBean> beanList = entry.getValue();
                RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList, (String)maxscore, rlevelIds);
                risk0values.add(bean.getRisktotal0());
                risk1values.add(bean.getRisktotal1());
                risk2values.add(bean.getRisktotal2());
                risk3values.add(bean.getRisktotal3());
                risk4values.add(bean.getRisktotal4());
                risk5values.add(bean.getRisktotal5());
                risk6values.add(bean.getRisktotal6());
                risk7values.add(bean.getRisktotal7());
                risk8values.add(bean.getRisktotal8());
                risk9values.add(bean.getNoRisktotal9());
            }
        } else if (RiskScoreEnum.TAXCAREA.getCode().equals(dimension)) {
            Map<String, List<RiskScoreInfoBean>> groupByAreaList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getArea())).collect(Collectors.groupingBy(s -> s.getArea()));
            this.setDataList(groupByAreaList, risk0values, risk1values, risk2values, risk3values, risk4values, risk5values, risk6values, risk7values, risk8values, risk9values, maxscore, rlevelIds);
        } else if (RiskScoreEnum.HANGYE.getCode().equals(dimension)) {
            Map<String, List<RiskScoreInfoBean>> groupByIndustryList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getIndustry())).collect(Collectors.groupingBy(s -> s.getIndustry()));
            this.setDataList(groupByIndustryList, risk0values, risk1values, risk2values, risk3values, risk4values, risk5values, risk6values, risk7values, risk8values, risk9values, maxscore, rlevelIds);
        }
        PieChart pieChart = this.getMainChart(view);
        LinkedHashMap<String, Integer> collectMap = new LinkedHashMap<String, Integer>(16);
        collectMap.put(riskLevelNames[0], risk0values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[1], risk1values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[2], risk2values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[3], risk3values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[4], risk4values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[5], risk5values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[6], risk6values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[7], risk7values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[8], risk8values.stream().reduce(0, Integer::sum));
        collectMap.put(riskLevelNames[9], risk9values.stream().reduce(0, Integer::sum));
        RiskEchartsHelper.drawDistributeChart(collectMap, pieChart, "0");
    }

    private void setDataList(Map<String, List<RiskScoreInfoBean>> groupByAreaList, List<Integer> risk0values, List<Integer> risk1values, List<Integer> risk2values, List<Integer> risk3values, List<Integer> risk4values, List<Integer> risk5values, List<Integer> risk6values, List<Integer> risk7values, List<Integer> risk8values, List<Integer> risk9values, String maxscore, List<Long> rlevelIds) {
        for (Map.Entry<String, List<RiskScoreInfoBean>> entry : groupByAreaList.entrySet()) {
            List<RiskScoreInfoBean> beanList = entry.getValue();
            RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList, (String)maxscore, rlevelIds);
            risk0values.add(bean.getRisktotal0());
            risk1values.add(bean.getRisktotal1());
            risk2values.add(bean.getRisktotal2());
            risk3values.add(bean.getRisktotal3());
            risk4values.add(bean.getRisktotal4());
            risk5values.add(bean.getRisktotal5());
            risk6values.add(bean.getRisktotal6());
            risk7values.add(bean.getRisktotal7());
            risk8values.add(bean.getRisktotal8());
            risk9values.add(bean.getNoRisktotal9());
        }
    }

    private PieChart getMainChart(IFormView view) {
        PieChart pieChart = (PieChart)view.getControl("piechartap");
        return pieChart;
    }
}

