/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.formplugin.analysis.RiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskServiceFactory;

public class RiskScoreRankCardPlugin
extends AbstractFormPlugin {
    private static final String QUERYDETAILS = "querydetails";
    private static final String BARCHARTAP = "barchartap";
    private static Log logger = LogFactory.getLog(RiskScoreRankCardPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        RiskScoreService serviceHelper = this.getServiceHelper();
        serviceHelper.initChat(this.getView(), "1", customParams);
    }

    private RiskScoreService getServiceHelper() {
        return RiskServiceFactory.getServiceFactory("1");
    }

    public void registerListener(EventObject e) {
        BarChart barChart = (BarChart)this.getView().getControl(BARCHARTAP);
        barChart.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{QUERYDETAILS});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (QUERYDETAILS.equals(key)) {
            this.showForm();
        } else if (BARCHARTAP.equals(key)) {
            String name = ((ChartClickEvent)evt).getName();
            String seriesName = ((ChartClickEvent)evt).getSeriesName();
            if (EmptyCheckUtils.isEmpty((Object)seriesName)) {
                return;
            }
            String currentpagecache = this.getPageCache().get("rankpagecacheids");
            String rankpagecacheorgids = this.getPageCache().get("rankpagecacheorgids");
            if (EmptyCheckUtils.isNotEmpty((Object)currentpagecache)) {
                Map pkidsMap = (Map)SerializationUtils.fromJsonString((String)currentpagecache, Map.class);
                Map orgidsMap = (Map)SerializationUtils.fromJsonString((String)rankpagecacheorgids, Map.class);
                if (EmptyCheckUtils.isNotEmpty((Object)pkidsMap)) {
                    this.openRiskRunResult((List)pkidsMap.get(name + seriesName.trim()), (List)orgidsMap.get(name + seriesName.trim()));
                }
            }
        }
    }

    private void openRiskRunResult(List<String> riskids, List<String> orgids) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        ListShowParameter param = new ListShowParameter();
        customParams.put("orgid", orgids != null && orgids.size() == 1 ? orgids.get(0) : "all");
        customParams.put("risklist", riskids);
        param.setBillFormId("tctrc_risk_run_result");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showForm() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tctrc_riskscore_rank");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("jump", "1");
        customParams.put("keys", this.getPageCache().get("keyspagecache"));
        customParams.put("highvalues", this.getPageCache().get("risk0valuespagecache"));
        customParams.put("midvalues", this.getPageCache().get("risk1valuespagecache"));
        customParams.put("lowvalues", this.getPageCache().get("risk2valuespagecache"));
        customParams.put("risk3values", this.getPageCache().get("risk3valuespagecache"));
        customParams.put("risk4values", this.getPageCache().get("risk4valuespagecache"));
        customParams.put("risk5values", this.getPageCache().get("risk5valuespagecache"));
        customParams.put("risk6values", this.getPageCache().get("risk6valuespagecache"));
        customParams.put("risk7values", this.getPageCache().get("risk7valuespagecache"));
        customParams.put("risk8values", this.getPageCache().get("risk8valuespagecache"));
        customParams.put("risk9values", this.getPageCache().get("risk9valuespagecache"));
        customParams.put("pagecacheids", this.getPageCache().get("rankpagecacheids"));
        customParams.put("pagecacheorgids", this.getPageCache().get("rankpagecacheorgids"));
        parameter.setCustomParams(customParams);
        parameter.setCaption(ResManager.loadKDString((String)"\u98ce\u9669\u5f97\u5206\u6392\u540d", (String)"RiskScoreRankCardPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }
}

