/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoCollBean;
import kd.taxc.tctrc.common.enums.RiskScoreEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.analysis.AbstractRiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskEchartsHelper;

public class RiskScoreRankHelper
extends AbstractRiskScoreService {
    @Override
    public void initChat(IFormView view, String type, Map<String, Object> customParams) {
        List<Integer> risk0values = new ArrayList(16);
        List<Integer> risk1values = new ArrayList(16);
        List<Integer> risk2values = new ArrayList(16);
        List<Integer> risk3values = new ArrayList(16);
        List<Integer> risk4values = new ArrayList(16);
        List<Integer> risk5values = new ArrayList(16);
        List<Integer> risk6values = new ArrayList(16);
        List<Integer> risk7values = new ArrayList(16);
        List<Integer> risk8values = new ArrayList(16);
        List<Integer> risk9values = new ArrayList(16);
        List keys = new ArrayList();
        Boolean flag = false;
        List rlevelIds = new ArrayList(16);
        Map<String, Object> rlevelMap = this.getRlevelIds();
        Map rlevelNameMap = new HashMap(16);
        if (rlevelMap != null) {
            rlevelIds = (List)rlevelMap.get("rlevelIds");
            rlevelNameMap = (Map)rlevelMap.get("rlevelIdVlue");
        }
        String[] riskLevelNames = new String[10];
        int i = 0;
        for (Long riskLevelId : rlevelIds) {
            riskLevelNames[i] = (String)rlevelNameMap.get(riskLevelId);
            if (++i <= 9) continue;
            break;
        }
        if (customParams != null && !"1".equals((String)customParams.get("jump"))) {
            view.setVisible(Boolean.FALSE, new String[]{"closeflex"});
            ArrayList<RiskScoreInfoBean> riskScoreInfoList = new ArrayList<RiskScoreInfoBean>(32);
            this.commonHander(view, riskScoreInfoList);
            if (rlevelIds != null && rlevelIds.size() <= 0) {
                return;
            }
            if (EmptyCheckUtils.isEmpty(riskScoreInfoList)) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
                return;
            }
            Date enddate = (Date)view.getParentView().getModel().getValue("enddate");
            String maxscore = RiskScoreViewUtils.getCurrentMaxScore((Date)enddate);
            if (StringUtil.isEmpty((CharSequence)maxscore)) {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
                return;
            }
            HashMap<String, List<String>> pkids = new HashMap<String, List<String>>(32);
            HashMap<String, List<String>> orgids = new HashMap<String, List<String>>(32);
            String dimension = (String)view.getParentView().getModel().getValue("dimension");
            ArrayList<RiskScoreResultInfoBean> riskScoreResultInfoBeanList = new ArrayList<RiskScoreResultInfoBean>(16);
            ArrayList riskScoreResultInfoCollBeanList = new ArrayList(16);
            if (RiskScoreEnum.ORG.getCode().equals(dimension)) {
                Map<Long, List<RiskScoreInfoBean>> groupByOrgList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
                for (Map.Entry<Long, List<RiskScoreInfoBean>> entry : groupByOrgList.entrySet()) {
                    List<RiskScoreInfoBean> beanList = entry.getValue();
                    RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList, (String)maxscore, rlevelIds);
                    riskScoreResultInfoBeanList.add(bean);
                }
            } else if (RiskScoreEnum.TAXCAREA.getCode().equals(dimension)) {
                Map<String, List<RiskScoreInfoBean>> groupByAreaList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getArea())).collect(Collectors.groupingBy(s -> s.getArea()));
                RiskScoreViewUtils.setRiskScoreResultInfoBeanList(groupByAreaList, riskScoreResultInfoCollBeanList, (String)maxscore, rlevelIds);
            } else if (RiskScoreEnum.HANGYE.getCode().equals(dimension)) {
                Map<String, List<RiskScoreInfoBean>> groupByIndustryList = riskScoreInfoList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getIndustry())).collect(Collectors.groupingBy(s -> s.getIndustry()));
                RiskScoreViewUtils.setRiskScoreResultInfoBeanList(groupByIndustryList, riskScoreResultInfoCollBeanList, (String)maxscore, rlevelIds);
            }
            if (RiskScoreEnum.ORG.getCode().equals(dimension)) {
                Collections.sort(riskScoreResultInfoBeanList, (v1, v2) -> new BigDecimal(v1.getRiskscore()).compareTo(new BigDecimal(v2.getRiskscore())));
                if (riskScoreResultInfoBeanList.size() > 0) {
                    for (RiskScoreResultInfoBean bean : riskScoreResultInfoBeanList) {
                        String orgName = (String)OrgUtils.getInfoByOrgIdFromErp((String)bean.getOrgid().toString(), (String[])new String[]{"number", "name", "uniformsocialcreditcode", "frepresentative", "registeredcapital", "establishmentdate", "bankaccount", "depositbank"}).get("name");
                        keys.add((String)(orgName + "  " + bean.getRiskscore()));
                        this.setDataIds(orgName + "  " + bean.getRiskscore(), pkids, orgids, bean, null, false, riskLevelNames);
                        view.getPageCache().put("rankpagecacheids", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
                        view.getPageCache().put("rankpagecacheorgids", EmptyCheckUtils.isEmpty(orgids) ? null : SerializationUtils.toJsonString(orgids));
                        risk0values.add(bean.getRisktotal0());
                        risk1values.add(bean.getRisktotal1());
                        risk2values.add(bean.getRisktotal2());
                        risk3values.add(bean.getRisktotal3());
                        risk4values.add(bean.getRisktotal4());
                        risk5values.add(bean.getRisktotal5());
                        risk6values.add(bean.getRisktotal6());
                        risk7values.add(bean.getRisktotal7());
                        risk8values.add(bean.getRisktotal8());
                        risk9values.add(bean.getNoRisktotal9());
                    }
                }
            } else if (RiskScoreEnum.TAXCAREA.getCode().equals(dimension)) {
                Collections.sort(riskScoreResultInfoCollBeanList, (v1, v2) -> new BigDecimal(v1.getRiskscore()).compareTo(new BigDecimal(v2.getRiskscore())));
                if (riskScoreResultInfoCollBeanList.size() > 0) {
                    for (RiskScoreResultInfoBean bean : riskScoreResultInfoCollBeanList) {
                        keys.add((String)(bean.getArea() + "  " + bean.getRiskscore()));
                        this.setDataIds(bean.getArea() + "  " + bean.getRiskscore(), pkids, orgids, null, (RiskScoreResultInfoCollBean)bean, true, riskLevelNames);
                        view.getPageCache().put("rankpagecacheids", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
                        view.getPageCache().put("rankpagecacheorgids", EmptyCheckUtils.isEmpty(orgids) ? null : SerializationUtils.toJsonString(orgids));
                        risk0values.add(bean.getRisktotal0());
                        risk1values.add(bean.getRisktotal1());
                        risk2values.add(bean.getRisktotal2());
                        risk3values.add(bean.getRisktotal3());
                        risk4values.add(bean.getRisktotal4());
                        risk5values.add(bean.getRisktotal5());
                        risk6values.add(bean.getRisktotal6());
                        risk7values.add(bean.getRisktotal7());
                        risk8values.add(bean.getRisktotal8());
                        risk9values.add(bean.getNorisktotal9());
                    }
                }
            } else if (RiskScoreEnum.HANGYE.getCode().equals(dimension)) {
                Collections.sort(riskScoreResultInfoCollBeanList, (v1, v2) -> new BigDecimal(v1.getRiskscore()).compareTo(new BigDecimal(v2.getRiskscore())));
                if (riskScoreResultInfoCollBeanList.size() > 0) {
                    for (RiskScoreResultInfoBean bean : riskScoreResultInfoCollBeanList) {
                        keys.add((String)(bean.getIndustry() + "  " + bean.getRiskscore()));
                        this.setDataIds(bean.getIndustry() + "  " + bean.getRiskscore(), pkids, orgids, null, (RiskScoreResultInfoCollBean)bean, true, riskLevelNames);
                        view.getPageCache().put("rankpagecacheids", EmptyCheckUtils.isEmpty(pkids) ? null : SerializationUtils.toJsonString(pkids));
                        view.getPageCache().put("rankpagecacheorgids", EmptyCheckUtils.isEmpty(orgids) ? null : SerializationUtils.toJsonString(orgids));
                        risk0values.add(bean.getRisktotal0());
                        risk1values.add(bean.getRisktotal1());
                        risk2values.add(bean.getRisktotal2());
                        risk3values.add(bean.getRisktotal3());
                        risk4values.add(bean.getRisktotal4());
                        risk5values.add(bean.getRisktotal5());
                        risk6values.add(bean.getRisktotal6());
                        risk7values.add(bean.getRisktotal7());
                        risk8values.add(bean.getRisktotal8());
                        risk9values.add(bean.getNorisktotal9());
                    }
                }
            }
            view.getPageCache().put("keyspagecache", EmptyCheckUtils.isEmpty(keys) ? null : SerializationUtils.toJsonString(keys));
            view.getPageCache().put("risk0valuespagecache", EmptyCheckUtils.isEmpty(risk0values) ? null : SerializationUtils.toJsonString(risk0values));
            view.getPageCache().put("risk1valuespagecache", EmptyCheckUtils.isEmpty(risk1values) ? null : SerializationUtils.toJsonString(risk1values));
            view.getPageCache().put("risk2valuespagecache", EmptyCheckUtils.isEmpty(risk2values) ? null : SerializationUtils.toJsonString(risk2values));
            view.getPageCache().put("risk3valuespagecache", EmptyCheckUtils.isEmpty(risk3values) ? null : SerializationUtils.toJsonString(risk3values));
            view.getPageCache().put("risk4valuespagecache", EmptyCheckUtils.isEmpty(risk4values) ? null : SerializationUtils.toJsonString(risk4values));
            view.getPageCache().put("risk5valuespagecache", EmptyCheckUtils.isEmpty(risk5values) ? null : SerializationUtils.toJsonString(risk5values));
            view.getPageCache().put("risk6valuespagecache", EmptyCheckUtils.isEmpty(risk6values) ? null : SerializationUtils.toJsonString(risk6values));
            view.getPageCache().put("risk7valuespagecache", EmptyCheckUtils.isEmpty(risk7values) ? null : SerializationUtils.toJsonString(risk7values));
            view.getPageCache().put("risk8valuespagecache", EmptyCheckUtils.isEmpty(risk8values) ? null : SerializationUtils.toJsonString(risk8values));
            view.getPageCache().put("risk9valuespagecache", EmptyCheckUtils.isEmpty(risk9values) ? null : SerializationUtils.toJsonString(risk9values));
            if (keys.size() > 10) {
                keys = keys.subList(keys.size() - 10, keys.size());
                risk0values = risk0values.subList(risk0values.size() - 10, risk0values.size());
                risk1values = risk1values.subList(risk1values.size() - 10, risk1values.size());
                risk2values = risk2values.subList(risk2values.size() - 10, risk2values.size());
                risk3values = risk3values.subList(risk3values.size() - 10, risk3values.size());
                risk4values = risk4values.subList(risk4values.size() - 10, risk4values.size());
                risk5values = risk5values.subList(risk5values.size() - 10, risk5values.size());
                risk6values = risk6values.subList(risk6values.size() - 10, risk6values.size());
                risk7values = risk7values.subList(risk7values.size() - 10, risk7values.size());
                risk8values = risk8values.subList(risk8values.size() - 10, risk8values.size());
                risk9values = risk9values.subList(risk9values.size() - 10, risk9values.size());
                view.setVisible(Boolean.TRUE, new String[]{"detailsflex"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
            }
            flag = false;
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
            view.setVisible(Boolean.TRUE, new String[]{"closeflex"});
            Map pkidsMap = new HashMap(16);
            Map orgidsMap = new HashMap(16);
            if (customParams != null) {
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("keys"))) {
                    keys = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("keys")), String.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("highvalues"))) {
                    risk0values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("highvalues")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("midvalues"))) {
                    risk1values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("midvalues")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("lowvalues"))) {
                    risk2values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("lowvalues")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk3values"))) {
                    risk3values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk3values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk4values"))) {
                    risk4values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk4values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk5values"))) {
                    risk5values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk5values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk6values"))) {
                    risk6values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk6values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk7values"))) {
                    risk7values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk7values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk8values"))) {
                    risk8values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk8values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("risk9values"))) {
                    risk9values = SerializationUtils.fromJsonStringToList((String)String.valueOf(customParams.get("risk9values")), Integer.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("pagecacheids"))) {
                    pkidsMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("pagecacheids")), Map.class);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)customParams.get("pagecacheorgids"))) {
                    orgidsMap = (Map)SerializationUtils.fromJsonString((String)String.valueOf(customParams.get("pagecacheorgids")), Map.class);
                }
            }
            view.getPageCache().put("rankpagecacheids", EmptyCheckUtils.isEmpty(pkidsMap) ? null : SerializationUtils.toJsonString(pkidsMap));
            view.getPageCache().put("rankpagecacheorgids", EmptyCheckUtils.isEmpty(orgidsMap) ? null : SerializationUtils.toJsonString(orgidsMap));
            flag = true;
        }
        BarChart customchart = this.getMainChart(view);
        customchart.clearData();
        RiskEchartsHelper.createCategoryAxisForRank(customchart, "", keys, false);
        RiskEchartsHelper.createValueAxisForRank(customchart, "", true);
        DynamicObjectCollection collection = RiskScoreViewUtils.getRiskLevelList((String)Boolean.TRUE.toString());
        if (collection != null) {
            // empty if block
        }
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[0], risk0values.toArray(new Integer[0]), "#D5D5D5", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[1], risk1values.toArray(new Integer[0]), "#F57582", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[2], risk2values.toArray(new Integer[0]), "#FFA940", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[3], risk3values.toArray(new Integer[0]), "#5582F3", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[4], risk4values.toArray(new Integer[0]), "#73D13D", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[5], risk5values.toArray(new Integer[0]), "#45DAD1", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[6], risk6values.toArray(new Integer[0]), "#40A9FF", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[7], risk7values.toArray(new Integer[0]), "#FFC53D", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[8], risk8values.toArray(new Integer[0]), "#F273B5", flag);
        RiskEchartsHelper.createBarSeries(customchart, riskLevelNames[9], risk9values.toArray(new Integer[0]), "#F57582", flag);
        customchart.setMargin(Position.right, "30px");
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(false);
        customchart.setLegendPropValue("padding", (Object)new Integer[]{0, 30, 0, 23});
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private void setDataIds(String key, Map<String, List<String>> pkids, Map<String, List<String>> orgids, RiskScoreResultInfoBean bean, RiskScoreResultInfoCollBean beans, Boolean isColl, String[] riskLevelNames) {
        ArrayList<String> orgList = new ArrayList<String>(16);
        if (!isColl.booleanValue()) {
            if (bean != null) {
                orgList.add(bean.getOrgid().toString());
            }
        } else if (beans != null) {
            beans.getOrgidList().forEach(v -> orgList.add(v.toString()));
        }
        ArrayList<String> orgidList = new ArrayList<String>(16);
        orgidList.addAll(orgList);
        if (isColl.booleanValue()) {
            if (beans != null) {
                pkids.put(key + riskLevelNames[0], Arrays.asList(beans.getIds0().split(",")));
                pkids.put(key + riskLevelNames[1], Arrays.asList(beans.getIds1().split(",")));
                pkids.put(key + riskLevelNames[2], Arrays.asList(beans.getIds2().split(",")));
                pkids.put(key + riskLevelNames[3], Arrays.asList(beans.getIds3().split(",")));
                pkids.put(key + riskLevelNames[4], Arrays.asList(beans.getIds4().split(",")));
                pkids.put(key + riskLevelNames[5], Arrays.asList(beans.getIds5().split(",")));
                pkids.put(key + riskLevelNames[6], Arrays.asList(beans.getIds6().split(",")));
                pkids.put(key + riskLevelNames[7], Arrays.asList(beans.getIds7().split(",")));
                pkids.put(key + riskLevelNames[8], Arrays.asList(beans.getIds8().split(",")));
                pkids.put(key + riskLevelNames[9], Arrays.asList(beans.getNoids().split(",")));
            }
        } else if (bean != null) {
            pkids.put(key + riskLevelNames[0], Arrays.asList(bean.getIds0().split(",")));
            pkids.put(key + riskLevelNames[1], Arrays.asList(bean.getIds1().split(",")));
            pkids.put(key + riskLevelNames[2], Arrays.asList(bean.getIds2().split(",")));
            pkids.put(key + riskLevelNames[3], Arrays.asList(bean.getIds3().split(",")));
            pkids.put(key + riskLevelNames[4], Arrays.asList(bean.getIds4().split(",")));
            pkids.put(key + riskLevelNames[5], Arrays.asList(bean.getIds5().split(",")));
            pkids.put(key + riskLevelNames[6], Arrays.asList(bean.getIds6().split(",")));
            pkids.put(key + riskLevelNames[7], Arrays.asList(bean.getIds7().split(",")));
            pkids.put(key + riskLevelNames[8], Arrays.asList(bean.getIds8().split(",")));
            pkids.put(key + riskLevelNames[9], Arrays.asList(bean.getNoids().split(",")));
        }
        for (int i = 0; i < riskLevelNames.length; ++i) {
            orgids.put(key + riskLevelNames[i], orgidList);
        }
    }

    private String getMidids() {
        return ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"RiskScoreRankHelper_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    private String getHighids() {
        return ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"RiskScoreRankHelper_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    private String getLowids() {
        return ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"RiskScoreRankHelper_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    private BarChart getMainChart(IFormView view) {
        BarChart barChart = (BarChart)view.getControl("barchartap");
        return barChart;
    }
}

