/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.analysis;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.IFormView;
import kd.bos.form.chart.PointLineChart;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.tctrc.common.entity.risk.RiskScoreInfoBean;
import kd.taxc.tctrc.common.entity.risk.RiskScoreResultInfoBean;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.analysis.AbstractRiskScoreService;
import kd.taxc.tctrc.formplugin.analysis.RiskEchartsHelper;

public class RiskScoreTrendHelper
extends AbstractRiskScoreService {
    @Override
    public void initChat(IFormView view, String type, Map<String, Object> customParams) {
        view.setVisible(Boolean.FALSE, new String[]{"detailsflex"});
        ArrayList<RiskScoreInfoBean> riskScoreInfoList = new ArrayList<RiskScoreInfoBean>(32);
        this.commonHander(view, riskScoreInfoList);
        List<Long> rlevelIds = new ArrayList(16);
        Map<String, Object> rlevelMap = this.getRlevelIds();
        Map rlevelNameMap = new HashMap(16);
        if (rlevelMap != null) {
            rlevelIds = (List)rlevelMap.get("rlevelIds");
            rlevelNameMap = (Map)rlevelMap.get("rlevelIdVlue");
        }
        if (rlevelIds != null && rlevelIds.size() <= 0) {
            return;
        }
        String[] riskLevelNames = new String[10];
        int i = 0;
        if (!CollectionUtils.isEmpty(rlevelIds)) {
            for (Long riskLevelId : rlevelIds) {
                riskLevelNames[i] = (String)rlevelNameMap.get(riskLevelId);
                if (++i <= 9) continue;
                break;
            }
        }
        Map<String, BigDecimal> currentScoreMap = this.initScoreMap(view);
        if (EmptyCheckUtils.isEmpty(riskScoreInfoList)) {
            return;
        }
        Date enddate = (Date)view.getParentView().getModel().getValue("enddate");
        String maxscore = RiskScoreViewUtils.getCurrentMaxScore((Date)enddate);
        if (StringUtil.isEmpty((CharSequence)maxscore)) {
            return;
        }
        String dimension = (String)view.getParentView().getModel().getValue("dimension");
        HashMap<String, List<Long>> pkids = new HashMap<String, List<Long>>(32);
        this.setScore(currentScoreMap, riskScoreInfoList, pkids, dimension, maxscore, rlevelIds);
        PointLineChart chart = this.getMainChart(view);
        RiskEchartsHelper.drawTrendChart(currentScoreMap, chart);
    }

    private PointLineChart getMainChart(IFormView view) {
        PointLineChart lineChart = (PointLineChart)view.getControl("pointlinechartap");
        return lineChart;
    }

    private Map<String, BigDecimal> initScoreMap(IFormView view) {
        Date startDate = (Date)view.getParentView().getModel().getValue("startdate");
        Date endDate = (Date)view.getParentView().getModel().getValue("enddate");
        List monthList = DateUtils.getMonthBetween((Date)startDate, (Date)endDate);
        LinkedHashMap<String, BigDecimal> scoreMap = new LinkedHashMap<String, BigDecimal>(monthList.size());
        for (String month : monthList) {
            scoreMap.put(month, BigDecimal.ZERO);
        }
        return scoreMap;
    }

    private void setScore(Map<String, BigDecimal> scoreMap, List<RiskScoreInfoBean> resultCol, Map<String, List<Long>> pkids, String dimension, String maxscore, List<Long> rlevelIds) {
        Map<String, List<RiskScoreInfoBean>> newResultCol = resultCol.stream().collect(Collectors.groupingBy(s -> DateUtils.format((Date)s.getEnddate(), (String)"yyyy-MM")));
        Iterator<Map.Entry<String, List<RiskScoreInfoBean>>> iterator = newResultCol.entrySet().iterator();
        while (iterator.hasNext()) {
            ArrayList<RiskScoreResultInfoBean> riskScoreResultInfoBeanList = new ArrayList<RiskScoreResultInfoBean>(16);
            Map.Entry<String, List<RiskScoreInfoBean>> entry = iterator.next();
            List<RiskScoreInfoBean> beanList = entry.getValue();
            Map<Long, List<RiskScoreInfoBean>> groupByOrgList = beanList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getOrg())).collect(Collectors.groupingBy(s -> s.getOrg()));
            for (Map.Entry<Long, List<RiskScoreInfoBean>> entry2 : groupByOrgList.entrySet()) {
                List<RiskScoreInfoBean> beanList2 = entry2.getValue();
                RiskScoreResultInfoBean bean = RiskScoreViewUtils.createNewBean(beanList2, (String)maxscore, rlevelIds);
                riskScoreResultInfoBeanList.add(bean);
            }
            BigDecimal totalScore = riskScoreResultInfoBeanList.stream().map(s -> new BigDecimal(s.getRiskscore())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal newScore = totalScore.divide(BigDecimal.valueOf(riskScoreResultInfoBeanList.size()), 2, 4);
            scoreMap.put(entry.getKey(), newScore);
        }
    }
}

