/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.apphome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.formplugin.apphome.Node;

public class TctrcHFTopRiskPlgun
extends AbstractFormPlugin
implements HyperLinkClickListener,
ListboxClickListener {
    private static final String LISTBOXAP = "listboxap";
    private static final String MONTH = "month";
    private static final String TOTAL = "total";
    private static final String ALL = "all";
    private static final String TOTAL_TYPE = "totaltype";
    private static final String TCTRC_HANDLE_LIST = "tctrc_handle_list";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        listboxap.addListboxClickListener((ListboxClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initListBoxItems();
        this.initHRiskTop10();
    }

    private void initListBoxItems() {
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem(MONTH, ResManager.loadKDString((String)"\u672c\u6708", (String)"TctrcHFTopRiskPlgun_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(TOTAL, ResManager.loadKDString((String)"\u7d2f\u8ba1", (String)"TctrcHFTopRiskPlgun_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(ALL, ResManager.loadKDString((String)"\u5168\u90e8", (String)"TctrcHFTopRiskPlgun_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.getPageCache().put(TOTAL_TYPE, MONTH);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(TOTAL_TYPE, itemId);
        this.initHRiskTop10();
    }

    private void initHRiskTop10() {
        QFilter startFilter = null;
        String itemid = this.getPageCache().get(TOTAL_TYPE);
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (MONTH.equals(itemid)) {
            startFilter = new QFilter("runtime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        } else if (TOTAL.equals(itemid)) {
            startFilter = new QFilter("runtime", ">=", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        }
        if (null != startFilter) {
            QFilter endFilter = new QFilter("runtime", "<=", (Object)new Date());
            startFilter.and(endFilter);
            qFilterList.add(startFilter);
        }
        qFilterList.add(new QFilter("rlevel.id", "not in", Arrays.asList(5, 4)));
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tctrc", (String)TCTRC_HANDLE_LIST, (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilterList.add(new QFilter("runorg.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)TCTRC_HANDLE_LIST, (String)"id,risk.id,risk.name,risk.number", (QFilter[])qFilterList.toArray(new QFilter[0]));
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (EmptyCheckUtils.isEmpty((Object)dynamicObjectCollection)) {
            return;
        }
        HashMap<String, List> riskGroupCountMap = new HashMap<String, List>();
        HashMap<String, DynamicObject> code2BeaMap = new HashMap<String, DynamicObject>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String key = dynamicObject.getString("risk.number");
            if (!EmptyCheckUtils.isNotEmpty((Object)key)) continue;
            code2BeaMap.put(key, dynamicObject);
            ArrayList<DynamicObject> groupList = (ArrayList<DynamicObject>)riskGroupCountMap.get(key);
            if (EmptyCheckUtils.isEmpty((Object)groupList)) {
                groupList = new ArrayList<DynamicObject>();
            }
            groupList.add(dynamicObject);
            riskGroupCountMap.put(key, groupList);
        }
        ArrayList nodes = new ArrayList();
        riskGroupCountMap.forEach((k, v) -> {
            DynamicObject bean = (DynamicObject)code2BeaMap.get(k);
            if (null != bean) {
                nodes.add(new Node(bean.getString("risk.name"), Long.parseLong(String.valueOf(v.size())), bean.getString("risk.number"), v.stream().map(v1 -> v1.getString("id")).collect(Collectors.joining(","))));
            }
        });
        List sortedList = nodes.stream().sorted(Comparator.comparing(Node::getCount).reversed()).collect(Collectors.toList());
        for (int i = 0; i < sortedList.size() && i <= 9; ++i) {
            int row = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("riskname", (Object)((Node)sortedList.get(i)).getRiskName(), row);
            this.getModel().setValue("risknumber", (Object)((Node)sortedList.get(i)).getRiskNumber(), row);
            this.getModel().setValue("riskid", (Object)((Node)sortedList.get(i)).getRiskId(), row);
            this.getModel().setValue("riskcount", (Object)((Node)sortedList.get(i)).getCount(), row);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String riskid = String.valueOf(this.getModel().getValue("riskid", rowIndex));
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(TCTRC_HANDLE_LIST);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
        List pkids = KdToolUtils.stringToLong((String[])riskid.split(","));
        for (Long pkid : pkids) {
            linkQueryPkIds.add((Object)new LinkQueryPkId((Object)pkid));
        }
        parameter.setShowQuickFilter(true);
        parameter.setLinkQueryPkIdCollection(linkQueryPkIds);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

