/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.apphome;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;

public class TctrcRiskDefCountPlugin
extends AbstractFormPlugin {
    private static final String RISK_TOTAL = "risktotal";
    private static final String RISK_DEF_FORM = "tctrc_risk_definition";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{RISK_TOTAL});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCountCard();
    }

    private void initCountCard() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)RISK_DEF_FORM, (String)"id", (QFilter[])new QFilter[]{qFilter});
        long count = EmptyCheckUtils.isEmpty((Object)dynamicObjectCollection) ? 0L : dynamicObjectCollection.stream().count();
        Label label = (Label)this.getView().getControl(RISK_TOTAL);
        label.setText(String.valueOf(count));
        this.getPageCache().put(RISK_TOTAL, dynamicObjectCollection.stream().map(k -> k.getString("id")).collect(Collectors.joining(",")));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (RISK_TOTAL.equals(key)) {
            this.openRiskDefList();
        }
    }

    private void openRiskDefList() {
        ListShowParameter parameter = new ListShowParameter();
        String pkids = this.getPageCache().get(RISK_TOTAL);
        List pkidList = KdToolUtils.stringToLong((String[])pkids.split(","));
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl((List)pkidList);
        parameter.setLinkQueryPkIdCollection(collection);
        parameter.setFormId("bos_templatetreelist");
        parameter.setBillFormId(RISK_DEF_FORM);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

