/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.apphome;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.constant.RiskLevelEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.formplugin.apphome.ShowData;
import kd.taxc.tctrc.formplugin.apphome.ShowItem;

public class TctrcRiskMonitor
extends AbstractFormPlugin
implements ClickListener,
ListboxClickListener {
    private static final String LISTBOXAP = "listboxap";
    private static final String CHART_ENTITY = "histogramchartap";
    private static final String WAIT_HANDLE = "0";
    private static final String HAS_HANDLE = "1";
    private static final String TRANSMITTING = "2";
    private static final String HANDLE_STATUS = "status";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String GREEN = "#00bf5f";
    private static final String YELLOW = "#f69343";
    private static final String RED = "#ff0000";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        HistogramChart histogramChart = (HistogramChart)this.getControl(CHART_ENTITY);
        histogramChart.addClickListener((ClickListener)this);
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        listboxap.addListboxClickListener((ListboxClickListener)this);
    }

    private void initListBoxItems() {
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem(WAIT_HANDLE, ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"TctrcRiskMonitor_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(HAS_HANDLE, ResManager.loadKDString((String)"\u5df2\u5904\u7406", (String)"TctrcRiskMonitor_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(TRANSMITTING, ResManager.loadKDString((String)"\u8f6c\u4ea4\u4e2d", (String)"TctrcRiskMonitor_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.getPageCache().put(HANDLE_STATUS, WAIT_HANDLE);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(HANDLE_STATUS, itemId);
        this.displayCountsByHandleStatus();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CHART_ENTITY.equals(key)) {
            String riskLevelName = ((ChartClickEvent)evt).getSeriesName();
            String riskLevel = RiskLevelEnum.getRiskLevelByName((String)riskLevelName);
            this.openRiskRunResultList(riskLevel);
        }
    }

    public void openRiskRunResultList(String riskLevel) {
        if (EmptyCheckUtils.isEmpty((Object)riskLevel)) {
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("tctrc_handle_list");
        String pkids = RiskLevelEnum.RISK_LEVEL_HIGH.getRiskLevel().equals(riskLevel) ? this.getPageCache().get("highpkidlist") : (RiskLevelEnum.RISK_LEVEL_MID.getRiskLevel().equals(riskLevel) ? this.getPageCache().get("midpkidlist") : this.getPageCache().get("lowpkidlist"));
        List pkidList = KdToolUtils.stringToLong((String[])pkids.split(","));
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl((List)pkidList);
        parameter.setLinkQueryPkIdCollection(collection);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterCreateNewData(EventObject e) {
        this.displayDefaultDate();
        this.initListBoxItems();
        this.displayCountsByHandleStatus();
    }

    public void displayDefaultDate() {
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        Date now = new Date();
        if (startDate == null) {
            this.getModel().setValue(START_DATE, (Object)DateUtils.getFirstDateOfYear((Date)now));
        }
        if (endDate == null) {
            this.getModel().setValue(END_DATE, (Object)now);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(START_DATE) || name.equals(END_DATE)) {
            this.displayCountsByHandleStatus();
        }
    }

    public void displayCountsByHandleStatus() {
        String handleStatus;
        int highCount = 0;
        int midCount = 0;
        int lowCount = 0;
        ArrayList<ShowData> showDatas = new ArrayList<ShowData>();
        QFilter orgFilter = null;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tctrc", (String)"tctrc_handle_list", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            orgFilter = new QFilter("runorg.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            qFilterList.add(orgFilter);
        }
        if ((handleStatus = this.getPageCache().get(HANDLE_STATUS)) == null) {
            handleStatus = WAIT_HANDLE;
        }
        QFilter handleStatusFilter = new QFilter(HANDLE_STATUS, "=", (Object)handleStatus);
        qFilterList.add(handleStatusFilter);
        Date startDate = (Date)this.getModel().getValue(START_DATE);
        Date endDate = (Date)this.getModel().getValue(END_DATE);
        QFilter startDateFilter = null;
        if (startDate != null) {
            startDateFilter = new QFilter(START_DATE, ">=", (Object)startDate);
            qFilterList.add(startDateFilter);
        }
        QFilter endDateFilter = null;
        if (endDate != null) {
            endDateFilter = new QFilter(END_DATE, "<=", (Object)endDate);
            qFilterList.add(endDateFilter);
        }
        DynamicObjectCollection riskRunResults = QueryServiceHelper.query((String)"tctrc_handle_list", (String)"id,rlevel.id", (QFilter[])qFilterList.toArray(new QFilter[0]));
        ArrayList<String> highPkIDList = new ArrayList<String>();
        ArrayList<String> midPkIDList = new ArrayList<String>();
        ArrayList<String> lowPkIDList = new ArrayList<String>();
        for (DynamicObject riskRunResult : riskRunResults) {
            String riskLevel = riskRunResult.getString("rlevel.id");
            if (RiskLevelEnum.RISK_LEVEL_HIGH.getRiskLevel().equals(riskLevel)) {
                ++highCount;
                highPkIDList.add(riskRunResult.getString("id"));
                continue;
            }
            if (RiskLevelEnum.RISK_LEVEL_MID.getRiskLevel().equals(riskLevel)) {
                ++midCount;
                midPkIDList.add(riskRunResult.getString("id"));
                continue;
            }
            if (!RiskLevelEnum.RISK_LEVEL_LOW.getRiskLevel().equals(riskLevel)) continue;
            ++lowCount;
            lowPkIDList.add(riskRunResult.getString("id"));
        }
        this.getPageCache().put("highpkidlist", highPkIDList.stream().collect(Collectors.joining(",")));
        this.getPageCache().put("midpkidlist", midPkIDList.stream().collect(Collectors.joining(",")));
        this.getPageCache().put("lowpkidlist", lowPkIDList.stream().collect(Collectors.joining(",")));
        LinkedHashMap<String, Integer> riskLevelMap = new LinkedHashMap<String, Integer>();
        riskLevelMap.put(ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"TctrcRiskMonitor_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), lowCount);
        riskLevelMap.put(ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"TctrcRiskMonitor_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), midCount);
        riskLevelMap.put(ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"TctrcRiskMonitor_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), highCount);
        ShowData showData = new ShowData();
        ArrayList<ShowItem> showItems = new ArrayList<ShowItem>(3);
        for (Map.Entry entry : riskLevelMap.entrySet()) {
            ShowItem showItem = new ShowItem();
            showItem.setNumber((Integer)entry.getValue());
            showItem.setName((String)entry.getKey());
            showItem.setCode(showItems.size() + "");
            showItems.add(showItem);
        }
        showData.setLevel("");
        showData.setShowItems(showItems);
        showDatas.add(showData);
        this.drawPieChart(showDatas);
    }

    private void drawPieChart(List<ShowData> showDatas) {
        if (showDatas.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> colorMap = new LinkedHashMap<String, String>();
        colorMap.put(WAIT_HANDLE, "rgba(0,191,95,0.3)-rgba(0,191,95,1)");
        colorMap.put(HAS_HANDLE, "rgba(246,147,67,0.3)-rgba(246,147,67,1)");
        colorMap.put(TRANSMITTING, "rgba(255,0,0,0.3)-rgba(255,0,0,1)");
        HistogramChart histogramChart = (HistogramChart)this.getControl(CHART_ENTITY);
        histogramChart.setShowLegend(true);
        histogramChart.setMargin(Position.right, "20");
        histogramChart.setMargin(Position.left, "70");
        histogramChart.setLegendAlign(XAlign.center, YAlign.bottom);
        histogramChart.setMargin(Position.top, WAIT_HANDLE);
        histogramChart.setMargin(Position.bottom, "20px");
        histogramChart.setLegendPropValue("padding", (Object)new Integer[]{0, 0, 20, 0});
        histogramChart.clearData();
        Axis xAxis = this.createCategoryAxis((Chart)histogramChart, "", true);
        String[] xItems = new String[]{""};
        List<ShowItem> showItems = showDatas.get(0).getShowItems();
        int barNum = showItems.size();
        for (int i = barNum - 1; i >= 0; --i) {
            Series series = this.createBarSeries("", "", histogramChart);
            Number[] xDatasInt = new Integer[]{showItems.get(i).getNumber()};
            this.setLinearGradient((BarSeries)series, ((String)colorMap.get(i + "")).split("-")[0], ((String)colorMap.get(i + "")).split("-")[1], showItems.get(i).getName());
            ((BarSeries)series).setData(xDatasInt);
        }
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        xAxis.setPropValue("splitLine", splitLine);
        Axis yAxis = this.createCategoryAxis((Chart)histogramChart, "", false);
        yAxis.setCategorys(xItems);
        HashMap<String, Boolean> axisLineMap = new HashMap<String, Boolean>();
        axisLineMap.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisLine", axisLineMap);
        histogramChart.setShowTooltip(true);
        HashMap<String, String> axisPointerMap = new HashMap<String, String>();
        axisPointerMap.put("type", "none");
        histogramChart.addTooltip("axisPointer", axisPointerMap);
        histogramChart.setShowLegend(false);
        histogramChart.refresh();
    }

    private void setLinearGradient(BarSeries barSeries, String color1, String color2, String name) {
        ArrayList<String> funPath = new ArrayList<String>();
        funPath.add("itemStyle");
        funPath.add("normal");
        funPath.add("color");
        barSeries.addFuncPath(funPath);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> normap = new HashMap<String, HashMap<String, String>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 1, 0, [{\"offset\": 0,\"color\": '" + color1 + "'}, {\"offset\": 1, \"color\": '" + color2 + "'}])");
        normap.put("normal", map);
        barSeries.setPropValue("barWidth", (Object)"15");
        barSeries.setPropValue("itemStyle", normap);
        barSeries.setPropValue("barGap", (Object)"300%");
        barSeries.setPropValue("name", (Object)name);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.left);
        label.setFormatter(name);
        barSeries.setLabel(label);
    }

    private Series createBarSeries(String title, String color, HistogramChart chart) {
        BarSeries series = chart.createBarSeries(title);
        Label histogramLabel = new Label();
        histogramLabel.setShow(false);
        series.setType(ChartType.bar);
        series.setColor(color);
        series.setLabel(histogramLabel);
        this.setItemNormalStyle(series);
        return series;
    }

    private void setItemNormalStyle(BarSeries series) {
        Map itemNormalStyle = series.getItemNormalStyle();
        HashMap<String, Boolean> lableMap = new HashMap<String, Boolean>();
        lableMap.put("show", Boolean.FALSE);
        itemNormalStyle.put("label", lableMap);
        HashMap<String, Boolean> lableLineMap = new HashMap<String, Boolean>();
        lableLineMap.put("show", Boolean.FALSE);
        itemNormalStyle.put("labelLine", lableLineMap);
    }

    protected Axis createCategoryAxis(Chart chart, String name, boolean isX) {
        Axis axis = null;
        axis = isX ? chart.createXAxis(name, AxisType.value) : chart.createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    protected void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

