/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.apphome;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;

public class TctrcRiskRunCountPlugin
extends AbstractFormPlugin {
    private static final String CURRENT_MONTH_RUN_TOTAL = "currentmonthruntotal";
    private static final String YEAR_RUN_TOTAL = "yearruntotal";
    private static final String RISK_RESULT_LIST_FORM = "tctrc_risk_run_result";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CURRENT_MONTH_RUN_TOTAL, YEAR_RUN_TOTAL});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCountCard();
    }

    private void initCountCard() {
        DynamicObjectCollection dynamicObjectCollection;
        QFilter startFilter = new QFilter("runtime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()));
        QFilter endFilter = new QFilter("runtime", "<=", (Object)new Date());
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tctrc", (String)RISK_RESULT_LIST_FORM, (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            endFilter.and(new QFilter("runorg.id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
        }
        long count = EmptyCheckUtils.isEmpty((Object)(dynamicObjectCollection = QueryServiceHelper.query((String)RISK_RESULT_LIST_FORM, (String)"id", (QFilter[])new QFilter[]{startFilter, endFilter}))) ? 0L : dynamicObjectCollection.stream().count();
        Label label = (Label)this.getView().getControl(CURRENT_MONTH_RUN_TOTAL);
        label.setText(String.valueOf(count));
        this.setPageCache(CURRENT_MONTH_RUN_TOTAL, dynamicObjectCollection);
        QFilter startFilter2 = new QFilter("runtime", ">=", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        DynamicObjectCollection dynamicObjectCollection2 = QueryServiceHelper.query((String)RISK_RESULT_LIST_FORM, (String)"id", (QFilter[])new QFilter[]{startFilter2, endFilter});
        count = EmptyCheckUtils.isEmpty((Object)dynamicObjectCollection2) ? 0L : dynamicObjectCollection2.stream().count();
        Label label2 = (Label)this.getView().getControl(YEAR_RUN_TOTAL);
        label2.setText(String.valueOf(count));
        this.setPageCache(YEAR_RUN_TOTAL, dynamicObjectCollection2);
    }

    private void setPageCache(String key, DynamicObjectCollection dynamicObjectCollection) {
        this.getPageCache().put(key, dynamicObjectCollection.stream().map(k -> k.getString("id")).collect(Collectors.joining(",")));
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CURRENT_MONTH_RUN_TOTAL.equals(key)) {
            this.openRiskDefList(1);
        } else if (YEAR_RUN_TOTAL.equals(key)) {
            this.openRiskDefList(2);
        }
    }

    private void openRiskDefList(int type) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        String pkids = 1 == type ? this.getPageCache().get(CURRENT_MONTH_RUN_TOTAL) : this.getPageCache().get(YEAR_RUN_TOTAL);
        List pkidList = KdToolUtils.stringToLong((String[])pkids.split(","));
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl((List)pkidList);
        parameter.setLinkQueryPkIdCollection(collection);
        parameter.setBillFormId(RISK_RESULT_LIST_FORM);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

