/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.apphome;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.LicenseTaxEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.KdToolUtils;
import kd.taxc.tctrc.common.util.OrgCheckUtil;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.TreeUtils;

public class TctrcRiskRunListCount
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"number", "check", "verify"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData;
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("org") && (changeData = e.getChangeSet()) != null && changeData.length > 0) {
            DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
            if (null == newOrg) {
                this.getView().getModel().setValue("org", (Object)this.getPageCache().get("orgid"));
                return;
            }
            String neworgid = newOrg.getString("id");
            String appid = this.getView().getFormShowParameter().getAppId();
            if (OrgCheckUtil.checkByElseForm((IFormView)this.getView(), (String)neworgid, (String)appid, (String)LicenseTaxEnum.getEnumInstanceByAppid((String)appid).getCategoryCode(), (String)"tctrc_risk_run_list")) {
                this.getView().getModel().setValue("org", (Object)this.getPageCache().get("orgid"));
            } else {
                this.getPageCache().put("orgid", neworgid);
                this.initCountCard();
            }
        }
    }

    public void displayTaxOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)"tctrc", (String)"tctrc_risk_run_list", (String)"47150e89000000ac");
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        this.getPageCache().put("orgList", SerializationUtils.toJsonString((Object)col));
        Object object = this.getModel().getValue("org");
        if (object == null) {
            Long orgId = RequestContext.get().getOrgId();
            if (!CollectionUtils.isEmpty((Collection)col)) {
                boolean useDefault = false;
                for (DynamicObject obj : col) {
                    if (obj.getLong("id") != orgId.longValue()) continue;
                    this.getModel().setValue("org", (Object)orgId);
                    useDefault = true;
                    break;
                }
                if (!useDefault) {
                    this.getModel().setValue("org", ((DynamicObject)col.get(0)).get("id"));
                } else {
                    this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.displayTaxOrg();
        this.initCountCard();
    }

    private void initCountCard() {
        int numberCount = 0;
        int checkCount = 0;
        int verifyCount = 0;
        ArrayList<String> numberCountPkids = new ArrayList<String>();
        ArrayList<String> checkCountPkids = new ArrayList<String>();
        ArrayList<String> verifyCountPkids = new ArrayList<String>();
        if (EmptyCheckUtils.isEmpty((Object)this.getModel().getValue("org"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8fd0\u884c\u7ec4\u7ec7\u201d\u3002", (String)"TctrcRiskRunListCount_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else {
            QFilter qFilter = new QFilter("runorg.id", "=", ((DynamicObject)this.getModel().getValue("org")).get("id"));
            QFilter qFilter2 = new QFilter("risk.enable", "=", (Object)BooleanEnum.YES.getCode());
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tctrc_risk_run_list", (String)"id,risk.risktype", (QFilter[])new QFilter[]{qFilter, qFilter2});
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String riskType = dynamicObject.getString("risk.risktype");
                if ("1".equals(riskType)) {
                    ++numberCount;
                    numberCountPkids.add(dynamicObject.getString("id"));
                    continue;
                }
                if ("2".equals(riskType)) {
                    ++checkCount;
                    checkCountPkids.add(dynamicObject.getString("id"));
                    continue;
                }
                if (!"3".equals(riskType)) continue;
                ++verifyCount;
                verifyCountPkids.add(dynamicObject.getString("id"));
            }
            Label label = (Label)this.getView().getControl("number");
            label.setText(String.valueOf(numberCount));
            Label labelCheck = (Label)this.getView().getControl("check");
            labelCheck.setText(String.valueOf(checkCount));
            Label labelVerify = (Label)this.getView().getControl("verify");
            labelVerify.setText(String.valueOf(verifyCount));
            this.getPageCache().put("numbercountpkids", numberCountPkids.stream().collect(Collectors.joining(",")));
            this.getPageCache().put("checkcountpkids", checkCountPkids.stream().collect(Collectors.joining(",")));
            this.getPageCache().put("verifycountpkids", verifyCountPkids.stream().collect(Collectors.joining(",")));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("number".equals(key)) {
            this.openRiskRunList("1");
        } else if ("check".equals(key)) {
            this.openRiskRunList("2");
        } else if ("verify".equals(key)) {
            this.openRiskRunList("3");
        }
    }

    public void openRiskRunList(String riskType) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId("tctrc_risk_run_list");
        String pkids = "1".equals(riskType) ? this.getPageCache().get("numbercountpkids") : ("2".equals(riskType) ? this.getPageCache().get("checkcountpkids") : this.getPageCache().get("verifycountpkids"));
        List pkidList = KdToolUtils.stringToLong((String[])pkids.split(","));
        LinkQueryPkIdCollection collection = KdToolUtils.listToLinkQueryPkidColl((List)pkidList);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setLinkQueryPkIdCollection(collection);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

