/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.tctrc.business.checkup.ImportDeclareReportEnum;

public class ImportDeclareReportPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ENTITY = "entryent";
    private static final Map<String, String> fieNameAndIdRelation = new LinkedHashMap<String, String>(3);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid tempGrid = (EntryGrid)this.getView().getControl(ENTITY);
        tempGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        this.queryEntityData();
    }

    private void queryEntityData() {
        ImportDeclareReportEnum[] declareReportEnums = ImportDeclareReportEnum.values();
        String fileInfoCache = this.getPageCache().get("fileInfoCache");
        this.getModel().deleteEntryData(ENTITY);
        this.getModel().beginInit();
        for (ImportDeclareReportEnum declareReportEnum : declareReportEnums) {
            Map resultCache;
            JSONObject resultJsonObject;
            int index = this.getModel().createNewEntryRow(ENTITY);
            String number = declareReportEnum.getNumber();
            this.getModel().setValue("typenumber", (Object)declareReportEnum.getNumber(), index);
            this.getModel().setValue("templatename", (Object)declareReportEnum.getName().loadKDString(), index);
            this.getModel().setValue("upload", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e", (String)"ImportDeclareReportPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), index);
            if (ObjectUtils.isEmpty((Object)fileInfoCache) || ObjectUtils.isEmpty((Object)(resultJsonObject = (JSONObject)(resultCache = (Map)JSONObject.parseObject((String)fileInfoCache, HashMap.class)).get(number)))) continue;
            ArrayList<String> fileNmaes = new ArrayList<String>(fieNameAndIdRelation.keySet());
            int i = 0;
            for (Map.Entry entry : resultJsonObject.entrySet()) {
                String name = (String)fileNmaes.get(i++);
                this.getModel().setValue(name, entry.getKey(), index);
                this.getModel().setValue(fieNameAndIdRelation.get(name), entry.getValue(), index);
            }
        }
        this.getModel().endInit();
        this.getView().updateView(ENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int index = hyperLinkClickEvent.getRowIndex();
        String fieldName = hyperLinkClickEvent.getFieldName();
        String typenumber = (String)this.getModel().getValue("typenumber", index);
        ImportDeclareReportEnum importDeclareReportEnum = ImportDeclareReportEnum.getImportDeclareReportEnumByNumber((String)typenumber);
        if (ObjectUtils.isEmpty((Object)importDeclareReportEnum)) {
            return;
        }
        if ("upload".equals(fieldName)) {
            String importDialogNumber = importDeclareReportEnum.getImportDialog();
            this.showForm(importDialogNumber, importDeclareReportEnum, importDeclareReportEnum.getNumber());
        } else if (fieldName.startsWith("file")) {
            String filename = (String)this.getModel().getValue(fieldName, index);
            String fileIdkey = fieNameAndIdRelation.get(fieldName);
            Object fileId = this.getModel().getValue(fileIdkey, index);
            if (!ObjectUtils.isEmpty((Object)fileId)) {
                Long fileid = Long.valueOf(fileId.toString());
                this.exportFile(fileid, filename, importDeclareReportEnum);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ((org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)actionId) && "zcfzb".equalsIgnoreCase(actionId) || "lrb".equalsIgnoreCase(actionId)) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(returnData = closedCallBackEvent.getReturnData())) && "success".equalsIgnoreCase(returnData.toString())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImportDeclareReportPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
    }

    private void exportFile(Long fileid, String filename, ImportDeclareReportEnum importDeclareReportEnum) {
        String table = importDeclareReportEnum.getTable();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)table, (String)MetadataUtil.getAllFieldString((String)table), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fileid)});
        OperationServiceHelper.executeOperate((String)"export", (String)table, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
    }

    private void showForm(String importDialogNumber, ImportDeclareReportEnum importDeclareReportEnum, String actionId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(importDialogNumber);
        parameter.setCustomParam("source", (Object)"declare");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)this.getView().getParentView())) {
            return;
        }
        Map customParam = importDeclareReportEnum.getCustomParam(Long.valueOf(this.getView().getParentView().getModel().getDataEntity().getLong("org.id")), this.getView().getParentView().getModel().getDataEntity().getDate("startdate"), this.getView().getParentView().getModel().getDataEntity().getDate("enddate"));
        if (!ObjectUtils.isEmpty((Object)customParam)) {
            parameter.getCustomParams().putAll(customParam);
        }
        this.getView().showForm(parameter);
    }

    static {
        fieNameAndIdRelation.put("file_one", "file_one_id");
        fieNameAndIdRelation.put("file_two", "file_two_id");
        fieNameAndIdRelation.put("file_three", "file_three_id");
    }
}

