/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.grid.DataGrid;
import kd.bos.form.control.grid.DataGridRow;
import kd.bos.form.control.grid.DataGridRowBuilder;
import kd.bos.form.control.grid.events.DataGridBindDataEvent;
import kd.bos.form.control.grid.events.DataGridBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.constant.tctsa.PredetailConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctsa.yhmx.YhmxServiceHelper;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tctrc.business.tctrc.TctrcPrefereceRecordBusiness;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import org.apache.commons.lang3.BooleanUtils;

public class PrefentDetailPlugin
extends AbstractFormPlugin
implements DataGridBindDataListener {
    private static Log logger = LogFactory.getLog(PrefentDetailPlugin.class);
    private static final String AMOUNT = "amount";
    private static final String PREFERENTTAX = "preferenttax";
    private static final String AMOUNTINCOME = "amountincome";

    public void initialize() {
        DataGrid dataGrid = (DataGrid)this.getControl("datagridapyhmx");
        dataGrid.addBindDataListener((DataGridBindDataListener)this);
    }

    public void dataGridBindData(DataGridBindDataEvent e) {
        logger.info("\u4f18\u60e0\u660e\u7ec6\u5f00\u59cb-PrefentDetailPlugin");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sbbid = (String)customParams.get("sbbid");
        String isrecord = (String)customParams.get("isrecord");
        if (Boolean.TRUE.toString().equals(isrecord)) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            DynamicObject[] dynamicObjects = TctrcPrefereceRecordBusiness.getTctrcPrefereceRecord((QFilter)qFilter);
            DataGridRowBuilder builder = e.getDataGridRowBuilder();
            int index = 0;
            ArrayList<List> list = new ArrayList<List>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    DataGridRow row = builder.buildRow();
                    row.setValue("rk", (Object)index);
                    row.setValue("seq", (Object)(index + 1));
                    row.setValue("org", (Object)dynamicObject1.getString("org"));
                    row.setValue("taxationsysid", (Object)dynamicObject1.getString("taxationsysid"));
                    row.setValue("taxcategoryid", (Object)dynamicObject1.getString("taxcategoryid"));
                    row.setValue("skssqq", (Object)dynamicObject1.getString("skssqq"));
                    row.setValue("statisticprotid", (Object)dynamicObject1.getString("statisticprotid"));
                    row.setValue("preferenttype", (Object)dynamicObject1.getString("preferenttype"));
                    row.setValue(AMOUNTINCOME, (Object)dynamicObject1.getBigDecimal(AMOUNTINCOME).setScale(2, 4));
                    row.setValue(PREFERENTTAX, (Object)dynamicObject1.getBigDecimal(PREFERENTTAX).setScale(2, 4));
                    row.setValue(AMOUNT, (Object)dynamicObject1.getBigDecimal(AMOUNT));
                    list.add(row.get());
                    ++index;
                }
            }
            e.setData(list);
        } else {
            if (BooleanUtils.isFalse((Boolean)HealthUtil.checkInput((IFormView)this.getView().getParentView()))) {
                return;
            }
            Long orgids = this.getView().getParentView().getModel().getDataEntity().getLong("org.id");
            Date start = this.getView().getParentView().getModel().getDataEntity().getDate("startdate");
            Date end = this.getView().getParentView().getModel().getDataEntity().getDate("enddate");
            TaxResult bdlist = YhmxServiceHelper.queryPreferentDetail((Long)orgids, (Date)start, (Date)(end = HealthUtil.getLastDateOfMonth((Date)end)), (String)"taxcategoryid.name, skssqq");
            if (bdlist == null || !bdlist.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)bdlist.getData()))) {
                logger.info("\u67e5\u8be2\u5df2\u4eab\u7a0e\u6536\u4f18\u60e0\u660e\u7ec6:\u65e0\u6570\u636e");
                return;
            }
            List dynamicObjectCollection = (List)bdlist.getData();
            TaxResult bdlist2 = YhmxServiceHelper.queryPreferentDetailsum((Long)orgids, (Date)start, (Date)end, null);
            if (bdlist2 == null || !bdlist2.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)bdlist2.getData()))) {
                logger.info("\u67e5\u8be2\u5df2\u4eab\u7a0e\u6536\u4f18\u60e0\u660e\u7ec6:\u65e0\u5408\u8ba1\u6570\u636e");
                return;
            }
            DynamicObject amountSum = (DynamicObject)((List)bdlist2.getData()).get(0);
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_preference_record");
            mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
            Map<String, String> comboItems = this.getComboItems("tctsa_preferentdetail");
            ArrayList<List> list = new ArrayList<List>(dynamicObjectCollection.size());
            int index = 0;
            DataGridRowBuilder builder = e.getDataGridRowBuilder();
            DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
            for (DynamicObject nodes : dynamicObjectCollection) {
                if (StringUtils.isEmpty((String)nodes.getString("entryentity.statisticprotid.name")) || nodes.getBigDecimal("entryentity.amountincome").compareTo(BigDecimal.ZERO) == 0 && nodes.getBigDecimal("entryentity.preferenttax").compareTo(BigDecimal.ZERO) == 0) continue;
                DynamicObject dynamicObject = entity0Collection.addNew();
                DataGridRow row = builder.buildRow();
                row.setValue("rk", (Object)index);
                row.setValue("seq", (Object)(index + 1));
                row.setValue("org", (Object)nodes.getString("org.name"));
                row.setValue("taxationsysid", (Object)nodes.getString("taxationsysid.name"));
                row.setValue("taxcategoryid", (Object)nodes.getString("taxcategoryid.name"));
                row.setValue("skssqq", (Object)(DateUtils.format((Date)nodes.getDate("skssqq"), (String)HealthUtil.getYyyymmddChinese()) + "-" + DateUtils.format((Date)nodes.getDate("skssqz"), (String)HealthUtil.getYyyymmddChinese())));
                row.setValue("statisticprotid", (Object)nodes.getString("entryentity.statisticprotid.name"));
                row.setValue("preferenttype", (Object)(comboItems.get(nodes.getString("entryentity.preferenttype")) == null ? nodes.getString("entryentity.preferenttype") : comboItems.get(nodes.getString("entryentity.preferenttype"))));
                row.setValue(AMOUNTINCOME, (Object)nodes.getBigDecimal("entryentity.amountincome"));
                row.setValue(PREFERENTTAX, (Object)nodes.getBigDecimal("entryentity.preferenttax"));
                BigDecimal amountincomeentry = nodes.getBigDecimal("entryentity.amountincome") == null ? BigDecimal.ZERO : nodes.getBigDecimal("entryentity.amountincome");
                BigDecimal preferenttaxentry = nodes.getBigDecimal("entryentity.preferenttax") == null ? BigDecimal.ZERO : nodes.getBigDecimal("entryentity.preferenttax");
                row.setValue(AMOUNT, (Object)amountincomeentry.multiply(PredetailConstant.RATIO).add(preferenttaxentry).setScale(2, 4));
                dynamicObject.set("org", (Object)nodes.getString("org.name"));
                dynamicObject.set("taxationsysid", (Object)nodes.getString("taxationsysid.name"));
                dynamicObject.set("taxcategoryid", (Object)nodes.getString("taxcategoryid.name"));
                dynamicObject.set("skssqq", (Object)(DateUtils.format((Date)nodes.getDate("skssqq"), (String)HealthUtil.getYyyymmddChinese()) + "-" + DateUtils.format((Date)nodes.getDate("skssqz"), (String)HealthUtil.getYyyymmddChinese())));
                dynamicObject.set("statisticprotid", (Object)nodes.getString("entryentity.statisticprotid.name"));
                dynamicObject.set("preferenttype", (Object)(comboItems.get(nodes.getString("entryentity.preferenttype")) == null ? nodes.getString("entryentity.preferenttype") : comboItems.get(nodes.getString("entryentity.preferenttype"))));
                dynamicObject.set(AMOUNTINCOME, (Object)nodes.getBigDecimal("entryentity.amountincome"));
                dynamicObject.set(PREFERENTTAX, (Object)nodes.getBigDecimal("entryentity.preferenttax"));
                dynamicObject.set(AMOUNT, (Object)amountincomeentry.multiply(PredetailConstant.RATIO).add(preferenttaxentry).setScale(2, 4));
                list.add(row.get());
                ++index;
            }
            DynamicObject dynamicObject1 = entity0Collection.addNew();
            DataGridRow row = builder.buildRow();
            row.setValue("rk", (Object)index);
            row.setValue("seq", (Object)(index + 1));
            row.setValue("org", (Object)HealthUtil.getSumRowFlag());
            row.setValue(AMOUNTINCOME, amountSum.get(AMOUNTINCOME));
            row.setValue(PREFERENTTAX, amountSum.get(PREFERENTTAX));
            row.setValue(AMOUNT, (Object)amountSum.getBigDecimal(AMOUNT).setScale(2, 4));
            dynamicObject1.set("org", (Object)HealthUtil.getSumRowFlag());
            dynamicObject1.set(AMOUNTINCOME, amountSum.get(AMOUNTINCOME));
            dynamicObject1.set(PREFERENTTAX, amountSum.get(PREFERENTTAX));
            dynamicObject1.set(AMOUNT, (Object)amountSum.getBigDecimal(AMOUNT).setScale(2, 4));
            list.add(row.get());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
            e.setData(list);
            logger.info("\u4f18\u60e0\u660e\u7ec6\u7ed3\u675f-PrefentDetailPlugin");
        }
    }

    private Map<String, String> getComboItems(String entityid) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        HashMap<String, String> comboitemmap = new HashMap<String, String>();
        if (mainEntityType != null) {
            Map allEntities = mainEntityType.getAllEntities();
            for (Map.Entry entityentry : allEntities.entrySet()) {
                EntityType value = (EntityType)entityentry.getValue();
                DataEntityPropertyCollection mainPros3 = value.getProperties();
                for (IDataEntityProperty property : mainPros3) {
                    if (!"preferenttype".equals(property.getName())) continue;
                    ((ComboProp)property).getComboItems().stream().forEach(object -> comboitemmap.put(object.getValue(), object.getName().getLocaleValue()));
                }
            }
        }
        return comboitemmap;
    }
}

