/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.formplugin.checkup.TctrcCheckupOverviewPlugin;

public class TctrcCheckupHomePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TctrcCheckupOverviewPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long sbbid = (Long)customParams.get("sbbid");
        String isrecord = (String)customParams.get("isrecord");
        if (Boolean.TRUE.toString().equals(isrecord)) {
            this.initHeader(customParams);
            this.getPageCache().put("sbbid", String.valueOf(sbbid));
            this.getPageCache().put("isrecord", isrecord);
            this.getView().invokeOperation("checkup");
        } else {
            this.initData();
            this.putYearToCache();
            String isdownload = (String)customParams.get("isdownload");
            if (EmptyCheckUtils.isNotEmpty((Object)isdownload) && "1".equals(isdownload)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"toolbarap"});
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"kdanalyzeflex", "kdanalyzeresult"});
    }

    private void initHeader(Map<String, Object> customParams) {
        this.getModel().setValue("org", customParams.get("org"));
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)((String)customParams.get("startdate")))));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth2((Date)DateUtils.stringToDate((String)((String)customParams.get("enddate")))));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"upload"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Button)evt.getSource()).getKey();
        if ("upload".equalsIgnoreCase(clickKey)) {
            this.showForm("tctrc_import_list");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            Object result = this.putYearToCache();
            DynamicObject dy = (DynamicObject)this.getModel().getValue("org");
            if (EmptyCheckUtils.isEmpty((Object)dy)) {
                result = Boolean.FALSE;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TctrcCheckupHomePlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            }
            if (Boolean.TRUE.equals(result)) {
                this.refreshView();
            }
            this.getPageCache().put("checkResult", result.toString());
        }
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
        formShowParameter.getCustomParams().put("orgFuncId", "40");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"TctrcCheckupHomePlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        TaxResult taxResultList1 = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"tctrc", (String)"tctrc_checkup_home", (String)"47150e89000000ac", null);
        TaxResult taxResultList2 = TaxcLicenseCheckDataServiceHelper.getOrgByAppId((String)"tctrc", (String)"B");
        ArrayList orgList1 = (ArrayList)taxResultList1.getData();
        List orgList2 = (List)taxResultList2.getData();
        if (EmptyCheckUtils.isNotEmpty((Object)orgList1)) {
            logger.info("orglist1 size:{}" + orgList1.size());
            logger.info("orglist2 size:{}" + (EmptyCheckUtils.isNotEmpty((Object)orgList2) ? orgList2.size() : 0));
            orgList1.retainAll(orgList2 == null ? new ArrayList(16) : orgList2);
        } else {
            logger.info("orglist1 size:0");
            orgList1 = new ArrayList(16);
        }
        QFilter orgIdsFilter = new QFilter("id", "in", orgList1);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    private boolean validateDate(Date start, Date end) {
        Date startdate;
        Date enddate = DateUtils.getLastDateOfMonth((Date)end);
        return null == enddate || !(startdate = DateUtils.getFirstDateOfMonth((Date)start)).after(enddate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getChangeSet()[0].getNewValue() == null) {
            return;
        }
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (date == null || dateend == null) {
            return;
        }
    }

    private Object putYearToCache() {
        Date date = (Date)this.getModel().getValue("startdate");
        Date dateend = (Date)this.getModel().getValue("enddate");
        if (EmptyCheckUtils.isEmpty((Object)date) || EmptyCheckUtils.isEmpty((Object)dateend)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u67e5\u8be2\u8303\u56f4\u201d\u3002", (String)"TctrcCheckupHomePlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean result = this.validateDate(date, dateend);
        if (!result) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6708\u4efd\u9009\u62e9\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f00\u59cb\u6708\u4efd\u5fc5\u987b\u2264\u7ed3\u675f\u6708\u4efd\u3002", (String)"TctrcCheckupHomePlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean issame = this.validateSameDateYear(date, dateend);
        if (!issame) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u8303\u56f4\u8d77\u6b62\u5e94\u8be5\u4e3a\u540c\u4e00\u5e74\u3002", (String)"TctrcCheckupHomePlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return "falseButNochange";
        }
        return true;
    }

    private boolean validateSameDateYear(Date date, Date dateend) {
        int dateendYear;
        int dateYear;
        return null == date || null == dateend || (dateYear = DateUtils.getYearOfDate((Date)date)) == (dateendYear = DateUtils.getYearOfDate((Date)dateend));
    }

    private void refreshView() {
        String sbbid = this.getPageCache().get("sbbid");
        String isrecord = this.getPageCache().get("isrecord");
        if (Boolean.TRUE.toString().equals(isrecord)) {
            this.openPage(isrecord, sbbid);
        } else {
            String isrecheck = this.getPageCache().get("isrecheck");
            Date startDate = DateUtils.trunc((Date)((Date)this.getModel().getValue("startdate")));
            Date endDate = DateUtils.trunc((Date)((Date)this.getModel().getValue("enddate")));
            Boolean isreinto = true;
            if ("1".equals(isrecheck)) {
                isreinto = true;
                this.getPageCache().put("isrecheck", null);
            } else {
                QFilter qFilter = new QFilter("org", "=", (Object)this.getModel().getDataEntity().getLong("org.id"));
                QFilter startdateFilter = new QFilter("startDate", "=", (Object)startDate);
                QFilter enddateFilter = new QFilter("enddate", "=", (Object)endDate);
                qFilter.and(startdateFilter).and(enddateFilter);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctrc_checkup_report_list", (String)"id,org,startDate,enddate,createtime", (QFilter[])new QFilter[]{qFilter}, (String)"createtime desc");
                if (collection.size() > 0) {
                    sbbid = ((DynamicObject)collection.get(0)).getString("id");
                    this.getPageCache().put("sbbid", sbbid);
                    this.getPageCache().put("isrecord", Boolean.TRUE.toString());
                    this.openPage(Boolean.TRUE.toString(), sbbid);
                    isreinto = false;
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("isrecheck", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u5df2\u5b58\u5728\u68c0\u67e5\u8303\u56f4\u671f\u95f4\u7684\u68c0\u67e5\u62a5\u544a\uff0c\u662f\u5426\u9700\u8981\u91cd\u65b0\u68c0\u67e5\uff1f", (String)"TctrcCheckupHomePlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            }
            if (isreinto.booleanValue()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tctrc_checkup_report_list");
                DynamicObject summary = new DynamicObject((DynamicObjectType)entityType);
                summary.set("org", (Object)this.getModel().getDataEntity().getLong("org.id"));
                summary.set("startdate", (Object)startDate);
                summary.set("enddate", (Object)endDate);
                summary.set("creator", (Object)RequestContext.get().getUserId());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{summary});
                logger.info("id : " + summary.getLong("id"));
                this.getPageCache().put("sbbid", String.valueOf(summary.getLong("id")));
                this.getPageCache().put("isrecord", Boolean.FALSE.toString());
                this.openPage(Boolean.FALSE.toString(), summary.getString("id"));
                QFilter qFilter = new QFilter("entryentity1.orgid", "in", (Object)this.getModel().getDataEntity().getLong("org.id"));
                QFilter startdateFilter = new QFilter("startDate", "<=", (Object)startDate);
                QFilter enddateFilter = new QFilter("enddate", ">=", (Object)endDate);
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                qFilter.and(startdateFilter).and(enddateFilter).and(enableFilter);
                DynamicObjectCollection checkCollection = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition as riskids", (QFilter[])new QFilter[]{qFilter});
                if (EmptyCheckUtils.isEmpty((Object)checkCollection)) {
                    QFilter nullFilter = new QFilter("entryentity1.orgid", "is null", null);
                    nullFilter.and(startdateFilter).and(enddateFilter).and(enableFilter);
                    checkCollection = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition as riskids", (QFilter[])new QFilter[]{nullFilter});
                    if (EmptyCheckUtils.isEmpty((Object)checkCollection)) {
                        return;
                    }
                }
                List riskids = checkCollection.stream().map(e -> e.getLong("riskids")).collect(Collectors.toList());
                QFilter orgFilter = new QFilter("runorg", "=", (Object)this.getModel().getDataEntity().getLong("org.id"));
                QFilter riskFilter = new QFilter("risk", "in", riskids);
                DynamicObject[] objArray = BusinessDataServiceHelper.load((String)"tctrc_risk_run_list", (String)MetadataUtil.getAllFieldString((String)"tctrc_risk_run_list"), (QFilter[])new QFilter[]{orgFilter, riskFilter}, null);
                ArrayList resultList = new ArrayList();
                ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
                progressBar.setPercent(0);
                boolean issucess = true;
                try {
                    RiskService.cal((ProgressBar)progressBar, resultList, (DynamicObject[])objArray, (Date)startDate, (Date)endDate, (String)ResManager.loadKDString((String)"\u624b\u5de5\u8ba1\u7b97\u8fd0\u884c", (String)"TctrcCheckupHomePlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), (Boolean)Boolean.FALSE);
                }
                catch (Exception e2) {
                    issucess = false;
                }
                if (issucess) {
                    progressBar.setPercent(100);
                    int totalRisk = resultList.size();
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u8ba1\u7b97%s\u9879\u98ce\u9669\uff0c\u53ef\u524d\u5f80\u7ed3\u679c\u5217\u8868\u67e5\u770b\u3002", (String)"TctrcCheckupHomePlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), totalRisk));
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if ("isrecheck".equals(fieldKey)) {
            this.getPageCache().put("sbbid", null);
            this.getPageCache().put("isrecord", null);
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getPageCache().put("isrecheck", "1");
                this.getView().invokeOperation("checkup");
            } else {
                return;
            }
        }
    }

    private void openPage(String isrecord, String sbbid) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("org", this.getModel().getDataEntity().getLong("org.id"));
        customParams.put("startDate", this.getModel().getDataEntity().getDate("startdate"));
        customParams.put("endDate", this.getModel().getDataEntity().getDate("enddate"));
        customParams.put("sbbid", sbbid);
        customParams.put("isrecord", isrecord);
        PageShowCommon.showForm((String)"content1", (String)"tctrc_perfentdetail", (IFormView)this.getView(), customParams);
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equals(e.getKey())) {
            this.refreshView();
        }
    }

    private void initData() {
        this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfYear((Date)new Date()));
        this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth2((Date)new Date()));
    }

    private void showForm(String formNumber) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formNumber);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        parameter.setCustomParam("source", (Object)"declare");
        parameter.setCustomParam("templatetype", (Object)"");
        this.getView().showForm(parameter);
    }
}

