/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.PieChart;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.RiskScoreViewUtils;
import kd.taxc.tctrc.formplugin.analysis.RiskEchartsHelper;

public class TctrcCheckupOverviewPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(TctrcCheckupOverviewPlugin.class);
    private static final String PIECHARTAP = "piechartap";
    private static final String PIECHARTAP1 = "piechartap1";

    public void registerListener(EventObject e) {
        PieChart chart = (PieChart)this.getControl(PIECHARTAP);
        chart.addClickListener((ClickListener)this);
        PieChart chart1 = (PieChart)this.getControl(PIECHARTAP1);
        chart1.addClickListener((ClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getControl("otherentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            String result = this.getPageCache().get("checkResult");
            if (Boolean.TRUE.toString().equals(result)) {
                Date startDate = this.getStartDate();
                Date endDate = this.getEndDate();
                Long orgid = this.getOrgid();
                String sbbid = this.getPageCache().get("sbbid");
                String isrecord = this.getPageCache().get("isrecord");
                this.initDrawChartAndData(orgid, startDate, endDate, sbbid, isrecord);
            }
        }
    }

    private void initDrawChartAndData(Long orgid, Date startDate, Date endDate, String sbbid, String isrecord) {
        PieChart pieChart = (PieChart)this.getControl(PIECHARTAP);
        PieChart pieChart1 = (PieChart)this.getControl(PIECHARTAP1);
        pieChart.clearData();
        pieChart.clearGraphic();
        pieChart1.clearData();
        pieChart1.clearGraphic();
        pieChart.refresh();
        pieChart1.refresh();
        this.getModel().deleteEntryData("otherentry");
        if (Boolean.TRUE.toString().equals(isrecord)) {
            DynamicObject[] dynamicObjects;
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_riskcheck_record", (String)"sbbid,riskcollect,taxtypecollect,riskpkids_tag,taxtypepkids_tag,entryentity.scandimensions,entryentity.indexcount,entryentity.indexcount,entryentity.indexcountids_tag,entryentity.hitcount,entryentity.hitcountids_tag,entryentity.highcount,\n entryentity.highcountids_tag,entryentity.meddiescount,entryentity.meddiescountids_tag,entryentity.lowcount,entryentity.lowcountids_tag,\n entryentity.customcount1,entryentity.customcount1ids_tag,entryentity.customcount2,entryentity.customcount2ids_tag,\n entryentity.customcount3,entryentity.customcount3ids_tag,entryentity.customcount4,entryentity.customcount4ids_tag,\n entryentity.customcount5,entryentity.customcount5ids_tag,entryentity.customcount6,entryentity.customcount6ids_tag,\n entryentity.customcount7,entryentity.customcount7ids_tag", (QFilter[])new QFilter[]{qFilter})) {
                String riskpkidsString = dynamicObject.getString("riskpkids_tag");
                String taxtypepkidsString = dynamicObject.getString("taxtypepkids_tag");
                String collectMapString = dynamicObject.getString("riskcollect");
                String collectMap1String = dynamicObject.getString("taxtypecollect");
                Map collectMap = (Map)SerializationUtils.fromJsonString((String)collectMapString, Map.class);
                Map collectMap1 = (Map)SerializationUtils.fromJsonString((String)collectMap1String, Map.class);
                Map riskpkidsStringMap = (Map)SerializationUtils.fromJsonString((String)riskpkidsString, Map.class);
                Map taxtypepkidsStringMap = (Map)SerializationUtils.fromJsonString((String)taxtypepkidsString, Map.class);
                RiskEchartsHelper.drawDistributeChart(collectMap, pieChart, "1");
                RiskEchartsHelper.drawDistributeChart(collectMap1, pieChart1, "1");
                this.getPageCache().put("riskpagecache", EmptyCheckUtils.isEmpty((Object)riskpkidsStringMap) ? null : SerializationUtils.toJsonString((Object)riskpkidsStringMap));
                this.getPageCache().put("taxtypepagecache", EmptyCheckUtils.isEmpty((Object)taxtypepkidsStringMap) ? null : SerializationUtils.toJsonString((Object)taxtypepkidsStringMap));
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                int a = 0;
                EntryGrid entryGrid = (EntryGrid)this.getControl("otherentry");
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    int row = this.getModel().createNewEntryRow("otherentry");
                    this.getModel().setValue("scandimensions", (Object)dynamicObject1.getString("scandimensions"), row);
                    this.getModel().setValue("indexcount", (Object)dynamicObject1.getString("indexcount"), row);
                    this.getModel().setValue("indexcountids", (Object)dynamicObject1.getString("indexcountids_tag"), row);
                    this.getModel().setValue("hitcount", (Object)dynamicObject1.getString("hitcount"), row);
                    this.getModel().setValue("hitcountids", (Object)dynamicObject1.getString("hitcountids_tag"), row);
                    this.getModel().setValue("highcount", (Object)dynamicObject1.getString("highcount"), row);
                    this.getModel().setValue("highcountids", (Object)dynamicObject1.getString("highcountids_tag"), row);
                    this.getModel().setValue("meddiescount", (Object)dynamicObject1.getString("meddiescount"), row);
                    this.getModel().setValue("meddiescountids", (Object)dynamicObject1.getString("meddiescountids_tag"), row);
                    this.getModel().setValue("lowcount", (Object)dynamicObject1.getString("lowcount"), row);
                    this.getModel().setValue("lowcountids", (Object)dynamicObject1.getString("lowcountids_tag"), row);
                    int i = 0;
                    for (int k = 1; k <= 7; ++k) {
                        String customcount = dynamicObject1.getString("customcount" + k);
                        String customname = "";
                        if (EmptyCheckUtils.isNotEmpty((Object)customcount)) {
                            String[] customnames = customcount.split("\\|");
                            customcount = customnames[0];
                            customname = customnames[1];
                        }
                        this.getModel().setValue("customcount" + k, (Object)customcount, row);
                        this.getModel().setValue("customcount" + k + "ids", (Object)dynamicObject1.getString("customcount" + k + "ids_tag"), row);
                        if (!EmptyCheckUtils.isNotEmpty((Object)customname)) continue;
                        ++i;
                        entryGrid.setColumnProperty("customcount" + k, "header", (Object)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6570\u91cf", (String)"TctrcCheckupOverviewPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), customname)));
                    }
                    if (i < a) continue;
                    a = i;
                }
                this.hideCustomcount(a);
            }
        } else {
            QFilter qFilter = new QFilter("entryentity1.orgid", "in", (Object)orgid);
            QFilter startdateFilter = new QFilter("startDate", "<=", (Object)startDate);
            QFilter enddateFilter = new QFilter("enddate", ">=", (Object)endDate);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(startdateFilter).and(enddateFilter).and(enableFilter);
            DynamicObjectCollection checkCollection = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition as riskids", (QFilter[])new QFilter[]{qFilter});
            if (EmptyCheckUtils.isEmpty((Object)checkCollection)) {
                QFilter nullFilter = new QFilter("entryentity1.orgid", "is null", null);
                nullFilter.and(startdateFilter).and(enddateFilter).and(enableFilter);
                checkCollection = QueryServiceHelper.query((String)"tctrc_check_list", (String)"id,entryentity.riskdefinition as riskids", (QFilter[])new QFilter[]{nullFilter});
                if (EmptyCheckUtils.isEmpty((Object)checkCollection)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"customcount1", "customcount2", "customcount3", "customcount4", "customcount5", "customcount6", "customcount7"});
                    return;
                }
            }
            Map<String, Object> rlevelMap = this.getRlevelIds();
            List rlevelIds = new ArrayList(16);
            Map<Long, String> rlevelNameMap = new HashMap(16);
            if (rlevelMap != null) {
                rlevelIds = (List)rlevelMap.get("rlevelIds");
                rlevelNameMap = (Map)rlevelMap.get("rlevelIdVlue");
            }
            List riskids = checkCollection.stream().map(e -> e.getLong("riskids")).collect(Collectors.toList());
            QFilter riskqFilter = new QFilter("runorg", "in", (Object)orgid);
            riskqFilter.and(new QFilter("rlevel.id", "in", rlevelIds));
            riskqFilter.and(new QFilter("risk.id", "in", riskids));
            riskqFilter.and(new QFilter("startdate", ">=", (Object)startDate));
            riskqFilter.and(new QFilter("enddate", "<=", (Object)endDate));
            DynamicObjectCollection rlevelResults = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id,runorg,startdate,enddate,rlevel,rlevel.name", (QFilter[])new QFilter[]{riskqFilter});
            if (EmptyCheckUtils.isEmpty((Object)rlevelResults)) {
                return;
            }
            DynamicObjectCollection taxtypeResults = QueryServiceHelper.query((String)"tctrc_risk_run_result", (String)"id,runorg,startdate,enddate,rlevel,risk.taxtypemul.fbasedataid.name as taxtypename,rlevel.name", (QFilter[])new QFilter[]{riskqFilter});
            int riskTotalCount = rlevelResults.size();
            Map<Long, List<DynamicObject>> rlevelDynamicObjectMap = rlevelResults.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getLong("rlevel"))).collect(Collectors.groupingBy(s -> s.getLong("rlevel")));
            Map<String, List<DynamicObject>> taxtypeDynamicObjectMap = taxtypeResults.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getString("taxtypename"))).collect(Collectors.groupingBy(s -> s.getString("taxtypename")));
            LinkedHashMap<String, Integer> collectMap = new LinkedHashMap<String, Integer>(16);
            HashMap riskpkids = new HashMap(32);
            Iterator<Map.Entry<Long, List<DynamicObject>>> iterator = rlevelDynamicObjectMap.entrySet().iterator();
            int groupCount = rlevelDynamicObjectMap.size();
            int i = 1;
            BigDecimal beforelastone = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                Map.Entry<Long, List<DynamicObject>> entry = iterator.next();
                List<DynamicObject> list = entry.getValue();
                List ids = list.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                int currentrLevel = list.size();
                BigDecimal zhanb = i == groupCount ? BigDecimalUtil.subtractObject((Object)BigDecimal.ONE, (Object)beforelastone, (int)4) : BigDecimalUtil.divideObject((Object)currentrLevel, (Object)riskTotalCount, (int)4);
                beforelastone = BigDecimalUtil.addObject((Object)beforelastone, (Object)zhanb);
                String zbResult = zhanb == null ? "0.00%" : new DecimalFormat("#####0.##%").format(zhanb);
                String rlevelName = (String)rlevelNameMap.get(entry.getKey()) + "|" + currentrLevel + "|" + zbResult;
                collectMap.put(rlevelName, currentrLevel);
                riskpkids.put(rlevelName, ids);
                ++i;
            }
            this.getPageCache().put("riskpagecache", EmptyCheckUtils.isEmpty(riskpkids) ? null : SerializationUtils.toJsonString(riskpkids));
            RiskEchartsHelper.drawDistributeChart(collectMap, pieChart, "1");
            int taxtypeTotalCount = taxtypeResults.size();
            LinkedHashMap<String, Integer> collectMap1 = new LinkedHashMap<String, Integer>(16);
            HashMap taxtypepkids = new HashMap(32);
            for (Map.Entry<String, List<DynamicObject>> entry : taxtypeDynamicObjectMap.entrySet()) {
                List<DynamicObject> list = entry.getValue();
                List ids = list.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
                int currentrLevel = list.size();
                BigDecimal zhanb = BigDecimalUtil.divideObject((Object)currentrLevel, (Object)taxtypeTotalCount, (int)4);
                String zbResult = zhanb == null ? "0.00%" : new DecimalFormat("#####0.##%").format(zhanb);
                String taxtypeName = entry.getKey() + "|" + currentrLevel + "|" + zbResult;
                collectMap1.put(taxtypeName, currentrLevel);
                taxtypepkids.put(taxtypeName, ids);
            }
            this.getPageCache().put("taxtypepagecache", EmptyCheckUtils.isEmpty(taxtypepkids) ? null : SerializationUtils.toJsonString(taxtypepkids));
            RiskEchartsHelper.drawDistributeChart(collectMap1, pieChart1, "1");
            String riskpkidsString = EmptyCheckUtils.isEmpty(riskpkids) ? null : SerializationUtils.toJsonString(riskpkids);
            String taxtypepkidsString = EmptyCheckUtils.isEmpty(taxtypepkids) ? null : SerializationUtils.toJsonString(taxtypepkids);
            String collectMapString = EmptyCheckUtils.isEmpty(collectMap) ? null : SerializationUtils.toJsonString(collectMap);
            String collectMap1String = EmptyCheckUtils.isEmpty(collectMap1) ? null : SerializationUtils.toJsonString(collectMap1);
            this.createEntryentity(taxtypeDynamicObjectMap, rlevelNameMap, riskpkidsString, taxtypepkidsString, collectMapString, collectMap1String, sbbid);
        }
    }

    private void createEntryentity(Map<String, List<DynamicObject>> taxtypeDynamicObjectMap, Map<Long, String> rlevelNameMap, String riskpkidsString, String taxtypepkidsString, String collectMapString, String collectMap1String, String sbbid) {
        DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_riskcheck_record");
        mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
        mainObject0.set("riskcollect", (Object)collectMapString);
        mainObject0.set("riskpkids_tag", (Object)riskpkidsString);
        mainObject0.set("taxtypecollect", (Object)collectMap1String);
        mainObject0.set("taxtypepkids_tag", (Object)taxtypepkidsString);
        DynamicObjectCollection labelentity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
        Iterator<Map.Entry<String, List<DynamicObject>>> iterator1 = taxtypeDynamicObjectMap.entrySet().iterator();
        int a = 0;
        while (iterator1.hasNext()) {
            Map.Entry<String, List<DynamicObject>> entry = iterator1.next();
            List<DynamicObject> list = entry.getValue();
            int zbjlcount = list.size();
            String indexcountids = list.stream().map(v -> v.getString("id")).collect(Collectors.joining(","));
            Map<Long, List<DynamicObject>> rlevelDynamicObjectMap = list.stream().filter(v -> v.getLong("rlevel") != 5L).collect(Collectors.groupingBy(s -> s.getLong("rlevel")));
            long hitcount = list.stream().filter(v -> v.getLong("rlevel") != 5L).count();
            String hitcountids = list.stream().filter(v -> v.getLong("rlevel") != 5L).map(v -> v.getString("id")).collect(Collectors.joining(","));
            String highcountids = list.stream().filter(v -> v.getLong("rlevel") == 1L).map(v -> v.getString("id")).collect(Collectors.joining(","));
            String meddiescountids = list.stream().filter(v -> v.getLong("rlevel") == 2L).map(v -> v.getString("id")).collect(Collectors.joining(","));
            String lowcountids = list.stream().filter(v -> v.getLong("rlevel") == 3L).map(v -> v.getString("id")).collect(Collectors.joining(","));
            int row = this.getModel().createNewEntryRow("otherentry");
            int highcount = rlevelDynamicObjectMap.get(1L) == null ? 0 : rlevelDynamicObjectMap.get(1L).size();
            int meddiescount = rlevelDynamicObjectMap.get(2L) == null ? 0 : rlevelDynamicObjectMap.get(2L).size();
            int lowcount = rlevelDynamicObjectMap.get(3L) == null ? 0 : rlevelDynamicObjectMap.get(3L).size();
            this.getModel().setValue("scandimensions", (Object)entry.getKey(), row);
            this.getModel().setValue("indexcount", (Object)zbjlcount, row);
            this.getModel().setValue("indexcountids", (Object)indexcountids, row);
            this.getModel().setValue("hitcount", (Object)hitcount, row);
            this.getModel().setValue("hitcountids", (Object)hitcountids, row);
            this.getModel().setValue("highcount", (Object)highcount, row);
            this.getModel().setValue("highcountids", (Object)highcountids, row);
            this.getModel().setValue("meddiescount", (Object)meddiescount, row);
            this.getModel().setValue("meddiescountids", (Object)meddiescountids, row);
            this.getModel().setValue("lowcount", (Object)lowcount, row);
            this.getModel().setValue("lowcountids", (Object)lowcountids, row);
            rlevelDynamicObjectMap.remove(1L);
            rlevelDynamicObjectMap.remove(2L);
            rlevelDynamicObjectMap.remove(3L);
            EntryGrid entryGrid = (EntryGrid)this.getControl("otherentry");
            DynamicObject dynamicObject = labelentity0Collection.addNew();
            Iterator<Map.Entry<Long, List<DynamicObject>>> iterator2 = rlevelDynamicObjectMap.entrySet().iterator();
            int i = 0;
            while (iterator2.hasNext()) {
                Map.Entry<Long, List<DynamicObject>> entry1 = iterator2.next();
                List<DynamicObject> list1 = entry1.getValue();
                this.getModel().setValue("customcount" + (i + 1), (Object)list1.size(), row);
                String customcountids = list1.stream().map(v -> v.getString("id")).collect(Collectors.joining(","));
                this.getModel().setValue("customcount" + (i + 1) + "ids", (Object)customcountids, row);
                dynamicObject.set("customcount" + (i + 1), (Object)(list1.size() + "|" + rlevelNameMap.get(entry1.getKey())));
                dynamicObject.set("customcount" + (i + 1) + "ids_tag", (Object)customcountids);
                entryGrid.setColumnProperty("customcount" + (i + 1), "header", (Object)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6570\u91cf", (String)"TctrcCheckupOverviewPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), rlevelNameMap.get(entry1.getKey()))));
                if (++i <= 6) continue;
                break;
            }
            if (i >= a) {
                a = i;
            }
            dynamicObject.set("scandimensions", (Object)entry.getKey());
            dynamicObject.set("indexcount", (Object)zbjlcount);
            dynamicObject.set("indexcountids_tag", (Object)indexcountids);
            dynamicObject.set("hitcount", (Object)hitcount);
            dynamicObject.set("hitcountids_tag", (Object)hitcountids);
            dynamicObject.set("highcount", (Object)highcount);
            dynamicObject.set("highcountids_tag", (Object)highcountids);
            dynamicObject.set("meddiescount", (Object)meddiescount);
            dynamicObject.set("meddiescountids_tag", (Object)meddiescountids);
            dynamicObject.set("lowcount", (Object)lowcount);
            dynamicObject.set("lowcountids_tag", (Object)lowcountids);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
        this.hideCustomcount(a);
    }

    private void hideCustomcount(int a) {
        ArrayList<String> customcountList = new ArrayList<String>(16);
        for (int c = a + 1; c <= 7; ++c) {
            customcountList.add("customcount" + c);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("otherentry");
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            if (!customcountList.contains(fieldEdit.getFieldKey())) continue;
            fieldEdit.setVisible(fieldEdit.getFieldKey(), false);
        }
    }

    private Map<String, Object> getRlevelIds() {
        DynamicObjectCollection rlevelCollection = RiskScoreViewUtils.getRiskLevelList((String)Boolean.FALSE.toString());
        ArrayList<Long> rlevelIds = new ArrayList<Long>(16);
        HashMap<String, Object> mapKey = new HashMap<String, Object>(16);
        HashMap<Long, String> mapValue = new HashMap<Long, String>(16);
        if (rlevelCollection != null) {
            for (DynamicObject dynamicObject : rlevelCollection) {
                rlevelIds.add(dynamicObject.getLong("id"));
                mapValue.put(dynamicObject.getLong("id"), dynamicObject.getString("name"));
            }
        }
        mapKey.put("rlevelIds", rlevelIds);
        mapKey.put("rlevelIdVlue", mapValue);
        return mapKey;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String name = ((ChartClickEvent)evt).getName();
        if (EmptyCheckUtils.isEmpty((Object)name)) {
            return;
        }
        String riskpagecache = this.getPageCache().get("riskpagecache");
        String taxtypepagecache = this.getPageCache().get("taxtypepagecache");
        Map pkidsMap = new HashMap(32);
        if (PIECHARTAP.equals(key)) {
            if (EmptyCheckUtils.isNotEmpty((Object)riskpagecache)) {
                pkidsMap = (Map)SerializationUtils.fromJsonString((String)riskpagecache, Map.class);
            }
        } else if (PIECHARTAP1.equals(key) && EmptyCheckUtils.isNotEmpty((Object)taxtypepagecache)) {
            pkidsMap = (Map)SerializationUtils.fromJsonString((String)taxtypepagecache, Map.class);
        }
        if (EmptyCheckUtils.isNotEmpty(pkidsMap)) {
            List<String> riskids = ((List)pkidsMap.get(name)).stream().map(s -> s + "").collect(Collectors.toList());
            this.openRiskRunResult(riskids, null);
        }
    }

    private void openRiskRunResult(List<String> riskids, List<String> orgids) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        ListShowParameter param = new ListShowParameter();
        customParams.put("orgid", orgids != null && orgids.size() == 1 ? orgids.get(0) : "all");
        customParams.put("risklist", riskids);
        param.setBillFormId("tctrc_risk_run_result");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private Date getStartDate() {
        return DateUtils.getFirstDateOfMonth((Date)((Date)this.getModel().getValue("startdate")));
    }

    private Date getEndDate() {
        return DateUtils.getLastDateOfMonth2((Date)((Date)this.getModel().getValue("enddate")));
    }

    private Long getOrgid() {
        return this.getModel().getDataEntity().getLong("org.id");
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String fieldName = hyperLinkClickEvent.getFieldName();
        String riskid = String.valueOf(this.getModel().getValue(fieldName + "ids", rowIndex));
        if (EmptyCheckUtils.isEmpty((Object)riskid)) {
            return;
        }
        String[] strArr = riskid.split(",");
        this.openRiskRunResult(EmptyCheckUtils.isEmpty((Object)strArr) ? new ArrayList(16) : Arrays.asList(strArr), null);
    }
}

