/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.tctrc.common.util.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TctrcCheckupReportList
extends AbstractListPlugin {
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        TaxResult taxResultList1 = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)Long.parseLong(RequestContext.get().getUserId()), (String)"tctrc", (String)"tctrc_checkup_report_list", (String)"47150e89000000ac");
        if (taxResultList1 != null && taxResultList1.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)taxResultList1.getData()))) {
            qFilters.add(new QFilter("org.id", "in", taxResultList1.getData()));
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("startdate".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("startdate"), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate("enddate"), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"startdate", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long sbbid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctrc_checkup_report_list", (String)"id,org,startdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbid)});
            FormShowParameter param = new FormShowParameter();
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("sbbid", sbbid);
            customParams.put("isrecord", Boolean.TRUE.toString());
            customParams.put("org", dynamicObject.getDynamicObject("org").getLong("id"));
            customParams.put("startdate", dynamicObject.getDate("startdate"));
            customParams.put("enddate", dynamicObject.getDate("enddate"));
            param.setFormId("tctrc_checkup_home");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
    }
}

