/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctrc.business.checkup.TctrcRiskIndexBusiness;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.enums.ExistEnum;
import kd.taxc.tctrc.common.enums.RiskLevelDbEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class TctrcRiskIndexPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            String result = this.getPageCache().get("checkResult");
            if (Boolean.TRUE.toString().equals(result)) {
                Date startDate = this.getModel().getDataEntity().getDate("startdate");
                Date endDate = this.getModel().getDataEntity().getDate("enddate");
                Long org = this.getModel().getDataEntity().getLong("org.id");
                endDate = HealthUtil.getLastDateOfMonth((Date)endDate);
                String sbbid = this.getPageCache().get("sbbid");
                String isrecord = this.getPageCache().get("isrecord");
                this.getModel().deleteEntryData("entryentityrisk");
                this.setValue(org, startDate, endDate, sbbid, isrecord);
            }
        }
    }

    public String setPicture(String riskLevel) {
        if (ResManager.loadKDString((String)"\u9ad8", (String)"TctrcRiskIndexPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            return "/images/pc/emotion/swy_fxdjg_119_119.png";
        }
        if (ResManager.loadKDString((String)"\u4e2d", (String)"TctrcRiskIndexPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            return "/images/pc/emotion/swy_fxdjz_120_119.png";
        }
        if (ResManager.loadKDString((String)"\u4f4e", (String)"TctrcRiskIndexPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            return "/images/pc/emotion/swy_fxdjd_120_119.png";
        }
        return "/images/pc/emotion/swy_fx5_223_223.png";
    }

    public void setValue(Long org, Date startDate, Date endDate, String sbbid, String isrecord) {
        if (Boolean.TRUE.toString().equals(isrecord)) {
            DynamicObject[] dynamicObjects;
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_risk_detail_record", (String)MetadataUtil.getAllSubFieldString((String)"tctrc_risk_detail_record"), (QFilter[])new QFilter[]{qFilter})) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                int i = 0;
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    int row = this.getModel().createNewEntryRow("entryentityrisk");
                    this.getModel().setValue("risktitle", (Object)dynamicObject1.getString("riskname"), row);
                    this.getModel().setValue("expression", (Object)dynamicObject1.getString("riskexpression"), row);
                    this.getModel().setValue("datestring", (Object)dynamicObject1.getString("skssqq"), row);
                    this.getModel().setValue("rlevel", (Object)dynamicObject1.getString("risklevel"), row);
                    this.getModel().setValue("describe", (Object)dynamicObject1.getString("riskdes"), row);
                    this.getModel().setValue("resultvalue", (Object)dynamicObject1.getString("riskresult"), row);
                    this.getModel().setValue("guideentity", (Object)dynamicObject1.getString("riskpoint"), row);
                    HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
                    HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
                    propertiesMap.put("src", this.setPicture(dynamicObject1.getString("risklevel")));
                    pmap.put("riskimage", propertiesMap);
                    ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    client.invokeControlMethod("entryentityrisk", "setCustomProperties", new Object[]{row++, pmap});
                    ++i;
                }
            }
            this.getPageCache().put("isrecord", null);
        } else {
            Map dataMap = TctrcRiskIndexBusiness.selectData((Long)org, (Date)startDate, (Date)endDate);
            Map recordMap = (Map)dataMap.get("recordMap");
            Map resultMap = (Map)dataMap.get("resultMap");
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_risk_detail_record");
            mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
            DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
            for (Map.Entry map : resultMap.entrySet()) {
                Map childMap = (Map)map.getValue();
                List detailList = (List)childMap.get("detail");
                for (DynamicObject dynamicObject : detailList) {
                    String guideentity;
                    Long rlevelId;
                    Object resultValue;
                    int index = this.getModel().createNewEntryRow("entryentityrisk");
                    DynamicObject dynamicObject1 = entity0Collection.addNew();
                    this.getModel().setValue("risktitle", childMap.get("name"), index);
                    this.getModel().setValue("expression", childMap.get("expression"), index);
                    this.getModel().setValue("datestring", dynamicObject.get("datestring"), index);
                    this.getModel().setValue("rlevel", dynamicObject.get("rlevel.name"), index);
                    if (StringUtils.isNotEmpty((CharSequence)((String)childMap.get("describe")))) {
                        this.getModel().setValue("describe", childMap.get("describe"), index);
                    }
                    if ((resultValue = TctrcRiskIndexPlugin.getResultValue(recordMap, dynamicObject, childMap, rlevelId = Long.valueOf(dynamicObject.getLong("rlevel.id")))) != null) {
                        this.getModel().setValue("resultvalue", resultValue, index);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)(guideentity = TctrcRiskIndexPlugin.setGuideentity(childMap, dynamicObject)))) {
                        this.getModel().setValue("guideentity", (Object)guideentity, index);
                    }
                    HashMap<String, String> propertiesMap = new HashMap<String, String>(16);
                    HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(16);
                    propertiesMap.put("src", this.setPicture(dynamicObject.getString("rlevel.name")));
                    pmap.put("riskimage", propertiesMap);
                    dynamicObject1.set("riskname", childMap.get("name"));
                    dynamicObject1.set("skssqq", dynamicObject.get("datestring"));
                    dynamicObject1.set("riskresult", resultValue);
                    dynamicObject1.set("risklevel", dynamicObject.get("rlevel.name"));
                    dynamicObject1.set("riskpoint", (Object)guideentity);
                    dynamicObject1.set("riskdes", childMap.get("describe"));
                    dynamicObject1.set("riskexpression", childMap.get("expression"));
                    dynamicObject1.set("number", (Object)index);
                    ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    client.invokeControlMethod("entryentityrisk", "setCustomProperties", new Object[]{index++, pmap});
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
        }
    }

    private static String setGuideentity(Map<String, Object> childMap, DynamicObject dynamicObject) {
        if ("1".equals(childMap.get("risktype"))) {
            String updownFlag = TctrcRiskIndexPlugin.getbmvalue(dynamicObject);
            if ("down".equals(updownFlag)) {
                return TctrcRiskIndexPlugin.getGuideentity((DynamicObjectCollection)childMap.get("guideentity21"), "handledesc21");
            }
            if ("up".equals(updownFlag)) {
                return TctrcRiskIndexPlugin.getGuideentity((DynamicObjectCollection)childMap.get("guideentity2"), "handledesc2");
            }
        } else {
            return TctrcRiskIndexPlugin.getGuideentity((DynamicObjectCollection)childMap.get("guideentity2"), "handledesc2");
        }
        return null;
    }

    private static String getbmvalue(DynamicObject dynamicObject) {
        Object resultValue = dynamicObject.get("result");
        BigDecimal bmvalue = dynamicObject.getBigDecimal("risk.bmvalue");
        if (EmptyCheckUtils.isEmpty((Object)resultValue) || "null".equalsIgnoreCase(String.valueOf(resultValue))) {
            return "wrong";
        }
        return new BigDecimal(resultValue.toString()).compareTo(new BigDecimal(bmvalue.toString())) < 0 ? "down" : "up";
    }

    private static String getGuideentity(DynamicObjectCollection guideentity2, String value) {
        return guideentity2.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getString(value))).map(v -> v.getString(value)).collect(Collectors.joining(" "));
    }

    private static Object getResultValue(Map<Long, String> recordMap, DynamicObject dynamicObject, Map<String, Object> childMap, Long rlevelId) {
        if ("1".equals(childMap.get("risktype"))) {
            return TctrcRiskIndexPlugin.getIndexResult(dynamicObject);
        }
        return TctrcRiskIndexPlugin.getIndexRiskResult(recordMap, dynamicObject.getLong("id"), rlevelId);
    }

    private static Object getIndexRiskResult(Map<Long, String> recordMap, Long resultId, Long rlevelId) {
        if (!recordMap.containsKey(resultId)) {
            return null;
        }
        String exist = recordMap.get(resultId);
        if (RiskLevelDbEnum.NO_RISK.getCode().equals(rlevelId.toString())) {
            return ExistEnum.getReverseName((String)exist);
        }
        return ExistEnum.getName((String)exist);
    }

    private static Object getIndexResult(DynamicObject dynamicObject) {
        String resultShow = dynamicObject.getString("risk.resultshow");
        Object resultValue = dynamicObject.get("result");
        if (EmptyCheckUtils.isEmpty((Object)resultValue) || "null".equalsIgnoreCase(String.valueOf(resultValue))) {
            resultValue = null;
        }
        if ("1".equals(resultShow)) {
            return EmptyCheckUtils.isEmpty((Object)resultValue) ? HealthUtil.getFormatNoValueString() : BigDecimalUtil.setScale((Object)resultValue, (int)4);
        }
        return EmptyCheckUtils.isEmpty((Object)resultValue) ? HealthUtil.getFormatNoValueString() : BigDecimalUtil.toBigDecimal((Object)resultValue).multiply(BigDecimalUtil.toBigDecimal((Object)100)).setScale(2, 4) + "%";
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        this.getPageCache().get("quescount");
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        e.setDataEntity((Object)dataEntity);
    }
}

