/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.grid.DataGrid;
import kd.bos.form.control.grid.DataGridRow;
import kd.bos.form.control.grid.DataGridRowBuilder;
import kd.bos.form.control.grid.events.DataGridBindDataEvent;
import kd.bos.form.control.grid.events.DataGridBindDataListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.sjmx.SjfbTctbServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcTaxationRecordBusiness;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import org.apache.commons.lang3.BooleanUtils;

public class TctrcSjfbPlugin
extends AbstractFormPlugin
implements DataGridBindDataListener {
    private static Log logger = LogFactory.getLog(TctrcSjfbPlugin.class);
    private static final String BQYBTSE = "bqybtse";
    private static final String RATIO = "ratio";

    public void initialize() {
        DataGrid dataGrid = (DataGrid)this.getControl("datagridap");
        dataGrid.addBindDataListener((DataGridBindDataListener)this);
    }

    public void dataGridBindData(DataGridBindDataEvent e) {
        logger.info("\u7a0e\u91d1\u660e\u7ec6\u5f00\u59cb-TctrcSjfbPlugin");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String sbbid = (String)customParams.get("sbbid");
        String isrecord = (String)customParams.get("isrecord");
        if (Boolean.TRUE.toString().equals(isrecord)) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            DynamicObject[] dynamicObjects = TctrcTaxationRecordBusiness.getTctrcTaxationRecord((QFilter)qFilter);
            DataGridRowBuilder builder = e.getDataGridRowBuilder();
            int index = 0;
            ArrayList<List> list = new ArrayList<List>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    DataGridRow row = builder.buildRow();
                    row.setValue("rk", (Object)index);
                    row.setValue("seq", (Object)(index + 1));
                    row.setValue("taxtypename", (Object)dynamicObject1.getString("taxtypename"));
                    row.setValue(BQYBTSE, (Object)dynamicObject1.getBigDecimal(BQYBTSE).setScale(2, 4));
                    row.setValue(RATIO, (Object)dynamicObject1.getString(RATIO));
                    list.add(row.get());
                    ++index;
                }
            }
            e.setData(list);
        } else {
            if (BooleanUtils.isFalse((Boolean)HealthUtil.checkInput((IFormView)this.getView().getParentView()))) {
                return;
            }
            Long orgids = this.getView().getParentView().getModel().getDataEntity().getLong("org.id");
            Date start = this.getView().getParentView().getModel().getDataEntity().getDate("startdate");
            Date end = this.getView().getParentView().getModel().getDataEntity().getDate("enddate");
            TaxResult sjfbResult = SjfbTctbServiceHelper.querysjfb((Long)orgids, (Date)start, (Date)(end = HealthUtil.getLastDateOfMonth((Date)end)));
            if (sjfbResult == null || !sjfbResult.isSuccess() || sjfbResult.getData() == null) {
                logger.info("\u67e5\u8be2\u7a0e\u91d1\u660e\u7ec6:\u65e0\u5408\u8ba1\u6570\u636e");
                return;
            }
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_taxation_record");
            mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
            DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
            try (DataSet sjfbDataSet = (DataSet)sjfbResult.getData();
                 DataSet total = sjfbDataSet.copy().groupBy(null).sum(BQYBTSE).finish();
                 DataSet result = sjfbDataSet.groupBy(new String[]{"taxtype.name"}).sum(BQYBTSE).finish().copy().orderBy(new String[]{"bqybtse  desc"});){
                BigDecimal totalbqybtse = BigDecimal.ZERO;
                for (Row row1 : total) {
                    totalbqybtse = row1.getBigDecimal(BQYBTSE);
                }
                ArrayList<List> list = new ArrayList<List>(10);
                int index = 0;
                DataGridRowBuilder builder = e.getDataGridRowBuilder();
                for (Row nodes : result) {
                    DynamicObject dynamicObject = entity0Collection.addNew();
                    DataGridRow row = builder.buildRow();
                    row.setValue("rk", (Object)index);
                    row.setValue("seq", (Object)(index + 1));
                    row.setValue("taxtypename", nodes.get("taxtype.name"));
                    row.setValue(BQYBTSE, (Object)nodes.getBigDecimal(BQYBTSE).setScale(2, 4));
                    String rate = totalbqybtse.compareTo(BigDecimal.ZERO) == 0 ? "0%" : nodes.getBigDecimal(BQYBTSE).multiply(HealthUtil.ONEHUNDRED).divide(totalbqybtse, 2, 4) + "%";
                    row.setValue(RATIO, (Object)rate);
                    dynamicObject.set("taxtypename", nodes.get("taxtype.name"));
                    dynamicObject.set(BQYBTSE, (Object)nodes.getBigDecimal(BQYBTSE).setScale(2, 4));
                    dynamicObject.set(RATIO, (Object)rate);
                    list.add(row.get());
                    ++index;
                }
                DynamicObject dynamicObject1 = entity0Collection.addNew();
                DataGridRow row = builder.buildRow();
                row.setValue("rk", (Object)index);
                row.setValue("seq", (Object)(index + 1));
                row.setValue("taxtypename", (Object)HealthUtil.getSumRowFlag());
                row.setValue(BQYBTSE, (Object)totalbqybtse);
                row.setValue(RATIO, (Object)"-");
                dynamicObject1.set("taxtypename", (Object)HealthUtil.getSumRowFlag());
                dynamicObject1.set(BQYBTSE, (Object)totalbqybtse);
                dynamicObject1.set(RATIO, (Object)"-");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
                list.add(row.get());
                e.setData(list);
                logger.info("\u7a0e\u91d1\u660e\u7ec6\u7ed3\u675f-TctrcSjfbPlugin");
            }
        }
    }
}

