/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctrc.business.tdm.TdmFinanceLrbBusiness;
import kd.taxc.tctrc.business.tdm.TdmFinanceMainBusiness;
import kd.taxc.tctrc.common.checkup.FinTaxSituationUtil;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.checkup.SybEnum;
import kd.taxc.tctrc.common.util.DateUtils;

public class TctrcSybPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(TctrcSybPlugin.class);
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String SYBENTITY = "sybentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            String result = this.getPageCache().get("checkResult");
            IDataModel parentModel = this.getModel();
            if (Boolean.TRUE.toString().equals(result) && !ObjectUtils.isEmpty((Object)parentModel.getValue(STARTDATE)) && !ObjectUtils.isEmpty((Object)parentModel.getValue(ENDDATE))) {
                String sbbid = this.getPageCache().get("sbbid");
                String isrecord = this.getPageCache().get("isrecord");
                Date startDate = parentModel.getDataEntity().getDate(STARTDATE);
                Date endDate = parentModel.getDataEntity().getDate(ENDDATE);
                EntryGrid entryGrid = (EntryGrid)this.getControl(SYBENTITY);
                FinTaxSituationUtil.setPeriodColText((EntryGrid)entryGrid, (String)"period", (Date)startDate, (Date)endDate);
                if (ObjectUtils.isEmpty((Object)parentModel.getValue("org"))) {
                    return;
                }
                this.getModel().deleteEntryData(SYBENTITY);
                this.buildEntity(sbbid, isrecord);
            }
        }
    }

    private void buildEntity(String sbbid, String isrecord) {
        if (Boolean.TRUE.toString().equals(isrecord)) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_loss_stateme_record", (String)MetadataUtil.getAllSubFieldString((String)"tctrc_loss_stateme_record"), (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                        int row = this.getModel().createNewEntryRow(SYBENTITY);
                        this.getModel().setValue("project", (Object)dynamicObject1.getString("project"), row);
                        this.getModel().setValue("amount1", (Object)dynamicObject1.getString("bqybtse0"), row);
                        this.getModel().setValue("amount2", (Object)dynamicObject1.getString("bqybtse1"), row);
                        this.getModel().setValue("change2", (Object)dynamicObject1.getString("yearonyear1"), row);
                        this.getModel().setValue("amount3", (Object)dynamicObject1.getString("bqybtse2"), row);
                        this.getModel().setValue("change3", (Object)dynamicObject1.getString("yearonyear2"), row);
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            }
        } else {
            IDataModel parentModel = this.getModel();
            Date startDate = parentModel.getDataEntity().getDate(STARTDATE);
            Date endDate = parentModel.getDataEntity().getDate(ENDDATE);
            Map yearAndColMap = FinTaxSituationUtil.getYearAndColRelation((Date)startDate);
            long taxOrgId = parentModel.getDataEntity().getDynamicObject("org").getLong("id");
            TaxResult result = OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)taxOrgId);
            if (!result.isSuccess() || result.getData() == null) {
                return;
            }
            List fromOrgs = (List)result.getData();
            if (fromOrgs.size() != 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"content"});
            long calOrgId = (Long)fromOrgs.get(0);
            DynamicObject[] bills = this.getFinMainInfo(calOrgId, startDate, endDate);
            HashMap<String, Integer> finMainIdAndYearMap = new HashMap<String, Integer>(16);
            ArrayList<String> finMainIds = new ArrayList<String>(16);
            Calendar calendar = Calendar.getInstance();
            for (DynamicObject bill : bills) {
                calendar.setTime(bill.getDate(SKSSQQ));
                finMainIdAndYearMap.put(bill.getString("id"), calendar.get(1));
                finMainIds.add(bill.getString("id"));
            }
            this.buildEntityProject();
            this.calEntityAmount(finMainIds, finMainIdAndYearMap, yearAndColMap);
            this.calEntityChange();
            this.saveData(sbbid);
        }
    }

    private void saveData(String sbbid) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(SYBENTITY);
        DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_loss_stateme_record");
        mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
        DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamic : collection) {
            DynamicObject dynamicObject = entity0Collection.addNew();
            dynamicObject.set("project", (Object)dynamic.getString("project"));
            dynamicObject.set("bqybtse0", (Object)dynamic.getString("amount1"));
            dynamicObject.set("bqybtse1", (Object)dynamic.getString("amount2"));
            dynamicObject.set("yearonyear1", (Object)dynamic.getString("change2"));
            dynamicObject.set("bqybtse2", (Object)dynamic.getString("amount3"));
            dynamicObject.set("yearonyear2", (Object)dynamic.getString("change3"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
    }

    private DynamicObject[] getFinMainInfo(Long calOrgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("templatetype.id", "=", (Object)"lrb");
        qFilter.and("org", "=", (Object)calOrgId);
        QFilter date1Qf = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate)));
        QFilter date2Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-1)).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-1))));
        QFilter date3Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-2)).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-2))));
        return TdmFinanceMainBusiness.getTdmFinanceMainDetails((QFilter)qFilter.and(date1Qf.or(date2Qf).or(date3Qf)), (String)"");
    }

    private void buildEntityProject() {
        for (int i = 0; i < SybEnum.values().length; ++i) {
            this.getModel().createNewEntryRow(SYBENTITY);
            this.getModel().setValue("project", (Object)SybEnum.values()[i].getName(), i);
        }
    }

    private void calEntityAmount(List<String> finMainIds, Map<String, Integer> finMainIdAndYearMap, Map<Integer, Integer> yearAndColMap) {
        DynamicObject[] datas;
        IDataModel model = this.getModel();
        QFilter filter = new QFilter("sbbid", "in", finMainIds);
        for (DynamicObject data : datas = TdmFinanceLrbBusiness.getTdmFinanceLrb((QFilter)filter)) {
            String sbbId = data.getString("sbbid");
            Integer colIndex = yearAndColMap.get(finMainIdAndYearMap.get(sbbId));
            DynamicObject reportItem = data.getDynamicObject("reportitem");
            if (reportItem == null) continue;
            String name = reportItem.getString("name.zh_CN");
            BigDecimal amount = data.getBigDecimal("bnljje");
            Map<String, String> rowAndItemMap = this.rowAndItemMap();
            for (Map.Entry<String, String> entry : rowAndItemMap.entrySet()) {
                String[] key = entry.getKey().split("_");
                int rowIndex = Integer.parseInt(key[0]);
                boolean flag = "contains".equals(key[1]) && name.contains(entry.getValue()) || "equals".equals(key[1]) && name.equals(entry.getValue());
                if (!flag) continue;
                BigDecimal tmpAmount = amount.add((BigDecimal)model.getValue("amount" + colIndex, rowIndex));
                model.setValue("amount" + colIndex, (Object)tmpAmount, rowIndex);
            }
        }
        for (int i = 1; i <= 3; ++i) {
            String colName = "amount" + i;
            model.setValue(colName, (Object)this.addRowAmount(colName, 1, 2), 0);
            model.setValue(colName, (Object)this.addRowAmount(colName, 4, 5), 3);
            model.setValue(colName, (Object)this.addRowAmount(colName, 7, 8, 9, 10), 6);
        }
    }

    private Map<String, String> rowAndItemMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("1_contains", ResManager.loadKDString((String)"\u8425\u4e1a\u6536\u5165", (String)"TctrcSybPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("2_contains", ResManager.loadKDString((String)"\u8425\u4e1a\u5916\u6536\u5165", (String)"TctrcSybPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("4_contains", ResManager.loadKDString((String)"\u8425\u4e1a\u6210\u672c", (String)"TctrcSybPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("5_contains", ResManager.loadKDString((String)"\u8425\u4e1a\u5916\u652f\u51fa", (String)"TctrcSybPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("7_equals", ResManager.loadKDString((String)"\u9500\u552e\u8d39\u7528", (String)"TctrcSybPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("8_equals", ResManager.loadKDString((String)"\u7ba1\u7406\u8d39\u7528", (String)"TctrcSybPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("9_equals", ResManager.loadKDString((String)"\u7814\u53d1\u8d39\u7528", (String)"TctrcSybPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("10_equals", ResManager.loadKDString((String)"\u8d22\u52a1\u8d39\u7528", (String)"TctrcSybPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("11_contains", ResManager.loadKDString((String)"\u6295\u8d44\u6536\u76ca", (String)"TctrcSybPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("12_contains", ResManager.loadKDString((String)"\u5229\u6da6\u603b\u989d", (String)"TctrcSybPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("13_contains", ResManager.loadKDString((String)"\u6240\u5f97\u7a0e\u8d39\u7528", (String)"TctrcSybPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("14_contains", ResManager.loadKDString((String)"\u51c0\u5229\u6da6", (String)"TctrcSybPlugin_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        return map;
    }

    private BigDecimal addRowAmount(String colName, int ... rowIndex) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int index : rowIndex) {
            totalAmount = totalAmount.add((BigDecimal)this.getModel().getValue(colName, index));
        }
        return totalAmount;
    }

    private void calEntityChange() {
        int size = this.getModel().getEntryRowCount(SYBENTITY);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            for (int j = 2; j <= 3; ++j) {
                String changeColName = "change" + j;
                String curAmtColName = "amount" + j;
                String preAmtColName = "amount" + (j - 1);
                BigDecimal curAmount = (BigDecimal)this.getModel().getValue(curAmtColName, rowIndex);
                BigDecimal preAmount = (BigDecimal)this.getModel().getValue(preAmtColName, rowIndex);
                if (curAmount.compareTo(BigDecimal.ZERO) == 0 || preAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal change = curAmount.subtract(preAmount).multiply(HealthUtil.ONEHUNDRED).divide(preAmount, 2, RoundingMode.HALF_UP);
                this.getModel().setValue(changeColName, (Object)(change + "%"), rowIndex);
            }
        }
    }
}

