/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.sjmx.SjfbTctbServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.declare.TccitDeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareTaxType;
import kd.taxc.tctrc.business.tctrc.TctrcIndicatiorsRecordBusiness;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.checkup.RateTaxEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TctrcTaxrateIndexPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(TctrcTaxrateIndexPlugin.class);
    private static final String YEARONYEAR = "yearOnyear";
    private static final String BQYBSTE = "bqybtse";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ENTRYENTITY = "entryentity";
    private static final String YSSR = "yssr";
    private static final String YNSDSE = "ynsdse";
    private static final String LRZE = "lrze";
    private static final int YEARS = -2;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            String result = this.getPageCache().get("checkResult");
            if (Boolean.TRUE.toString().equals(result)) {
                String sbbid = this.getPageCache().get("sbbid");
                String isrecord = this.getPageCache().get("isrecord");
                this.selectRatio(sbbid, isrecord);
                logger.info("\u7a0e\u8d1f\u7387\u7ed3\u675f-TctrcTaxrateIndexPlugin");
            }
        }
    }

    public void selectRatio(String sbbid, String isrecord) {
        Long orgid = this.getModel().getDataEntity().getLong("org.id");
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endDate = this.getModel().getDataEntity().getDate("enddate");
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        String yearone = "";
        String yeartwo = "";
        String yearthree = "";
        for (int i = -2; i <= 0; ++i) {
            String yearString = DateUtils.format((Date)DateUtils.addYear((Date)startDate, (int)i), (String)HealthUtil.getYyyymmChinese()) + "~" + DateUtils.format((Date)DateUtils.addYear((Date)endDate, (int)i), (String)HealthUtil.getYyyymmChinese());
            if (i == -2) {
                yearone = yearString;
            } else if (i == -1) {
                yeartwo = yearString;
            } else if (i == 0) {
                yearthree = yearString;
            }
            entryGrid.setColumnProperty("year" + Math.abs(i), "header", (Object)new LocaleString(yearString));
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (Boolean.TRUE.toString().equals(isrecord)) {
            DynamicObject[] dynamicObjects;
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            for (DynamicObject dynamicObject : dynamicObjects = TctrcIndicatiorsRecordBusiness.getTctrcIndicatiorsRecord((QFilter)qFilter)) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    int row = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("project1", (Object)dynamicObject1.getString("project"), row);
                    this.getModel().setValue("bqybtse2", (Object)dynamicObject1.getString("bqybtse2"), row);
                    this.getModel().setValue("bqybtse1", (Object)dynamicObject1.getString("bqybtse1"), row);
                    this.getModel().setValue("yearonyear1", (Object)dynamicObject1.getString("yearonyear1"), row);
                    this.getModel().setValue("bqybtse0", (Object)dynamicObject1.getString("bqybtse0"), row);
                    this.getModel().setValue("yearonyear0", (Object)dynamicObject1.getString("yearonyear0"), row);
                }
            }
        } else {
            if (BooleanUtils.isFalse((Boolean)HealthUtil.checkInput((IFormView)this.getView()))) {
                return;
            }
            endDate = HealthUtil.getLastDateOfMonth((Date)endDate);
            DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_indicators_record");
            mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
            mainObject0.set("yearone", (Object)yearone);
            mainObject0.set("yeartwo", (Object)yeartwo);
            mainObject0.set("yearthree", (Object)yearthree);
            DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection(ENTRYENTITY);
            int index2 = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("project1", (Object)HealthUtil.getSde(), index2);
            Map<String, Object> thisyear = this.getDeclare((TaxResult<Map<String, Object>>)TccitDeclareDataServiceHelper.getTaxAndProfitAmount((Long)orgid, (Date)startDate, (Date)HealthUtil.getLastDateOfMonth((Date)endDate)));
            Map<String, Object> lastyear = this.getDeclare((TaxResult<Map<String, Object>>)TccitDeclareDataServiceHelper.getTaxAndProfitAmount((Long)orgid, (Date)DateUtils.addYear((Date)startDate, (int)-1), (Date)HealthUtil.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-1))));
            Map<String, Object> yearbeforelast = this.getDeclare((TaxResult<Map<String, Object>>)TccitDeclareDataServiceHelper.getTaxAndProfitAmount((Long)orgid, (Date)DateUtils.addYear((Date)startDate, (int)-2), (Date)HealthUtil.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-2))));
            this.getModel().beginInit();
            DynamicObject dynamicObject = entity0Collection.addNew();
            dynamicObject.set("project", (Object)HealthUtil.getSde());
            this.cancleYearOnYearShenBao(yearbeforelast, null, Math.abs(-2), index2, LRZE, YNSDSE, dynamicObject);
            this.cancleYearOnYearShenBao(lastyear, yearbeforelast, Math.abs(-1), index2, LRZE, YNSDSE, dynamicObject);
            this.cancleYearOnYearShenBao(thisyear, lastyear, Math.abs(0), index2, LRZE, YNSDSE, dynamicObject);
            QFilter taxtypeFilter = new QFilter("taxtype", "in", Arrays.asList(Integer.valueOf(DeclareTaxType.ZZS.getBaseTaxCode()), Integer.valueOf(DeclareTaxType.QYSDS.getBaseTaxCode())));
            QFilter date1Qf = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)HealthUtil.getLastDateOfMonth((Date)endDate)));
            QFilter date2Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-1)).and(new QFilter(SKSSQZ, "<=", (Object)HealthUtil.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-1))));
            QFilter date3Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-2)).and(new QFilter(SKSSQZ, "<=", (Object)HealthUtil.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-2))));
            TaxResult sjfbResult = SjfbTctbServiceHelper.querysjfbByRate((Long)orgid, (QFilter)date1Qf.or(date2Qf).or(date3Qf), (QFilter)taxtypeFilter);
            if (sjfbResult == null || !sjfbResult.isSuccess() || sjfbResult.getData() == null) {
                logger.info("\u67e5\u8be2\u7a0e\u91d1\u660e\u7ec6:\u65e0\u6570\u636e");
                for (RateTaxEnum enums : RateTaxEnum.values()) {
                    DynamicObject dynamicObject1 = entity0Collection.addNew();
                    int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("project1", (Object)enums.getName(), index);
                    dynamicObject1.set("project", (Object)enums.getName());
                }
                this.getModel().endInit();
                return;
            }
            try (DataSet sjfbDataSet = (DataSet)sjfbResult.getData();){
                Map<String, Map<Integer, DynamicObject>> selectMap = this.selectdata(sjfbDataSet);
                Map zzsMap = selectMap.computeIfAbsent(DeclareTaxType.ZZS.getBaseTaxCode(), k -> new HashMap());
                Map qysdsMap = selectMap.computeIfAbsent(DeclareTaxType.QYSDS.getBaseTaxCode(), k -> new HashMap());
                for (RateTaxEnum enums : RateTaxEnum.values()) {
                    DynamicObject dynamicObject2 = entity0Collection.addNew();
                    int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("project1", (Object)enums.getName(), index);
                    dynamicObject2.set("project", (Object)enums.getName());
                    for (int i = -2; i <= 0; ++i) {
                        DynamicObject preObj;
                        DynamicObject obj;
                        if (enums.getName().equals(RateTaxEnum.ZZS_CHINESE.getName())) {
                            obj = (DynamicObject)zzsMap.get(DateUtils.getYearOfDate((Date)startDate) + i);
                            preObj = (DynamicObject)zzsMap.get(DateUtils.getYearOfDate((Date)startDate) + i - 1);
                            this.cancleYearOnYear(obj, preObj, Math.abs(i), index, YSSR, BQYBSTE, dynamicObject2);
                            continue;
                        }
                        if (!enums.getName().equals(RateTaxEnum.QYSDS_CHINESE.getName())) continue;
                        obj = (DynamicObject)qysdsMap.get(DateUtils.getYearOfDate((Date)startDate) + i);
                        preObj = (DynamicObject)qysdsMap.get(DateUtils.getYearOfDate((Date)startDate) + i - 1);
                        this.cancleYearOnYear(obj, preObj, Math.abs(i), index, YSSR, BQYBSTE, dynamicObject2);
                    }
                }
            }
            this.getModel().endInit();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
            this.getView().updateView();
        }
    }

    private Map<String, Object> getDeclare(TaxResult<Map<String, Object>> result) {
        if (!result.isSuccess() || ObjectUtils.isEmpty((Object)result.getData())) {
            logger.info("getDeclare=noData");
            return null;
        }
        logger.info("getDeclare={}", result.getData());
        return (Map)result.getData();
    }

    private void cancleYearOnYearShenBao(Map<String, Object> obj, Map<String, Object> preObj, int i, int index, String yssr, String bqybste, DynamicObject dynamicObject) {
        try {
            if (ObjectUtils.isEmpty(obj)) {
                this.getModel().setValue(BQYBSTE + i, (Object)"", index);
                dynamicObject.set(BQYBSTE + i, (Object)"");
                return;
            }
            BigDecimal bqybtse = BigDecimal.ZERO;
            if (new BigDecimal(obj.get(yssr).toString()).compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue(BQYBSTE + i, (Object)"", index);
                dynamicObject.set(BQYBSTE + i, (Object)"");
                return;
            }
            bqybtse = new BigDecimal(obj.get(bqybste).toString()).multiply(HealthUtil.ONEHUNDRED).divide(new BigDecimal(obj.get(yssr).toString()), 2, 4);
            this.getModel().setValue(BQYBSTE + i, (Object)(bqybtse + "%"), index);
            dynamicObject.set(BQYBSTE + i, (Object)(bqybtse + "%"));
            if (i == 2) {
                return;
            }
            if (ObjectUtils.isEmpty(preObj) || new BigDecimal(preObj.get(yssr).toString()).compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue(YEARONYEAR + i, (Object)"", index);
                dynamicObject.set(YEARONYEAR + i, (Object)"");
                return;
            }
            BigDecimal preBqybtse = new BigDecimal(preObj.get(bqybste).toString()).multiply(HealthUtil.ONEHUNDRED).divide(new BigDecimal(preObj.get(yssr).toString()), 2, 4);
            if (preBqybtse.compareTo(BigDecimal.ZERO) == 0) {
                this.getModel().setValue(YEARONYEAR + i, (Object)"", index);
                dynamicObject.set(YEARONYEAR + i, (Object)"");
                return;
            }
            this.getModel().setValue(YEARONYEAR + i, (Object)(bqybtse.subtract(preBqybtse).multiply(HealthUtil.ONEHUNDRED).divide(preBqybtse, 2, 4) + "%"), index);
            dynamicObject.set(YEARONYEAR + i, (Object)(bqybtse.subtract(preBqybtse).multiply(HealthUtil.ONEHUNDRED).divide(preBqybtse, 2, 4) + "%"));
        }
        catch (Exception e) {
            logger.error("TctrcTaxrateIndexPlugin---\u6240\u5f97\u989d\u5229\u6da6\u53d6\u6570\u8d4b\u503c\u62a5\u9519-obj={}\uff0cpreObj={}", obj, preObj);
        }
    }

    private void cancleYearOnYear(DynamicObject obj, DynamicObject preObj, int i, int index, String yssr, String bqybste, DynamicObject dynamicObject2) {
        if (obj == null) {
            this.getModel().setValue(BQYBSTE + i, (Object)"", index);
            dynamicObject2.set(BQYBSTE + i, (Object)"");
            return;
        }
        BigDecimal bqybtse = BigDecimal.ZERO;
        if (obj.getBigDecimal(yssr).compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(BQYBSTE + i, (Object)"", index);
            dynamicObject2.set(BQYBSTE + i, (Object)"");
            return;
        }
        bqybtse = obj.getBigDecimal(bqybste).multiply(HealthUtil.ONEHUNDRED).divide(obj.getBigDecimal(yssr), 2, 4);
        this.getModel().setValue(BQYBSTE + i, (Object)(bqybtse + "%"), index);
        dynamicObject2.set(BQYBSTE + i, (Object)(bqybtse + "%"));
        if (i == 2) {
            return;
        }
        if (preObj == null || preObj.getBigDecimal(yssr).compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(YEARONYEAR + i, (Object)"", index);
            dynamicObject2.set(YEARONYEAR + i, (Object)"");
            return;
        }
        BigDecimal preBqybtse = preObj.getBigDecimal(bqybste).multiply(HealthUtil.ONEHUNDRED).divide(preObj.getBigDecimal(yssr), 2, 4);
        if (preBqybtse.compareTo(BigDecimal.ZERO) == 0) {
            this.getModel().setValue(YEARONYEAR + i, (Object)"", index);
            dynamicObject2.set(YEARONYEAR + i, (Object)"");
            return;
        }
        this.getModel().setValue(YEARONYEAR + i, (Object)(bqybtse.subtract(preBqybtse).multiply(HealthUtil.ONEHUNDRED).divide(preBqybtse, 2, 4) + "%"), index);
        dynamicObject2.set(YEARONYEAR + i, (Object)(bqybtse.subtract(preBqybtse).multiply(HealthUtil.ONEHUNDRED).divide(preBqybtse, 2, 4) + "%"));
    }

    private Map<String, Map<Integer, DynamicObject>> selectdata(DataSet sjfbDataSet) {
        HashMap<Integer, DynamicObject> zzsObjectMap = new HashMap<Integer, DynamicObject>();
        HashMap<Integer, DynamicObject> qysdsselectMap = new HashMap<Integer, DynamicObject>();
        DataSet sjfbDataSet2 = sjfbDataSet.copy();
        this.setdata(sjfbDataSet, zzsObjectMap, "taxtype  =1");
        this.setdata(sjfbDataSet2, qysdsselectMap, "taxtype  =3");
        sjfbDataSet.close();
        sjfbDataSet2.close();
        HashMap<String, Map<Integer, DynamicObject>> returnMap = new HashMap<String, Map<Integer, DynamicObject>>();
        returnMap.put(DeclareTaxType.ZZS.getBaseTaxCode(), zzsObjectMap);
        returnMap.put(DeclareTaxType.QYSDS.getBaseTaxCode(), qysdsselectMap);
        return returnMap;
    }

    private void setdata(DataSet sjfbDataSet, Map<Integer, DynamicObject> stringObjectMap, String sql) {
        for (Row row : sjfbDataSet.where(sql)) {
            DynamicObject obj;
            int date = DateUtils.getYearOfDate((Date)row.getDate(SKSSQQ));
            if (!stringObjectMap.containsKey(date)) {
                obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctb_tjsjb"));
                obj.set(BQYBSTE, (Object)row.getBigDecimal(BQYBSTE));
                obj.set(YSSR, (Object)row.getBigDecimal(YSSR));
                stringObjectMap.put(date, obj);
                continue;
            }
            obj = stringObjectMap.get(date);
            obj.set(BQYBSTE, (Object)obj.getBigDecimal(BQYBSTE).add(row.getBigDecimal(BQYBSTE)));
            obj.set(YSSR, (Object)obj.getBigDecimal(YSSR).add(row.getBigDecimal(YSSR)));
            stringObjectMap.put(date, obj);
        }
    }
}

