/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.checkup;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tctrc.business.tdm.TdmFinanceMainBusiness;
import kd.taxc.tctrc.business.tdm.TdmFinanceZcfzbBusiness;
import kd.taxc.tctrc.common.checkup.FinTaxSituationUtil;
import kd.taxc.tctrc.common.checkup.HealthUtil;
import kd.taxc.tctrc.common.checkup.ZcfzbEnum;
import kd.taxc.tctrc.common.util.DateUtils;

public class TctrcZcfzbPlugin
extends AbstractFormPlugin {
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String ZCFZENTITY = "zcfzentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "checkup".equals(args.getOperateKey())) {
            String result = this.getPageCache().get("checkResult");
            IDataModel parentModel = this.getModel();
            if (Boolean.TRUE.toString().equals(result) && !ObjectUtils.isEmpty((Object)parentModel.getValue(STARTDATE)) && !ObjectUtils.isEmpty((Object)parentModel.getValue(ENDDATE))) {
                String sbbid = this.getPageCache().get("sbbid");
                String isrecord = this.getPageCache().get("isrecord");
                Date startDate = parentModel.getDataEntity().getDate(STARTDATE);
                Date endDate = parentModel.getDataEntity().getDate(ENDDATE);
                FinTaxSituationUtil.setPeriodColText((EntryGrid)((EntryGrid)this.getControl(ZCFZENTITY)), (String)"zperiod", (Date)startDate, (Date)endDate);
                if (ObjectUtils.isEmpty((Object)parentModel.getValue("org"))) {
                    return;
                }
                this.getModel().deleteEntryData(ZCFZENTITY);
                this.buildEntity(sbbid, isrecord);
            }
        }
    }

    private void buildEntity(String sbbid, String isrecord) {
        if (Boolean.TRUE.toString().equals(isrecord)) {
            QFilter qFilter = new QFilter("sbbid", "=", (Object)Long.parseLong(sbbid));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_loss_stateme_record", (String)MetadataUtil.getAllSubFieldString((String)"tctrc_loss_stateme_record"), (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                        int row = this.getModel().createNewEntryRow(ZCFZENTITY);
                        this.getModel().setValue("zproject", (Object)dynamicObject1.getString("project"), row);
                        this.getModel().setValue("zamount1", (Object)dynamicObject1.getString("bqybtse0"), row);
                        this.getModel().setValue("zamount2", (Object)dynamicObject1.getString("bqybtse1"), row);
                        this.getModel().setValue("zchange2", (Object)dynamicObject1.getString("yearonyear1"), row);
                        this.getModel().setValue("zamount3", (Object)dynamicObject1.getString("bqybtse2"), row);
                        this.getModel().setValue("zchange3", (Object)dynamicObject1.getString("yearonyear2"), row);
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"content"});
            }
        } else {
            IDataModel parentModel = this.getModel();
            Date startDate = parentModel.getDataEntity().getDate(STARTDATE);
            Date endDate = parentModel.getDataEntity().getDate(ENDDATE);
            Map yearAndColMap = FinTaxSituationUtil.getYearAndColRelation((Date)startDate);
            long taxOrgId = parentModel.getDataEntity().getDynamicObject("org").getLong("id");
            TaxResult result = OrgRelationDataServiceHelper.getAccountingOrgIdByTaxcOrgId((Long)taxOrgId);
            if (!result.isSuccess() || result.getData() == null || ((List)result.getData()).size() != 1) {
                return;
            }
            long calOrgId = (Long)((List)result.getData()).get(0);
            DynamicObject[] bills = this.getFinMainInfo(calOrgId, startDate, endDate);
            HashMap<String, Integer> finMainIdAndYearMap = new HashMap<String, Integer>(16);
            ArrayList<String> finMainIds = new ArrayList<String>(16);
            Calendar calendar = Calendar.getInstance();
            for (DynamicObject bill : bills) {
                calendar.setTime(bill.getDate(SKSSQQ));
                int year = calendar.get(1);
                if (finMainIdAndYearMap.containsValue(year)) continue;
                finMainIdAndYearMap.put(bill.getString("id"), year);
                finMainIds.add(bill.getString("id"));
            }
            this.buildEntityProject();
            this.calEntityAmount(finMainIds, finMainIdAndYearMap, yearAndColMap);
            this.calEntityChange();
            this.saveData(sbbid);
        }
    }

    private void saveData(String sbbid) {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ZCFZENTITY);
        DynamicObject mainObject0 = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_balanc_sheet_record");
        mainObject0.set("sbbid", (Object)Long.parseLong(sbbid));
        DynamicObjectCollection entity0Collection = mainObject0.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamic : collection) {
            DynamicObject dynamicObject = entity0Collection.addNew();
            dynamicObject.set("project", (Object)dynamic.getString("zproject"));
            dynamicObject.set("bqybtse0", (Object)dynamic.getString("zamount1"));
            dynamicObject.set("bqybtse1", (Object)dynamic.getString("zamount2"));
            dynamicObject.set("yearonyear1", (Object)dynamic.getString("zchange2"));
            dynamicObject.set("bqybtse2", (Object)dynamic.getString("zamount3"));
            dynamicObject.set("yearonyear2", (Object)dynamic.getString("zchange3"));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObject0});
    }

    private DynamicObject[] getFinMainInfo(Long calOrgId, Date startDate, Date endDate) {
        QFilter qFilter = new QFilter("templatetype.id", "=", (Object)"zcfzb");
        qFilter.and("org", "=", (Object)calOrgId);
        QFilter date1Qf = new QFilter(SKSSQQ, ">=", (Object)startDate).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate)));
        QFilter date2Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-1)).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-1))));
        QFilter date3Qf = new QFilter(SKSSQQ, ">=", (Object)DateUtils.addYear((Date)startDate, (int)-2)).and(new QFilter(SKSSQZ, "<=", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addYear((Date)endDate, (int)-2))));
        return TdmFinanceMainBusiness.getTdmFinanceMainDetails((QFilter)qFilter.and(date1Qf.or(date2Qf).or(date3Qf)), (String)"skssqq desc");
    }

    private void buildEntityProject() {
        for (int i = 0; i < ZcfzbEnum.values().length; ++i) {
            this.getModel().createNewEntryRow(ZCFZENTITY);
            this.getModel().setValue("zproject", (Object)ZcfzbEnum.values()[i].getName(), i);
        }
    }

    private void calEntityAmount(List<String> finMainIds, Map<String, Integer> finMainIdAndYearMap, Map<Integer, Integer> yearAndColMap) {
        DynamicObject[] datas;
        IDataModel model = this.getModel();
        QFilter filter = new QFilter("sbbid", "in", finMainIds);
        for (DynamicObject data : datas = TdmFinanceZcfzbBusiness.getTdmFinanceZcfzb((QFilter)filter)) {
            String sbbId = data.getString("sbbid");
            Integer colIndex = yearAndColMap.get(finMainIdAndYearMap.get(sbbId));
            DynamicObject reportItem = data.getDynamicObject("reportitem");
            if (reportItem == null) continue;
            String name = reportItem.getString("name.zh_CN");
            BigDecimal amount = data.getBigDecimal("qmye");
            Map<String, String> rowAndItemMap = this.rowAndItemMap();
            for (Map.Entry<String, String> entry : rowAndItemMap.entrySet()) {
                String[] key = entry.getKey().split("_");
                int rowIndex = Integer.parseInt(key[0]);
                boolean flag = "contains".equals(key[1]) && name.contains(entry.getValue()) || "equals".equals(key[1]) && name.equals(entry.getValue());
                if (!flag) continue;
                model.setValue("zamount" + colIndex, (Object)amount, rowIndex);
            }
        }
    }

    private Map<String, String> rowAndItemMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("0_equals", ResManager.loadKDString((String)"\u8d44\u4ea7\u603b\u8ba1", (String)"TctrcZcfzbPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("1_equals", ResManager.loadKDString((String)"\u5e94\u6536\u8d26\u6b3e", (String)"TctrcZcfzbPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("2_equals", ResManager.loadKDString((String)"\u9884\u4ed8\u6b3e\u9879", (String)"TctrcZcfzbPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("3_equals", ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7", (String)"TctrcZcfzbPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("4_equals", ResManager.loadKDString((String)"\u65e0\u5f62\u8d44\u4ea7", (String)"TctrcZcfzbPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("5_equals", ResManager.loadKDString((String)"\u4f7f\u7528\u6743\u8d44\u4ea7", (String)"TctrcZcfzbPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("6_equals", ResManager.loadKDString((String)"\u957f\u671f\u80a1\u6743\u6295\u8d44", (String)"TctrcZcfzbPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("7_equals", ResManager.loadKDString((String)"\u9012\u5ef6\u6240\u5f97\u7a0e\u8d44\u4ea7", (String)"TctrcZcfzbPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("8_equals", ResManager.loadKDString((String)"\u8d1f\u503a\u5408\u8ba1", (String)"TctrcZcfzbPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("9_equals", ResManager.loadKDString((String)"\u5e94\u4ed8\u8d26\u6b3e", (String)"TctrcZcfzbPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("10_equals", ResManager.loadKDString((String)"\u9884\u6536\u6b3e\u9879", (String)"TctrcZcfzbPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("11_equals", ResManager.loadKDString((String)"\u5e94\u4ed8\u804c\u5de5\u85aa\u916c", (String)"TctrcZcfzbPlugin_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("12_equals", ResManager.loadKDString((String)"\u5e94\u4ea4\u7a0e\u8d39", (String)"TctrcZcfzbPlugin_12", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        map.put("13_contains", ResManager.loadKDString((String)"\u6240\u6709\u8005\u6743\u76ca\uff08\u6216\u80a1\u4e1c\u6743\u76ca\uff09\u5408\u8ba1", (String)"TctrcZcfzbPlugin_13", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        return map;
    }

    private void calEntityChange() {
        int size = this.getModel().getEntryRowCount(ZCFZENTITY);
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            for (int j = 2; j <= 3; ++j) {
                String changeColName = "zchange" + j;
                String curAmtColName = "zamount" + j;
                String preAmtColName = "zamount" + (j - 1);
                BigDecimal curAmount = (BigDecimal)this.getModel().getValue(curAmtColName, rowIndex);
                BigDecimal preAmount = (BigDecimal)this.getModel().getValue(preAmtColName, rowIndex);
                if (curAmount.compareTo(BigDecimal.ZERO) == 0 || preAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal change = curAmount.subtract(preAmount).multiply(HealthUtil.ONEHUNDRED).divide(preAmount, 2, RoundingMode.HALF_UP);
                this.getModel().setValue(changeColName, (Object)(change + "%"), rowIndex);
            }
        }
    }
}

