/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.tctrc.business.bd.BdTaxcategoryBusiness;
import kd.taxc.tctrc.business.tctrc.TctrcRiskNumberBusiness;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.helper.OrgServiceHelper;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.service.RiskScoreService;

public class AbstractRiskDefPlugin
extends AbstractFormPlugin {
    public static final String VARIABLE_WINDOW = "tctrc_variable_window";
    public static final String HIGH_RISK = "0";
    public static final String LOW_RISK = "1";
    private static final String LISTBOX_AP = "listboxap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addlabel", "vector_addlabel", "label_addlabel", "variableflex", "addvariable", "constant"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit org = (BasedataEdit)this.getView().getControl("createorg");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void orgAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        OrgServiceHelper.orgAddBeforeF7SelectListener((BeforeF7SelectEvent)event);
    }

    public void showForm(String itemKey, String formId, Map<String, Object> customParams) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(formId);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, itemKey));
        if (customParams != null) {
            parameter.setCustomParams(customParams);
        }
        this.getView().showForm(parameter);
    }

    public void switchListBox(String key) {
        if (HIGH_RISK.equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexhigh"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexlow"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexhigh"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexlow"});
        }
    }

    public void initListBox() {
        Listbox listbox = (Listbox)this.getControl(LISTBOX_AP);
        ArrayList<ListboxItem> list = new ArrayList<ListboxItem>();
        ListboxItem listboxItem = new ListboxItem();
        listboxItem.setId(HIGH_RISK);
        listboxItem.setContent(ResManager.loadKDString((String)"\u9ad8\u4e8e\u5bf9\u6807\u503c", (String)"AbstractRiskDefPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem1 = new ListboxItem();
        listboxItem1.setId(LOW_RISK);
        listboxItem1.setContent(ResManager.loadKDString((String)"\u4f4e\u4e8e\u5bf9\u6807\u503c", (String)"AbstractRiskDefPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        list.add(listboxItem);
        list.add(listboxItem1);
        listbox.addItems(list);
    }

    public void afterCreateNewData(EventObject e) {
        this.setTaxTypeMulValue();
        this.setCreateOrgValue();
    }

    public void setCreateOrgValue() {
        Object object = this.getModel().getValue("createorg");
        if (object == null) {
            Long unitOrgId = RequestContext.get().getOrgId();
            this.setOrg(unitOrgId);
        } else {
            this.setOrg(((DynamicObject)object).getLong("id"));
        }
    }

    private void setOrg(Long unitOrgId) {
        List list = OrgServiceHelper.getAllOrgEnable((long)RequestContext.get().getCurrUserId(), (String)"tctrc", (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
        if (list.contains(unitOrgId)) {
            this.getModel().setValue("createorg", (Object)unitOrgId);
            this.getPageCache().put("createorg", unitOrgId.toString());
        } else if (!CollectionUtils.isEmpty((Collection)list)) {
            this.getModel().setValue("createorg", list.get(0));
            this.getPageCache().put("createorg", ((Long)list.get(0)).toString());
        }
    }

    public void setTaxTypeMulValue() {
        DynamicObjectCollection taxtypemul = (DynamicObjectCollection)this.getModel().getValue("taxtypemul");
        if (CollectionUtils.isEmpty((Collection)taxtypemul)) {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            DynamicObject d = BdTaxcategoryBusiness.getBdTaxcategory((Long)1L);
            dynamicObjectCollection.add((Object)d);
            this.getModel().setValue("taxtypemul", (Object)dynamicObjectCollection);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("vector_addlabel".equals(key) || "label_addlabel".equals(key) || "flex_addlabel".equals(key)) {
            this.showLabelSelect();
        }
        if ("addvariable".equals(key)) {
            String riskNumber = (String)this.getModel().getValue("number");
            this.openVariableWindow(riskNumber);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing && "addvariable".equals(((Donothing)args.getSource()).getOperateKey())) {
            String riskNumber = (String)this.getModel().getValue("number");
            this.openVariableWindow(riskNumber);
        } else if (args.getSource() instanceof Save) {
            if (((Boolean)this.getModel().getValue("issbshow")).booleanValue() && EmptyCheckUtils.isEmpty((Object)this.getModel().getValue("sbbtype"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7533\u62a5\u8868\u7c7b\u578b\u201d\u3002", (String)"AbstractRiskDefPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean flag = this.checkTemplateType();
            if (flag && EmptyCheckUtils.isEmpty((Object)this.getModel().getValue("draftpurpose"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5e95\u7a3f\u7528\u9014\u201d\u3002", (String)"AbstractRiskDefPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (this.checkUk("number", ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskNumberEdit_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d\u3002", (String)"RiskNumberEdit_32", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), args)) {
                args.setCancel(true);
                return;
            }
            if (this.checkUk("name", ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskNumberEdit_33", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"RiskNumberEdit_34", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), args)) {
                args.setCancel(true);
                return;
            }
            this.setRiskExplainByEntry();
        }
    }

    protected boolean checkTemplateType() {
        DynamicObjectCollection sbbtype = (DynamicObjectCollection)this.getModel().getValue("sbbtype");
        Set collect = sbbtype.stream().map(v -> v.getString("fbasedataid.id")).collect(Collectors.toSet());
        boolean flag = false;
        for (String declareType : collect) {
            TemplateEnum enumByDeclareType = TemplateEnum.getEnumByDeclareType((String)declareType);
            if (!DeclareConstant.MODEL_VERSION_THREE.equals(enumByDeclareType.getVersion())) continue;
            flag = true;
        }
        return flag;
    }

    public void openVariableWindow(String riskNumber) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(VARIABLE_WINDOW);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setWidth("1230px");
        sc.setHeight("690px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("riskNumber", riskNumber);
        customParams.put("isvariable", Boolean.FALSE);
        customParams.put("row", 0);
        customParams.put("caltype", this.getModel().getValue("caltype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VARIABLE_WINDOW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void setRiskExplainByEntry() {
        int row = this.getModel().getEntryCurrentRowIndex("risklevelentryentity");
        DynamicObject risklevel = (DynamicObject)this.getModel().getValue("rlevel", row);
        String rlevelid = risklevel == null ? "" : risklevel.getString("id");
        String explain = (String)this.getModel().getValue("explain", row);
        this.getModel().setValue("risklevel", (Object)rlevelid);
        this.getModel().setValue("suggestion", (Object)explain);
    }

    public void showVariableSuggestion(ClosedCallBackEvent evt) {
        Map map = (Map)evt.getReturnData();
        if (map == null) {
            return;
        }
        String variableName = (String)map.get("variablenumber");
        int row = this.getModel().getEntryCurrentRowIndex("risklevelentryentity");
        String explain = (String)this.getModel().getValue("explain", row);
        boolean isVariable = StringUtils.isNotEmpty((CharSequence)variableName);
        if (isVariable) {
            explain = explain + "${" + variableName + "}";
        }
        this.getModel().setValue("explain", (Object)explain, row);
    }

    private void showLabelSelect() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("tctb_label_window");
        showParameter.setBillFormId("tctb_label_group");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setMultiSelect(true);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)LOW_RISK));
        DynamicObjectCollection labelentity = this.getModel().getEntryEntity("labelentity");
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : labelentity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject org = entity.getDynamicObject("labelid");
            if (null == org) continue;
            row.setName(org.getString("name"));
            row.setNumber(org.getString("number"));
            row.setPrimaryKeyValue(org.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        StyleCss sc = new StyleCss();
        sc.setHeight("610px");
        sc.setWidth("960px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        showParameter.setListSelectedRowCollection(listSelectedRowCollection);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "tctb_label_window");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection labels;
        if ("tctb_label_window".equals(evt.getActionId()) && (labels = (ListSelectedRowCollection)evt.getReturnData()) != null) {
            this.getModel().deleteEntryData("labelentity");
            for (ListSelectedRow selectedRow : labels) {
                int index = this.getModel().createNewEntryRow("labelentity");
                this.getModel().setValue("labelid", selectedRow.getPrimaryKeyValue(), index);
            }
        }
    }

    public void afterBindData(EventObject e) {
        String preset;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)customParams) && StringUtils.equals((CharSequence)"copy", (CharSequence)((String)customParams.get("risksource")))) {
            this.getModel().setValue("preset", (Object)HIGH_RISK);
            if (StringUtils.equals((CharSequence)"tctrc_risk_number", (CharSequence)parameter.getFormId())) {
                this.getPageCache().put("hasselectele", LOW_RISK);
            }
        }
        if (StringUtil.equals((CharSequence)LOW_RISK, (CharSequence)(preset = (String)this.getModel().getValue("preset")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
        }
        this.setVisibleRisk(this.getModel().getValue("caltype"));
        this.initDeviated(String.valueOf(this.getModel().getValue("caltype")), String.valueOf(this.getModel().getValue("deviatedcount")));
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("sbbtype");
        mulBasedataEdit.setMustInput(((Boolean)this.getModel().getValue("issbshow")).booleanValue());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (propertyName.equals("caltype")) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.setVisibleRisk(newValue);
            String newVal = String.valueOf(e.getChangeSet()[0].getNewValue());
            this.initDeviated(newVal, HIGH_RISK);
        } else if ("taxtypemul".equals(propertyName)) {
            this.dealTaxTypeMul(e);
        } else if ("issbshow".equals(propertyName)) {
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("sbbtype");
            mulBasedataEdit.setMustInput(newVal.booleanValue());
        }
        if ("rlevel".equals(propertyName)) {
            int currentIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject level = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (level != null) {
                String defaultscore = RiskScoreService.getDefaultScoreByLevelId(level.getLong("id"));
                this.getModel().setValue("riskscore", (Object)defaultscore, currentIndex);
            } else {
                this.getModel().setValue("riskscore", null, currentIndex);
            }
        }
    }

    protected void initDeviated(String newVal, String deviatedcount) {
        TimeDeviatedEnum timeDeviatedEnum = TimeDeviatedEnum.getEnumByDeviatedType((String)newVal);
        if (EmptyCheckUtils.isEmpty((Object)timeDeviatedEnum)) {
            return;
        }
        Integer comboValCount = timeDeviatedEnum.getComboValCount();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboValCount);
        for (int i = 0; i < comboValCount; ++i) {
            ComboItem item = new ComboItem(new LocaleString(String.valueOf(i)), String.valueOf(i));
            comboItems.add(item);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("deviatedcount");
        comboEdit.setComboItems(comboItems);
        this.getModel().setValue("deviatedcount", (Object)deviatedcount);
    }

    protected void clearVarable() {
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity("risklevelentryentity");
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String remark = String.valueOf(dynamicObject.get("explain"));
            if (!EmptyCheckUtils.isNotEmpty((Object)remark) || !remark.contains("${") || !remark.contains("}")) continue;
            this.getModel().setValue("explain", null, index++);
        }
    }

    public void dealTaxTypeMul(PropertyChangedArgs e) {
    }

    public void setVisibleRisk(Object key) {
        boolean isExist;
        Object id = this.getModel().getValue("id");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        boolean isSourceCopy = EmptyCheckUtils.isNotEmpty((Object)customParams) && StringUtils.equals((CharSequence)"copy", (CharSequence)((String)customParams.get("risksource")));
        boolean isAddNew = EmptyCheckUtils.isEmpty((Object)id) || 0L == Long.parseLong(String.valueOf(id));
        boolean bl = isExist = !isSourceCopy && isAddNew;
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"month"});
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"month"});
            ComboEdit comboEdit = (ComboEdit)this.getControl("month");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a\u6708", (String)"AbstractRiskDefPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), LOW_RISK));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a\u6708", (String)"AbstractRiskDefPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "2"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a\u6708", (String)"AbstractRiskDefPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "3"));
            if (isExist) {
                this.getModel().setValue("month", (Object)LOW_RISK);
            }
            comboEdit.setComboItems(items);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"month"});
            ComboEdit comboEdit = (ComboEdit)this.getControl("month");
            ArrayList<ComboItem> items = new ArrayList<ComboItem>();
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e00\u4e2a\u6708", (String)"AbstractRiskDefPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), LOW_RISK));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e8c\u4e2a\u6708", (String)"AbstractRiskDefPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "2"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e09\u4e2a\u6708", (String)"AbstractRiskDefPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "3"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u56db\u4e2a\u6708", (String)"AbstractRiskDefPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "4"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u4e94\u4e2a\u6708", (String)"AbstractRiskDefPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "5"));
            items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7b2c\u516d\u4e2a\u6708", (String)"AbstractRiskDefPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])), "6"));
            if (isExist) {
                this.getModel().setValue("month", (Object)LOW_RISK);
            }
            comboEdit.setComboItems(items);
        }
    }

    protected boolean checkUk(String key, String notNullErrorMsg, String notRepeateErrorMsg, BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dynamicObjects;
        Object value = this.getView().getModel().getValue(key);
        if (EmptyCheckUtils.isEmpty((Object)value)) {
            this.getView().showTipNotification(notNullErrorMsg);
            args.setCancel(true);
            return true;
        }
        QFilter qFilter = new QFilter(key, "=", value);
        if (key.equalsIgnoreCase("name")) {
            qFilter = new QFilter(key, "=", (Object)((OrmLocaleValue)value).getLocaleValue());
        }
        if (EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("id")) && !HIGH_RISK.equals(String.valueOf(this.getModel().getValue("id")))) {
            qFilter.and(new QFilter("id", "!=", this.getModel().getValue("id")));
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(dynamicObjects = TctrcRiskNumberBusiness.getTctrcRiskNumber((QFilter)qFilter)))) {
            this.getView().showTipNotification(notRepeateErrorMsg);
            args.setCancel(true);
            return true;
        }
        return false;
    }
}

