/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.tctrc.formplugin.definition.AbstractRiskDefPlugin;

public class ElementVerifyEdit
extends AbstractRiskDefPlugin
implements ListboxClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addriskflex", "addriskvector", "addrisklabel", "edit", "riskscore"});
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String key = listboxEvent.getItemId();
        this.switchListBox(key);
    }

    @Override
    protected void clearVarable() {
        super.clearVarable();
        this.getView().getModel().deleteEntryData("entryentity");
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry entryentity = (CardEntry)this.getControl("entryentity");
        entryentity.setChildVisible(false, 0, new String[]{"cardentryflexpanelap2", "cardentryflexpanelap3", "cardentryflexpanelap4"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("addriskflex") || key.equals("addriskvector") || key.equals("addrisklabel")) {
            this.openElementVerifyDialog(false);
        } else if (key.equals("edit")) {
            this.openElementVerifyDialog(true);
        } else if ("riskscore".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("risklevelentryentity");
            DynamicObject risklevel = (DynamicObject)this.getModel().getValue("rlevel", row);
            if (risklevel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u98ce\u9669\u7b49\u7ea7\u3002", (String)"ElementVerifyEdit_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("levelId", risklevel.getString("id"));
            this.getPageCache().put("currentrow", String.valueOf(row));
            this.showForm(key, "tctrc_risk_score_dialog", params);
        }
    }

    private void openElementVerifyDialog(boolean isEdit) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("tctrc_verify_dialog");
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryentity.getSelectRows();
        HashMap<String, Object> customParams = new HashMap<String, Object>(5);
        if (selectRows != null && selectRows.length > 0 && isEdit) {
            int rowIndex = selectRows[0];
            customParams.put("rowindex", rowIndex);
            customParams.put("exist", this.getModel().getValue("exist", rowIndex));
            customParams.put("title", this.getModel().getValue("title", rowIndex));
            customParams.put("json_tag", this.getModel().getValue("json_tag", rowIndex));
        }
        parameter.setCustomParams(customParams);
        StyleCss sc = new StyleCss();
        sc.setHeight("580px");
        sc.setWidth("960px");
        parameter.getOpenStyle().setInlineStyleCss(sc);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "save"));
        this.getView().showForm(parameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals("save")) {
            if (evt.getReturnData() != null) {
                Map returnData = (Map)evt.getReturnData();
                int rowindex = returnData.get("rowindex") == null ? this.getModel().createNewEntryRow("entryentity") : ((Integer)returnData.get("rowindex")).intValue();
                this.getModel().setValue("exist", returnData.get("exist"), rowindex);
                this.getModel().setValue("title", returnData.get("title"), rowindex);
                this.getModel().setValue("json_tag", returnData.get("json_tag"), rowindex);
                this.getModel().setValue("text", returnData.get("text_tag"), rowindex);
                CardEntry entryentity = (CardEntry)this.getControl("entryentity");
                entryentity.setChildVisible(false, 0, new String[]{"cardentryflexpanelap2", "cardentryflexpanelap3", "cardentryflexpanelap4"});
            }
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"tctrc_variable_window")) {
            this.showVariableSuggestion(evt);
        } else if ("riskscore".equals(evt.getActionId()) && evt.getReturnData() != null) {
            Map result = (Map)evt.getReturnData();
            String score = (String)result.get("score");
            String currentrow = this.getPageCache().get("currentrow");
            this.getModel().setValue("riskscore", (Object)score, Integer.parseInt(currentrow));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperateKey().equals("deleteentry")) {
            CardEntry entryentity = (CardEntry)this.getControl("entryentity");
            entryentity.setChildVisible(false, 0, new String[]{"cardentryflexpanelap2", "cardentryflexpanelap3", "cardentryflexpanelap4"});
        }
    }
}

