/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.business.org.TctrcTaxorgCommonBusiness;
import kd.taxc.tctrc.business.riskdefinition.RiskDefinitionBusiness;
import kd.taxc.tctrc.business.tctb.TctbLabelInfoBusiness;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.TreeUtils;
import kd.taxc.tctrc.formplugin.service.RiskListService;

public class RiskDefinitionPlugin
extends AbstractListPlugin {
    public static final String ENTITY_NUMBER = "tctrc_risk_number";
    public static final String ENTITY_SAMPLING = "tctrc_risk_sampling";
    public static final String ENTITY_VERIFY = "tctrc_element_verify";
    private static final String DELETE_REOCRD = "DELETE_REOCRD";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BaseShowParameter parameter = (BaseShowParameter)e.getParameter();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        if (EmptyCheckUtils.isEmpty((Object)listSelectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RiskDefinitionPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (listSelectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RiskDefinitionPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objectArr = BusinessDataServiceHelper.load((Object[])listSelectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctrc_risk_definition"));
        String riskType = objectArr[0].getString("risktype");
        long createorg = objectArr[0].getDynamicObject("createorg").getLong("id");
        RiskTypeEnum riskenum = RiskTypeEnum.getEnumByKey((String)riskType);
        String entityNumber = EmptyCheckUtils.isNotEmpty((Object)riskenum) ? riskenum.getFormid() : "";
        Boolean checkPermission = TctrcTaxorgCommonBusiness.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)createorg, (String)RiskDefinitionBusiness.getAppid((FormShowParameter)parameter, (String)"tctrc"), (String)entityNumber, (String)"47156aff000000ac");
        if (!checkPermission.booleanValue()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RiskDefinitionPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), EmptyCheckUtils.isNotEmpty((Object)riskenum) ? riskenum.getTitle() : ""));
            e.setCancel(true);
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("risksource", "copy");
        params.put("iscopy", true);
        params.put("isCopyRelateEntity", true);
        params.put("CopyEmptyRow", true);
        parameter.setFormId(entityNumber);
        parameter.setCustomParams(params);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            if ("donothingevaluation".equals(args.getOperateKey())) {
                if (listSelectedRows.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"RiskDefinitionPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject[] objectArr = BusinessDataServiceHelper.load((Object[])listSelectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tctrc_risk_definition"));
                String orgid = this.initOrg();
                List numberList = Arrays.stream(objectArr).map(v -> v.getLong("id")).collect(Collectors.toList());
                Map customMap = this.getView().getFormShowParameter().getCustomParams();
                customMap.put("user", String.valueOf(RequestContext.get().getCurrUserId()));
                customMap.put("number", numberList);
                customMap.put("datasource", "4");
                customMap.put("orgid", orgid);
                customMap.put("riskname", objectArr[objectArr.length - 1].getString("name"));
                customMap.put("resultid", numberList.get(numberList.size() - 1));
                PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_evaluation_frame", (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
            }
        }
    }

    private String initOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgId = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Collection)col)) {
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong("id") != orgId.longValue()) continue;
                useDefault = true;
                break;
            }
            if (!useDefault) {
                return String.valueOf(((DynamicObject)col.get(0)).get("id"));
            }
            return String.valueOf(RequestContext.get().getOrgId());
        }
        return "";
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals("sz")) {
            this.openBill(null, ENTITY_NUMBER);
        } else if (evt.getItemKey().equals("cj")) {
            this.openBill(null, ENTITY_SAMPLING);
        } else if (evt.getItemKey().equals("hd")) {
            this.openBill(null, ENTITY_VERIFY);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List labelIdList;
        super.filterContainerInit(args);
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn("labelid.number");
        args.addFilterColumn((FilterColumn)commonFilterColumn);
        commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7b7e", (String)"RiskDefinitionPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        if (!ObjectUtils.isEmpty((Object)this.getPageCache().get("labelId")) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(labelIdList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("labelId"), String.class))) && null != labelIdList.get(0) && ((String)labelIdList.get(0)).trim().length() > 0) {
            commonFilterColumn.setDefaultValues(labelIdList.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        List list;
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && "labelid.id".equals((list = (List)currentCommonFilter.get("FieldName")).get(0))) {
            List labelId = (List)currentCommonFilter.get("Value");
            this.getPageCache().put("labelId", SerializationUtils.toJsonString((Object)labelId));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List labelId;
        Object val;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qFilter = qFilters.stream().filter(v -> v.getProperty().equalsIgnoreCase("group")).findFirst().orElse(null);
        if (null != qFilter && !"0".equalsIgnoreCase(String.valueOf(val = qFilter.getValue()))) {
            qFilters.remove(qFilter);
            QFilter qFilter2 = new QFilter("taxtypemul.fbasedataid", "=", val);
            qFilters.add(qFilter2);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object riskType = customParams.get("riskType");
        Object riskLevel = customParams.get("riskLevel");
        Object orgId = customParams.get("orgId");
        if (riskType != null) {
            qFilters.add(new QFilter("risktype", "=", riskType));
        }
        if (orgId != null) {
            qFilters.add(new QFilter("runorg.id", "=", orgId));
        }
        if (riskLevel != null) {
            qFilters.add(new QFilter("risklevel", "=", riskLevel));
        }
        if (null != this.getPageCache().get("labelId") && null != (labelId = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("labelId"), String.class)) && labelId.size() > 0 && !"".equals(labelId.get(0))) {
            List risktype = null;
            risktype = null != this.getPageCache().get("risktype") ? SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("risktype"), String.class) : new ArrayList();
            if (risktype.isEmpty() || "".equals(risktype.get(0))) {
                risktype.add("1");
                risktype.add("2");
                risktype.add("3");
                qFilters.add(new QFilter("risktype", "in", risktype));
            }
            qFilters.add(new QFilter("labelentity.labelid", "in", labelId.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tctrc_risk_definition", (String)"id,risktype");
        String risktype = object.getString("risktype");
        Object pkValue = object.getPkValue();
        if ("1".equals(risktype)) {
            this.openBill(pkValue, ENTITY_NUMBER);
        } else if ("2".equals(risktype)) {
            this.openBill(pkValue, ENTITY_SAMPLING);
        } else if ("3".equals(risktype)) {
            this.openBill(pkValue, ENTITY_VERIFY);
        }
    }

    private void openBill(Object pkValue, String entity) {
        this.openBill(pkValue, entity, null);
    }

    private void openBill(Object pkValue, String entity, Map<String, Object> params) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(entity);
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setPkId(pkValue);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            if (!"tctrc_apphome".equals(this.getView().getParentView().getEntityId())) {
                if (!StringUtil.equals((CharSequence)"tctrc_risk_def_card", (CharSequence)this.getView().getParentView().getEntityId())) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
            } else {
                long userId = RequestContext.get().getCurrUserId();
                DynamicObject riskDefine = RiskDefinitionBusiness.getDataById((String)entity, (Long)Long.parseLong(pkValue.toString()));
                boolean hasSpecificPerm = TctrcTaxorgCommonBusiness.checkPermission((Long)userId, (Long)riskDefine.getLong("createorg.id"), (String)"tctrc", (String)entity, (String)"4715a0df000000ac");
                if (!hasSpecificPerm) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
            }
            parameter.setPageId(this.getView().getPageId() + entity + pkValue);
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (EmptyCheckUtils.isNotEmpty(params)) {
            parameter.setCustomParams(params);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        DynamicObject rowData = event.getRowData();
        if (source instanceof DynamicTextColumnDesc) {
            String key = ((DynamicTextColumnDesc)source).getKey();
            if ("label".equals(key)) {
                this.packageLabel(event);
            }
            return;
        }
        if (source instanceof ColumnDesc) {
            String key = ((ColumnDesc)source).getKey();
            if ("caltype".equals(key)) {
                this.packageCalType(event, rowData, key);
            } else if ("deviatedcount".equals(key)) {
                this.packageDeviatedCount(event, rowData, key);
            }
        }
    }

    private void packageDeviatedCount(PackageDataEvent event, DynamicObject rowData, String key) {
        String deviatedcount = rowData.getString("deviatedcount");
        String calType = rowData.getString("calType");
        RiskListService.setRiskCalulationDeviation(event, calType, deviatedcount);
    }

    public void packageCalType(PackageDataEvent event, DynamicObject d, String key) {
        String calType = d.getString("calType");
        Object id = d.get("id");
        String month = " ";
        String day = " ";
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject riskDynamicObject = QueryServiceHelper.queryOne((String)"tctrc_risk_definition", (String)"month,day", (QFilter[])new QFilter[]{qFilter});
        if (riskDynamicObject != null) {
            month = riskDynamicObject.getString("month");
            day = riskDynamicObject.getString("day");
        }
        RiskListService.setRiskListCalType(event, calType, month, day);
    }

    private void packageLabel(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        Object primaryKeyValue = rowData.get("id");
        QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"tctrc_risk_definition", (String)"labelentity.labelid", (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Object id = dynamicObject.get("labelentity.labelid");
            QFilter q = new QFilter("id", "=", id);
            DynamicObject object = TctbLabelInfoBusiness.getTctbLabelInfo((QFilter)q);
            if (object == null) continue;
            String name = object.getString("name");
            list.add(name);
        }
        e.setFormatValue((Object)String.join((CharSequence)",", list));
    }
}

