/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationBusiness;
import kd.taxc.tctrc.common.enums.RiskResultEnum;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.TreeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RiskEvaluationPlugin
extends AbstractListPlugin {
    private static final String NUMBER = "number";
    private static final String DONOTHINGDEAL = "donothingdeal";
    private static final String DONOTHING_CANCEL_DEAL = "donothingcanceldeal";
    private static final String DONOTHING_RISK_RESULT = "donothingriskresult";
    private static final String SUBMIT = "btnSubmit";
    private static final String REFRESH = "refresh";
    private static final String RISKCODE = "riskcode";
    private static final String MODULE = "taxc-tctrc-formplugin";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            List<String> idsList;
            if (DONOTHINGDEAL.equals(args.getOperateKey())) {
                idsList = this.getEntityId();
                this.donothingDeal(idsList);
            }
            if (DONOTHING_RISK_RESULT.equals(args.getOperateKey())) {
                idsList = this.getEntityId();
                this.donothingriskresult(idsList);
            }
            if (DONOTHING_CANCEL_DEAL.equals(args.getOperateKey())) {
                this.getView().invokeOperation(REFRESH);
            }
        }
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess() && DONOTHING_CANCEL_DEAL.equals(args.getOperateKey())) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void donothingDeal(List<String> idsList) {
        String userId = RequestContext.get().getUserId();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("tctrc_evaluation_process");
        parameters.setShowTitle(true);
        parameters.setCustomParam("user", (Object)String.valueOf(userId));
        parameters.setCustomParam("ids", idsList);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, SUBMIT);
        parameters.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameters);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SUBMIT) && closedCallBackEvent.getReturnData() != null) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f\u3002", (String)"RiskEvaluationPlugin_0", (String)MODULE, (Object[])new Object[0]));
            this.getView().invokeOperation(REFRESH);
        }
    }

    private List<String> getEntityId() {
        BillList billList = (BillList)this.getControl("billlistap");
        ArrayList<String> idsList = new ArrayList<String>();
        if (billList == null) {
            IDataModel model = this.getModel();
            String id = model.getValue("id").toString();
            idsList.add(id);
        } else {
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            idsList = listSelectedRows.stream().map(e -> e.getPrimaryKeyValue().toString()).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(idsList)) {
            return Collections.emptyList();
        }
        return idsList;
    }

    private void donothingriskresult(List<String> idsList) {
        QFilter q = new QFilter("id", "=", (Object)Long.parseLong(idsList.get(0)));
        DynamicObjectCollection dynamicObjectCollection = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluation((QFilter)q);
        if (dynamicObjectCollection == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u98ce\u9669\u7ed3\u679c\u8be6\u60c5\u3002", (String)"RiskEvaluationPlugin_1", (String)MODULE, (Object[])new Object[0]));
            return;
        }
        DynamicObject dynobj = (DynamicObject)dynamicObjectCollection.get(0);
        String pkValue = dynobj.getString("riskresultfid");
        String orgid = dynobj.getString("orgid");
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)"tctrc", (String)"tctrc_risk_run_result", (String)"47150e89000000ac");
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Boolean orgidBoo = false;
        if (!CollectionUtils.isEmpty((Collection)col)) {
            for (DynamicObject obj : col) {
                Long quanxianId = obj.getLong("id");
                Long orgidLong = Long.parseLong(orgid);
                if (orgidLong.longValue() != quanxianId.longValue()) continue;
                orgidBoo = true;
                break;
            }
        }
        if (Boolean.FALSE.equals(orgidBoo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u770b\u6743\u9650\u3002", (String)"RiskEvaluationPlugin_2", (String)MODULE, (Object[])new Object[0]));
            return;
        }
        String riskcode = dynobj.getString(RISKCODE);
        if (StringUtils.isEmpty((CharSequence)riskcode)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u7684\u201c\u98ce\u9669\u8bbe\u7f6e\u201d\u4e3b\u952e\u3002", (String)"RiskEvaluationPlugin_3", (String)MODULE, (Object[])new Object[0]));
            return;
        }
        QFilter defFilter = new QFilter("id", "=", (Object)Long.parseLong(riskcode));
        DynamicObject defresult = QueryServiceHelper.queryOne((String)"tctrc_risk_definition", (String)"riskType", (QFilter[])new QFilter[]{defFilter});
        if (defresult == null) {
            return;
        }
        String risktype = defresult.getString("risktype");
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        String formId = RiskResultEnum.getFormIdByKey((String)risktype);
        param.setFormId(formId);
        customParams.put("resultid", Long.parseLong(pkValue));
        String riskname = dynobj.getString("riskname");
        Long numberId = Long.parseLong(riskcode);
        customParams.put(NUMBER, numberId);
        String userId = RequestContext.get().getUserId();
        customParams.put("user", String.valueOf(userId));
        customParams.put("datasource", "0");
        customParams.put("orgid", orgid);
        customParams.put("riskname", riskname);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!StringUtils.equals((CharSequence)NUMBER, (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
            BillList list = (BillList)hyperEvt.getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            QFilter filter = new QFilter("id", "=", primaryKeyValue);
            DynamicObject result = TctrcRiskEvaluationBusiness.getTctrcRiskEvaluationQue4((QFilter)filter);
            if (result == null) {
                return;
            }
            String riskCodePk = result.getString(RISKCODE);
            QFilter defFilter = new QFilter("id", "=", (Object)Long.parseLong(riskCodePk));
            DynamicObject defresult = QueryServiceHelper.queryOne((String)"tctrc_risk_definition", (String)"riskType", (QFilter[])new QFilter[]{defFilter});
            if (defresult == null) {
                return;
            }
            String riskType = defresult.getString("risktype");
            RiskTypeEnum riskenum = RiskTypeEnum.getEnumByKey((String)riskType);
            this.openBill(riskCodePk, riskenum.getFormid());
        }
    }

    private void openBill(Object pkValue, String entity) {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(entity);
        if (pkValue == null) {
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            parameter.setPkId(pkValue);
            parameter.setBillStatus(BillOperationStatus.VIEW);
            if (!"tctrc_apphome".equals(this.getView().getParentView().getEntityId())) {
                if (!StringUtils.equals((CharSequence)"tctrc_risk_def_card", (CharSequence)this.getView().getParentView().getEntityId())) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
            } else {
                String appid = AppMetadataCache.getAppInfo((String)"tctrc").getId();
                long userId = RequestContext.get().getCurrUserId();
                boolean hasSpecificPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appid, (String)entity, (String)"4715a0df000000ac");
                if (!hasSpecificPerm) {
                    parameter.setStatus(OperationStatus.VIEW);
                }
            }
            parameter.setPageId(this.getView().getPageId() + entity + pkValue);
        }
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entity);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

