/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.common.enums.ProcessStateEnum;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.TreeUtils;
import org.apache.commons.lang3.StringUtils;

public class RiskEvaluationSavePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static final String SAVE = "save";
    private static final String EVALATION = "evaluation";
    private static final String FEEBACK = "feeback";
    private static final String PROCESSSTATE = "processstate";
    private static final String ORGID = "orgid";
    private static final String RISKCODE = "riskcode";
    private static final String DATASOURCE = "datasource";
    private static final String CHANGEORG = "changeorg";
    private static final String DONOTHINGDEAL = "donothingdeal";
    private static final String DONOTHING_CANCEL_DEAL = "donothingcanceldeal";
    private static final String ID = "id";
    private static final String RISKNAME = "riskname";

    public void afterCreateNewData(EventObject e) {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String datasource = (String)customMap.get(DATASOURCE);
        if (StringUtils.isEmpty((CharSequence)datasource)) {
            datasource = "2";
        }
        this.getModel().setValue(DATASOURCE, (Object)datasource);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam(CHANGEORG)))) {
            this.getView().getFormShowParameter().setCustomParam(CHANGEORG, (Object)"true");
            String orgid = this.initOrg();
            this.getModel().setValue(ORGID, (Object)orgid);
        } else {
            Object x = this.getView().getModel().getValue(ORGID);
            this.getModel().setValue(ORGID, (Object)((DynamicObject)x).getLong(ID));
        }
    }

    private String initOrg() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgId = RequestContext.get().getOrgId();
        if (!CollectionUtils.isEmpty((Collection)col)) {
            boolean useDefault = false;
            for (DynamicObject obj : col) {
                if (obj.getLong(ID) != orgId.longValue()) continue;
                useDefault = true;
                break;
            }
            if (!useDefault) {
                return String.valueOf(((DynamicObject)col.get(0)).get(ID));
            }
            return String.valueOf(RequestContext.get().getOrgId());
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.setEnableDeal();
        }
    }

    public void beforeBindData(EventObject e) {
        this.setEnableDeal();
    }

    private void setEnableDeal() {
        Object processstate = this.getModel().getValue(PROCESSSTATE);
        if (ProcessStateEnum.PROCESS_1.getCode().equals(processstate)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{DONOTHINGDEAL});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DONOTHINGDEAL});
        }
        if (ProcessStateEnum.PROCESS_2.getCode().equals(processstate)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{DONOTHING_CANCEL_DEAL});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{DONOTHING_CANCEL_DEAL});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)SAVE, (CharSequence)formOperate.getOperateKey())) {
            if (this.getModel().getValue(PROCESSSTATE) != null && this.getModel().getValue(PROCESSSTATE).toString().equals(ProcessStateEnum.PROCESS_2.getCode())) {
                return;
            }
            String processstate = null;
            String evaluation = (String)this.getModel().getValue(EVALATION);
            String feeback = (String)this.getModel().getValue(FEEBACK);
            processstate = "0".equals(evaluation) && StringUtils.isEmpty((CharSequence)feeback) ? ProcessStateEnum.PROCESS_0.getCode() : ProcessStateEnum.PROCESS_1.getCode();
            this.getModel().setValue(PROCESSSTATE, (Object)processstate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)RISKCODE, (CharSequence)propertyName)) {
            DynamicObject newOrg = (DynamicObject)cd.getNewValue();
            if (cd.getNewValue() == null) {
                this.getModel().setValue(RISKNAME, null);
            } else {
                this.getModel().setValue(RISKNAME, (Object)newOrg.getString("name"));
            }
        }
        super.propertyChanged(e);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{RISKCODE, PROCESSSTATE});
        BasedataEdit lables = (BasedataEdit)this.getView().getControl(RISKCODE);
        lables.addBeforeF7SelectListener(this::riskAddBeforeF7SelectListener);
    }

    void riskAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        DynamicObject[] collection;
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.getView().getModel().getValue(ORGID) == null) {
            return;
        }
        Long orgid = ((DynamicObject)this.getView().getModel().getValue(ORGID)).getLong(ID);
        QFilter qFilter = new QFilter("runorg", "=", (Object)orgid);
        QFilter enableFilter = new QFilter("risk.enable", "=", (Object)"1");
        ArrayList<Long> riskCodeList = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : collection = BusinessDataServiceHelper.load((String)"tctrc_risk_run_list", (String)"risk.id", (QFilter[])new QFilter[]{qFilter, enableFilter})) {
            riskCodeList.add(Long.parseLong(dynamicObject.getString("risk.id")));
        }
        QFilter orgIdsFilter = new QFilter(ID, "in", riskCodeList);
        formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

