/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcRiskNumberBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.task.helper.TdmEleCheckPlanHelper;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.OrgUtils;
import kd.taxc.tctrc.common.util.PermissionUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.common.util.TreeUtils;
import kd.taxc.tctrc.formplugin.definition.AbstractRiskDefPlugin;

public class RiskNumberEdit
extends AbstractRiskDefPlugin
implements TreeNodeClickListener,
ListboxClickListener {
    private static final String TREE = "treeviewap";
    private static final String VARIABLE_WINDOW = "tctrc_variable_window";
    private static final String Key_ExpressionText = "json";
    private static final String Key_ExpressionTextName = "jsonname";
    private static final String IS_CLOSE = "2";
    private static final String HAS_SELECT_ELE_KEY = "hasselectele";
    private static final String LISTBOX_MAX_ID = "listboxmaxid";
    private static final String CURRENT_LISTBOX_INDEX = "currentrowindex";
    private static final String ORGS = "orgs";
    private static final String BENCH_MARKING = "benchmarking";
    private static final String BM_VALUE = "bmvalue";
    private static final String BENCH_MARKING_1 = "benchmarking1";
    private static final String BM_VALUE_1 = "bmvalue1";
    private static final String ORGS_1 = "orgs1";
    private static final String item_id = "itemid";
    private static final String ORGS_BY_ALL = "orgsbyall";
    private static final String ADD_PIANCHA_MENU = "addpianchamenu";
    private static final String DEL_PIANCHA_MENU = "delpianchamenu";
    private static final String SELECT_ORG_BTN = "selectorgbtn";
    private static final String VIEW_SELECT_ORG_BTN = "viewselectorgbtn";
    private static final String ALL_LISTBOX_ITEMS = "alllistboxitems";
    private static final String DEFAULT_LISTBOX_ORG_ID = "-10241024";
    private static final String PIANCHA_NAME = "pianchaname";
    private static final String PIANCHA_NAME_1 = "pianchaname1";
    private static final String PIANCHA_ITEM_ID = "itemid";
    private static final String PIANCHA_INDEX = "pianchaname1";
    private static final String PIANCHA_INFO = "pianchainfo";
    private static final String RISK_ASSIGN_ORG = "tctrc_risk_assign_org";
    private static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = -6264470238648123248L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("leftparentheses", "(");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("rightparentheses", ")");
            this.put("abs", "abs(");
            this.put("clr", "CLR");
            this.put("constant", "constant");
        }
    };
    private static final Map<String, String> operationCharacterSymbol = new HashMap<String, String>(){
        private static final long serialVersionUID = -6264470238648123248L;
        {
            this.put("+", "+");
            this.put("-", "-");
            this.put("*", "*");
            this.put("/", "/");
            this.put("=", "=");
            this.put("<", "<");
            this.put("<=", "<=");
            this.put("(", "(");
            this.put(">", ">");
            this.put(">=", ">=");
            this.put("<>", "<>");
            this.put(")", ")");
            this.put("and", "and");
            this.put("IN", "IN");
            this.put("NOTIN", "NOTIN");
            this.put("NOT", "NOT");
            this.put("LIKE", "LIKE");
            this.put("NOT LIKE", "NOT LIKE");
            this.put("or", "or");
            this.put("abs(", "abs(");
            this.put("CLR", "CLR");
        }
    };
    private static final String EXPRESS_CONSTANT = "tctrc_risk_def_constant";
    private static final String ELEMENT_SELECT = "selectelement";
    private static final String LISTBOX_AP = "listboxap";
    private static final String LISTBOX_BY_PIANCHA = "listboxap1";
    private static final String ADD_VARIABLE_BTN = "addvariable";
    public static final String ENTRY_ENTITY = "entryentity";

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"flex_addlabel", "vector_addlabel", "label_addlabel", "elementpond", "riskscore", ADD_VARIABLE_BTN, ADD_PIANCHA_MENU, DEL_PIANCHA_MENU, SELECT_ORG_BTN, VIEW_SELECT_ORG_BTN});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbarap2", "advcontoolbarap3", ADD_VARIABLE_BTN, ADD_PIANCHA_MENU, DEL_PIANCHA_MENU, SELECT_ORG_BTN, VIEW_SELECT_ORG_BTN});
        Listbox listbox = (Listbox)this.getControl(LISTBOX_AP);
        listbox.addListboxClickListener((ListboxClickListener)this);
        Listbox pianchaMenuListBox = (Listbox)this.getControl(LISTBOX_BY_PIANCHA);
        pianchaMenuListBox.addListboxClickListener((ListboxClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("createorg");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    public void initialize() {
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toString().toLowerCase();
            Button btn = (Button)this.getControl(key);
            if (null == btn) continue;
            btn.addClickListener((ClickListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.setTaxTypeMulValue();
        this.setCreateOrgValue();
        this.getModel().setDataChanged(false);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String key = listboxEvent.getItemId();
        String sourceKey = ((Listbox)listboxEvent.getSource()).getKey();
        if (sourceKey.equalsIgnoreCase(LISTBOX_BY_PIANCHA)) {
            this.initPianchaEntryentity(key);
        } else {
            this.switchListBox(key);
        }
    }

    private void initPianchaEntryentity(String key) {
        if (BooleanEnum.NO.getCode().equals(this.getPageCache().get("isneedsave"))) {
            this.getPageCache().remove("isneedsave");
        } else {
            this.saveCurrentListBox();
        }
        this.getPageCache().put(CURRENT_LISTBOX_INDEX, key);
        this.doInitPianchaEntryentity(key);
    }

    private void doInitPianchaEntryentity(String key) {
        Map<String, List<Map<String, Object>>> itemid2EntryentityMap = this.getItemId2EntryEntityMap();
        List<Map<String, Object>> pianchaEntryEntityList = itemid2EntryentityMap.get(key);
        this.initEWaiInfo(key);
        this.initEntryentityInfo(pianchaEntryEntityList);
    }

    private void initEWaiInfo(String key) {
        Map<String, String> map = this.getItemElseInfo(key);
        this.getModel().setValue(ORGS, (Object)map.get(ORGS));
        if ("0".equalsIgnoreCase(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_ORG_BTN, VIEW_SELECT_ORG_BTN});
            this.getView().setEnable(Boolean.FALSE, new String[]{PIANCHA_NAME});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{SELECT_ORG_BTN, VIEW_SELECT_ORG_BTN});
            this.getView().setEnable(Boolean.TRUE, new String[]{PIANCHA_NAME});
        }
        this.getModel().setValue(PIANCHA_NAME, (Object)map.get(PIANCHA_NAME));
        this.getModel().setValue(BENCH_MARKING, (Object)map.get(BENCH_MARKING));
        this.getModel().setValue(BM_VALUE, (Object)map.get(BM_VALUE));
    }

    private void initEntryentityInfo(List<Map<String, Object>> pianchaEntryEntityList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (EmptyCheckUtils.isNotEmpty(pianchaEntryEntityList)) {
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, pianchaEntryEntityList.size());
            int rowIndex = 0;
            for (Map<String, Object> dynamicObject : pianchaEntryEntityList) {
                this.getModel().setValue("offset", dynamicObject.get("offset"), rowIndex);
                this.getModel().setValue("minborder", dynamicObject.get("minborder"), rowIndex);
                this.getModel().setValue("range", dynamicObject.get("range"), rowIndex);
                this.getModel().setValue("rangemax", dynamicObject.get("rangemax"), rowIndex);
                this.getModel().setValue("explain", dynamicObject.get("explain"), rowIndex);
                this.getModel().setValue("grade", dynamicObject.get("grade"), rowIndex);
                Long levelid = dynamicObject.get("rlevel") == null ? null : Long.valueOf(Long.parseLong(((Map)dynamicObject.get("rlevel")).get("id").toString()));
                this.getModel().setValue("rlevel", levelid, rowIndex);
                this.getModel().setValue("riskscore", dynamicObject.get("riskscore"), rowIndex);
                this.getModel().setValue("maxborder", dynamicObject.get("maxborder"), rowIndex);
                ++rowIndex;
            }
        } else {
            this.getModel().createNewEntryRow(ENTRY_ENTITY);
        }
    }

    private void saveCurrentListBox() {
        String currentListboxIndex = this.getPageCache().get(CURRENT_LISTBOX_INDEX);
        this.saveItemInfo(currentListboxIndex);
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList mapList = new ArrayList(dynamicObjects.size());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            map = new HashMap();
            map.put("offset", dynamicObject.get("offset"));
            map.put("minborder", dynamicObject.get("minborder"));
            map.put("range", dynamicObject.get("range"));
            map.put("rangemax", dynamicObject.get("rangemax"));
            map.put("explain", dynamicObject.get("explain"));
            map.put("grade", dynamicObject.get("grade"));
            map.put("rlevel", dynamicObject.get("rlevel"));
            map.put("riskscore", dynamicObject.get("riskscore"));
            map.put("maxborder", dynamicObject.get("maxborder"));
            mapList.add(map);
        }
        Map<String, List<Map<String, Object>>> itemid2EntryentityMap = this.getItemId2EntryEntityMap();
        itemid2EntryentityMap.put(currentListboxIndex, mapList);
        this.getPageCache().put(PIANCHA_INFO, SerializationUtils.toJsonString(itemid2EntryentityMap));
    }

    private String getCurrentOrg() {
        return this.getValByKey(ORGS);
    }

    private String getValByKey(String key) {
        return EmptyCheckUtils.isEmpty((Object)this.getView().getModel().getValue(key)) ? null : String.valueOf(this.getView().getModel().getValue(key));
    }

    private List<String> strToList(String str) {
        if (null == str || "".equals(str.trim())) {
            return new ArrayList<String>();
        }
        return Arrays.stream(str.split(",")).collect(Collectors.toList());
    }

    private void saveItemInfo(String currentListboxIndex) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, String> oldMap = this.getItemElseInfo(currentListboxIndex);
        String orgs = this.getCurrentOrg();
        map.put(ORGS, orgs);
        map.put(PIANCHA_NAME, this.getValByKey(PIANCHA_NAME));
        map.put(BENCH_MARKING, this.getValByKey(BENCH_MARKING));
        map.put(BM_VALUE, this.getValByKey(BM_VALUE));
        List<String> oldOrgs = this.strToList(oldMap.get(ORGS));
        List<String> oldAllOrgs = this.strToList(this.getPageCache().get(ORGS_BY_ALL));
        if (EmptyCheckUtils.isNotEmpty(oldAllOrgs) && EmptyCheckUtils.isNotEmpty(oldOrgs)) {
            oldAllOrgs.removeIf(v -> oldOrgs.contains(v));
        }
        List<String> currentOrgs = this.strToList(orgs);
        String lastOrgsByAll = EmptyCheckUtils.isNotEmpty(oldAllOrgs) ? Stream.concat(oldAllOrgs.stream(), currentOrgs.stream()).distinct().collect(Collectors.joining(",")) : orgs;
        this.getPageCache().put(ORGS_BY_ALL, lastOrgsByAll);
        this.getPageCache().put(this.getItemInfoElseKey(currentListboxIndex), SerializationUtils.toJsonString(map));
    }

    private void updateOrgsByDel(List<String> orgs) {
        if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(ORGS_BY_ALL))) {
            String lastOrgs = Arrays.stream(this.getPageCache().get(ORGS_BY_ALL).split(",")).filter(v -> !orgs.contains(v)).collect(Collectors.joining(","));
            this.getPageCache().put(ORGS_BY_ALL, lastOrgs);
        }
    }

    private Map<String, String> getItemElseInfo(String itemID) {
        String key = this.getItemInfoElseKey(itemID);
        String json = this.getPageCache().get(key);
        if (EmptyCheckUtils.isEmpty((Object)json)) {
            return new HashMap<String, String>();
        }
        return (Map)SerializationUtils.fromJsonString((String)json, Map.class);
    }

    private String getItemInfoElseKey(String itemID) {
        return "pianchaewaixinxi_" + itemID;
    }

    private Map<String, List<Map<String, Object>>> getItemId2EntryEntityMap() {
        String json = this.getPageCache().get(PIANCHA_INFO);
        if (EmptyCheckUtils.isEmpty((Object)json)) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        return (Map)SerializationUtils.fromJsonString((String)json, Map.class);
    }

    private String transformNumberToName(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return "";
        }
        String[] formula = json.split(" ");
        QFilter qfilter = new QFilter("enable", "!=", (Object)"0");
        Object objectiId = this.getModel().getValue("id");
        if (null != objectiId && !"".equals(objectiId.toString())) {
            qfilter.and(new QFilter("id", "!=", objectiId));
        }
        StringBuilder nameStrBuilder = new StringBuilder();
        DynamicObjectCollection collection = TdmElementGroupBusiness.getTdmElementGroupQuery((QFilter)qfilter);
        for (String content : formula) {
            if (!StringUtils.isEmpty((CharSequence)content) && operationCharacterSymbol.get(content) == null) {
                boolean isConstant = true;
                for (DynamicObject dynamicObject : collection) {
                    String number = dynamicObject.getString("number");
                    String name = dynamicObject.getString("name");
                    if (!content.trim().equals(number)) continue;
                    nameStrBuilder.append(name).append(' ');
                    this.getPageCache().put(HAS_SELECT_ELE_KEY, "1");
                    isConstant = false;
                    break;
                }
                if (!isConstant) continue;
                nameStrBuilder.append(content).append(' ');
                continue;
            }
            nameStrBuilder.append(content).append(' ');
        }
        return nameStrBuilder.toString();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisibleRisk(this.getModel().getValue("caltype"));
        this.initListBox();
        this.initPianchaMenuListBox();
        String json = (String)this.getModel().getValue(Key_ExpressionText);
        String oldJsonName = (String)this.getModel().getValue(Key_ExpressionTextName);
        String jsonName = this.transformNumberToName(json);
        if (!StringUtils.equals((CharSequence)jsonName, (CharSequence)oldJsonName)) {
            this.getModel().setValue(Key_ExpressionTextName, (Object)jsonName);
        }
        this.getModel().setDataChanged(false);
    }

    private void initPianchaMenuListBox() {
        Listbox listbox = (Listbox)this.getControl(LISTBOX_BY_PIANCHA);
        listbox.addListboxClickListener((ListboxClickListener)this);
        ArrayList<ListboxItem> listboxItemList = new ArrayList<ListboxItem>();
        Object id = this.getModel().getValue("id");
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity(ENTRY_ENTITY);
        int maxid = 0;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        if (!StringUtils.equals((CharSequence)"copy", (CharSequence)((String)customParams.get("risksource"))) && (EmptyCheckUtils.isEmpty((Object)id) || 0L == Long.parseLong(String.valueOf(id)) || EmptyCheckUtils.isEmpty((Object)dynamicObjects))) {
            ListboxItem listboxItem = new ListboxItem();
            listboxItem.setId("0");
            listboxItem.setContent(ResManager.loadKDString((String)"\u9ed8\u8ba4\u504f\u5dee", (String)"RiskNumberEdit_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            listboxItemList.add(listboxItem);
            listbox.addItems(listboxItemList);
            this.getView().updateView(LISTBOX_BY_PIANCHA);
            HashMap<String, String> ewaiMap = new HashMap<String, String>();
            ewaiMap.put(ORGS, null);
            ewaiMap.put(PIANCHA_NAME, ResManager.loadKDString((String)"\u9ed8\u8ba4\u504f\u5dee", (String)"RiskNumberEdit_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            ewaiMap.put(BENCH_MARKING, "1");
            ewaiMap.put(BM_VALUE, "0");
            this.getPageCache().put(this.getItemInfoElseKey("0"), SerializationUtils.toJsonString(ewaiMap));
        } else {
            TreeMap<String, List> orgsGroupListMap = new TreeMap<String, List>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                List groupList;
                if (EmptyCheckUtils.isEmpty((Object)dynamicObject.getString(ORGS_1))) {
                    dynamicObject.set("pianchaname1", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u504f\u5dee", (String)"RiskNumberEdit_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    dynamicObject.set("itemid", (Object)"0");
                }
                groupList = EmptyCheckUtils.isEmpty((Object)(groupList = (List)orgsGroupListMap.get(dynamicObject.getString("itemid")))) ? new ArrayList() : groupList;
                groupList.add(dynamicObject);
                orgsGroupListMap.put(dynamicObject.getString("itemid"), groupList);
            }
            Collections.sort(dynamicObjects, (v1, v2) -> v1.getString("itemid").compareTo(v2.getString("itemid")));
            StringBuilder sb = new StringBuilder();
            orgsGroupListMap.forEach((k, listVal) -> {
                listboxItemList.add(new ListboxItem(k, ((DynamicObject)listVal.get(0)).getString("pianchaname1")));
                if (EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)listVal.get(0)).getString(ORGS_1))) {
                    sb.append(((DynamicObject)listVal.get(0)).getString(ORGS_1)).append(',');
                }
                HashMap<String, String> ewaiMap = new HashMap<String, String>();
                ewaiMap.put(ORGS, ((DynamicObject)listVal.get(0)).getString(ORGS_1));
                ewaiMap.put(PIANCHA_NAME, ((DynamicObject)listVal.get(0)).getString("pianchaname1"));
                ewaiMap.put(BENCH_MARKING, ((DynamicObject)listVal.get(0)).getString(BENCH_MARKING_1));
                ewaiMap.put(BM_VALUE, ((DynamicObject)listVal.get(0)).getString(BM_VALUE_1));
                this.getPageCache().put(this.getItemInfoElseKey((String)k), SerializationUtils.toJsonString(ewaiMap));
            });
            if (EmptyCheckUtils.isNotEmpty(listboxItemList)) {
                maxid = Integer.parseInt(((ListboxItem)listboxItemList.get(listboxItemList.size() - 1)).getId());
            }
            if (EmptyCheckUtils.isNotEmpty((Object)sb)) {
                String orgsByAll = sb.substring(0, sb.length() - 2);
                this.getPageCache().put(ORGS_BY_ALL, orgsByAll);
            }
            this.getPageCache().put(PIANCHA_INFO, SerializationUtils.toJsonString(orgsGroupListMap));
            listbox.addItems(listboxItemList);
        }
        this.getPageCache().put(LISTBOX_MAX_ID, String.valueOf(maxid));
        this.getPageCache().put(CURRENT_LISTBOX_INDEX, "0");
        this.setAllListboxItems(listboxItemList);
        this.getPageCache().put("isneedsave", BooleanEnum.NO.getCode());
        listbox.listboxClick("0");
        listbox.activeItem("0");
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map data;
        String number;
        String nodeid = (String)evt.getNodeId();
        TreeView treeView = (TreeView)this.getView().getControl(TREE);
        TreeNode node = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)nodeid);
        Object object = node.getData();
        String eleName = node.getText().split("\\(")[0].trim();
        if (null != object && !StringUtils.isEmpty((CharSequence)(number = (String)(data = (Map)object).get("number")))) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TREE, (String)Key_ExpressionText, (String)number);
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TREE, (String)Key_ExpressionTextName, (String)eleName);
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Object source = evt.getSource();
        if (source instanceof Button && null != operationCharacter.get(((Button)source).getKey())) {
            this.operation(((Button)source).getKey());
        } else if ("elementpond".equals(key)) {
            this.showSelectEle();
        } else if (ADD_VARIABLE_BTN.equals(key)) {
            this.addVariable();
        } else if (ADD_PIANCHA_MENU.equals(key)) {
            this.addPianchaMenu();
        } else if (DEL_PIANCHA_MENU.equals(key)) {
            this.delPianchaMenu();
        } else if (SELECT_ORG_BTN.equals(key)) {
            this.showOrgTreeList(OperationStatus.EDIT.getValue(), ResManager.loadKDString((String)"\u9009\u62e9\u7ec4\u7ec7", (String)"RiskNumberEdit_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else if (VIEW_SELECT_ORG_BTN.equals(key)) {
            this.showOrgTreeList(OperationStatus.VIEW.getValue(), ResManager.loadKDString((String)"\u5df2\u9009\u7ec4\u7ec7", (String)"RiskNumberEdit_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        } else if ("riskscore".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            DynamicObject risklevel = (DynamicObject)this.getModel().getValue("rlevel", row);
            if (risklevel == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u98ce\u9669\u7b49\u7ea7\u3002", (String)"RiskNumberEdit_40", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("levelId", risklevel.getString("id"));
            this.getPageCache().put("currentrow", String.valueOf(row));
            this.showForm(key, "tctrc_risk_score_dialog", params);
        }
    }

    private void showOrgTreeList(int status, String title) {
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)RISK_ASSIGN_ORG, (boolean)true, (int)2);
        showParameter.setCustomParam("title", (Object)title);
        showParameter.setFormId(RISK_ASSIGN_ORG);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss sc = new StyleCss();
        sc.setHeight("660px");
        sc.setWidth("1200px");
        showParameter.getOpenStyle().setInlineStyleCss(sc);
        String orgs = String.valueOf(this.getModel().getValue(ORGS));
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        if (EmptyCheckUtils.isNotEmpty((Object)orgs)) {
            List structIds = OrgUtils.getStructurePkidsByOrgId(Arrays.stream(orgs.split(",")).collect(Collectors.toList()));
            for (String orgid : structIds) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)orgid);
                listSelectedRowCollection.add((Object)row);
            }
        }
        if (OperationStatus.EDIT.getValue() == status) {
            if (EmptyCheckUtils.isNotEmpty((Object)this.getPageCache().get(ORGS_BY_ALL))) {
                String[] selectedorgs = this.getPageCache().get(ORGS_BY_ALL).split(",");
                String[] currentCardSelectedOrgs = orgs.split(",");
                List currentCardSelectedOrgList = Arrays.stream(currentCardSelectedOrgs).collect(Collectors.toList());
                List notInIds = Arrays.stream(selectedorgs).filter(v -> !currentCardSelectedOrgList.contains(v)).collect(Collectors.toList());
                if (EmptyCheckUtils.isNotEmpty(notInIds)) {
                    QFilter qFilter = new QFilter("org.id", "not in", notInIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()));
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
            }
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)"1");
            showParameter.getListFilterParameter().getQFilters().add(enableFilter);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            hasPermOrgResult.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                QFilter qFilter = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        } else {
            QFilter qFilter = new QFilter("org.id", "in", EmptyCheckUtils.isEmpty((Object)orgs) ? new ArrayList() : Arrays.stream(orgs.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList()));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("view.treetype", "=", (Object)String.valueOf(OrgUtils.getDefaultViewSchemaInfoId())));
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("view.number", "=", (Object)"40"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, RISK_ASSIGN_ORG);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setLookUp(true);
        showParameter.setListSelectedRowCollection(listSelectedRowCollection);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void delPianchaMenu() {
        String itemid = this.findCurrentSelectedItemId();
        Listbox listbox = (Listbox)this.getControl(LISTBOX_BY_PIANCHA);
        List<ListboxItem> listboxItems = this.findCurrentAllListboxItems();
        if (EmptyCheckUtils.isEmpty(listboxItems)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u504f\u5dee", (String)"RiskNumberEdit_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        if ("0".equals(itemid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9ed8\u8ba4\u504f\u5dee\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"RiskNumberEdit_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        Map<String, String> ewaiMap = this.getItemElseInfo(itemid);
        if (EmptyCheckUtils.isNotEmpty((Object)ewaiMap.get(ORGS))) {
            this.updateOrgsByDel(Arrays.stream(ewaiMap.get(ORGS).split(",")).collect(Collectors.toList()));
        }
        this.getPageCache().remove(this.getItemInfoElseKey(itemid));
        listboxItems.removeIf(v -> v.getId().equalsIgnoreCase(itemid));
        this.setAllListboxItems(listboxItems);
        String selectedItemId = listboxItems.get(listboxItems.size() - 1).getId();
        this.getPageCache().put("isneedsave", BooleanEnum.NO.getCode());
        listbox.listboxClick(selectedItemId);
        listbox.activeItem(selectedItemId);
    }

    private String findCurrentSelectedItemId() {
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(CURRENT_LISTBOX_INDEX))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u504f\u5dee", (String)"RiskNumberEdit_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        return this.getPageCache().get(CURRENT_LISTBOX_INDEX);
    }

    private void addPianchaMenu() {
        Listbox listbox = (Listbox)this.getControl(LISTBOX_BY_PIANCHA);
        ListboxItem listboxItem = new ListboxItem();
        String itemid = this.findListboxId();
        String pianchaName = String.format(ResManager.loadKDString((String)"\u504f\u5dee%s", (String)"RiskNumberEdit_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), itemid);
        listboxItem.setContent(pianchaName);
        listboxItem.setId(itemid);
        List<ListboxItem> listboxItems = this.findCurrentAllListboxItems();
        listboxItems.add(listboxItem);
        listbox.addItems(listboxItems);
        this.setAllListboxItems(listboxItems);
        HashMap<String, String> ewaiMap = new HashMap<String, String>();
        ewaiMap.put(PIANCHA_NAME, pianchaName);
        ewaiMap.put(BENCH_MARKING, "1");
        ewaiMap.put(ORGS, null);
        ewaiMap.put(BM_VALUE, "0");
        this.getPageCache().put(this.getItemInfoElseKey(itemid), SerializationUtils.toJsonString(ewaiMap));
        listbox.listboxClick(itemid);
        listbox.activeItem(itemid);
    }

    private void setAllListboxItems(List<ListboxItem> listboxItems) {
        String json = SerializationUtils.toJsonString(listboxItems);
        this.getPageCache().put(ALL_LISTBOX_ITEMS, json);
    }

    private List<ListboxItem> findCurrentAllListboxItems() {
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(ALL_LISTBOX_ITEMS))) {
            return new ArrayList<ListboxItem>();
        }
        String json = this.getPageCache().get(ALL_LISTBOX_ITEMS);
        return SerializationUtils.fromJsonStringToList((String)json, ListboxItem.class);
    }

    private String findListboxId() {
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(LISTBOX_MAX_ID))) {
            this.getPageCache().put(LISTBOX_MAX_ID, "1");
            return "1";
        }
        Integer id = Integer.parseInt(this.getPageCache().get(LISTBOX_MAX_ID));
        id = id + 1;
        this.getPageCache().put(LISTBOX_MAX_ID, String.valueOf(id));
        return String.valueOf(id);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("addvariable2".equals(itemKey)) {
            this.addVariable();
        }
    }

    public void addVariable() {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryentity.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u201c\u63d2\u5165\u53d8\u91cf\u201d\u3002", (String)"RiskNumberEdit_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        Object rowId = ((DynamicObject)entryEntityCollection.get(row)).get("id");
        if ((Long)rowId == 0L) {
            DynamicObject dynamicObject = (DynamicObject)entryEntityCollection.get(row);
            rowId = DB.genLongId((String)"tctrc_risk_definition.entryentity");
            dynamicObject.set("id", rowId);
        }
        String riskNumber = (String)this.getModel().getValue("number");
        String explain = (String)this.getModel().getValue("explain", row);
        int orderNo = StringUtils.countMatches((CharSequence)explain, (CharSequence)"$") / 2 + 1;
        this.openVariableWindow(riskNumber, rowId, orderNo);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!"taxtypemul".equals(propertyName)) {
            if (propertyName.equals("caltype")) {
                Object newValue = e.getChangeSet()[0].getNewValue();
                this.setVisibleRisk(newValue);
                super.initDeviated(String.valueOf(newValue), "0");
            } else if (propertyName.equals("isvariable")) {
                long id = (Long)this.getModel().getValue("id");
                if (0L != id) {
                    DynamicObject dynamicObject = TctrcRiskNumberBusiness.queryTctrcRiskNumberBusSingle((Long)id);
                    dynamicObject.set("isvariable", e.getChangeSet()[0].getNewValue());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                }
            } else if (propertyName.equals(PIANCHA_NAME)) {
                String newRuleName = String.valueOf(e.getChangeSet()[0].getNewValue());
                String oldRuleName = String.valueOf(e.getChangeSet()[0].getOldValue());
                if (EmptyCheckUtils.isEmpty((Object)newRuleName)) {
                    this.getModel().setValue(PIANCHA_NAME, (Object)oldRuleName);
                    return;
                }
                String index = this.getPageCache().get(CURRENT_LISTBOX_INDEX);
                if (ResManager.loadKDString((String)"\u9ed8\u8ba4\u504f\u5dee", (String)"RiskNumberEdit_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(newRuleName) && !"0".equals(index)) {
                    this.getModel().setValue(PIANCHA_NAME, (Object)oldRuleName);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e0e\u9ed8\u8ba4\u504f\u5dee\u91cd\u590d\u3002", (String)"RiskNumberEdit_13", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.updatePianchaName(newRuleName);
            } else if ("issbshow".equals(propertyName)) {
                Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
                MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("sbbtype");
                mulBasedataEdit.setMustInput(newVal.booleanValue());
            } else if ("element".equals(propertyName)) {
                DynamicObject elementObject = (DynamicObject)this.getModel().getValue("element");
                if (elementObject == null) {
                    return;
                }
                if (elementObject.getBoolean("bottom") || !elementObject.getBoolean("typevalue")) {
                    this.getModel().setValue("resultshow", (Object)"1");
                } else {
                    this.getModel().setValue("resultshow", (Object)IS_CLOSE);
                }
            } else {
                super.propertyChanged(e);
            }
        }
    }

    @Override
    protected void clearVarable() {
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity(ENTRY_ENTITY);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String remark = String.valueOf(dynamicObject.get("explain"));
            if (!EmptyCheckUtils.isNotEmpty((Object)remark) || !remark.contains("${") || !remark.contains("}")) continue;
            this.getModel().setValue("explain", null, index++);
        }
        Map<String, List<Map<String, Object>>> allPianchaInfoMap = this.getItemId2EntryEntityMap();
        allPianchaInfoMap.forEach((k, list) -> {
            if (EmptyCheckUtils.isNotEmpty((Object)list)) {
                for (Map row : list) {
                    String remark = String.valueOf(row.get("explain"));
                    if (!EmptyCheckUtils.isNotEmpty((Object)remark) || !remark.contains("${") || !remark.contains("}")) continue;
                    row.put("explain", null);
                }
            }
        });
        this.getPageCache().put(PIANCHA_INFO, SerializationUtils.toJsonString(allPianchaInfoMap));
    }

    private void updatePianchaName(String newPianchaName) {
        String currentPianchaIndex = this.getPageCache().get(CURRENT_LISTBOX_INDEX);
        List<ListboxItem> allDatas = this.findCurrentAllListboxItems();
        for (ListboxItem item : allDatas) {
            if (!item.getId().equals(currentPianchaIndex)) continue;
            item.setContent(newPianchaName);
        }
        Listbox listbox = (Listbox)this.getControl(LISTBOX_BY_PIANCHA);
        listbox.addItems(allDatas);
        listbox.listboxClick(currentPianchaIndex);
        listbox.activeItem(currentPianchaIndex);
        this.setAllListboxItems(allDatas);
    }

    public void openVariableWindow(String riskNumber, Object rowId, int orderNo) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(VARIABLE_WINDOW);
        showParameter.setParentPageId(this.getView().getPageId());
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1230px");
        css.setHeight("690px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        Object id = this.getModel().getValue("id");
        Boolean isvariable = (Boolean)this.getModel().getValue("isvariable");
        customParams.put("id", String.valueOf(id));
        customParams.put("riskName", String.valueOf(name.get((Object)"zh_CN")));
        customParams.put("riskNumber", riskNumber);
        customParams.put("rowId", rowId);
        customParams.put("orderNo", orderNo);
        customParams.put("isvariable", isvariable);
        customParams.put("caltype", this.getModel().getValue("caltype"));
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, VARIABLE_WINDOW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)VARIABLE_WINDOW)) {
            this.dealVariableExplain(closedCallBackEvent);
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)EXPRESS_CONSTANT)) {
            String constant = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isNotEmpty((CharSequence)constant)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"constant", (String)Key_ExpressionText, (String)constant);
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"constant", (String)Key_ExpressionTextName, (String)constant);
            }
        } else if (ELEMENT_SELECT.equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null != listSelectedRows && !listSelectedRows.isEmpty()) {
                DynamicObject dynamicObject = TdmElementGroupBusiness.getTdmElementGroupSingleAll((Object)listSelectedRows.get(0).getPrimaryKeyValue());
                String number = dynamicObject.getString("number");
                String eleName = dynamicObject.getString("name");
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TREE, (String)Key_ExpressionText, (String)number);
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)TREE, (String)Key_ExpressionTextName, (String)eleName);
                this.getPageCache().put(HAS_SELECT_ELE_KEY, "1");
            }
        } else if (RISK_ASSIGN_ORG.equals(closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection listSelectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (null != listSelectedRows && !listSelectedRows.isEmpty()) {
                ArrayList<String> orgList = new ArrayList<String>();
                for (ListSelectedRow listSelectedRow : listSelectedRows) {
                    orgList.add(String.valueOf(listSelectedRow.getPrimaryKeyValue()));
                }
                List orgs = OrgUtils.getOrgIdByStructurePkids(orgList);
                this.getModel().setValue(ORGS, (Object)orgs.stream().collect(Collectors.joining(",")));
            }
        } else if ("riskscore".equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            String score = (String)result.get("score");
            String currentrow = this.getPageCache().get("currentrow");
            this.getModel().setValue("riskscore", (Object)score, Integer.parseInt(currentrow));
        }
    }

    public void dealVariableExplain(ClosedCallBackEvent closedCallBackEvent) {
        Map map = (Map)closedCallBackEvent.getReturnData();
        if (map == null) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
        String explain = (String)this.getModel().getValue("explain", row);
        String variableName = (String)map.get("variablenumber");
        boolean isVariable = StringUtils.isNotEmpty((CharSequence)variableName);
        if (isVariable) {
            explain = explain + "${" + variableName + "}";
        }
        this.getModel().setValue("explain", (Object)explain, row);
    }

    private void showSelectEle() {
        ListShowParameter listForm = new ListShowParameter();
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("580px");
        styleCss.setWidth("960px");
        listForm.setFormId("bos_treelistf7");
        listForm.setBillFormId("tdm_element_group");
        listForm.setMultiSelect(false);
        listForm.getOpenStyle().setInlineStyleCss(styleCss);
        listForm.getOpenStyle().setShowType(ShowType.Modal);
        listForm.setShowTitle(false);
        listForm.setLookUp(true);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        listForm.setListFilterParameter(listFilterParameter);
        listForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ELEMENT_SELECT));
        this.getView().showForm((FormShowParameter)listForm);
    }

    private void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(Key_ExpressionText, (Object)"");
            this.getModel().setValue(Key_ExpressionTextName, (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)Key_ExpressionText, (int)0);
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)Key_ExpressionTextName, (int)0);
            this.getPageCache().remove(HAS_SELECT_ELE_KEY);
        } else if (character.equalsIgnoreCase("abs(")) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionText, (String)character);
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionTextName, (String)character);
        } else if ("backspace".equalsIgnoreCase(character)) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionText);
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionTextName);
        } else if ("constant".equals(character)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(EXPRESS_CONSTANT);
            showParameter.setParentPageId(this.getView().getPageId());
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("400px");
            css.setHeight("200px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXPRESS_CONSTANT);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionText, (String)character);
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)xx, (String)Key_ExpressionTextName, (String)character);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.saveCurrentListBox();
            this.checkEntryEntityAndSet(args);
        } else if (args.getSource() instanceof Donothing && ADD_VARIABLE_BTN.equals(((Donothing)args.getSource()).getOperateKey())) {
            this.addVariable();
        }
    }

    private void checkEntryEntityAndSet(BeforeDoOperationEventArgs args) {
        if (this.checkUk("number", ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskNumberEdit_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d\u3002", (String)"RiskNumberEdit_32", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), args)) {
            args.setCancel(true);
            return;
        }
        if (this.checkUk("name", ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"RiskNumberEdit_33", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d", (String)"RiskNumberEdit_34", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), args)) {
            args.setCancel(true);
            return;
        }
        Map<String, List<Map<String, Object>>> allDataMap = this.getItemId2EntryEntityMap();
        if (EmptyCheckUtils.isEmpty(allDataMap)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u504f\u5dee\u4fe1\u606f\u201d\u3002", (String)"RiskNumberEdit_14", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String riskName = this.getValByKey("name");
        if (null != riskName && (riskName.indexOf(95) > -1 || riskName.indexOf(125) > -1 || riskName.indexOf(123) > -1 || riskName.indexOf(36) > -1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u201c_\u3001{\u3001}\u3001$\u7b49\u7279\u6b8a\u7b26\u53f7\u201d\u3002", (String)"RiskNumberEdit_17", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (((Boolean)this.getModel().getValue("issbshow")).booleanValue() && EmptyCheckUtils.isEmpty((Object)this.getModel().getValue("sbbtype"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7533\u62a5\u8868\u7c7b\u578b\u201d\u3002", (String)"RiskNumberEdit_35", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean flag = this.checkTemplateType();
        if (flag && EmptyCheckUtils.isEmpty((Object)this.getModel().getValue("draftpurpose"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5e95\u7a3f\u7528\u9014\u201d\u3002", (String)"AbstractRiskDefPlugin_10", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        List<ListboxItem> listboxItems = this.findCurrentAllListboxItems();
        ArrayList<Map<String, Object>> saves = new ArrayList<Map<String, Object>>();
        for (ListboxItem listboxItem : listboxItems) {
            if (this.checkEntryEntityByItemID(allDataMap.get(listboxItem.getId()), args, listboxItem, saves)) continue;
            args.setCancel(true);
            return;
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, saves.size());
        int rowIndex = 0;
        for (Map map : saves) {
            this.getModel().setValue("offset", map.get("offset"), rowIndex);
            this.getModel().setValue("minborder", map.get("minborder"), rowIndex);
            this.getModel().setValue("range", map.get("range"), rowIndex);
            this.getModel().setValue("rangemax", map.get("rangemax"), rowIndex);
            this.getModel().setValue("explain", map.get("explain"), rowIndex);
            this.getModel().setValue("grade", map.get("grade"), rowIndex);
            Long levelid = map.get("rlevel") == null ? null : Long.valueOf(Long.parseLong(((Map)map.get("rlevel")).get("id").toString()));
            this.getModel().setValue("rlevel", levelid, rowIndex);
            this.getModel().setValue("riskscore", map.get("riskscore"), rowIndex);
            this.getModel().setValue("maxborder", map.get("maxborder"), rowIndex);
            this.getModel().setValue("pianchaname1", map.get("pianchaname1"), rowIndex);
            this.getModel().setValue("itemid", map.get("itemid"), rowIndex);
            this.getModel().setValue(ORGS_1, map.get(ORGS_1), rowIndex);
            this.getModel().setValue(BENCH_MARKING_1, map.get(BENCH_MARKING_1), rowIndex);
            this.getModel().setValue(BM_VALUE_1, map.get(BM_VALUE_1), rowIndex);
            ++rowIndex;
        }
        try {
            TdmEleCheckPlanHelper.checkFormula((String)this.getModel().getValue(Key_ExpressionText).toString());
        }
        catch (Exception exception) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f\u3002", (String)"RiskNumberEdit_41", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private boolean checkEntryEntityByItemID(List<Map<String, Object>> maps, BeforeDoOperationEventArgs args, ListboxItem listboxItem, List<Map<String, Object>> saves) {
        String pianchaName = listboxItem.getContent();
        String itemId = listboxItem.getId();
        if (pianchaName.length() > 50) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u540d\u79f0\u201c%s\u201d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"RiskNumberEdit_18", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        if (EmptyCheckUtils.isEmpty(maps)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u81f3\u5c11\u6709\u4e00\u6761\u504f\u5dee\u8bb0\u5f55\u3002", (String)"RiskNumberEdit_21", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        Map<String, String> ewaiMap = this.getItemElseInfo(listboxItem.getId());
        if (!"0".equals(itemId) && EmptyCheckUtils.isEmpty((Object)ewaiMap.get(ORGS))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u672a\u8bbe\u7f6e\u7ec4\u7ec7\u3002", (String)"RiskNumberEdit_22", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        if (!this.checkEntryEntity(maps, args, pianchaName, ewaiMap)) {
            args.setCancel(true);
            return false;
        }
        for (Map<String, Object> rowMap : maps) {
            rowMap.put("pianchaname1", pianchaName);
            rowMap.put("itemid", itemId);
            rowMap.put(ORGS_1, ewaiMap.get(ORGS));
            rowMap.put(BENCH_MARKING_1, ewaiMap.get(BENCH_MARKING));
            rowMap.put(BM_VALUE_1, ewaiMap.get(BM_VALUE));
        }
        saves.addAll(maps);
        return true;
    }

    private boolean checkEntryEntity(List<Map<String, Object>> maps, BeforeDoOperationEventArgs args, String pianchaName, Map<String, String> ewaiMap) {
        Map<String, List<Map>> type2GroupListMap = maps.stream().collect(Collectors.groupingBy(k -> String.valueOf(k.get("offset"))));
        if (null != type2GroupListMap && type2GroupListMap.size() > 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u504f\u5dee\u7c7b\u578b\u8981\u4fdd\u6301\u4e00\u81f4\uff0c\u6570\u503c\u548c\u6bd4\u4f8b\u4e0d\u80fd\u540c\u65f6\u9009\u62e9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskNumberEdit_23", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        if (!this.doCheckEntryEntity(maps, args, pianchaName, ewaiMap)) {
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean doCheckEntryEntity(List<Map<String, Object>> maps, BeforeDoOperationEventArgs args, String pianchaName, Map<String, String> ewaiMap) {
        int size = maps.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> rowData = maps.get(i);
            if (rowData == null) continue;
            if (!this.checkCurrentRow(rowData, args, pianchaName, i, ewaiMap)) {
                args.setCancel(true);
                return false;
            }
            for (int j = i + 1; j < size; ++j) {
                Map<String, Object> rowData2 = maps.get(j);
                if (rowData2 == null || !this.isDataOverride(rowData, rowData2, args, pianchaName) && !this.isDataOverride(rowData2, rowData, args, pianchaName)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u504f\u5dee\u8303\u56f4\u8f93\u5165\u7684\u8303\u56f4\u4e0d\u80fd\u4ea4\u53c9\u6216\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"RiskNumberEdit_24", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
                args.setCancel(true);
                return false;
            }
        }
        return true;
    }

    private boolean checkCurrentRow(Map<String, Object> rowData, BeforeDoOperationEventArgs args, String pianchaName, int i, Map<String, String> ewaiMap) {
        String risklevelmsg = this.checkRiskLevel(rowData);
        if (risklevelmsg != null) {
            this.getView().showTipNotification(risklevelmsg);
            args.setCancel(true);
            return false;
        }
        BigDecimal left = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData.get("range")));
        BigDecimal right = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData.get("rangemax")));
        Object offset = rowData.get("offset");
        if (IS_CLOSE.equals(offset) && BigDecimalUtil.toBigDecimal((Object)ewaiMap.get(BM_VALUE)).compareTo(BigDecimal.ZERO) == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u504f\u5dee\u7c7b\u578b\u4e3a\u6bd4\u4f8b\u65f6\uff0c\u5bf9\u6807\u503c\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u4fee\u6539\u504f\u5dee\u7c7b\u578b\u6216\u5bf9\u6807\u503c\u3002", (String)"RiskNumberEdit_36", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        if (null == left || EmptyCheckUtils.isEmpty((Object)String.valueOf(rowData.get("range")))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%1$s\u201d\u504f\u5dee\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff1a \u7b2c%2$s\u884c\u201c\u504f\u5dee\u6700\u5c0f\u503c\u201d\u5e94\u8be5\u8f93\u5165\u6570\u5b57\u6216\u8005\u8d1f\u65e0\u7a77\u3002", (String)"RiskNumberEdit_26", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName, i + 1));
            args.setCancel(true);
            return false;
        }
        if (left.scale() > 2) {
            if (IS_CLOSE.equals(offset)) {
                left = BigDecimalUtil.setScale((Object)left, (int)2);
            } else if (left.scale() > 4) {
                left = BigDecimalUtil.setScale((Object)left, (int)4);
            }
            rowData.put("range", left);
        }
        if (null == right || EmptyCheckUtils.isEmpty((Object)String.valueOf(rowData.get("rangemax")))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%1$s\u201d\u504f\u5dee\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff1a \u7b2c%2$s\u884c\u201c\u504f\u5dee\u6700\u5927\u503c\u201d\u5e94\u8be5\u8f93\u5165\u6570\u5b57\u6216\u8005\u6b63\u65e0\u7a77\u3002", (String)"RiskNumberEdit_27", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName, i + 1));
            args.setCancel(true);
            return false;
        }
        if (right.scale() > 2) {
            if (IS_CLOSE.equals(offset)) {
                right = BigDecimalUtil.setScale((Object)right, (int)2);
            } else if (left.scale() > 4) {
                right = BigDecimalUtil.setScale((Object)right, (int)4);
            }
            rowData.put("rangemax", right);
        }
        if (left.compareTo(right) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%1$s\u201d\u504f\u5dee\u8303\u56f4\u8bbe\u7f6e\u6709\u8bef\uff0c \u7b2c%2$s\u884c\u201c\u504f\u5dee\u6700\u5c0f\u503c\u201d\u4e0d\u80fd\u5927\u4e8e\u201c\u504f\u5dee\u6700\u5927\u503c\u201d\u3002", (String)"RiskNumberEdit_28", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName, i + 1));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private String checkRiskLevel(Map<String, Object> rowData) {
        ArrayList<String> list = new ArrayList<String>(2);
        if (rowData.get("rlevel") == null) {
            list.add(ResManager.loadKDString((String)"\u201c\u98ce\u9669\u7b49\u7ea7\u201d", (String)"RiskNumberEdit_37", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        if (StringUtil.isBlank((CharSequence)String.valueOf(rowData.get("riskscore")))) {
            list.add(ResManager.loadKDString((String)"\u201c\u98ce\u9669\u5f97\u5206\u201d", (String)"RiskNumberEdit_38", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        if (list.size() > 0) {
            String msg = String.join((CharSequence)"\u3001", list);
            return String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"RiskNumberEdit_39", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), msg);
        }
        return null;
    }

    public boolean isDataOverride(Map<String, Object> rowData, Map<String, Object> rowData2, BeforeDoOperationEventArgs args, String pianchaName) {
        BigDecimal left = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData.get("range")));
        BigDecimal right = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData.get("rangemax")));
        String leftBracket = String.valueOf(rowData.get("minborder"));
        String rightBracket = String.valueOf(rowData.get("maxborder"));
        if (left == null || right == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u504f\u5dee\u201c%s\u201d\u504f\u5dee\u6700\u5c0f/\u5927\u503c\uff0c\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u3002", (String)"RiskNumberEdit_30", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), pianchaName));
            args.setCancel(true);
            return false;
        }
        BigDecimal left2 = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData2.get("range")));
        BigDecimal right2 = RiskCalSerivce.getRangeBigDecimal((String)String.valueOf(rowData2.get("rangemax")));
        String leftBracket2 = String.valueOf(rowData2.get("minborder"));
        String rightBracket2 = String.valueOf(rowData2.get("maxborder"));
        if (left2 == null || right2 == null) {
            return false;
        }
        if (left.compareTo(left2) == 0 && right.compareTo(right2) == 0) {
            return true;
        }
        if (left.compareTo(left2) > 0 && left.compareTo(right2) < 0) {
            return true;
        }
        if (right.compareTo(left2) > 0 && right.compareTo(right2) < 0) {
            return true;
        }
        if (left.compareTo(left2) == 0 && IS_CLOSE.equals(leftBracket) && IS_CLOSE.equals(leftBracket2)) {
            return true;
        }
        if (left.compareTo(right2) == 0 && IS_CLOSE.equals(leftBracket) && IS_CLOSE.equals(rightBracket2)) {
            return true;
        }
        if (right.compareTo(left2) == 0 && IS_CLOSE.equals(rightBracket) && IS_CLOSE.equals(leftBracket2)) {
            return true;
        }
        return right.compareTo(right2) == 0 && IS_CLOSE.equals(rightBracket) && IS_CLOSE.equals(rightBracket2);
    }
}

