/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tctrc.common.enums.InvoiceTypeEnum;

public class RiskSamplingDialogPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static String INVOICE_TYPE = "";
    private static final String KEY_BTNOK = "btnok";
    private static final String Key_filtergridap = "filtergridap";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNOK, "label_addfield", "flex_addfield", "vector_addfield"});
    }

    public void initialize() {
        BasedataEdit tablefield = (BasedataEdit)this.getControl("tableid");
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals("tableid")) {
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("number", "=", (Object)"ds_yscj"));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"RiskSamplingDialogPlugin_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (params.get("org") != null) {
                formShowParameter.setUseOrgId(Long.parseLong(params.get("org").toString()));
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(KEY_BTNOK)) {
            String json;
            if (StringUtils.isBlank((Object)this.getModel().getValue("title"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62bd\u68c0\u9879\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"RiskSamplingDialogPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.getModel().getValue("tableid") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u3002", (String)"RiskSamplingDialogPlugin_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (this.getModel().getEntryRowCount("entryentity") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u5c55\u793a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u5c55\u793a\u5b57\u6bb5\u3002", (String)"RiskSamplingDialogPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject table = (DynamicObject)this.getModel().getValue("tableid");
            String entityName = this.getEntityName(table.getLong("id"));
            if (!(!StringUtil.equals((CharSequence)"tpo_declare_main_tsd", (CharSequence)entityName) || (json = this.getWhere()).contains("row.number") && json.contains("column.number") && json.contains("value"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u8fc7\u6ee4\u5fc5\u987b\u5305\u542b\u201c\u884c\u7ef4\u201d\uff0c\u201c\u5217\u7ef4\u201d\uff0c\u201c\u503c\u201d\uff0c\u8bf7\u586b\u5199\u3002", (String)"RiskSamplingDialogPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private String getEntityName(Long tableid) {
        QFilter q1 = new QFilter("id", "=", (Object)tableid);
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject d = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"id,bizname,name,subname,ischild,entryentity.id,entryentity.bizsubname", (QFilter[])filters);
        return d.getString("name");
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(KEY_BTNOK)) {
            this.returnDataToParent();
        } else if (key.equals("label_addfield") || key.equals("flex_addfield") || key.equals("vector_addfield")) {
            this.showFieldsSelect();
        }
    }

    private void showFieldsSelect() {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tctb_datasource_entry", (boolean)true, (int)2);
        DynamicObjectCollection fieldsEntity = this.getModel().getEntryEntity("entryentity");
        ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
        for (DynamicObject entity : fieldsEntity) {
            ListSelectedRow row = new ListSelectedRow();
            DynamicObject field = entity.getDynamicObject("fieldid");
            row.setPrimaryKeyValue(field.get("id"));
            listSelectedRowCollection.add((Object)row);
        }
        parameter.setListSelectedRowCollection(listSelectedRowCollection);
        DynamicObject table = (DynamicObject)this.getModel().getValue("tableid");
        if (table == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8868\u3002", (String)"RiskSamplingDialogPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        List filters = parameter.getListFilterParameter().getQFilters();
        filters.add(new QFilter("inspectionshowfield", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("tableid", "=", (Object)table.getLong("id")));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectfield"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection fields;
        if (evt.getActionId().equals("selectfield") && (fields = (ListSelectedRowCollection)evt.getReturnData()) != null) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", fields.size());
            int index = 0;
            for (ListSelectedRow selectedRow : fields) {
                this.getModel().setValue("fieldid", selectedRow.getPrimaryKeyValue(), index++);
            }
        }
    }

    private void returnDataToParent() {
        DynamicObject table = (DynamicObject)this.getModel().getValue("tableid");
        DynamicObjectCollection entryenitty = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> nameList = new ArrayList<String>();
        for (DynamicObject entry : entryenitty) {
            idList.add(entry.getDynamicObject("fieldid").getString("id"));
            nameList.add(entry.getDynamicObject("fieldid").getString("bizsubname"));
        }
        String fieldIds = idList.stream().collect(Collectors.joining(","));
        String fieldNames = nameList.stream().collect(Collectors.joining(","));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowindex", this.getView().getFormShowParameter().getCustomParam("rowindex"));
        data.put("title", (String)this.getModel().getValue("title"));
        data.put("exist", (String)this.getModel().getValue("exist"));
        data.put("tableid", table.getString("id"));
        data.put("fieldid", fieldIds);
        data.put("fieldname", fieldNames);
        data.put("text_tag", this.getText());
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("tableid", table.getString("id"));
        jsonMap.put("fieldid", fieldIds);
        jsonMap.put("filterJson", this.getWhere());
        data.put("json_tag", SerializationUtils.toJsonString(jsonMap));
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private String getText() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        DynamicObject tableid = (DynamicObject)this.getModel().getValue("tableid");
        String ischild = tableid.getString("ischild");
        String subname = tableid.getString("subname");
        String entity = tableid.getString("name");
        if (ischild.equals("false") && StringUtils.isNotEmpty((CharSequence)subname)) {
            entity = subname;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getFilter();
    }

    private String getWhere() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        String modelType = "DynamicFormModel";
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)modelType, (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object exist = params.get("exist");
        if (exist != null) {
            this.getModel().setValue("exist", exist);
        }
        this.getModel().setValue("title", params.get("title"));
        this.getModel().setValue("tableid", params.get("tableid"));
        if (params.get("fieldid") != null) {
            for (String f : ((String)params.get("fieldid")).split(",")) {
                int row = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("fieldid", (Object)f, row);
            }
        }
        String entityNumber = "tdm_balance_new";
        if (params.get("json_tag") != null) {
            String json_tag = (String)params.get("json_tag");
            Map map = (Map)SerializationUtils.fromJsonString((String)json_tag, Map.class);
            this.setvalue((String)map.get("tableid"), (String)map.get("filterJson"));
            String filterJson = (String)map.get("filterJson");
            if (!StringUtils.isBlank((CharSequence)filterJson)) {
                this.setDataFilter(filterJson);
            }
        } else {
            QFilter q1 = new QFilter("issystem", "=", (Object)"1");
            QFilter q2 = new QFilter("group.number", "=", (Object)"ds_yscj");
            QFilter q3 = new QFilter("name", "=", (Object)entityNumber);
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"tctb_custom_datasource", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
            this.getModel().setValue("tableid", (Object)config);
            this.setvalue(config.getString("id"), null);
        }
    }

    private void setvalue(String configId, String filterJson) {
        QFilter q1 = new QFilter("id", "=", (Object)Long.parseLong(configId));
        QFilter[] filters = new QFilter[]{q1};
        DynamicObject d = QueryServiceHelper.queryOne((String)"tctb_custom_datasource", (String)"id,bizname,name,subname,ischild,entryentity.id,entryentity.bizsubname", (QFilter[])filters);
        if (null != d) {
            String id = d.getString("id");
            String name = d.getString("name");
            INVOICE_TYPE = InvoiceTypeEnum.getEnumByEntityId((String)name);
            String subname = d.getString("subname");
            String ischild = d.getString("ischild");
            this.initFilterCondition(id, ischild, name, subname);
            if (!StringUtils.isEmpty((CharSequence)filterJson)) {
                this.setDataFilter(filterJson);
            }
        }
    }

    private void initFilterCondition(String id, String ischild, String entityNumber, String subname) {
        QFilter q1 = new QFilter("id", "=", (Object)Long.parseLong(id));
        QFilter q3 = new QFilter("entryentity.elementwhere", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{q1, q3};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_custom_datasource", (String)"entryentity.id,entryentity.fieldsubname,entryentity.fieldname,entryentity.bizsubname", (QFilter[])filters);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        fc.getFilterRow().clear();
        List<Map<String, Object>> filterColumns = this.handlerFilterColumns(collection, ischild, entityNumber, subname);
        if (StringUtil.equals((CharSequence)"tpo_declare_main_tsd", (CharSequence)entityNumber)) {
            List<Map<String, Object>> filterColumnstsd = this.getTsdFilterColumns(filterColumns);
            filterGrid.setFilterColumns(filterColumnstsd);
        } else {
            filterGrid.setFilterColumns(filterColumns);
        }
        if (ischild.equals("false") && StringUtils.isNotEmpty((CharSequence)subname)) {
            filterGrid.setEntityNumber(subname);
        } else {
            filterGrid.setEntityNumber(entityNumber);
        }
        filterGrid.SetValue(fc);
        this.getView().updateView(Key_filtergridap);
    }

    private List<Map<String, Object>> getTsdFilterColumns(List<Map<String, Object>> filterColumns) {
        ArrayList<Map<String, Object>> filterColumnstsd = new ArrayList<Map<String, Object>>(10);
        filterColumns = filterColumns.stream().filter(v -> v.get("fieldName").equals("value") || v.get("fieldName").equals("column.number") || v.get("fieldName").equals("row.number")).collect(Collectors.toList());
        for (Map<String, Object> filterColumn : filterColumns) {
            if (filterColumn.get("fieldName").equals("value")) {
                ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals("67") && !dto.getId().equals("19") && !dto.getId().equals("21") && !dto.getId().equals("36") && !dto.getId().equals("65"));
            } else {
                ((List)filterColumn.get("compareTypes")).removeIf(dto -> !dto.getId().equals("67"));
            }
            filterColumnstsd.add(filterColumn);
        }
        return filterColumnstsd;
    }

    private List<Map<String, Object>> handlerFilterColumns(DynamicObjectCollection collection, String ischild, String entityNumber, String subname) {
        List<Map<String, Object>> filterColumns = this.createFilterColumns(entityNumber);
        if (ischild.equals("false") && StringUtils.isNotEmpty((CharSequence)subname)) {
            filterColumns.addAll(this.createFilterColumns(subname));
        }
        ArrayList<Map<String, Object>> ff = new ArrayList<Map<String, Object>>();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        for (DynamicObject d : collection) {
            map.put(d.getString("entryentity.fieldsubname") + "_" + d.getString("entryentity.fieldname"), d);
        }
        HashMap<String, String> cc = new HashMap<String, String>();
        for (Map<String, Object> entry : filterColumns) {
            String table = (String)entry.get("entryEntity");
            Object type = entry.get("type");
            String fieldName = (String)entry.get("fieldName");
            String key = table + "_" + fieldName.split("\\.")[0];
            String entityId = (String)entry.get("entityId");
            String key2 = entityId + "_" + fieldName;
            DynamicObject temp = (DynamicObject)map.get(key);
            boolean isTwo = false;
            if (null == temp) {
                temp = (DynamicObject)map.get(key2);
                isTwo = true;
            }
            if (null == temp) continue;
            if ("basedata".equals(type)) {
                String caption = (String)entry.get("fieldCaption");
                entry.put("fieldCaption", caption.replaceAll("\\.", ""));
            } else {
                entry.put("fieldCaption", temp.get("entryentity.bizsubname"));
            }
            if (null != cc.get(key) && (!isTwo || null != cc.get(key2))) continue;
            ff.add(entry);
            if (isTwo) {
                cc.put(key2, key2);
                continue;
            }
            cc.put(key, key);
        }
        this.renameFieldCaption(ff);
        return ff;
    }

    private List<Map<String, Object>> createFilterColumns(String entityNumber) {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        return filterColumns;
    }

    private void renameFieldCaption(List<Map<String, Object>> filterColumns) {
        for (Map<String, Object> filterColumn : filterColumns) {
            Object type = filterColumn.get("type");
            String caption = (String)filterColumn.get("fieldCaption");
            if (!caption.contains(".")) continue;
            if ("basedata".equals(type)) {
                filterColumn.put("fieldCaption", caption.replaceAll("\\.", ""));
                continue;
            }
            filterColumn.put("fieldCaption", caption.split("\\.")[1]);
        }
    }

    private void setDataFilter(String dataFilter) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)dataFilter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(Key_filtergridap);
        filterGrid.SetValue(filterCondition);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("tableid")) {
            this.getModel().deleteEntryData("entryentity");
            Object newVal = e.getChangeSet()[0].getNewValue();
            if (ObjectUtils.isEmpty((Object)newVal)) {
                return;
            }
            DynamicObject table = (DynamicObject)newVal;
            this.setvalue(table.getString("id"), null);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        if ("bd_invoicetype".equals(beforeFilterF7SelectEvent.getRefEntityId())) {
            QFilter q = new QFilter("number", "in", Arrays.asList(INVOICE_TYPE.split(",")));
            beforeFilterF7SelectEvent.addCustomQFilter(q);
        }
    }
}

