/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.tctrc.formplugin.service.RiskScoreService;

public class RiskScoreDialogPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String LEVEL_ID = "levelId";
    private static final String ENTRY_ENTITY = "entryentity";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        String levelId;
        List<String> scorelist;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.containsKey(LEVEL_ID) && (scorelist = RiskScoreService.getScoresByLevelId(Long.parseLong(levelId = (String)customParams.get(LEVEL_ID)))) != null && scorelist.size() > 0) {
            this.setScoreEntry(scorelist);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button && BTNOK.equals(((Button)source).getKey())) {
            EntryGrid entryList = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryList.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f97\u5206\u201d\u3002", (String)"RiskScoreDialogPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("score", String.valueOf(this.getModel().getValue("score", selectRows[0])));
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private void setScoreEntry(List<String> scores) {
        if (scores == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, scores.size());
        int row = 0;
        for (String score : scores) {
            this.getModel().setValue("score", (Object)score, row);
            ++row;
        }
    }
}

