/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcVariableInfoBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementTypeBusiness;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.SearchUtil;
import kd.taxc.tctrc.common.util.TreeUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class RiskVariableWindow
extends AbstractFormPlugin
implements TreeNodeClickListener,
ListRowClickListener,
ListboxClickListener {
    private static final String CURRENT_ITEM_ID = "currentItemId";
    private static final String ITEM_ELEMENT_TYPE = "itemElementType";
    private static final String ITEM_RISK_TYPE = "itemRiskType";
    private static final String ELEMENT_ENTRY_ENTITY = "elemententryentity";
    private static final String RISK_ENTRY_ENTITY = "riskentryentity";
    private static String TYPE_TREE = "treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String BILL_LIST_ELEMENT = "billlistap";
    private static final String BILL_LIST_RISK = "riskbilllist";
    private static final String VAR_NAME = "VAR_NAME";
    private static final String VARIABLE_NUMBER = "variablenumber";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TYPE_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"concel", "save"});
    }

    public void registerListener(EventObject e) {
        Listbox listboxap = (Listbox)this.getControl("listboxap");
        listboxap.addListboxClickListener((ListboxClickListener)this);
        Search search = (Search)this.getControl("entitysearchap");
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(TYPE_TREE);
        search.addEnterListener(event -> {
            if (StringUtils.isNotEmpty((CharSequence)event.getText())) {
                SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)TYPE_TREE);
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u7f16\u53f7\u6216\u540d\u79f0\u201d\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"RiskVariableWindow_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initListBoxItems();
        this.getView().setVisible(Boolean.TRUE, new String[]{ELEMENT_ENTRY_ENTITY});
        this.getView().setVisible(Boolean.FALSE, new String[]{RISK_ENTRY_ENTITY});
        this.refreshTreeList();
    }

    public void initListBoxItems() {
        Listbox listboxap = (Listbox)this.getControl("listboxap");
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem(ITEM_ELEMENT_TYPE, ResManager.loadKDString((String)"\u5143\u7d20", (String)"RiskVariableWindow_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(ITEM_RISK_TYPE, ResManager.loadKDString((String)"\u98ce\u9669", (String)"RiskVariableWindow_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.getPageCache().put(CURRENT_ITEM_ID, ITEM_ELEMENT_TYPE);
    }

    public void listboxClick(ListboxEvent evt) {
        String itemId = evt.getItemId();
        this.getPageCache().put(CURRENT_ITEM_ID, itemId);
        this.refreshTreeList();
    }

    public void refreshTreeList() {
        String itemId = this.getPageCache().get(CURRENT_ITEM_ID);
        if (StringUtils.isEmpty((CharSequence)itemId)) {
            itemId = ITEM_ELEMENT_TYPE;
        }
        if (ITEM_ELEMENT_TYPE.equals(itemId)) {
            this.loadTree();
            this.getView().setVisible(Boolean.TRUE, new String[]{ELEMENT_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.FALSE, new String[]{RISK_ENTRY_ENTITY});
        } else if (ITEM_RISK_TYPE.equals(itemId)) {
            this.loadRiskTree();
            this.getView().setVisible(Boolean.FALSE, new String[]{ELEMENT_ENTRY_ENTITY});
            this.getView().setVisible(Boolean.TRUE, new String[]{RISK_ENTRY_ENTITY});
        }
    }

    public void loadTree() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection dType = TdmElementTypeBusiness.getTdmElementType(null);
        if (dType != null && !dType.isEmpty()) {
            for (DynamicObject entry : dType) {
                TreeNode node = new TreeNode();
                String id = entry.getString("id");
                String name = entry.getString("name");
                node.setId(id);
                node.setText(name);
                node.setParentid("0");
                nodeList.add(node);
            }
        }
        QFilter qFilter = new QFilter("isvariable", "=", (Object)"1");
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection collection = TdmElementGroupBusiness.getTdmElementGroupQuery6((QFilter)qFilter.and(qFilter2));
        TreeView treeView = (TreeView)this.getView().getControl(TYPE_TREE);
        treeView.deleteAllNodes();
        if (collection != null && !collection.isEmpty()) {
            for (DynamicObject entry : collection) {
                String id = entry.getString("id");
                String name = entry.getString("name");
                String number = entry.getString("number");
                String parentid = entry.getString("group");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name + "(" + number + ")");
                node.setParentid(parentid);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("number", number);
                node.setData(data);
                nodeList.add(node);
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)true);
        }
    }

    public void loadRiskTree() {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        this.loadRiskTypeNode(nodeList);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilters.add(qFilter);
        QFilter qFilter2 = new QFilter("risktype", "=", (Object)"1");
        qFilters.add(qFilter2);
        QFilter qFilter3 = new QFilter("isvariable", "=", (Object)"1");
        qFilters.add(qFilter3);
        Map custom = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty((Object)custom) && EmptyCheckUtils.isNotEmpty(custom.get("caltype"))) {
            QFilter qFilter4 = new QFilter("caltype", ">=", custom.get("caltype"));
            qFilters.add(qFilter4);
        }
        DynamicObjectCollection riskDefinition = QueryServiceHelper.query((String)"tctrc_risk_definition", (String)"id,number,name,enable,risktype", (QFilter[])qFilters.toArray(new QFilter[0]));
        TreeView treeView = (TreeView)this.getView().getControl(TYPE_TREE);
        treeView.deleteAllNodes();
        if (CollectionUtils.isNotEmpty((Collection)riskDefinition)) {
            for (DynamicObject entry : riskDefinition) {
                String id = entry.getString("id");
                String name = entry.getString("name");
                String number = entry.getString("number");
                String parentid = entry.getString("risktype");
                TreeNode node = new TreeNode();
                node.setId(id);
                node.setText(name + "(" + number + ")");
                node.setParentid(parentid);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("number", number);
                node.setData(data);
                nodeList.add(node);
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)true);
        }
    }

    public void loadRiskTypeNode(List<TreeNode> nodeList) {
        TreeNode node1 = new TreeNode();
        node1.setId("1");
        node1.setText(ResManager.loadKDString((String)"\u6570\u503c\u6307\u6807", (String)"RiskVariableWindow_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        node1.setParentid("0");
        nodeList.add(node1);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        IPageCache pageCache = this.getPageCache();
        pageCache.put(CURRENT_NODE, nodeId);
        TreeView treeView = (TreeView)this.getControl(TYPE_TREE);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
        if (treeNode == null) {
            return;
        }
        List childNodesList = TreeUtils.getNodeList((TreeNode)treeNode);
        ArrayList<Long> idList = new ArrayList<Long>(childNodesList.size());
        for (TreeNode node : childNodesList) {
            idList.add(Long.parseLong(node.getId()));
        }
        String itemId = this.getPageCache().get(CURRENT_ITEM_ID);
        if (ITEM_ELEMENT_TYPE.equals(itemId)) {
            this.refreshElementEntryEntity(idList);
        } else if (ITEM_RISK_TYPE.equals(itemId)) {
            this.refreshRiskEntryEntity(idList);
        }
    }

    public void refreshElementEntryEntity(List<Long> idList) {
        this.getModel().deleteEntryData(ELEMENT_ENTRY_ENTITY);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tdm_element_group");
        DynamicObject[] elements = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mainEntityType);
        if (elements == null) {
            return;
        }
        if (elements.length > 0) {
            this.getModel().batchCreateNewEntryRow(ELEMENT_ENTRY_ENTITY, elements.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : elements) {
                this.getModel().setValue("elementnumber", dynamicObject.get("number"), rowIndex);
                this.getModel().setValue("elementname", dynamicObject.get("name"), rowIndex);
                this.getModel().setValue("timedeviationcount", dynamicObject.get("timedeviationcount"), rowIndex);
                this.getModel().setValue("timedeviationtype", dynamicObject.get("timedeviationtype"), rowIndex);
                this.getModel().setValue("risktimedeviationtype", dynamicObject.get("risktimedeviationtype"), rowIndex);
                this.getModel().setValue("timedeviationdirection", dynamicObject.get("timedeviationdirection"), rowIndex);
                ++rowIndex;
            }
        }
    }

    public void refreshRiskEntryEntity(List<Long> idList) {
        this.getModel().deleteEntryData(RISK_ENTRY_ENTITY);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctrc_risk_definition");
        DynamicObject[] riskDefineDynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mainEntityType);
        if (riskDefineDynamicObjects == null) {
            return;
        }
        if (riskDefineDynamicObjects.length > 0) {
            this.getModel().batchCreateNewEntryRow(RISK_ENTRY_ENTITY, riskDefineDynamicObjects.length);
            int rowIndex = 0;
            for (DynamicObject dynamicObject : riskDefineDynamicObjects) {
                this.getModel().setValue("risknumber", dynamicObject.get("number"), rowIndex);
                this.getModel().setValue("riskname", dynamicObject.get("name"), rowIndex);
                this.getModel().setValue("caltype", (Object)TimeDeviatedEnum.getMsgByDeviatedType((String)dynamicObject.getString("caltype")), rowIndex);
                ++rowIndex;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow selectedRow;
        ListSelectedRowCollection selectedRowCollection = evt.getListSelectedRowCollection();
        if (selectedRowCollection.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u53d8\u91cf\u3002", (String)"RiskVariableWindow_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRowCollection.size() == 1 && (selectedRow = selectedRowCollection.get(0)) != null) {
            Object id = selectedRow.getPrimaryKeyValue();
            this.getPageCache().put("elementId", String.valueOf(id));
            String itemId = this.getPageCache().get(CURRENT_ITEM_ID);
            if (ITEM_ELEMENT_TYPE.equals(itemId)) {
                this.refreshElementVariable(id);
            } else if (ITEM_RISK_TYPE.equals(itemId)) {
                this.refreshRiskVariable(id);
            }
        }
    }

    public void refreshElementVariable(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject dynamicObject = TdmElementGroupBusiness.getTdmElementGroupSingleQuery((QFilter)qFilter);
        if (dynamicObject != null) {
            String elementNumber = dynamicObject.getString("number");
            String elementName = dynamicObject.getString("name");
            String timeDeviationType = dynamicObject.getString("timedeviationtype");
            String timeDeviationDirection = dynamicObject.getString("timedeviationdirection");
            int timeDeviationCount = dynamicObject.getInt("timedeviationcount");
            String isBottom = dynamicObject.getString("bottom");
            String json = dynamicObject.getString("json_tag");
            Label label = (Label)this.getView().getControl("selectedname");
            label.setText(elementName);
            this.getPageCache().put("selectednumber", elementNumber);
            this.getPageCache().put("selectedname", elementName);
            this.getPageCache().put("bottom", isBottom);
            this.getPageCache().put("json", json);
            this.getModel().setValue("timedeviationtype", (Object)timeDeviationType);
            this.getModel().setValue("timedeviationdirection", (Object)timeDeviationDirection);
            this.getModel().setValue("timedeviationcount", (Object)timeDeviationCount);
        }
    }

    public void refreshRiskVariable(Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"1");
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(qFilter);
        filterList.add(qFilter2);
        DynamicObject riskDefinition = QueryServiceHelper.queryOne((String)"tctrc_risk_definition", (String)"id,number,name,enable,risktype,json", (QFilter[])filterList.toArray(new QFilter[1]));
        if (riskDefinition != null) {
            String riskNumber = riskDefinition.getString("number");
            String riskName = riskDefinition.getString("name");
            String expression = riskDefinition.getString("json");
            Label label = (Label)this.getView().getControl("selectedname");
            label.setText(riskName);
            this.getPageCache().put("selectednumber", riskNumber);
            this.getPageCache().put("selectedname", riskName);
            this.getPageCache().put("json", expression);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if ("concel".equals(sourceKey)) {
            this.getView().close();
        } else if ("save".equals(sourceKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Object rowId = customParams.get("rowId");
            Integer orderNo = (Integer)customParams.get("orderNo");
            String fatherRiskNumber = (String)customParams.get("riskNumber");
            String itemId = this.getPageCache().get(CURRENT_ITEM_ID);
            if (StringUtils.isEmpty((CharSequence)itemId)) {
                itemId = ITEM_ELEMENT_TYPE;
            }
            this.saveVariable(fatherRiskNumber, rowId, orderNo, itemId);
        }
    }

    public void saveVariable(String fatherRiskNumber, Object rowId, Integer orderNo, String itemId) {
        String entryEntityName = null;
        String name = null;
        String number = null;
        if (ITEM_ELEMENT_TYPE.equals(itemId)) {
            entryEntityName = ELEMENT_ENTRY_ENTITY;
            name = "elementname";
            number = "elementnumber";
        } else if (ITEM_RISK_TYPE.equals(itemId)) {
            entryEntityName = RISK_ENTRY_ENTITY;
            name = "riskname";
            number = "risknumber";
        }
        int row = this.getModel().getEntryCurrentRowIndex(entryEntityName);
        String selectedName = (String)this.getModel().getValue(name, row);
        String selectedNumber = (String)this.getModel().getValue(number, row);
        if (EmptyCheckUtils.isEmpty((Object)selectedNumber)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"RiskVariableWindow_14", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String timeDeviationType = (String)this.getModel().getValue("timedeviationtype", row);
        String timeDeviationDirection = (String)this.getModel().getValue("timedeviationdirection", row);
        String timeDeviationCount = "0";
        int deviationCount = NumberUtils.toInt((String)timeDeviationCount);
        String timeDeviation = TimeDeviatedEnum.getDeviatedDesc((String)timeDeviationDirection, (Integer)deviationCount, (String)timeDeviationType);
        Integer deviatedMonth = TimeDeviatedEnum.getDeviatedMonth((String)timeDeviationDirection, (int)deviationCount, (String)timeDeviationType);
        String variableNumber = null;
        if (ITEM_ELEMENT_TYPE.equals(itemId)) {
            variableNumber = String.format(ResManager.loadKDString((String)"%1$s_\u5143\u7d20_%2$s\u4e2a\u6708", (String)"RiskVariableWindow_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), selectedName, deviatedMonth * -1);
        } else if (ITEM_RISK_TYPE.equals(itemId)) {
            timeDeviationCount = "0";
            timeDeviation = ResManager.loadKDString((String)"\u4e0d\u504f\u79fb", (String)"RiskVariableWindow_11", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
            variableNumber = String.format(ResManager.loadKDString((String)"%s_\u98ce\u9669_0\u4e2a\u6708", (String)"RiskVariableWindow_12", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), selectedName);
        }
        QFilter qFilter = new QFilter("number", "=", variableNumber);
        DynamicObject dynamicObject = TctrcVariableInfoBusiness.getTctrcVariableInfo((QFilter)qFilter);
        if (dynamicObject == null) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_variable_info");
        }
        dynamicObject.set("rowid", rowId);
        dynamicObject.set("orderno", (Object)orderNo);
        dynamicObject.set("risknumber", (Object)fatherRiskNumber);
        dynamicObject.set("selectednumber", (Object)selectedNumber);
        dynamicObject.set("timedeviationtype", (Object)timeDeviationType);
        dynamicObject.set("timedeviationdirection", (Object)timeDeviationDirection);
        dynamicObject.set("timedeviationcount", (Object)timeDeviationCount);
        dynamicObject.set("timedeviation", (Object)timeDeviation);
        dynamicObject.set("json", (Object)this.getPageCache().get("json"));
        dynamicObject.set("number", (Object)variableNumber);
        DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
        Object[] objects = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        DynamicObject d = (DynamicObject)objects[0];
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(VARIABLE_NUMBER, variableNumber);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

