/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition.riskcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.tctrc.business.bd.BdTaxcategoryBusiness;
import kd.taxc.tctrc.business.org.TctrcTaxorgCommonBusiness;
import kd.taxc.tctrc.business.riskcontrol.RiskControlBusiness;
import kd.taxc.tctrc.common.util.DateUtils;

public class RiskControlEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ORG_SIGN = "org";
    private static final String BTN_SAVE_OPERATE_KEY = "save";
    private static final String KEY_FILTER_GRID_AP = "filtergridap";
    private static final List<String> FILTER_COLUMN_NAME = Stream.of("rlevel", "risk.name", "risk.number").collect(Collectors.toList());

    public void afterCreateNewData(EventObject e) {
        String nodeIdStr = this.getView().getParentView().getPageCache().get("selectedTreeNodeId");
        if (StringUtils.isNotEmpty((CharSequence)nodeIdStr)) {
            this.setTaxTypeMultiValue(Long.parseLong(nodeIdStr));
        }
    }

    public void setTaxTypeMultiValue(Long taxTypeId) {
        DynamicObjectCollection taxTypeCollection = (DynamicObjectCollection)this.getModel().getValue("taxtype");
        if (CollectionUtils.isEmpty((Collection)taxTypeCollection)) {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            DynamicObject object = BdTaxcategoryBusiness.getBdTaxcategory((Long)taxTypeId);
            dynamicObjectCollection.add((Object)object);
            this.getModel().setValue("taxtype", (Object)dynamicObjectCollection);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit taxOrgEdit = (BasedataEdit)this.getControl(ORG_SIGN);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxtype = (BasedataEdit)this.getControl("taxtype");
        taxtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.setFilterGripApFilterColumns("tctrc_risk_run_result", FILTER_COLUMN_NAME);
        String filterJson = this.getModel().getValue("filterjson_tag").toString();
        if (StringUtils.isNotEmpty((CharSequence)filterJson)) {
            this.setFilterGripValue(filterJson);
        }
        this.getView().updateView(KEY_FILTER_GRID_AP);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getProperty().getName().equals(ORG_SIGN)) {
            List orgIds = TctrcTaxorgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
            QFilter filter = orgIds == null || orgIds.isEmpty() ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", (Object)orgIds);
            evt.getCustomQFilters().add(filter);
        } else if (evt.getProperty().getName().equals("taxtype")) {
            Date firstTime = DateUtils.getFirstDateOfYear((Date)new Date());
            Date lastTime = DateUtils.getLastDateOfDay((Date)new Date());
            QFilter expDateFilter = new QFilter("expdate", "is null", null).or("expdate", ">=", (Object)lastTime);
            QFilter activeDateFilter = new QFilter("activedate", "<=", (Object)firstTime);
            evt.getCustomQFilters().add(activeDateFilter.and(expDateFilter));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save && ((Save)source).getOperateKey().equals(BTN_SAVE_OPERATE_KEY)) {
            this.getModel().setValue("filterjson_tag", (Object)this.getFilterGripApJson(KEY_FILTER_GRID_AP));
            DynamicObjectCollection orgEntryEntity = (DynamicObjectCollection)this.getModel().getValue("entryentity");
            this.getModel().setValue("isallorg", (Object)(orgEntryEntity.stream().anyMatch(p -> p.get(ORG_SIGN) != null) ? "0" : "1"));
            if (!this.checkBeforeSaveOperation().booleanValue()) {
                args.setCancel(true);
            }
        }
    }

    private Boolean checkBeforeSaveOperation() {
        List riskControlVerifyResults;
        String errorMsg;
        String draftPurpose;
        String filterJson = this.getModel().getValue("filterjson_tag").toString();
        Map filterMap = (Map)SerializationUtils.fromJsonString((String)filterJson, Map.class);
        if (!filterMap.containsKey("FilterRow") || CollectionUtils.isEmpty((Collection)((List)filterMap.get("FilterRow")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u98ce\u9669\u5f3a\u63a7\u6761\u4ef6\u3002", (String)"RiskControlEditPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection sbbTypes = (DynamicObjectCollection)this.getModel().getValue("sbbtype");
        List declareReportTypeNumbers = sbbTypes.stream().map(p -> p.getString("fbasedataid.number")).collect(Collectors.toList());
        TaxResult mapTaxResult = MultiDeclareDataServiceHelper.queryModelVersionByTypes(declareReportTypeNumbers);
        String string = draftPurpose = this.getModel().getValue("draftpurpose") == null ? "" : this.getModel().getValue("draftpurpose").toString();
        if (mapTaxResult != null && ((Map)mapTaxResult.getData()).values().stream().anyMatch(p -> p == ModelVersionEnum.MODEL3) && StringUtils.isEmpty((CharSequence)draftPurpose)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e95\u7a3f\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RiskControlEditPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean isAllOrg = (Boolean)this.getModel().getValue("isallorg");
        List<Object> orgIds = new ArrayList(0);
        if (!isAllOrg) {
            orgIds = ((DynamicObjectCollection)this.getModel().getValue("entryentity")).stream().map(p -> p.getLong("org.id")).collect(Collectors.toList());
        }
        List taxTypeIds = ((DynamicObjectCollection)this.getModel().getValue("taxtype")).stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList());
        Map<String, String> sbbTypeIdNumberMap = ((DynamicObjectCollection)this.getModel().getValue("sbbtype")).stream().collect(Collectors.toMap(k -> k.getString("fbasedataid.id"), v -> v.getString("fbasedataid.number")));
        DynamicObjectCollection riskControls = RiskControlBusiness.getEnableDataByOrgTaxTypeSbbType((Long)this.getModel().getDataEntity().getLong("id"), (boolean)isAllOrg, orgIds, null, sbbTypeIdNumberMap.keySet().stream().collect(Collectors.toList()), (String)"id,name,isallorg,taxtype.fbasedataid.id,taxtype.fbasedataid.name,sbbtype.fbasedataid.id,sbbtype.fbasedataid.name,entryentity.org.id,entryentity.org.name,draftpurpose");
        if (CollectionUtils.isEmpty((Collection)riskControls)) {
            return true;
        }
        Map sbbTypeNumberVersionMap = new HashMap(0);
        if (mapTaxResult != null) {
            sbbTypeNumberVersionMap = (Map)mapTaxResult.getData();
        }
        if (StringUtils.isNotEmpty((CharSequence)(errorMsg = RiskControlBusiness.buildRiskControlVerifyEntityMsg((List)(riskControlVerifyResults = RiskControlBusiness.getRiskControlVerifyResult(orgIds, (boolean)isAllOrg, sbbTypeIdNumberMap, sbbTypeNumberVersionMap, taxTypeIds, (String)draftPurpose, (Collection)riskControls)))))) {
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    private void setFilterGripApFilterColumns(String entityName, List<String> fieldSigns) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        List filterColumns = new EntityTypeUtil().getFilterColumns((IDataEntityType)entityType);
        filterColumns = filterColumns.stream().filter(p -> fieldSigns.stream().anyMatch(t -> t.equals(p.get("fieldName").toString()) || p.get("fieldName").toString().startsWith(t + "."))).collect(Collectors.toList());
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(entityName);
        filterGrid.SetValue(filterCondition);
    }

    private String getFilterGripApJson(String filterGripApSign) {
        FilterGrid filterGrid = (FilterGrid)this.getControl(filterGripApSign);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        DomainModelBinder binder = new DomainModelBinder(DomainModelType.getDomainModelType((String)"DynamicFormModel", (boolean)false));
        DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
        Map filterConditionMap = ser.serializeToMap((Object)filterCondition, null);
        String filterJson = SerializationUtils.toJsonString((Object)filterConditionMap);
        return filterJson;
    }

    private void setFilterGripValue(String filterGripApJson) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)filterGripApJson, Map.class);
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dataEntityTypes);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterGrid filterGrid = (FilterGrid)this.getControl(KEY_FILTER_GRID_AP);
        filterGrid.SetValue(filterCondition);
    }
}

