/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.definition.riskcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.tctrc.business.riskcontrol.RiskControlBusiness;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;

public class RiskControlListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    public static final String CACHE_TREE_SELECTED_NODE_ID = "selectedTreeNodeId";
    public static final String CACHE_PLUGIN = "plugin";

    public void afterCreateNewData(EventObject e) {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanel_treebtn"});
        super.afterCreateNewData(e);
    }

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        QFilter qFilter = qFilters.stream().filter(v -> v.getProperty().equalsIgnoreCase("group")).findFirst().orElse(null);
        if (null != qFilter) {
            Object groupValue = qFilter.getValue();
            if (!"0".equalsIgnoreCase(String.valueOf(groupValue))) {
                qFilters.remove(qFilter);
                QFilter qFilter2 = new QFilter("taxtype.fbasedataid", "=", groupValue);
                qFilters.add(qFilter2);
            } else {
                qFilters.remove(qFilter);
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        String cacheValue = !NumberUtils.isNumber((String)nodeId.toString()) ? "" : nodeId.toString();
        this.getPageCache().put(CACHE_TREE_SELECTED_NODE_ID, cacheValue);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof StatusConvert && "enable".equals(((StatusConvert)args.getSource()).getOperateKey())) {
            List taxTypeIds;
            Map<String, String> sbbTypeIdNumberMap;
            boolean isAllOrg;
            List orgIds;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            List ids = selectedRows.stream().map(p -> (Long)p.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObject[] selectedRiskControls = RiskControlBusiness.getDataByIds(ids, (Boolean)false, (String)"id,number,name,taxtype,sbbtype,entryentity.org,isallorg,draftpurpose");
            List sbbNumbers = Arrays.stream(selectedRiskControls).flatMap(t -> t.getDynamicObjectCollection("sbbtype").stream().map(p -> p.getString("fbasedataid.number"))).distinct().collect(Collectors.toList());
            TaxResult mapTaxResult = MultiDeclareDataServiceHelper.queryModelVersionByTypes(sbbNumbers);
            Map sbbTypeNumberVersionMap = new HashMap(0);
            if (mapTaxResult != null) {
                sbbTypeNumberVersionMap = (Map)mapTaxResult.getData();
            }
            DynamicObjectCollection riskControlList = RiskControlBusiness.getDisableDataByIds(ids, (String)"id,name,isallorg,taxtype.fbasedataid.id,taxtype.fbasedataid.name,sbbtype.fbasedataid.id,sbbtype.fbasedataid.name,entryentity.org.id,entryentity.org.name,draftpurpose");
            for (DynamicObject selectedRiskControl : selectedRiskControls) {
                orgIds = selectedRiskControl.getDynamicObjectCollection("entryentity").stream().map(p -> p.getLong("org.id")).collect(Collectors.toList());
                List riskControlVerifyResults = RiskControlBusiness.getRiskControlVerifyResult(orgIds, (boolean)(isAllOrg = selectedRiskControl.getBoolean("isallorg")), sbbTypeIdNumberMap = selectedRiskControl.getDynamicObjectCollection("sbbtype").stream().collect(Collectors.toMap(k -> k.getString("fbasedataid.id"), v -> v.getString("fbasedataid.number"))), sbbTypeNumberVersionMap, taxTypeIds = selectedRiskControl.getDynamicObjectCollection("taxtype").stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList()), (String)selectedRiskControl.getString("draftpurpose"), (Collection)riskControlList.stream().filter(p -> p.getLong("id") != selectedRiskControl.getLong("id")).collect(Collectors.toList()));
                if (!CollectionUtils.isNotEmpty((Collection)riskControlVerifyResults)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u79cd\u548c\u7533\u62a5\u8868\u7c7b\u578b\u76f8\u540c\u65f6\uff0c\u63a7\u5236\u65b9\u6848\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RiskControlListPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection riskControls = RiskControlBusiness.getEnableDataByDataOrgTaxTypeSbbType((Collection)Arrays.stream(selectedRiskControls).collect(Collectors.toList()), (String)"id,name,isallorg,taxtype.fbasedataid.id,taxtype.fbasedataid.name,sbbtype.fbasedataid.id,sbbtype.fbasedataid.name,entryentity.org.id,entryentity.org.name,draftpurpose");
            ArrayList riskControlVerifyResults = new ArrayList(16);
            for (DynamicObject selectedRiskControl : selectedRiskControls) {
                orgIds = selectedRiskControl.getDynamicObjectCollection("entryentity").stream().map(p -> p.getLong("org.id")).collect(Collectors.toList());
                isAllOrg = selectedRiskControl.getBoolean("isallorg");
                sbbTypeIdNumberMap = selectedRiskControl.getDynamicObjectCollection("sbbtype").stream().collect(Collectors.toMap(k -> k.getString("fbasedataid.id"), v -> v.getString("fbasedataid.number")));
                taxTypeIds = selectedRiskControl.getDynamicObjectCollection("taxtype").stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList());
                riskControlVerifyResults.addAll(RiskControlBusiness.getRiskControlVerifyResult(orgIds, (boolean)isAllOrg, sbbTypeIdNumberMap, sbbTypeNumberVersionMap, taxTypeIds, (String)selectedRiskControl.getString("draftpurpose"), (Collection)riskControls));
            }
            String errorMsg = RiskControlBusiness.buildRiskControlVerifyEntityMsg(riskControlVerifyResults);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
                return;
            }
        }
    }
}

