/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.eventmanage;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tctrc.business.org.TctrcTaxorgCommonBusiness;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class EventHandlerList
extends AbstractListPlugin {
    private static final String SKSSQQ = "effectdate";
    private static final String SKSSQZ = "invaliddate";
    private static final String PUSH = "push";
    private static final String GLSCPUSH = "glscpush";
    private static final String UNAUDIT = "unaudit";
    private static final String RESEVENTCODE = "reseventcode";
    private static final String TCTF_EVENT_MANAGEMENT = "tctf_event_management";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        TaxResult orgidList = TctrcTaxorgCommonBusiness.getAllOrg();
        if (orgidList != null && orgidList.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgidList.getData()))) {
            qFilters.add(new QFilter("org.id", "in", orgidList.getData()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            List orgIds;
            TaxResult listTaxResult;
            TaxResult orgFlag;
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("org.number") || (orgFlag = TctrcTaxorgCommonBusiness.isOrg((Long)RequestContext.get().getOrgId())).isSuccess() && !BooleanUtils.isFalse((Boolean)((Boolean)orgFlag.getData())) || (listTaxResult = TctrcTaxorgCommonBusiness.getAllOrg()) == null || !listTaxResult.isSuccess() || !CollectionUtils.isNotEmpty((Collection)(orgIds = (List)listTaxResult.getData()))) continue;
            filterColumn.setDefaultValues(new Object[]{((Long)orgIds.get(0)).toString()});
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        FormOperate operate = (FormOperate)args.getSource();
        if (PUSH.equals(operate.getOperateKey())) {
            Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (collect.size() > 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5904\u7406\u3002", (String)"EventManagement_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billEntity = billlist.getListModel().getDataEntityType().getName();
            DynamicObject loadResult = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)billEntity);
            String status = loadResult.getString("billstatus");
            if (!"C".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u5904\u7406\u3002", (String)"EventManagement_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (GLSCPUSH.equals(operate.getOperateKey())) {
            args.setCancel(true);
            Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (collect.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5173\u8054\u751f\u6210\u3002", (String)"EventManagement_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billEntity = billlist.getListModel().getDataEntityType().getName();
            DynamicObject loadResult = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)billEntity);
            String status = loadResult.getString("handlestatus");
            if (!"1".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u5df2\u5904\u7406\u7684\u4e8b\u4ef6\u7ba1\u7406\u3002", (String)"EventManagement_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (UNAUDIT.equals(operate.getOperateKey())) {
            // empty if block
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (RESEVENTCODE.equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            String billEntity = list.getListModel().getDataEntityType().getName();
            DynamicObject loadResult = BusinessDataServiceHelper.loadSingle((Object)pkv, (String)billEntity);
            String reseventcode = loadResult.getString(RESEVENTCODE);
            QFilter qFilter = new QFilter("billno", "=", (Object)reseventcode);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)TCTF_EVENT_MANAGEMENT, (String)"id", (QFilter[])new QFilter[]{qFilter});
            Long resId = dynamicObject.getLong("id");
            BillShowParameter param = new BillShowParameter();
            param.setFormId(TCTF_EVENT_MANAGEMENT);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setPkId((Object)resId);
            param.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

