/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.eventmanage;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tctrc.business.license.TctrcLicenseCheckBusiness;
import kd.taxc.tctrc.business.org.TctrcTaxorgCommonBusiness;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;

public class EventManagementList
extends AbstractListPlugin {
    private static final String SKSSQQ = "effectdate";
    private static final String SKSSQZ = "invaliddate";
    private static final String PUSH = "push";
    private static final String GLSCPUSH = "glscpush";
    private static final String UNAUDIT = "unaudit";
    private static final String TCTF_EVENT_MANAGE_HANDLER = "tctf_event_manage_handler";
    private static final String TCTF_EVENT_MANAGEMENT = "tctf_event_management";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        TaxResult orgidList = TctrcTaxorgCommonBusiness.getAllOrg();
        if (orgidList != null && orgidList.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)orgidList.getData()))) {
            qFilters.add(new QFilter("org.id", "in", orgidList.getData()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilters = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilters) {
            List orgIds;
            TaxResult listTaxResult;
            TaxResult orgFlag;
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("org.number") || (orgFlag = TctrcTaxorgCommonBusiness.isOrg((Long)RequestContext.get().getOrgId())).isSuccess() && !BooleanUtils.isFalse((Boolean)((Boolean)orgFlag.getData())) || (listTaxResult = TctrcTaxorgCommonBusiness.getAllOrg()) == null || !listTaxResult.isSuccess() || !CollectionUtils.isNotEmpty((Collection)(orgIds = (List)listTaxResult.getData()))) continue;
            filterColumn.setDefaultValues(new Object[]{((Long)orgIds.get(0)).toString()});
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        FormOperate operate = (FormOperate)args.getSource();
        if (PUSH.equals(operate.getOperateKey())) {
            Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (collect.size() > 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5904\u7406\u3002", (String)"EventManagement_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billEntity = billlist.getListModel().getDataEntityType().getName();
            DynamicObject loadResult = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)billEntity);
            String status = loadResult.getString("billstatus");
            if (!"C".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5355\u636e\u624d\u80fd\u5904\u7406\u3002", (String)"EventManagement_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            TctrcLicenseCheckBusiness.orgLicenseCheck((Long)loadResult.getLong("org.id"));
            DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)TCTF_EVENT_MANAGEMENT);
            String billno = result.getString("billno");
            QFilter qfilter = new QFilter("reseventcode", "=", (Object)billno);
            DynamicObject resload = BusinessDataServiceHelper.loadSingle((String)TCTF_EVENT_MANAGE_HANDLER, (String)"id,billstatus", (QFilter[])new QFilter[]{qfilter});
            if (resload != null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e8b\u4ef6\u7ba1\u7406\u6b63\u5728\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c\u3002", (String)"EventManagement_5", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
        } else if (GLSCPUSH.equals(operate.getOperateKey())) {
            Set collect = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (collect.size() > 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5173\u8054\u751f\u6210\u3002", (String)"EventManagement_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            String billEntity = billlist.getListModel().getDataEntityType().getName();
            DynamicObject loadResult = BusinessDataServiceHelper.loadSingle((Object)list.get(0).getPrimaryKeyValue(), (String)billEntity);
            String status = loadResult.getString("handlestatus");
            if (!"1".equals(status)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u5df2\u5904\u7406\u7684\u4e8b\u4ef6\u7ba1\u7406\u3002", (String)"EventManagement_4", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            TctrcLicenseCheckBusiness.orgLicenseCheck((Long)loadResult.getLong("org.id"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        long mainOrgId = currentSelectedRowInfo.getMainOrgId();
        if (!ObjectUtils.isNotEmpty((Object)mainOrgId)) {
            args.setCancel(true);
            return;
        }
        TctrcLicenseCheckBusiness.orgLicenseCheck((Long)mainOrgId);
        String fieldName = args.getFieldName();
        if ("changestatus".equals(fieldName)) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && "canceldone".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }
}

