/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.eventmanage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tctrc.business.org.TctrcTaxorgCommonBusiness;

public class EventManagementPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener(this::orgAddBeforeF7SelectListener);
    }

    private void orgAddBeforeF7SelectListener(BeforeF7SelectEvent beforeF7SelectEvent) {
        TctrcTaxorgCommonBusiness.fseven((BeforeF7SelectEvent)beforeF7SelectEvent, null, (String)"1");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("org".equals(evt.getProperty())) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("orgid".equals(name)) {
            int i = this.getModel().getEntryCurrentRowIndex("entryentity");
            ChangeData[] changeData = e.getChangeSet();
            DynamicObject newOrg = (DynamicObject)changeData[0].getNewValue();
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            orgIds.add(newOrg.getLong("id"));
            String taxpayer = this.queryTaxcOrgByOrgId(orgIds);
            this.getModel().setValue("taxpayername", (Object)taxpayer, i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        if (e.getEntryProp().getName().equals("entryentity") && (rowDataEntities = e.getRowDataEntities()) != null && rowDataEntities.length > 0) {
            int rowIndex = rowDataEntities[0].getRowIndex();
            this.getModel().setValue("orgid", this.getModel().getValue("org"), rowIndex);
            ArrayList<Long> orgIds = new ArrayList<Long>(16);
            orgIds.add(((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            String taxpayer = this.queryTaxcOrgByOrgId(orgIds);
            this.getModel().setValue("taxpayername", (Object)taxpayer, rowIndex);
        }
    }

    public String queryTaxcOrgByOrgId(List<Long> orgIds) {
        TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgIds);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            List dynamicList = (List)listTaxResult.getData();
            return ((DynamicObject)dynamicList.get(0)).getString("taxpayer");
        }
        return null;
    }
}

