/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tctrc.business.bos.BosUserBusiness;
import kd.taxc.tctrc.common.element.Element;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.RiskElementSqlService;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.enums.RiskHandlerEnum;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.CalUtils;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.OrgCheckUtil;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.biz.RiskDealUtil;
import org.apache.commons.collections.CollectionUtils;

@Deprecated
public abstract class AbstractResultPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    protected static final String ENTITY_RUN_RESULT = "tctrc_risk_run_result";
    private static final String ENTRY_RULE = "policies";
    private static final String RISK_TYPE_NUMBER = "1";
    private static final String CHECK_DETAIL_FLEX = "checkdetailflex";
    private static final String VECTOR_SHOW = "vectorap_show";
    private static final String CHECK_DETAIL_TAG = "checkdetailtag";
    private static final String CLOSE_DETAIL_FLEX = "closedetailflex";
    private static final String CLOSE_DETAIL_TAG = "closedetailtag";
    private static final String VECTOR_HIDE = "vectorap_hide";
    private static final String RISK_DESC_ALL = "riskdescall";
    private static final String KEY_VECTORAP1 = "vectorap1";
    private static final String RISK_LEVEL = "risklevel";
    private static final String WAIT_STATUS = "0";
    private static final String HANDLED_STATUS = "1";
    private static final String TRANSMIT_STATUS = "2";
    private int numResult = 0;
    protected static final String ELEMENT_DESC = "elementdesc";
    protected static final String ELEMENT_DESC_NO = AbstractResultPlugin.getNoExistMsg();
    private static final String KEY_ENTRY = "handles";
    private static final String UN_DO_CALL_BACK = "undocallback";
    private static final Map<String, String> RISK_LEVEL_MAP = new HashMap<String, String>(){
        {
            this.put("5", ResManager.loadKDString((String)"\u65e0\u98ce\u9669", (String)"AbstractResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            this.put("1", ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"AbstractResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            this.put(AbstractResultPlugin.TRANSMIT_STATUS, ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"AbstractResultPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            this.put("3", ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"AbstractResultPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            this.put("4", ResManager.loadKDString((String)"\u8ba1\u7b97\u9519\u8bef", (String)"AbstractResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
    };
    private static final Map<String, String> RISK_COLOR = new HashMap<String, String>(){
        {
            this.put(AbstractResultPlugin.WAIT_STATUS, "#e5e5e5");
            this.put("1", "#ff5656");
            this.put(AbstractResultPlugin.TRANSMIT_STATUS, "#ffcc66");
            this.put("3", "#00bf00");
        }
    };

    private static String getNoExistMsg() {
        return ResManager.loadKDString((String)"\u6682\u65e0\u63cf\u8ff0\u4fe1\u606f\u3002", (String)"AbstractResultPlugin_22", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    protected abstract void init(DynamicObject var1);

    protected LabelAp createLabelApNameTitle(String fieldid, String title) {
        LabelAp lable = LabelUtils.createLabel1((String)fieldid, (String)title, null);
        lable.setFontSize(14);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setTop("3px");
        padding.setBottom("3px");
        padding.setLeft("20px");
        padding.setRight("20px");
        style.setPadding(padding);
        lable.setStyle(style);
        lable.setForeColor("#212121");
        return lable;
    }

    protected LabelAp createLabelApTitle(String fieldid, String title) {
        LabelAp lable = LabelUtils.createLabel1((String)fieldid, (String)title, null);
        lable.setFontSize(14);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setTop("6px");
        padding.setBottom("6px");
        padding.setLeft("20px");
        padding.setRight("20px");
        style.setPadding(padding);
        lable.setStyle(style);
        lable.setForeColor("#212121");
        lable.setWidth(new LocaleString("1300px"));
        lable.setBackColor("#F5F5F5");
        return lable;
    }

    protected LabelAp createLabelAp(String fieldid, String title) {
        LabelAp lable = LabelUtils.createLabel((String)fieldid, (String)title, null);
        lable.setFontSize(16);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("5px");
        style.setMargin(margin);
        lable.setStyle(style);
        return lable;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        Vector vectorIcon = (Vector)this.getView().getControl(KEY_VECTORAP1);
        vectorIcon.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_RULE);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{CHECK_DETAIL_FLEX, VECTOR_SHOW, CHECK_DETAIL_TAG, CLOSE_DETAIL_FLEX, CLOSE_DETAIL_TAG, VECTOR_HIDE, "checkdetailflex1", "checkdetailtag1", "vectorap_show1", "closedetailflex1", "closedetailtag1", "vectorap_hide1", "handleview", "policydetail", "labelaptitle"});
    }

    public void afterCreateNewData(EventObject e) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object result = map.get("resultid");
        if (result == null) {
            return;
        }
        long resultId = (Long)result;
        DynamicObject riskRunResultDynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        DynamicObject person = riskRunResultDynamicObject.getDynamicObject("lastupdateby");
        this.getModel().setValue("lastupdatetime", (Object)DateUtils.formatHMS((Date)riskRunResultDynamicObject.getDate("runtime")));
        this.getModel().setValue("lastupdateby", null == person ? "" : person.get("name"));
        DynamicObject riskDefineDynamicObject = riskRunResultDynamicObject.getDynamicObject("risk");
        if (null != riskDefineDynamicObject) {
            this.getModel().setValue("number", (Object)riskDefineDynamicObject.getString("number"));
            this.getModel().setValue("numberid", (Object)riskDefineDynamicObject.getString("id"));
            this.getModel().setValue("name", (Object)riskDefineDynamicObject.getString("name"));
            DynamicObjectCollection taxtypedynamicObjects = riskDefineDynamicObject.getDynamicObjectCollection("taxtypemul");
            this.getModel().setValue("taxtypetext", (Object)taxtypedynamicObjects.stream().map(v -> v.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(";")));
            this.getModel().setValue("caltype", (Object)riskDefineDynamicObject.getString("caltype"));
            this.getModel().setValue("caltypetext", (Object)TimeDeviatedEnum.getMsgByDeviatedType((String)riskDefineDynamicObject.getString("caltype")));
            String riskType = riskDefineDynamicObject.getString("risktype");
            if ("1".equals(riskType)) {
                this.setBmValueLabel(riskRunResultDynamicObject, riskDefineDynamicObject);
            } else {
                this.displayRiskLevelPicture(riskRunResultDynamicObject);
            }
            this.displayPolicies(riskDefineDynamicObject);
            DynamicObjectCollection labelentity = riskDefineDynamicObject.getDynamicObjectCollection("labelentity");
            String labelids = labelentity.stream().map(l -> l.getDynamicObject("labelid").getString("id")).collect(Collectors.joining(","));
            this.getPageCache().put("labelids", labelids);
            this.refreshLabelEntity();
        }
        this.displayHandleStatus(riskRunResultDynamicObject);
        this.getModel().setValue("startdate", riskRunResultDynamicObject.get("startdate"));
        this.getModel().setValue("enddate", riskRunResultDynamicObject.get("enddate"));
        this.getModel().setValue("datestring", (Object)riskRunResultDynamicObject.getString("datestring"));
        this.getModel().setValue("runorg", (Object)riskRunResultDynamicObject.getDynamicObject("runorg"));
        this.getModel().setValue(RISK_DESC_ALL, (Object)riskRunResultDynamicObject.getString("riskdesc"));
        String riskLevel = riskRunResultDynamicObject.getString("rlevel.id");
        this.getModel().setValue(RISK_LEVEL, (Object)RISK_LEVEL_MAP.get(riskLevel));
        HashMap<String, String> colorMap = new HashMap<String, String>();
        String color = RISK_COLOR.get(riskLevel);
        colorMap.put("fc", color);
        colorMap.put("hoverClass", color);
        this.getView().updateControlMetadata(RISK_LEVEL, colorMap);
        this.init(riskRunResultDynamicObject);
    }

    public void displayHandleStatus(DynamicObject risk) {
        String handleStatus = risk.getString("status");
        String risklevel = risk.getString("rlevel.id");
        List<String> risklevels = Arrays.asList("5", "4");
        if (EmptyCheckUtils.isEmpty((Object)risklevel) || risklevels.contains(risklevel)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"waitstatus", "transmitting", "handled"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"handle", "transmit", "undo"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"recal"});
        } else if (WAIT_STATUS.equals(handleStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"waitstatus", "recal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"transmitting"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"handled", "undo"});
        } else if ("1".equals(handleStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"waitstatus"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"transmitting", "transmit", "handle", "recal"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"undo"});
        } else if (TRANSMIT_STATUS.equals(handleStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"waitstatus"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"transmitting", "undo", "recal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"handled"});
        }
    }

    public void displayPolicies(DynamicObject risk) {
        DynamicObjectCollection policies = risk.getDynamicObjectCollection(ENTRY_RULE);
        for (DynamicObject policy : policies) {
            int index = this.getModel().createNewEntryRow(ENTRY_RULE);
            this.getModel().setValue("policiesname", policy.get("policiesname"), index);
            this.getModel().setValue("policiesurl", policy.get("policiesurl"), index);
            this.getModel().setValue("policyarticles", (Object)policy.getString("policyarticles"), index);
        }
    }

    public void displayRiskLevelPicture(DynamicObject dynamicObject) {
        String riskLevel = RISK_LEVEL_MAP.get(dynamicObject.getString("rlevel.id"));
        String imageUrl = null;
        if (ResManager.loadKDString((String)"\u65e0\u98ce\u9669", (String)"AbstractResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_fxjbgw_223_223.png";
        } else if (ResManager.loadKDString((String)"\u9ad8\u98ce\u9669", (String)"AbstractResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_fxjbg_223_223.png";
        } else if (ResManager.loadKDString((String)"\u4e2d\u98ce\u9669", (String)"AbstractResultPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_fxjbgz_223_223.png";
        } else if (ResManager.loadKDString((String)"\u4f4e\u98ce\u9669", (String)"AbstractResultPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_fxjbgd_223_223.png";
        } else if (ResManager.loadKDString((String)"\u8ba1\u7b97\u9519\u8bef", (String)"AbstractResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_jccw_223_223.png";
        } else if (!ResManager.loadKDString((String)"\u65e0\u98ce\u9669", (String)"AbstractResultPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]).equals(riskLevel)) {
            imageUrl = "/images/pc/emotion/swy_fx5_223_223.png";
        }
        HashMap<String, String> imageUrlMap = new HashMap<String, String>();
        imageUrlMap.put("imageKey", imageUrl);
        this.getView().updateControlMetadata("riskimage", imageUrlMap);
    }

    public void setBmValueLabel(DynamicObject dynamicObject, DynamicObject risk) {
        Label bmValueLabel = (Label)this.getView().getControl("labelap6");
        BigDecimal bmValue = risk.getBigDecimal("bmvalue");
        if (bmValueLabel != null) {
            bmValueLabel.setText(new DecimalFormat("0.0000").format(bmValue));
        }
        Label valueLabel = (Label)this.getView().getControl("labelap4");
        String riskResultStr = dynamicObject.getString("result");
        BigDecimal riskResult = BigDecimalUtil.toBigDecimal((Object)riskResultStr);
        if (valueLabel != null && riskResultStr != null) {
            valueLabel.setText(new DecimalFormat("0.0000").format(riskResult));
        } else if (valueLabel != null && riskResultStr == null) {
            valueLabel.setText(null);
        }
        this.numResult = riskResult.compareTo(bmValue);
        this.getPageCache().put("numriskresulttype", String.valueOf(this.numResult));
    }

    private void refreshLabelEntity() {
        String labelids = this.getPageCache().get("labelids");
        if (StringUtils.isNotEmpty((CharSequence)labelids)) {
            String[] ids = labelids.split(",");
            this.getModel().deleteEntryData("labelentity");
            int h = ids.length;
            for (int i = 0; i < h; ++i) {
                int index = this.getModel().createNewEntryRow("labelentity");
                this.getModel().setValue("labelid", (Object)ids[i], index);
                this.setBackGroundColor(index);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelentity"});
        }
    }

    private void setBackGroundColor(int index) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>();
        String color = "#5F7FEB";
        if (index % 2 == 1) {
            color = "#2EC6C8";
        }
        propertiesMap.put("bc", color);
        pmap.put("cardentryflexpanelap14", propertiesMap);
        ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        client.invokeControlMethod("labelentity", "setCustomProperties", new Object[]{index, pmap});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (StringUtils.equals((CharSequence)sourceKey, (CharSequence)KEY_VECTORAP1)) {
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY, index);
            QFilter filters = new QFilter("id", "=", (Object)Long.parseLong(entryRowEntity.getString("creatorid")));
            DynamicObject[] dobjs = BosUserBusiness.getUserDataByConditions((QFilter)filters);
            String openId = dobjs[0].getString("useropenid");
            HashMap<String, String> mData = new HashMap<String, String>();
            mData.put("oid", openId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("chatToYZJ_PC", mData);
        } else if (StringUtils.equals((CharSequence)sourceKey, (CharSequence)"handleview")) {
            HashMap<String, String> customMap = new HashMap<String, String>();
            int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY, index);
            customMap.put("id", entryRowEntity.getString("handleid"));
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_handle_history", (IFormView)this.getView(), customMap, (IFormPlugin)this);
        } else if (StringUtils.equals((CharSequence)sourceKey, (CharSequence)"policydetail")) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_RULE);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_RULE, index);
            String msg = entryRowEntity.getString("policyarticles");
            String caption = String.format(ResManager.loadKDString((String)"\u4f9d\u636e%s", (String)"AbstractResultPlugin_18", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), entryRowEntity.getString("policiesname"));
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tctrc_policy_dialog");
            param.setCaption(caption);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("msg", (Object)msg);
            this.getView().showForm(param);
        } else if (StringUtils.equals((CharSequence)sourceKey, (CharSequence)"labelaptitle")) {
            String msg = (String)this.getModel().getValue(RISK_DESC_ALL);
            String caption = ResManager.loadKDString((String)"\u98ce\u9669\u63d0\u793a", (String)"AbstractResultPlugin_19", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tctrc_policy_dialog");
            param.setCaption(caption);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("msg", (Object)msg);
            this.getView().showForm(param);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("donothingrecal".equals(args.getOperateKey())) {
                this.reCal();
            } else if ("donothingundo".equals(args.getOperateKey())) {
                this.undo();
            } else if ("donothingnormal".equals(args.getOperateKey()) || "donothingrisk".equals(args.getOperateKey()) || "donothingtransmit".equals(args.getOperateKey()) || "donothingguide".equals(args.getOperateKey())) {
                String typeKey = args.getOperateKey().substring(9);
                RiskHandlerEnum riskHandlerEnum = RiskHandlerEnum.getEnumByCode((String)typeKey);
                this.openHandler(riskHandlerEnum);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (evt.getItemKey().equals(RiskHandlerEnum.HISTORY.getCode())) {
            RiskHandlerEnum riskHandlerEnum = RiskHandlerEnum.getEnumByCode((String)evt.getItemKey());
            this.openHandler(riskHandlerEnum);
        } else if ("refresh".equals(key)) {
            this.refresh();
        }
    }

    private void reCal() {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        Object result = customMap.get("resultid");
        QFilter qFilter = new QFilter("id", "=", result);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit,runorg,startdate,enddate,lastupdateby,runtime,rlevel,riskscore,riskdesc,result,isdenominatorzero,isemptyfield,dealresult,json,datestring,caltype", (QFilter[])new QFilter[]{qFilter});
        if (null == collection || collection.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"AbstractResultPlugin_23", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (OrgCheckUtil.checkById((IFormView)this.getView(), (String)collection[0].getString("runorg.id"), (String)"tctrc", (String)"tctrc_risk_run_list")) {
            return;
        }
        long resultId = (Long)result;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        Map<String, Object> olderResultMap = this.getOlderResultMap(dynamicObject);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctrc_handle_entity");
        DynamicObject riskHandleDynmicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        riskHandleDynmicObject.set("result", (Object)4);
        riskHandleDynmicObject.set("riskresult", "null".equals(olderResultMap.get("json")) ? this.getFormatNoValueString() : olderResultMap.get("json"));
        riskHandleDynmicObject.set("type", (Object)"rgcl");
        riskHandleDynmicObject.set("time", (Object)new Date());
        riskHandleDynmicObject.set("handler", (Object)RequestContext.get().getUserId());
        riskHandleDynmicObject.set("resultid", result);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskHandleDynmicObject});
        for (DynamicObject resultObj : collection) {
            DynamicObject risk = resultObj.getDynamicObject("risk");
            String enable = risk.getString("enable");
            if (!enable.equalsIgnoreCase(BooleanEnum.YES.getCode())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"AbstractResultPlugin_23", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
                return;
            }
            String risknumber = risk.getString("number");
            String risktype = risk.getString("risktype");
            String orgid = resultObj.getString("runorg.id");
            String startdate = resultObj.getString("startdate");
            String enddate = resultObj.getString("enddate");
            this.setDateStrByCalTypeSingle(resultObj, startdate, enddate);
            Map map = RiskCalSerivce.calRisk((String)String.valueOf(result), (Map)ElementSqlService.queryAllEnableEleInfoMap(), (String)risktype, (String)orgid, (String)risknumber, (String)startdate, (String)startdate, (String)enddate);
            resultObj.set("json", map.get("json"));
            resultObj.set("lastupdateby", (Object)RequestContext.get().getUserId());
            resultObj.set("runtime", (Object)new Date());
            resultObj.set("rlevel", map.get(RISK_LEVEL));
            resultObj.set("riskscore", map.get("riskscore"));
            resultObj.set("riskdesc", map.get("riskdesc"));
            resultObj.set("result", map.get("result"));
            if ("true".equals(map.get("isDenominatorZero"))) {
                resultObj.set("isdenominatorzero", (Object)Boolean.TRUE);
                resultObj.set("rlevel", (Object)"4");
                resultObj.set("riskdesc", (Object)"");
            } else {
                resultObj.set("isdenominatorzero", (Object)Boolean.FALSE);
            }
            if ("true".equals(map.get("isEmptyField"))) {
                resultObj.set("isemptyfield", (Object)Boolean.TRUE);
                resultObj.set("rlevel", (Object)"4");
                resultObj.set("riskdesc", (Object)"");
            } else {
                resultObj.set("isemptyfield", (Object)Boolean.FALSE);
            }
            List filterFieldValueList = ListUtils.stringToList((String)((String)map.get("filterFieldValueList")));
            if (filterFieldValueList != null) {
                for (String filterFieldValue : filterFieldValueList) {
                    if (!StringUtils.isEmpty((CharSequence)filterFieldValue)) continue;
                    resultObj.set("isemptyfield", (Object)Boolean.TRUE);
                    break;
                }
            }
            if (!DealStatusEnum.CHANING.getCode().equalsIgnoreCase(resultObj.getString("status"))) {
                resultObj.set("status", (Object)DealStatusEnum.TO_DO.getCode());
            }
            resultObj.set("dealresult", (Object)"1");
        }
        SaveServiceHelper.save((DynamicObject[])collection);
        this.refresh();
    }

    public void setDateStrByCalTypeSingle(DynamicObject resultObj, String startdate, String enddate) {
        String caltype = resultObj.getString("caltype");
        Date startdatedate = DateUtils.stringToDate((String)startdate);
        Date enddatedate = DateUtils.stringToDate((String)enddate);
        List dateList = CalUtils.getCalDate((String)caltype, (Date)startdatedate, (Date)enddatedate);
        for (Map dateMap : dateList) {
            RiskService.setDateStrByCalType((String)caltype, (Map)dateMap, (DynamicObject)resultObj);
        }
    }

    private void undo() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object result = map.get("resultid");
        QFilter qFilter = new QFilter("id", "=", result);
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit", (QFilter[])new QFilter[]{qFilter});
        if (null == collection || collection.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : collection) {
            RiskDealUtil.undoCheck((DynamicObject)dynamicObject);
            dynamicObject.set("status", (Object)DealStatusEnum.TO_DO.getCode());
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(UN_DO_CALL_BACK, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d6\u6d88\u5904\u7406\u201d\u540e\u7684\u98ce\u9669\u6570\u636e\u53ef\u4ee5\u91cd\u65b0\u5f55\u5165\u5904\u7406\u6307\u5f15\u4e5f\u53ef\u4ee5\u91cd\u65b0\u8ba1\u7b97\uff0c\u786e\u5b9a\u7ee7\u7eed\u53d6\u6d88\u5417\uff1f", (String)"AbstractResultPlugin_24", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (UN_DO_CALL_BACK.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Object result = map.get("resultid");
            QFilter qFilter = new QFilter("id", "=", result);
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"id,risk,status,transmit", (QFilter[])new QFilter[]{qFilter});
            if (null == collection || collection.length == 0) {
                return;
            }
            for (DynamicObject dynamicObject : collection) {
                dynamicObject.set("status", (Object)DealStatusEnum.TO_DO.getCode());
            }
            SaveServiceHelper.save((DynamicObject[])collection);
            Object[] arr = new Object[]{result};
            AbstractResultPlugin.cancelundo(arr);
            this.refresh();
        }
    }

    public static void cancelundo(Object[] ids) {
        long userId = RequestContext.get().getCurrUserId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(5);
        DynamicObjectCollection dynamicObjectsResult = QueryServiceHelper.query((String)ENTITY_RUN_RESULT, (String)"id,json,result,risk.risktype", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList(ids))});
        Map<Long, List<DynamicObject>> orgmainMap = dynamicObjectsResult.stream().collect(Collectors.groupingBy(s -> s.getLong("id")));
        for (Object obj : ids) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_handle_entity");
            dynamicObject.set("handler", (Object)userId);
            dynamicObject.set("result", (Object)"5");
            dynamicObject.set("time", (Object)new Date());
            dynamicObject.set("resultid", obj);
            dynamicObject.set("type", (Object)"rgcl");
            long resultId = (Long)obj;
            if (orgmainMap.containsKey(resultId)) {
                String riskType = orgmainMap.get(resultId).get(0).getString("risk.risktype");
                if ("1".equals(riskType)) {
                    dynamicObject.set("riskresult", orgmainMap.get(resultId).get(0).get("result"));
                } else {
                    dynamicObject.set("riskresult", orgmainMap.get(resultId).get(0).get("json"));
                }
            }
            list.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public void openHandler(RiskHandlerEnum riskHandlerEnum) {
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object result = map.get("resultid");
        customMap.put("resultid", result);
        long resultId = (Long)result;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        RiskDealUtil.checkRecord((DynamicObject)dynamicObject, (RiskHandlerEnum)riskHandlerEnum);
        customMap.putAll(this.getOlderResultMap(dynamicObject));
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)riskHandlerEnum.getFormId(), (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    private Map<String, Object> getOlderResultMap(DynamicObject dynamicObject) {
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        DynamicObject risk = dynamicObject.getDynamicObject("risk");
        if (null != risk) {
            String riskType = risk.getString("risktype");
            if ("1".equals(riskType)) {
                BigDecimal bmValue = BigDecimalUtil.toBigDecimal((Object)this.getView().getModel().getValue("bmvalue"));
                String resultshow = dynamicObject.getDynamicObject("risk").getString("resultshow");
                if (TRANSMIT_STATUS.equals(resultshow)) {
                    bmValue = BigDecimalUtil.divideObject((Object)bmValue, (Object)100, (int)2);
                }
                BigDecimal riskResult = BigDecimalUtil.toBigDecimal((Object)dynamicObject.getString("result"));
                this.numResult = riskResult.compareTo(bmValue);
                customMap.put("numriskresulttype", String.valueOf(this.numResult));
                customMap.put("json", dynamicObject.getString("result"));
            } else {
                customMap.put("json", dynamicObject.getString("json"));
            }
            customMap.put("runorg", dynamicObject.getLong("runorg.id"));
        }
        return customMap;
    }

    private void refresh() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object resultId = map.get("resultid");
        QFilter filter = new QFilter("id", "=", resultId);
        DynamicObject result = QueryServiceHelper.queryOne((String)ENTITY_RUN_RESULT, (String)"risk.risktype,risk.id,runorg.id,risk.name", (QFilter[])new QFilter[]{filter});
        FormShowParameter param = new FormShowParameter();
        String mainPageId = (String)map.get("mainPageId");
        HashMap customParams = new HashMap(4);
        String risktype = result.getString("risk.risktype");
        if ("1".equals(risktype)) {
            param.setFormId("tctrc_resultview_number");
        } else if (TRANSMIT_STATUS.equals(risktype)) {
            param.setFormId("tctrc_resultview_sampling");
        } else {
            param.setFormId("tctrc_resultview_verify");
        }
        param.setPageId(mainPageId);
        customParams.put("resultid", resultId);
        Long numberId = result.getLong("risk.id");
        String orgid = result.getString("runorg.id");
        String riskname = result.getString("risk.name");
        String userId = RequestContext.get().getUserId();
        customParams.put("user", String.valueOf(userId));
        customParams.put("number", numberId);
        customParams.put("datasource", WAIT_STATUS);
        customParams.put("orgid", orgid);
        customParams.put("riskname", riskname);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
        this.getView().invokeOperation("refresh");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap mapr;
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        List<String> actionids = Arrays.asList("tctrc_risk_normal", "tctrc_risk_transmit", "tctrc_risk_risk", "tctrc_risk_evaluation", "tctrc_handle_riskresult", "tctrc_risk_guide");
        if (actionids.contains(actionId) && null != (returnData = closedCallBackEvent.getReturnData()) && (mapr = (HashMap)returnData).get("submited") != null) {
            this.getView().updateView();
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Object result = map.get("resultid");
            if (result == null) {
                return;
            }
            long resultId = (Long)result;
            DynamicObject riskResultDynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
            this.init(riskResultDynamicObject);
            this.displayHandleStatus(riskResultDynamicObject);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String policiesurl = (String)this.getModel().getValue("policiesurl", rowIndex);
        this.getView().openUrl(policiesurl);
    }

    public void initChart(Map<String, List> datas, String name, String control, boolean isRateDisplay) {
        BigDecimal[] values;
        PointLineChart chart = (PointLineChart)this.getControl(control);
        chart.clearData();
        List resultList = datas.get("result");
        List periodList = datas.get("period");
        List isEmptyFieldList = datas.get("isEmptyField");
        List<String> periodsNewList = new ArrayList();
        if (isEmptyFieldList != null) {
            for (int i = 0; i < isEmptyFieldList.size(); ++i) {
                if ("true".equals(isEmptyFieldList.get(i))) {
                    periodsNewList.add((String)periodList.get(i) + " " + this.getFormatNoValueString());
                    continue;
                }
                periodsNewList.add((String)periodList.get(i));
            }
        } else {
            periodsNewList = periodList;
        }
        if (isRateDisplay) {
            LinkedList<BigDecimal> results = new LinkedList<BigDecimal>();
            for (BigDecimal val : resultList) {
                results.add(val.multiply(new BigDecimal("100")));
            }
            values = results.toArray(new BigDecimal[resultList.size()]);
        } else {
            values = resultList.stream().map(b -> b.setScale(4, 4)).collect(Collectors.toList()).toArray(new BigDecimal[resultList.size()]);
        }
        this.createCategoryAxis((Chart)chart, false, isRateDisplay);
        LineSeries lineSeries1 = this.createLineSeries((Chart)chart, "", values);
        lineSeries1.setSmooth(true);
        Axis xAxis = this.createCategoryAxis((Chart)chart, true, isRateDisplay);
        xAxis.setCategorys(periodsNewList);
        chart.setMargin(Position.left, "20");
        chart.setMargin(Position.right, "20");
        chart.setName(new LocaleString(name));
        chart.setTitleAlign(XAlign.center, YAlign.top);
        chart.setShowTooltip(true);
        chart.refresh();
    }

    private LineSeries createLineSeries(Chart chart, String name, BigDecimal[] values) {
        LineSeries series = chart.createLineSeries(name);
        series.setData((Number[])values);
        series.setSmooth(true);
        series.setItemColor("#3F83F2");
        series.setLineColor("#3F83F2");
        series.setColor("#73DCDD");
        return series;
    }

    private Axis createCategoryAxis(Chart chart, boolean isX, boolean isRateType) {
        Axis axis = null;
        String yAxisName = isRateType ? " % " : "";
        axis = isX ? chart.createXAxis("", AxisType.category) : chart.createYAxis(yAxisName, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    public Map<String, List> getElementsByPeriod(long runOrg, String elementCode, String calType, Date startDate, Date endDate, int diffMonth) {
        RiskElementSqlService elementSqlService = new RiskElementSqlService();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList periodsList = new ArrayList();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>();
        ArrayList<String> isEmptyFieldList = new ArrayList<String>();
        HashMap<String, List> mapResult = new HashMap<String, List>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType)) {
            calendar.add(2, -12);
            for (int i = 0; i < 12; ++i) {
                calendar.add(2, 1);
                if (i == 0) {
                    String string = DateUtils.format((Date)calendar.getTime());
                }
                Iterator date = calendar.getTime();
                Date deviationDate = DateUtils.addMonth((Date)((Object)date), (int)(-diffMonth));
                String dd = DateUtils.formatMonth((Date)deviationDate);
                String startDate1 = DateUtils.format((Date)deviationDate);
                String endDate1 = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)deviationDate));
                periodList.add(dd);
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", startDate1);
                map1.put("endDate", endDate1);
                periodsList.add(map1);
            }
            List list = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, periodsList);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                HashMap<String, String> isEmptyFieldMap = new HashMap<String, String>(16);
                for (Element element : list) {
                    String key = DateUtils.format((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)element.getStartData()), (int)(-diffMonth)), (String)"yyyy-MM");
                    String value = element.getValue();
                    String isEmptyField = element.getIsEmptyField();
                    map.put(key, value);
                    isEmptyFieldMap.put(key, isEmptyField);
                }
                for (String s : periodList) {
                    String str = (String)map.get(s);
                    String isEmptyField = (String)isEmptyFieldMap.get(s);
                    if (str != null) {
                        resultList.add(BigDecimalUtil.toBigDecimal((Object)str).setScale(4, 4));
                    } else {
                        resultList.add(BigDecimalUtil.toBigDecimal((Object)0));
                    }
                    isEmptyFieldList.add(isEmptyField);
                }
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType)) {
            HashMap<String, String> quarterStr = new HashMap<String, String>(){
                {
                    this.put("01", "Q1");
                    this.put("02", "Q1");
                    this.put("03", "Q1");
                    this.put("04", "Q2");
                    this.put("05", "Q2");
                    this.put("06", "Q2");
                    this.put("07", "Q3");
                    this.put("08", "Q3");
                    this.put("09", "Q3");
                    this.put("10", "Q4");
                    this.put("11", "Q4");
                    this.put("12", "Q4");
                }
            };
            calendar.add(2, -9);
            for (int i = 0; i < 4; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(2, 3);
                String end = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                String month = timeStr[1];
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                end = DateUtils.getLastDateOfMonthStr((Date)DateUtils.stringToDate((String)end), (String)"yyyy-MM-dd");
                map1.put("endDate", end);
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                periodList.add(year + "-" + (String)quarterStr.get(month));
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equalsIgnoreCase(calType)) {
            calendar.add(2, -6);
            for (int i = 0; i < 2; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(2, 6);
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                map1.put("endDate", DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1))));
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                String half = Integer.parseInt(timeStr[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"AbstractResultPlugin_20", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"AbstractResultPlugin_21", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"AbstractResultPlugin_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year + half));
            }
        } else {
            calendar.add(1, -1);
            for (int i = 0; i < 2; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(1, 1);
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                map1.put("endDate", DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1))));
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"AbstractResultPlugin_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year));
            }
        }
        mapResult.put("isEmptyField", isEmptyFieldList);
        mapResult.put("period", periodList);
        mapResult.put("result", resultList);
        return mapResult;
    }

    public void beforeBindData(EventObject e) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRY);
        CardEntry cardEntry = (CardEntry)this.getControl(KEY_ENTRY);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long resultId = (Long)customParams.get("resultid");
        QFilter q = new QFilter("resultid", "=", (Object)String.valueOf(resultId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tctrc_handle_entity", (String)"id", (QFilter[])new QFilter[]{q}, (String)"time desc", (int)8);
        if (dynamicObjects.isEmpty()) {
            return;
        }
        Long[] pkIdArr = new Long[dynamicObjects.size()];
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            pkIdArr[i] = ((DynamicObject)dynamicObjects.get(i)).getLong("id");
        }
        String fields = "id,handler,result,time,type,entryentity.suggestion,transmit";
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((String)"tctrc_handle_entity", (String)fields, (QFilter[])new QFilter[]{q}, (String)"time desc", (int)8);
        for (int ii = 0; ii < dObjects.length; ++ii) {
            String desc;
            DynamicObject handler = dObjects[ii].getDynamicObject("handler");
            DynamicObject transmit = dObjects[ii].getDynamicObject("transmit");
            if (handler == null) continue;
            DynamicObject creator = BosUserBusiness.getBosUserCache((Long)handler.getLong("id"));
            String transmitStr = null;
            if (null != transmit) {
                transmitStr = transmit.getString("name");
            }
            int i = this.getModel().createNewEntryRow(KEY_ENTRY);
            if (!ObjectUtils.isEmpty((Object)creator.get("picturefield"))) {
                model.setValue("picturefield", (Object)creator.getString("picturefield"), i);
            }
            String descStr = TRANSMIT_STATUS.equals(desc = dObjects[ii].getString("result")) ? ResManager.loadKDString((String)"\u5904\u7406\u6210\u6b63\u5e38\u72b6\u6001", (String)"AbstractResultPlugin_13", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ("3".equals(desc) ? ResManager.loadKDString((String)"\u5904\u7406\u6210\u98ce\u9669\u72b6\u6001", (String)"AbstractResultPlugin_14", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ("4".equals(desc) ? ResManager.loadKDString((String)"\u91cd\u65b0\u8fd0\u884c\u98ce\u9669", (String)"AbstractResultPlugin_25", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ("5".equals(desc) ? ResManager.loadKDString((String)"\u53d6\u6d88\u5904\u7406", (String)"AbstractResultPlugin_30", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : (EmptyCheckUtils.isEmpty((Object)desc) && EmptyCheckUtils.isNotEmpty((Object)transmitStr) ? String.format(ResManager.loadKDString((String)"\u8f6c\u4ea4\u7ed9%s\u5904\u7406", (String)"AbstractResultPlugin_26", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), transmitStr) : ResManager.loadKDString((String)"\u5904\u7406\u4e86\u98ce\u9669", (String)"AbstractResultPlugin_15", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])))));
            model.setValue("handleid", (Object)dObjects[ii].getString("id"), i);
            model.setValue("creatorid", (Object)creator.getString("id"), i);
            model.setValue("createname", (Object)creator.getString("name"), i);
            model.setValue("createtime", (Object)DateUtils.formatHMS((Date)dObjects[ii].getDate("time")), i);
            DynamicObjectCollection entryentity = dObjects[ii].getDynamicObjectCollection("entryentity");
            String type = dObjects[ii].getString("type");
            model.setValue("handletype", (Object)type, i);
            if ("sdjs".equals(type)) {
                if (entryentity.size() <= 0) continue;
                model.setValue("desc", (Object)((DynamicObject)entryentity.get(0)).getString("suggestion"), i);
                continue;
            }
            if (!"rgcl".equals(type)) continue;
            model.setValue("desc", (Object)descStr, i);
        }
        cardEntry.setChildVisible(false, 0, new String[]{"line"});
        cardEntry.setChildVisible(false, 0, new String[]{"gapline"});
        cardEntry.setChildVisible(false, 9, new String[]{"lastline"});
        cardEntry.setChildVisible(false, 9, new String[]{"line2"});
    }

    protected String createElementLableKey(Formula formula, int index, boolean isBottom) {
        boolean isElement = formula.getType().equals("1");
        String prefix = "label_&";
        prefix = isBottom ? prefix + "bottom_&" : prefix + "bottomno_&";
        if (isElement) {
            prefix = prefix + formula.getCode() + "_&";
        }
        prefix = prefix + index;
        return prefix;
    }

    protected void doClearOldControl(Container container, String cacheKeys) {
        String keys = this.getPageCache().get(cacheKeys);
        if (StringUtils.isNotEmpty((CharSequence)keys)) {
            for (String key : keys.split(",")) {
                container.deleteControls(new String[]{key});
            }
        }
    }

    protected LabelAp createLabel(String key, String text, String value, boolean clickable) {
        LabelAp stageLabelAp = new LabelAp();
        stageLabelAp.setId(key);
        stageLabelAp.setKey(key);
        stageLabelAp.setAlignSelf("center");
        stageLabelAp.setTextAlign("center");
        Style style = new Style();
        if (clickable) {
            stageLabelAp.setName(new LocaleString(text + "\r\n" + value));
            stageLabelAp.setForeColor("#5E80EB");
            stageLabelAp.setClickable(true);
            stageLabelAp.setFontSize(12);
            Border border = new Border();
            border.setBottom("1px solid #5582F3");
            border.setLeft("1px solid #5582F3");
            border.setRight("1px solid #5582F3");
            border.setTop("1px solid #5582F3");
            style.setBorder(border);
            Padding padding = new Padding();
            padding.setTop("3px");
            padding.setBottom("3px");
            padding.setLeft("10px");
            padding.setRight("10px");
            style.setPadding(padding);
            Margin margin = new Margin();
            margin.setLeft("3px");
            margin.setRight("3px");
            margin.setBottom("10px");
            style.setMargin(margin);
            stageLabelAp.setRadius("4px");
            stageLabelAp.setStyle(style);
        } else {
            stageLabelAp.setName(new LocaleString(text));
            Margin margin = new Margin();
            margin.setLeft("3px");
            margin.setRight("3px");
            margin.setBottom("10px");
            style.setMargin(margin);
            stageLabelAp.setStyle(style);
        }
        return stageLabelAp;
    }

    protected String getFormatNoValueString() {
        return ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"AbstractResultPlugin_28", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    protected String getCalNoValueMessage() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u5468\u671f\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractResultPlugin_29", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    protected void showMessage(IFormView view) {
        this.showMessage(view, this.getCalNoValueMessage());
    }

    protected void showMessage(IFormView view, String message) {
        if (EmptyCheckUtils.isNotEmpty((Object)view)) {
            view.showTipNotification(message);
        }
    }
}

