/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.business.tctrc.TctrcRiskEvaluationBusiness;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.enums.BooleanEnum;
import kd.taxc.tctrc.common.enums.DealStatusEnum;
import kd.taxc.tctrc.common.enums.ProcessStateEnum;
import kd.taxc.tctrc.common.enums.RiskHandleResultEnum;
import kd.taxc.tctrc.common.enums.RiskHandlerEnum;
import kd.taxc.tctrc.common.enums.RiskResultLevelEnum;
import kd.taxc.tctrc.common.enums.RiskResultStatusEnum;
import kd.taxc.tctrc.common.enums.RiskTypeEnum;
import kd.taxc.tctrc.common.task.RiskService;
import kd.taxc.tctrc.common.util.CalUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.ListUtils;
import kd.taxc.tctrc.common.util.OrgCheckUtil;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.common.util.biz.RiskDealUtil;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractRiskResultDetailPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SetFilterListener {
    protected static final String FIELD_RISK_NAME_KEY = "riskname";
    protected static final String FIELD_ORG_NAME_KEY = "orgname";
    protected static final String FIELD_PERIOD_KEY = "period";
    protected static final String FIELD_TAX_TYPE_NAME_KEY = "taxtypename";
    protected static final String FIELD_CALCULATE_CYCLE_KEY = "calcycle";
    protected static final String FIELD_RISK_NUMBER_KEY = "number";
    protected static final String FIELD_MODIFY_TIME_KEY = "mofifytime";
    protected static final String FIELD_RISK_LEVEL_KEY = "risklevel";
    protected static final String FIELD_RISK_DESC_KEY = "riskdescall";
    protected static final String LABEL_WAIT_STATUS_KEY = "waitstatus";
    protected static final String LABEL_HANDLED_STATUS_KEY = "handled";
    protected static final String LABEL_TRANSMITTING_STATUS_KEY = "transmitting";
    protected static final String LABEL_COLLECTED_STATUS_KEY = "collected";
    protected static final String BTN_EVALUATE_KEY = "evaluate";
    protected static final String BTN_COLLECT_KEY = "collect";
    protected static final String BTN_MY_COLLECT_KEY = "mycollect";
    protected static final String BTN_CANCEL_COLLECT_KEY = "uncollect";
    protected static final String BTN_TRANSMIT_KEY = "transmit";
    protected static final String BTN_RECALCULATE_KEY = "recal";
    protected static final String BTN_HANDLE_KEY = "handle";
    protected static final String BTN_CANCEL_HANDLE_KEY = "undo";
    protected static final String BTN_REFRESH_KEY = "refresh";
    protected static final String BTN_HANDLE_RESULT_LIST_KEY = "handleresultlist";
    protected static final String IMAGE_RISK_IMAGE_KEY = "riskimage";
    protected static final String ENTRY_POLICIES_KEY = "policies";
    protected static final String CACHE_RESULT_ID_KEY = "resultid";
    protected static final String CACHE_LABEL_ID_KEY = "labelKey";

    public void afterCreateNewData(EventObject eventObject) {
        Long resultId = this.getResultId();
        if (resultId == null) {
            return;
        }
        this.getPageCache().put(CACHE_RESULT_ID_KEY, resultId.toString());
        this.initData(resultId);
        BillList billListAp = (BillList)this.getControl("billlistap");
        billListAp.addSetFilterListener((SetFilterListener)this);
    }

    protected Long getResultId() {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        Object result = map.get(CACHE_RESULT_ID_KEY);
        if (result == null) {
            return null;
        }
        return (Long)result;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_POLICIES_KEY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"policydetail", "labelaptitle"});
    }

    private void initData(Long resultId) {
        DynamicObject riskResultObject = this.getRiskResultDynamicObject(resultId);
        this.initImage();
        this.initLabel(riskResultObject);
        this.initCommonContent(riskResultObject);
        this.initOtherBizContent(riskResultObject);
    }

    private void initImage() {
        this.updateImageControlImageUrl("indeximg", "/kingdee/taxc/images/pc/riskresult/title_3.png");
        this.updateImageControlImageUrl("orgimg", "/kingdee/taxc/images/pc/riskresult/company_3.png");
        this.updateImageControlImageUrl("dateimg", "/kingdee/taxc/images/pc/riskresult/date_3.png");
        this.updateImageControlImageUrl("taxtypeimg", "/kingdee/taxc/images/pc/riskresult/taxtype_3.png");
        this.updateImageControlImageUrl("policyimg", "/kingdee/taxc/images/pc/riskresult/policy_3.png");
    }

    private void initLabel(DynamicObject riskResultObject) {
        DynamicObjectCollection labelObjectCollection = riskResultObject.getDynamicObject("risk").getDynamicObjectCollection("labelentity");
        ArrayList<Map> items = new ArrayList<Map>();
        StringJoiner joiner = new StringJoiner(",");
        for (DynamicObject label : labelObjectCollection) {
            joiner.add(label.getString("id"));
            LabelAp labelAp = LabelUtils.createLabelAp((String)label.getString("id"), (String)label.getDynamicObject("labelid").getString("name"), (Integer)12, (String)"#002273", (String)"#DBEDFF", (String)"400");
            Style labelStyle = new Style();
            LabelUtils.setPadding((Style)labelStyle, (String)"", (String)"", (String)"5px", (String)"5px");
            LabelUtils.setBorder((Style)labelStyle, (String)"1px solid #DBEDFF");
            LabelUtils.setMargin((Style)labelStyle, (String)"", (String)"", (String)"", (String)"12px");
            labelAp.setStyle(labelStyle);
            labelAp.setRadius("10px");
            items.add(labelAp.createControl());
        }
        Container container = (Container)this.getView().getControl("flexpanelap1");
        String labelId = this.getPageCache().get(CACHE_LABEL_ID_KEY);
        if (StringUtils.isNotEmpty((CharSequence)labelId)) {
            container.deleteControls(labelId.split(","));
        }
        this.getPageCache().put(CACHE_LABEL_ID_KEY, joiner.toString());
        container.addControls(items);
    }

    private void initCommonContent(DynamicObject riskResultObject) {
        IDataModel model = this.getModel();
        model.setValue(FIELD_MODIFY_TIME_KEY, (Object)DateUtils.format((Date)riskResultObject.getDate("runtime"), (String)"yyyy-MM-dd HH:mm:ss"));
        model.setValue(FIELD_PERIOD_KEY, (Object)riskResultObject.getString("datestring"));
        model.setValue(FIELD_ORG_NAME_KEY, (Object)riskResultObject.getString("runorg.name"));
        String riskLevelId = riskResultObject.getString("rlevel.id");
        RiskResultLevelEnum riskResultLevelEnum = RiskResultLevelEnum.getEnumByCode((String)riskLevelId);
        String riskLevel = riskResultLevelEnum == RiskResultLevelEnum.CUSTOM_RISK ? riskResultObject.getString("rlevel.name") : riskResultLevelEnum.getName().getDescription();
        model.setValue(FIELD_RISK_LEVEL_KEY, (Object)riskLevel);
        this.updateImageControlImageUrl(IMAGE_RISK_IMAGE_KEY, riskResultLevelEnum.getImageUrl());
        model.setValue(FIELD_RISK_DESC_KEY, (Object)riskResultObject.getString("riskdesc"));
        DynamicObject riskObject = riskResultObject.getDynamicObject("risk");
        if (riskObject != null) {
            model.setValue(FIELD_RISK_NAME_KEY, (Object)riskObject.getString("name"));
            DynamicObjectCollection taxTypes = riskObject.getDynamicObjectCollection("taxtypemul");
            model.setValue(FIELD_TAX_TYPE_NAME_KEY, (Object)taxTypes.stream().map(v -> v.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.joining(";")));
            model.setValue(FIELD_RISK_NUMBER_KEY, (Object)riskObject.getString(FIELD_RISK_NUMBER_KEY));
            model.setValue(FIELD_CALCULATE_CYCLE_KEY, (Object)TimeDeviatedEnum.getMsgByDeviatedType((String)riskObject.getString("caltype")));
            this.initPolicies(riskObject);
        }
        String handleStatus = riskResultObject.getString("status");
        List<String> riskLevelIds = Arrays.asList(RiskResultLevelEnum.CALCULATE_ERROR.getCode(), RiskResultLevelEnum.NON_RISK.getCode());
        if (EmptyCheckUtils.isEmpty((Object)riskLevelId) || riskLevelIds.contains(riskLevelId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_WAIT_STATUS_KEY, LABEL_TRANSMITTING_STATUS_KEY, LABEL_HANDLED_STATUS_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_HANDLE_KEY, BTN_TRANSMIT_KEY, BTN_CANCEL_HANDLE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_RECALCULATE_KEY});
        } else if (RiskResultStatusEnum.WAIT_HANDLE.getCode().equals(handleStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_WAIT_STATUS_KEY, BTN_RECALCULATE_KEY, BTN_HANDLE_KEY, BTN_TRANSMIT_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_TRANSMITTING_STATUS_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_HANDLED_STATUS_KEY, BTN_CANCEL_HANDLE_KEY});
        } else if (RiskResultStatusEnum.HANDLED.getCode().equals(handleStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_WAIT_STATUS_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_TRANSMITTING_STATUS_KEY, BTN_TRANSMIT_KEY, BTN_HANDLE_KEY, BTN_RECALCULATE_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_CANCEL_HANDLE_KEY});
        } else if (RiskResultStatusEnum.TRANSMITTING.getCode().equals(handleStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_WAIT_STATUS_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_TRANSMITTING_STATUS_KEY, BTN_CANCEL_HANDLE_KEY, BTN_RECALCULATE_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_HANDLED_STATUS_KEY});
        }
        QFilter filter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()).and(new QFilter("riskcode", "=", (Object)riskResultObject.getLong("risk.id"))).and(new QFilter("riskresultfid", "=", (Object)riskResultObject.getString("id")));
        DynamicObject dynamicObject = TctrcRiskEvaluationBusiness.getOneRiskEvaluation((QFilter[])new QFilter[]{filter}, (String)"processstate");
        if (dynamicObject != null && ProcessStateEnum.PROCESS_2.getCode().equals(dynamicObject.getString("processstate"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_EVALUATE_KEY});
        }
    }

    private void initPolicies(DynamicObject riskObject) {
        DynamicObjectCollection policies = riskObject.getDynamicObjectCollection(ENTRY_POLICIES_KEY);
        for (DynamicObject policy : policies) {
            int index = this.getModel().createNewEntryRow(ENTRY_POLICIES_KEY);
            this.getModel().setValue("policiesname", policy.get("policiesname"), index);
            this.getModel().setValue("policiesurl", policy.get("policiesurl"), index);
            this.getModel().setValue("policyarticles", (Object)policy.getString("policyarticles"), index);
        }
    }

    protected void updateImageControlImageUrl(String imageControlKey, String imageUrl) {
        HashMap<String, String> imageUrlMap = new HashMap<String, String>(1);
        imageUrlMap.put("imageKey", imageUrl);
        this.getView().updateControlMetadata(imageControlKey, imageUrlMap);
    }

    public abstract void initOtherBizContent(DynamicObject var1);

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String policyUrl = (String)this.getModel().getValue("policiesurl", rowIndex);
        this.getView().openUrl(policyUrl);
    }

    public void setFilter(SetFilterEvent evt) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String resultId = map.get(CACHE_RESULT_ID_KEY).toString();
        List qFilters = evt.getQFilters();
        qFilters.add(new QFilter(CACHE_RESULT_ID_KEY, "=", (Object)resultId));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        if (args.getOperationResult() == null || !args.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey = args.getOperateKey()) {
            case "recal": {
                this.recalculate();
                break;
            }
            case "handle": {
                this.handle();
                break;
            }
            case "undo": {
                this.cancelHandle();
                break;
            }
            case "transmit": {
                this.transmit();
                break;
            }
            case "handleresultlist": {
                this.showHandleResultList();
                break;
            }
            case "evaluate": {
                this.evaluate();
            }
        }
    }

    private void recalculate() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = this.getRiskResultDynamicObject(resultId);
        if (riskResultObject == null) {
            return;
        }
        if (OrgCheckUtil.checkById((IFormView)this.getView(), (String)riskResultObject.getString("runorg.id"), (String)"tctrc", (String)"tctrc_risk_run_list")) {
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tctrc_handle_entity");
        DynamicObject riskHandleDynmicObject = new DynamicObject((DynamicObjectType)mainEntityType);
        riskHandleDynmicObject.set("result", (Object)RiskHandleResultEnum.RECALCULATE.getCode());
        String riskHandleRiskResult = this.getRiskHandleRiskResult(riskResultObject);
        riskHandleDynmicObject.set("riskresult", (Object)("null".equals(riskHandleRiskResult) ? this.getFormatNoValueString() : riskHandleRiskResult));
        riskHandleDynmicObject.set("type", (Object)"rgcl");
        riskHandleDynmicObject.set("time", (Object)new Date());
        riskHandleDynmicObject.set("handler", (Object)RequestContext.get().getCurrUserId());
        riskHandleDynmicObject.set(CACHE_RESULT_ID_KEY, (Object)riskResultObject.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskHandleDynmicObject});
        DynamicObject risk = riskResultObject.getDynamicObject("risk");
        String enable = risk.getString("enable");
        if (!enable.equalsIgnoreCase(BooleanEnum.YES.getCode())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u98ce\u9669\u5df2\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"AbstractResultPlugin_23", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            return;
        }
        String startDate = riskResultObject.getString("startdate");
        String endDate = riskResultObject.getString("enddate");
        this.setDateStrByCalTypeSingle(riskResultObject, startDate, endDate);
        String riskNumber = risk.getString(FIELD_RISK_NUMBER_KEY);
        String orgId = riskResultObject.getString("runorg.id");
        Map calculateResultMap = RiskCalSerivce.calRisk((String)riskResultObject.getString("id"), (Map)ElementSqlService.queryAllEnableEleInfoMap(), (String)risk.getString("risktype"), (String)orgId, (String)riskNumber, (String)startDate, (String)startDate, (String)endDate);
        riskResultObject.set("json", calculateResultMap.get("json"));
        riskResultObject.set("lastupdateby", (Object)RequestContext.get().getCurrUserId());
        riskResultObject.set("runtime", (Object)new Date());
        riskResultObject.set("rlevel", calculateResultMap.get(FIELD_RISK_LEVEL_KEY));
        riskResultObject.set("riskscore", calculateResultMap.get("riskscore"));
        riskResultObject.set("riskdesc", calculateResultMap.get("riskdesc"));
        riskResultObject.set("result", calculateResultMap.get("result"));
        if ("true".equals(calculateResultMap.get("isDenominatorZero"))) {
            riskResultObject.set("isdenominatorzero", (Object)Boolean.TRUE);
            riskResultObject.set("rlevel", (Object)RiskResultLevelEnum.CALCULATE_ERROR.getCode());
            riskResultObject.set("riskdesc", (Object)"");
        } else {
            riskResultObject.set("isdenominatorzero", (Object)Boolean.FALSE);
        }
        if ("true".equals(calculateResultMap.get("isEmptyField"))) {
            riskResultObject.set("isemptyfield", (Object)Boolean.TRUE);
            riskResultObject.set("rlevel", (Object)RiskResultLevelEnum.CALCULATE_ERROR.getCode());
            riskResultObject.set("riskdesc", (Object)"");
        } else {
            riskResultObject.set("isemptyfield", (Object)Boolean.FALSE);
        }
        List filterFieldValueList = ListUtils.stringToList((String)((String)calculateResultMap.get("filterFieldValueList")));
        if (filterFieldValueList != null) {
            for (String filterFieldValue : filterFieldValueList) {
                if (!StringUtils.isEmpty((CharSequence)filterFieldValue)) continue;
                riskResultObject.set("isemptyfield", (Object)Boolean.TRUE);
                break;
            }
        }
        if (!DealStatusEnum.CHANING.getCode().equalsIgnoreCase(riskResultObject.getString("status"))) {
            riskResultObject.set("status", (Object)DealStatusEnum.TO_DO.getCode());
        }
        riskResultObject.set("dealresult", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskResultObject});
        this.refresh();
    }

    private String getRiskHandleRiskResult(DynamicObject riskResultObject) {
        String riskType = riskResultObject.getString("risk.risktype");
        if (RiskTypeEnum.NUMBER.getKey().equals(riskType)) {
            return riskResultObject.getString("result");
        }
        return riskResultObject.getString("json");
    }

    protected String getFormatNoValueString() {
        return ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"AbstractResultPlugin_28", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    public void setDateStrByCalTypeSingle(DynamicObject riskResultObject, String startDateStr, String endDateStr) {
        String calType = riskResultObject.getString("caltype");
        Date startDate = kd.taxc.tctrc.common.util.DateUtils.stringToDate((String)startDateStr);
        Date endDate = kd.taxc.tctrc.common.util.DateUtils.stringToDate((String)endDateStr);
        List dateList = CalUtils.getCalDate((String)calType, (Date)startDate, (Date)endDate);
        for (Map dateMap : dateList) {
            RiskService.setDateStrByCalType((String)calType, (Map)dateMap, (DynamicObject)riskResultObject);
        }
    }

    private void handle() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = RiskResultBusiness.queryDataById((Long)resultId, (String)"risk.id,risk.risktype,result,json,transmit.id,status");
        long transmit = riskResultObject.getLong("transmit.id");
        if (RiskResultStatusEnum.TRANSMITTING.getCode().equals(riskResultObject.getString("status")) && RequestContext.get().getCurrUserId() != transmit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8f6c\u4ea4\u4e2d\u201d\u72b6\u6001\u7684\u98ce\u9669\u7ed3\u679c\u4e0d\u80fd\u88ab\u5176\u4ed6\u4eba\u5f55\u5165\u5904\u7406\u6307\u5f15\uff08\u53ea\u6709\u8f6c\u4ea4\u540e\u7684\u5904\u7406\u4eba\u53ef\u4ee5\u5f55\u6307\u5f15\uff09\u3002", (String)"AbstractRiskResultDetailPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>(5);
        customMap.put(CACHE_RESULT_ID_KEY, resultId);
        customMap.put("riskId", riskResultObject.get("risk.id"));
        customMap.put("riskType", riskResultObject.get("risk.risktype"));
        customMap.put("riskResult", this.getRiskHandleRiskResult(riskResultObject));
        Map<String, Object> openHandlePageParam = this.getOpenHandlePageParam();
        if (MapUtils.isNotEmpty(openHandlePageParam)) {
            customMap.putAll(openHandlePageParam);
        }
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_risk_result_handle", (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    protected abstract Map<String, Object> getOpenHandlePageParam();

    protected abstract Map<String, Object> getOpenTransmitPageParam();

    private void cancelHandle() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)resultId, (String)"id,risk,status,transmit");
        if (null == riskResultObject) {
            return;
        }
        RiskDealUtil.undoCheck((DynamicObject)riskResultObject);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CANCEL_HANDLE_KEY, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d6\u6d88\u5904\u7406\u201d\u540e\u7684\u98ce\u9669\u6570\u636e\u53ef\u4ee5\u91cd\u65b0\u5f55\u5165\u5904\u7406\u6307\u5f15\u4e5f\u53ef\u4ee5\u91cd\u65b0\u8ba1\u7b97\uff0c\u786e\u5b9a\u7ee7\u7eed\u53d6\u6d88\u5417\uff1f", (String)"AbstractResultPlugin_24", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
    }

    private void transmit() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = RiskResultBusiness.queryDataById((Long)resultId, (String)"status,transmit.id,risk.risktype,result,json,runorg");
        RiskDealUtil.checkRecord((DynamicObject)riskResultObject, (RiskHandlerEnum)RiskHandlerEnum.TRANSMIT);
        HashMap<String, Object> customMap = new HashMap<String, Object>(2);
        customMap.put(CACHE_RESULT_ID_KEY, resultId);
        customMap.put("json", this.getRiskHandleRiskResult(riskResultObject));
        customMap.put("runorg", riskResultObject.getString("runorg"));
        Map<String, Object> openTransmitPageParam = this.getOpenTransmitPageParam();
        if (MapUtils.isNotEmpty(openTransmitPageParam)) {
            customMap.putAll(openTransmitPageParam);
        }
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)RiskHandlerEnum.TRANSMIT.getFormId(), (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    private void showHandleResultList() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        HashMap<String, Long> customMap = new HashMap<String, Long>(1);
        customMap.put(CACHE_RESULT_ID_KEY, resultId);
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_handle_result_list", (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }

    private void evaluate() {
        long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
        DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)resultId);
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        customMap.put("user", RequestContext.get().getCurrUserId());
        customMap.put(FIELD_RISK_NUMBER_KEY, Stream.of(Long.valueOf(riskResultObject.getLong("risk.id"))).collect(Collectors.toList()));
        customMap.put("datasource", "1");
        customMap.put("orgid", riskResultObject.getString("runorg.id"));
        customMap.put(FIELD_RISK_NAME_KEY, riskResultObject.getString("risk.name"));
        customMap.put("stars", "");
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tctrc_evaluation_frame", (IFormView)this.getView(), (Map)customMap, (IFormPlugin)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_REFRESH_KEY.equals(key)) {
            this.refresh();
        }
    }

    private void refresh() {
        this.getView().invokeOperation(BTN_REFRESH_KEY);
    }

    public void click(EventObject evt) {
        if (!(evt.getSource() instanceof Control)) {
            return;
        }
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("policydetail".equals(controlKey)) {
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY_POLICIES_KEY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_POLICIES_KEY, index);
            String msg = entryRowEntity.getString("policyarticles");
            String caption = String.format(ResManager.loadKDString((String)"\u4f9d\u636e%s", (String)"AbstractResultPlugin_18", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), entryRowEntity.getString("policiesname"));
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tctrc_policy_dialog");
            param.setCaption(caption);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("msg", (Object)msg);
            this.getView().showForm(param);
        } else if ("labelaptitle".equals(controlKey)) {
            String msg = (String)this.getModel().getValue(FIELD_RISK_DESC_KEY);
            String caption = ResManager.loadKDString((String)"\u98ce\u9669\u63d0\u793a", (String)"AbstractResultPlugin_19", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tctrc_policy_dialog");
            param.setCaption(caption);
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setCustomParam("msg", (Object)msg);
            this.getView().showForm(param);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (BTN_CANCEL_HANDLE_KEY.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            long resultId = Long.parseLong(this.getPageCache().get(CACHE_RESULT_ID_KEY));
            DynamicObject riskResultObject = RiskResultBusiness.getDataById((Long)resultId, (String)"id,risk,status,transmit,json,result");
            riskResultObject.set("status", (Object)DealStatusEnum.TO_DO.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskResultObject});
            DynamicObject riskResultHandleObject = BusinessDataServiceHelper.newDynamicObject((String)"tctrc_risk_result_handle");
            riskResultHandleObject.set("handler", (Object)RequestContext.get().getCurrUserId());
            riskResultHandleObject.set("result", (Object)RiskHandleResultEnum.CANCEL_HANDLE.getCode());
            riskResultHandleObject.set("time", (Object)new Date());
            riskResultHandleObject.set(CACHE_RESULT_ID_KEY, (Object)resultId);
            riskResultHandleObject.set("handletype", (Object)"rgcl");
            String riskHandleRiskResult = this.getRiskHandleRiskResult(riskResultObject);
            riskResultHandleObject.set("riskresult", (Object)riskHandleRiskResult);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{riskResultHandleObject});
            this.refresh();
        }
    }

    protected DynamicObject getRiskResultDynamicObject(Long resultId) {
        return RiskResultBusiness.getDataById((Long)resultId);
    }

    protected void showMessage(IFormView view, String message) {
        if (EmptyCheckUtils.isNotEmpty((Object)view)) {
            view.showTipNotification(message);
        }
    }
}

