/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.tctrc.business.element.ElementResultBusiness;
import kd.taxc.tctrc.business.riskresult.RiskResultBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.common.element.Element;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.RiskElementSqlService;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.PageShowCommon;
import kd.taxc.tctrc.formplugin.result.AbstractRiskResultDetailPlugin;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractRiskResultNumberAndVerifyPlugin
extends AbstractRiskResultDetailPlugin {
    protected static final String ELEMENT_DESC = "elementdesc";
    protected static final String ELEMENT_DESC_NO = AbstractRiskResultNumberAndVerifyPlugin.getNoExistMsg();
    protected static final String ELEMENT_NAME = "elementname";
    private static final String KEY_DEVIATIONTIME = "deviationtime";
    protected static final String RUNORG = "runorg";
    protected static final String CALTYPE = "caltype";
    protected static final String STARTDATE = "startdate";
    protected static final String ENDDATE = "enddate";

    private static String getNoExistMsg() {
        return ResManager.loadKDString((String)"\u6682\u65e0\u63cf\u8ff0\u4fe1\u606f\u3002", (String)"AbstractResultPlugin_22", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    @Override
    public void initOtherBizContent(DynamicObject riskResultObject) {
        this.getModel().setValue(RUNORG, (Object)riskResultObject.getDynamicObject(RUNORG));
        this.getModel().setValue(CALTYPE, (Object)riskResultObject.getString(CALTYPE));
        this.getModel().setValue(STARTDATE, riskResultObject.get(STARTDATE));
        this.getModel().setValue(ENDDATE, riskResultObject.get(ENDDATE));
    }

    protected Axis createCategoryAxis(Chart chart, boolean isX, boolean isRateType) {
        Axis axis = null;
        String yAxisName = isRateType ? " % " : "";
        axis = isX ? chart.createXAxis("", AxisType.category) : chart.createYAxis(yAxisName, AxisType.value);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private void setLineColor(Axis axis, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axis.setPropValue("axisLine", axisLineMap);
    }

    protected LabelAp createLabel(String key, String text, String value, boolean clickable) {
        LabelAp stageLabelAp = new LabelAp();
        stageLabelAp.setId(key);
        stageLabelAp.setKey(key);
        stageLabelAp.setAlignSelf("center");
        stageLabelAp.setTextAlign("center");
        Style style = new Style();
        if (clickable) {
            stageLabelAp.setName(new LocaleString(text + "\r\n" + value));
            stageLabelAp.setForeColor("#5E80EB");
            stageLabelAp.setClickable(true);
            stageLabelAp.setFontSize(12);
            Border border = new Border();
            border.setBottom("1px solid #5582F3");
            border.setLeft("1px solid #5582F3");
            border.setRight("1px solid #5582F3");
            border.setTop("1px solid #5582F3");
            style.setBorder(border);
            Padding padding = new Padding();
            padding.setTop("3px");
            padding.setBottom("3px");
            padding.setLeft("10px");
            padding.setRight("10px");
            style.setPadding(padding);
            Margin margin = new Margin();
            margin.setLeft("3px");
            margin.setRight("3px");
            margin.setBottom("10px");
            style.setMargin(margin);
            stageLabelAp.setRadius("4px");
            stageLabelAp.setStyle(style);
        } else {
            stageLabelAp.setName(new LocaleString(text));
            Margin margin = new Margin();
            margin.setLeft("3px");
            margin.setRight("3px");
            margin.setBottom("10px");
            style.setMargin(margin);
            stageLabelAp.setStyle(style);
        }
        return stageLabelAp;
    }

    public Map<String, List> getElementsByPeriod(long runOrg, String elementCode, String calType, Date startDate, Date endDate, int diffMonth) {
        RiskElementSqlService elementSqlService = new RiskElementSqlService();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList periodsList = new ArrayList();
        ArrayList<String> periodList = new ArrayList<String>();
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>();
        ArrayList<String> isEmptyFieldList = new ArrayList<String>();
        HashMap<String, List> mapResult = new HashMap<String, List>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(calType)) {
            calendar.add(2, -12);
            for (int i = 0; i < 12; ++i) {
                calendar.add(2, 1);
                if (i == 0) {
                    String string = DateUtils.format((Date)calendar.getTime());
                }
                Iterator date = calendar.getTime();
                Date deviationDate = DateUtils.addMonth((Date)((Object)date), (int)(-diffMonth));
                String dd = DateUtils.formatMonth((Date)deviationDate);
                String startDate1 = DateUtils.format((Date)deviationDate);
                String endDate1 = DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)deviationDate));
                periodList.add(dd);
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", startDate1);
                map1.put("endDate", endDate1);
                periodsList.add(map1);
            }
            List list = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, periodsList);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                HashMap<String, String> isEmptyFieldMap = new HashMap<String, String>(16);
                for (Element element : list) {
                    String key = DateUtils.format((Date)DateUtils.addMonth((Date)DateUtils.stringToDate((String)element.getStartData()), (int)(-diffMonth)), (String)"yyyy-MM");
                    String value = element.getValue();
                    String isEmptyField = element.getIsEmptyField();
                    map.put(key, value);
                    isEmptyFieldMap.put(key, isEmptyField);
                }
                for (String s : periodList) {
                    String str = (String)map.get(s);
                    String isEmptyField = (String)isEmptyFieldMap.get(s);
                    if (str != null) {
                        resultList.add(BigDecimalUtil.toBigDecimal((Object)str).setScale(4, 4));
                    } else {
                        resultList.add(BigDecimalUtil.toBigDecimal((Object)0));
                    }
                    isEmptyFieldList.add(isEmptyField);
                }
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(calType)) {
            HashMap<String, String> quarterStr = new HashMap<String, String>(){
                {
                    this.put("01", "Q1");
                    this.put("02", "Q1");
                    this.put("03", "Q1");
                    this.put("04", "Q2");
                    this.put("05", "Q2");
                    this.put("06", "Q2");
                    this.put("07", "Q3");
                    this.put("08", "Q3");
                    this.put("09", "Q3");
                    this.put("10", "Q4");
                    this.put("11", "Q4");
                    this.put("12", "Q4");
                }
            };
            calendar.add(2, -9);
            for (int i = 0; i < 4; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(2, 3);
                String end = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                String month = timeStr[1];
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                end = DateUtils.getLastDateOfMonthStr((Date)DateUtils.stringToDate((String)end), (String)"yyyy-MM-dd");
                map1.put("endDate", end);
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                periodList.add(year + "-" + (String)quarterStr.get(month));
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equalsIgnoreCase(calType)) {
            calendar.add(2, -6);
            for (int i = 0; i < 2; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(2, 6);
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                map1.put("endDate", DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1))));
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                String half = Integer.parseInt(timeStr[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"AbstractResultPlugin_20", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"AbstractResultPlugin_21", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"AbstractResultPlugin_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year + half));
            }
        } else {
            calendar.add(1, -1);
            for (int i = 0; i < 2; ++i) {
                String start = DateUtils.format((Date)calendar.getTime());
                String startStr = DateUtils.format((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)(-diffMonth)));
                calendar.add(1, 1);
                final HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("startDate", start);
                map1.put("endDate", DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)calendar.getTime(), (int)-1))));
                List elements = elementSqlService.queryElementValue(String.valueOf(runOrg), elementCode, (List)new ArrayList<Map<String, String>>(){
                    {
                        this.add(map1);
                    }
                });
                BigDecimal bigDecimal = BigDecimal.ZERO;
                String isEmptyField = null;
                for (Element element : elements) {
                    bigDecimal = bigDecimal.add(BigDecimalUtil.toBigDecimal((Object)element.getValue()));
                    isEmptyField = element.getIsEmptyField();
                }
                isEmptyFieldList.add(isEmptyField);
                resultList.add(bigDecimal.setScale(4, 4));
                String[] timeStr = startStr.split("-");
                String year = timeStr[0];
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"AbstractResultPlugin_31", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year));
            }
        }
        mapResult.put("isEmptyField", isEmptyFieldList);
        mapResult.put("period", periodList);
        mapResult.put("result", resultList);
        return mapResult;
    }

    protected String createElementLableKey(Formula formula, int index, boolean isBottom) {
        boolean isElement = formula.getType().equals("1");
        String prefix = "label_&";
        prefix = isBottom ? prefix + "bottom_&" : prefix + "bottomno_&";
        if (isElement) {
            prefix = prefix + formula.getCode() + "_&";
        }
        prefix = prefix + index;
        return prefix;
    }

    protected void doClearOldControl(Container container, String cacheKeys) {
        String keys = this.getPageCache().get(cacheKeys);
        if (StringUtils.isNotEmpty((CharSequence)keys)) {
            for (String key : keys.split(",")) {
                container.deleteControls(new String[]{key});
            }
        }
    }

    protected LabelAp createLabelAp(String fieldid, String title) {
        LabelAp lable = LabelUtils.createLabel((String)fieldid, (String)title, null);
        lable.setFontSize(16);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("5px");
        style.setMargin(margin);
        lable.setStyle(style);
        return lable;
    }

    protected void initChart(Map<String, List> datas, String name, String control, boolean isRateDisplay) {
        BigDecimal[] values;
        PointLineChart chart = (PointLineChart)this.getControl(control);
        chart.clearData();
        List resultList = datas.get("result");
        List periodList = datas.get("period");
        List isEmptyFieldList = datas.get("isEmptyField");
        List<String> periodsNewList = new ArrayList();
        if (isEmptyFieldList != null) {
            for (int i = 0; i < isEmptyFieldList.size(); ++i) {
                if ("true".equals(isEmptyFieldList.get(i))) {
                    periodsNewList.add((String)periodList.get(i) + " " + this.getFormatNoValueString());
                    continue;
                }
                periodsNewList.add((String)periodList.get(i));
            }
        } else {
            periodsNewList = periodList;
        }
        if (isRateDisplay) {
            LinkedList<BigDecimal> results = new LinkedList<BigDecimal>();
            for (BigDecimal val : resultList) {
                results.add(val.multiply(new BigDecimal("100")));
            }
            values = results.toArray(new BigDecimal[resultList.size()]);
        } else {
            values = resultList.stream().map(b -> b.setScale(4, 4)).collect(Collectors.toList()).toArray(new BigDecimal[resultList.size()]);
        }
        this.createCategoryAxis((Chart)chart, false, isRateDisplay);
        LineSeries lineSeries1 = this.createLineSeries((Chart)chart, "", values);
        lineSeries1.setSmooth(true);
        Axis xAxis = this.createCategoryAxis((Chart)chart, true, isRateDisplay);
        xAxis.setCategorys(periodsNewList);
        chart.setMargin(Position.left, "20");
        chart.setMargin(Position.right, "20");
        chart.setName(new LocaleString(name));
        chart.setTitleAlign(XAlign.center, YAlign.top);
        chart.setShowTooltip(true);
        chart.refresh();
    }

    protected FlexPanelAp createElementFlexPanelAp(String flexkey, List<Formula> formulas, LoadCustomControlMetasArgs e, boolean isBottom, Map<String, DynamicObject> code2EleInfoMap) {
        List eleTrueKeys2;
        List listKeys;
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexkey);
        ArrayList<String> elementKeys = new ArrayList<String>();
        ArrayList<String> eleTrueKeys = new ArrayList<String>(10);
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        if (formulas != null && formulas.size() != 0) {
            for (int i = 0; i < formulas.size(); ++i) {
                Formula formula = formulas.get(i);
                boolean clickable = formula.getType().equals("1");
                String keys = this.createElementLableKey(formula, i, isBottom);
                StringBuilder value = new StringBuilder();
                String elementNumber = formula.getCode();
                DynamicObject element = code2EleInfoMap.get(elementNumber);
                boolean isRateTypeElement = false;
                if (element != null) {
                    isRateTypeElement = element.getBoolean("typevalue");
                }
                if ("true".equals(formulas.get(i).getIsEmptyField()) || "true".equals(formulas.get(i).getIsDenominatorZero())) {
                    value.append(this.getFormatNoValueString());
                } else {
                    BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)formulas.get(i).getValue());
                    if (isRateTypeElement && !isBottom) {
                        value.append(decimal.multiply(new BigDecimal("100")).setScale(2)).append('%');
                    } else {
                        value.append(BigDecimalUtil.setScale((Object)decimal, (int)4));
                    }
                }
                LabelAp label = this.createLabel(keys, StringUtils.trim((String)formulas.get(i).getName()), value.toString(), clickable);
                flex.getItems().add(label);
                elementKeys.add(keys);
                eleTrueKeys.add(elementNumber + "&&&" + value);
            }
        }
        if (null != (listKeys = (List)formParamter.getCustomParam("elementKeys"))) {
            elementKeys.addAll(listKeys);
        }
        if (null != (eleTrueKeys2 = (List)formParamter.getCustomParam("eletruekeys"))) {
            eleTrueKeys.addAll(eleTrueKeys2);
        }
        formParamter.setCustomParam("eletruekeys", eleTrueKeys);
        formParamter.setCustomParam("elementKeys", elementKeys);
        return flex;
    }

    protected void displayElementAndChart(Map<String, List> resultMap, String eleName, String control, String eleCode, String desc, int month, Map map) {
        if (null == desc || desc.isEmpty()) {
            this.getModel().setValue(ELEMENT_DESC, (Object)ELEMENT_DESC_NO);
        } else {
            this.getModel().setValue(ELEMENT_DESC, (Object)desc);
        }
        Label label1 = (Label)this.getView().getControl(KEY_DEVIATIONTIME);
        if (0 > month) {
            label1.setText(String.format(ResManager.loadKDString((String)"(\u6b64\u5143\u7d20\u7684\u53d6\u503c\u5411\u524d\u504f\u79fb%s\u4e2a\u6708)", (String)"FigureTargetResultPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Math.abs(month)));
        } else if (0 < month) {
            label1.setText(String.format(ResManager.loadKDString((String)"(\u6b64\u5143\u7d20\u7684\u53d6\u503c\u5411\u540e\u504f\u79fb%\u4e2a\u6708)", (String)"FigureTargetResultPlugin_18", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Math.abs(month)));
        } else {
            label1.setText("");
        }
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get("isfirst")) && ("true".equals(map.get("isEmptyField")) || "true".equals(map.get("isDenominatorZero")))) {
            this.showMessage(this.getView(), this.getCalNoValueMessage());
        }
        Label label = (Label)this.getView().getControl(ELEMENT_NAME);
        label.setText(eleName);
        QFilter qFilter = new QFilter("number", "=", (Object)eleCode);
        DynamicObject dynamicObject = TdmElementGroupBusiness.getTdmElementGroupSingleBus((QFilter)qFilter);
        if (null != dynamicObject) {
            boolean isScale = dynamicObject.getBoolean("typevalue");
            this.initChart(resultMap, eleName, control, isScale);
        }
    }

    private LineSeries createLineSeries(Chart chart, String name, BigDecimal[] values) {
        LineSeries series = chart.createLineSeries(name);
        series.setData((Number[])values);
        series.setSmooth(true);
        series.setItemColor("#3F83F2");
        series.setLineColor("#3F83F2");
        series.setColor("#73DCDD");
        return series;
    }

    protected void showMessage(IFormView view) {
        this.showMessage(view, this.getCalNoValueMessage());
    }

    protected String getCalNoValueMessage() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u7b97\u5468\u671f\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"AbstractResultPlugin_29", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
    }

    protected void showElementInfoForm(DynamicObject elementObject) {
        HashMap<String, Object> customMap = new HashMap<String, Object>(7);
        customMap.put("number", elementObject.getString("number"));
        long riskResultId = Long.parseLong(this.getPageCache().get("resultid"));
        DynamicObject riskResultObject = RiskResultBusiness.queryDataById((Long)riskResultId, (String)"startdate,enddate,caltype,runtime,runorg.id");
        customMap.put(CALTYPE, riskResultObject.get(CALTYPE));
        customMap.put("runtime", riskResultObject.get("runtime"));
        customMap.put("sssjq", riskResultObject.get(STARTDATE));
        customMap.put("sssjz", riskResultObject.get(ENDDATE));
        customMap.put("orgid", riskResultObject.get("runorg.id"));
        DynamicObjectCollection elementResults = ElementResultBusiness.queryRiskElementResult(Collections.singletonList(elementObject.getLong("id")), (Date)riskResultObject.getDate(STARTDATE), (Date)riskResultObject.getDate(ENDDATE), (Long)riskResultObject.getLong("runorg.id"), (String)"value");
        if (CollectionUtils.isEmpty((Collection)elementResults)) {
            customMap.put("eleval", this.getFormatNoValueString());
        } else {
            String value = ((DynamicObject)elementResults.get(0)).getString("value");
            customMap.put("eleval", "null".equals(value) ? this.getFormatNoValueString() : value);
        }
        String formNumber = elementObject.getBoolean("bottom") ? "tdm_ele_bottom_info" : "tdm_element_info";
        PageShowCommon.showForm((ShowType)ShowType.Modal, (String)formNumber, (IFormView)this.getView(), customMap, (IFormPlugin)this);
    }
}

