/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tctrc.business.tctrc.TctrcResultRecordsBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.entity.FilterElement;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.LabelUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.result.AbstractResultPlugin;

@Deprecated
public class ElementVerifyResultPlugin
extends AbstractResultPlugin
implements ClickListener {
    private static final String CURRENT_ELEMENT_RESULT_ID = "current_field_id";
    private static final String IS_EMPTY_FIELD = "isemptyfield";
    private static final String IS_DENOMINATOR_ZERO = "isdenominatorzero";
    public static final String TRUE_STRING = "true";
    private static final String TDM_ELEMENT_RESULT_ENTITY = "tdm_element_result";
    private static final String ELE_FORMULA_FLEX = "flexpanelap11";
    private static final String ELE_DEFAULT_FIRST_CODE_KEY = "eledefaultfirstcodekey";
    private static final String DEFAULT_FIRST_ELE_BY_CHAT = "defaultFirstEleByChat";
    private static final String ELEMENT_TRUE_KEYS = "elementTrueKeys";
    private static final String ELE_FORMULA_KEYS = "eleformulakeys";
    private static final String ELE_FORMULA_PARENT_KEYS = "eleformulaparentkeys";
    private static final String ITEM_CLICK_KEY_CACHE = "item_click_key_cache";
    private static final String DISPLAY_ITEM_CLICK_KEY_CACHE = "display_item_click_key_cache";
    private static Log logger = LogFactory.getLog(ElementVerifyResultPlugin.class);

    @Override
    protected void init(DynamicObject dynamicObject) {
        QFilter filter = new QFilter("resultid", "=", dynamicObject.get("id"));
        DynamicObjectCollection records = TctrcResultRecordsBusiness.getTctrcResultRecords((QFilter)filter);
        List idList = records.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        logger.info("\u5f00\u59cb\u67e5\u8be2\u6838\u5bf9\u9879\u5361\u7247\uff0c\u98ce\u9669\u8fd0\u884c\u8bb0\u5f55\u8868\u3002");
        DynamicObject[] load = TctrcResultRecordsBusiness.getTctrcResultRecordsBus((QFilter)new QFilter("id", "in", idList));
        Container container = (Container)this.getView().getControl("flexpanelapfliter");
        String filterKeyStr = this.getPageCache().get("filterKeyStr");
        StringBuilder keyStr = new StringBuilder();
        if (null != filterKeyStr) {
            String[] keys;
            for (String str : keys = filterKeyStr.split(",")) {
                container.deleteControls(new String[]{str});
            }
        } else {
            int row = 0;
            boolean lengthMoreThenOne = load.length > 1;
            Boolean isFirstEle = Boolean.TRUE;
            for (DynamicObject record : load) {
                Boolean isFistOne = row == 0 ? Boolean.TRUE : Boolean.FALSE;
                String json_tag = record.getString("json_tag");
                if (!StringUtils.isNotEmpty((CharSequence)json_tag)) continue;
                logger.info("json_tag:" + json_tag);
                List<FilterElement> elements = SerializationUtils.fromJsonStringToList((String)json_tag, FilterElement.class);
                elements = this.filterEleNumber(elements);
                ArrayList<Map> items = new ArrayList<Map>();
                String title = "1".equalsIgnoreCase(record.getString("exist")) || StringUtil.isEmpty((CharSequence)record.getString("exist")) ? ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669", (String)"ElementVerifyResultPlugin_1", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4ee5\u4e0b\u60c5\u51b5\u65f6\u5224\u5b9a\u4e3a\u98ce\u9669\u3002", (String)"ElementVerifyResultPlugin_2", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                String nametitle = record.getString("title");
                if (load.length > 1) {
                    title = lengthMoreThenOne && isFistOne != false ? title : String.format(ResManager.loadKDString((String)"\u4e14%s", (String)"ElementVerifyResultPlugin_3", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), title);
                }
                LabelAp infoLabelAp = this.createLabelAp("title_" + record.getString("fieldid"), title);
                infoLabelAp.setForeColor("#999");
                items.add(infoLabelAp.createControl());
                LabelAp nametitleap = this.createLabelAp("nametitle_" + record.getString("fieldid"), nametitle);
                nametitleap.setForeColor("#1b1b28");
                items.add(nametitleap.createControl());
                String key = row + "FlexPanelApEntity";
                FlexPanelAp labels = LabelUtils.createFlex((String)key, elements);
                isFirstEle = this.bindClick(labels, record, elements, isFirstEle);
                keyStr.append(key).append(',');
                items.add(labels.createControl());
                container.addControls(items);
                ++row;
            }
            if (load.length > 0) {
                ArrayList<String> elementResultIdList = new ArrayList<String>(load.length);
                for (DynamicObject object : load) {
                    elementResultIdList.add(object.getString("fieldid"));
                }
                this.getPageCache().put(CURRENT_ELEMENT_RESULT_ID, String.join((CharSequence)",", elementResultIdList));
            }
            this.getPageCache().put("filterKeyStr", keyStr.toString());
        }
    }

    private List<FilterElement> filterEleNumber(List<FilterElement> elements) {
        HashSet<String> ids = new HashSet<String>();
        for (FilterElement element : elements) {
            if (null != element.getElement() && StringUtil.isNotEmpty((CharSequence)element.getElement().getId())) {
                ids.add(element.getElement().getId());
            }
            if (null == element.getContrastValue() || null == element.getContrastValue().getElement() || !StringUtil.isNotEmpty((CharSequence)element.getContrastValue().getElement().getId()) || "undefined".equalsIgnoreCase(element.getContrastValue().getElement().getId())) continue;
            ids.add(element.getContrastValue().getElement().getId());
        }
        DynamicObject[] dynamicObjects = TdmElementGroupBusiness.getTdmElementGroupDetails2((QFilter)new QFilter("id", "in", ids.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList())));
        Map<String, String> id2EleNameMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(k -> k.getString("id"), v -> v.getString("name")));
        for (FilterElement element : elements) {
            boolean isIll;
            boolean isIll2;
            boolean bl = isIll2 = null != element.getElement() && null != id2EleNameMap && null != id2EleNameMap.get(element.getElement().getId());
            if (isIll2) {
                element.getElement().setValue(id2EleNameMap.get(element.getElement().getId()));
            }
            if (!(isIll = null != element.getContrastValue() && null != element.getContrastValue().getElement() && null != id2EleNameMap && null != id2EleNameMap.get(element.getContrastValue().getElement().getId()))) continue;
            element.getContrastValue().getElement().setValue(id2EleNameMap.get(element.getContrastValue().getElement().getId()));
        }
        return elements;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("label_element_&")) {
            this.setClickStyle(key.toLowerCase(), ITEM_CLICK_KEY_CACHE);
            String[] arr = key.split("_");
            if (EmptyCheckUtils.isEmpty((Object)arr) || arr.length < 5) {
                return;
            }
            String elementid = arr[4];
            DynamicObject[] load = TdmElementGroupBusiness.getTdmElementGroupDetails2((QFilter)new QFilter("id", "in", Arrays.stream(elementid.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList())));
            if (null == load || load.length == 0) {
                return;
            }
            Map ele2EleInfoMap = ElementSqlService.queryAllEnableEleInfoMap();
            this.initResultShowForm(load, ele2EleInfoMap);
            String isDefaultFirstEleByChat = this.getPageCache().get(DEFAULT_FIRST_ELE_BY_CHAT);
            if (StringUtils.isNotEmpty((CharSequence)isDefaultFirstEleByChat)) {
                String eleCode = isDefaultFirstEleByChat.split("_&")[2];
                this.initChart(eleCode);
            }
        } else if (key.startsWith("label_&bottom")) {
            this.setClickStyle(key.toLowerCase(), DISPLAY_ITEM_CLICK_KEY_CACHE);
            String eleCode = key.split("_&")[2];
            this.initChart(eleCode);
        }
    }

    private void setClickStyle(String key, String itemClickKeyCache) {
        key = key.toLowerCase();
        this.clearLastClickStyle(itemClickKeyCache);
        this.doSetClickStyle(key);
        this.cacheCurrentClickKey(key, itemClickKeyCache);
    }

    private void cacheCurrentClickKey(String key, String itemClickKeyCache) {
        this.getPageCache().put(itemClickKeyCache, key);
    }

    private void doSetClickStyle(String key) {
        HashMap<String, String> stylemap = new HashMap<String, String>(8);
        stylemap.put("bc", "#5582F3");
        stylemap.put("fc", "#FFFFFF");
        this.getView().updateControlMetadata(key.toLowerCase(), stylemap);
    }

    private void clearLastClickStyle(String itemClickKeyCache) {
        if (null != this.getPageCache().get(itemClickKeyCache)) {
            String lastClickKey = this.getPageCache().get(itemClickKeyCache);
            HashMap<String, String> stylemap1 = new HashMap<String, String>(8);
            stylemap1.put("bc", "#fff");
            stylemap1.put("fc", "#5E80EB");
            this.getView().updateControlMetadata(lastClickKey.toLowerCase(), stylemap1);
        }
    }

    private void initChart(String eleCode) {
        eleCode = this.getTrueEleCode(eleCode);
        DynamicObject runorg = (DynamicObject)this.getModel().getValue("runorg");
        DynamicObject eleResult = this.getEleInfo(eleCode);
        DynamicObject eleInfo = this.getEleInfoByCode(eleCode);
        if (null == eleResult || null == eleInfo) {
            return;
        }
        String caltype = (String)this.getModel().getValue("caltype");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        String eleName = eleResult.getString("name");
        String isEmptyField = eleResult.getString(IS_EMPTY_FIELD);
        String isDenominatorZero = eleResult.getString(IS_DENOMINATOR_ZERO);
        String desc = eleInfo.getString("describe");
        Label eledesc = (Label)this.getView().getControl("eledesc");
        if (EmptyCheckUtils.isEmpty((Object)desc)) {
            eledesc.setText(ELEMENT_DESC_NO);
        } else {
            eledesc.setText(desc);
        }
        Label label = (Label)this.getView().getControl("elementname");
        label.setText(eleName);
        Map<String, List> resultMap = this.getElementsByPeriod(runorg.getLong("id"), eleCode, caltype, startDate, endDate, 0);
        if (TRUE_STRING.equals(isDenominatorZero)) {
            this.showMessage(this.getView());
        } else if (TRUE_STRING.equals(isEmptyField)) {
            this.showMessage(this.getView());
        }
        this.initChart(resultMap, eleName, "pointlinechartap", false);
    }

    private String getTrueEleCode(String eleCode) {
        String keys = this.getPageCache().get(ELEMENT_TRUE_KEYS);
        if (StringUtils.isEmpty((CharSequence)keys)) {
            return eleCode;
        }
        return Arrays.stream(keys.split(",")).filter(v -> eleCode.equalsIgnoreCase((String)v)).findFirst().get();
    }

    private DynamicObject getEleInfo(String eleCode) {
        DynamicObject runorg = (DynamicObject)this.getModel().getValue("runorg");
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        QFilter elementcode = new QFilter("element", "=", (Object)eleCode);
        QFilter startdata = new QFilter("startdata", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)startDate)));
        QFilter enddata = new QFilter("enddata", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)endDate))));
        enddata.or(new QFilter("enddata", "=", (Object)DateUtils.getLastDateOfMonth((Date)endDate)));
        QFilter qelement = new QFilter("org", "=", runorg.get("id"));
        QFilter usetype = new QFilter("usetype", "=", (Object)"0");
        qelement.and(usetype);
        qelement.and(elementcode);
        qelement.and(startdata);
        qelement.and(enddata);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)TDM_ELEMENT_RESULT_ENTITY, (String)"id,element,name,startdata,enddata,value,isemptyfield,isdenominatorzero,elestartdate,eleenddate", (QFilter[])new QFilter[]{qelement}, (String)"runtime asc");
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return null;
        }
        return (DynamicObject)doc.get(0);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label button = (Label)this.getControl("eleinfolabel");
        button.addClickListener((ClickListener)this);
    }

    private DynamicObject getEleInfoByCode(String eleCode) {
        QFilter elementcode = new QFilter("number", "=", (Object)eleCode);
        DynamicObjectCollection doc = TdmElementGroupBusiness.getTdmElementGroupQuery2((QFilter)elementcode);
        if (CollectionUtils.isEmpty((Collection)doc)) {
            return null;
        }
        return (DynamicObject)doc.get(0);
    }

    private void initResultShowForm(DynamicObject[] load, Map<String, DynamicObject> ele2EleInfoMap) {
        if (null == load || load.length == 0) {
            return;
        }
        String type = load[0].getBoolean("bottom") ? "1" : "0";
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long resultId = (Long)customParams.get("resultid");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)"tctrc_risk_run_result");
        String riskCode = dynamicObject.getDynamicObject("risk").getString("number");
        Date startdate = dynamicObject.getDate("startdate");
        Date enddate = dynamicObject.getDate("enddate");
        String orgid = dynamicObject.getDynamicObject("runorg").getString("id");
        logger.info("startdate:" + startdate + ",enddate:" + enddate + ",riskCode:" + riskCode + ",type:" + type + ",orgid:" + orgid);
        List formulasNo = RiskCalSerivce.queryFormulaByeElement((DynamicObject)dynamicObject, (DynamicObject)load[0], ele2EleInfoMap);
        formulasNo.forEach(formula -> logger.info("startdate:" + formula.getStartDate() + ""));
        this.setFormula(formulasNo, load[0]);
    }

    protected FlexPanelAp createElementLabels(String flexkey, List<Formula> formulas, boolean isBottom) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexkey);
        ArrayList<String> elementKeys = new ArrayList<String>();
        ArrayList<String> elementTrueKeys = new ArrayList<String>();
        Boolean isDefaultFirstEle = Boolean.TRUE;
        ElementSqlService.queryAllEnableEleInfoMap();
        if (formulas != null && formulas.size() != 0) {
            for (int i = 0; i < formulas.size(); ++i) {
                Formula formula = formulas.get(i);
                boolean clickable = formula.getType().equals("1");
                String keys = this.createElementLableKey(formula, i, isBottom);
                StringBuilder value = new StringBuilder();
                String elementNumber = formula.getCode();
                QFilter qFilter = new QFilter("number", "=", (Object)elementNumber);
                DynamicObject element = TdmElementGroupBusiness.getTdmElementGroupSingleQuery7((QFilter)qFilter);
                boolean isRateTypeElement = false;
                if (element != null) {
                    isRateTypeElement = element.getBoolean("typevalue");
                }
                if (TRUE_STRING.equals(formulas.get(i).getIsEmptyField()) || TRUE_STRING.equals(formulas.get(i).getIsDenominatorZero())) {
                    value.append(this.getFormatNoValueString());
                } else {
                    BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)formulas.get(i).getValue());
                    if (isRateTypeElement && !isBottom) {
                        value.append(decimal.multiply(new BigDecimal("100")).setScale(2)).append('%');
                    } else {
                        value.append(decimal);
                    }
                }
                if (TRUE_STRING.equals(formulas.get(i).getIsEmptyField())) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.getCalNoValueMessage());
                    value = new StringBuilder(this.getFormatNoValueString());
                }
                LabelAp label = this.createLabel(keys, StringUtils.trim((String)formulas.get(i).getName()), value.toString(), clickable);
                flex.getItems().add(label);
                if (isDefaultFirstEle.booleanValue() && clickable) {
                    isDefaultFirstEle = Boolean.FALSE;
                    this.setClickColStyle(label);
                    this.getPageCache().put(DISPLAY_ITEM_CLICK_KEY_CACHE, label.getKey());
                    this.getPageCache().put(DEFAULT_FIRST_ELE_BY_CHAT, label.getKey());
                }
                elementKeys.add(keys.toLowerCase());
                elementTrueKeys.add(elementNumber);
            }
        }
        this.getPageCache().put(ELE_FORMULA_KEYS, elementKeys.stream().collect(Collectors.joining(",")));
        this.getPageCache().put(ELE_FORMULA_PARENT_KEYS, flexkey.toLowerCase());
        this.getPageCache().put(ELEMENT_TRUE_KEYS, elementTrueKeys.stream().collect(Collectors.joining(",")));
        return flex;
    }

    private void setFormula(List<Formula> formulas, DynamicObject element) {
        this.clearOldControl();
        Container container = (Container)this.getView().getControl(ELE_FORMULA_FLEX);
        ArrayList<Map> items = new ArrayList<Map>();
        this.addFormula(formulas, element);
        boolean isBottom = element.getBoolean("bottom");
        FlexPanelAp flex = this.createElementLabels(element.getString("number"), formulas, isBottom);
        items.add(flex.createControl());
        container.addControls(items);
    }

    private void clearOldControl() {
        Container container = (Container)this.getView().getControl(ELE_FORMULA_FLEX);
        this.doClearOldControl(container, ELE_FORMULA_KEYS);
        this.doClearOldControl(container, ELE_FORMULA_PARENT_KEYS);
    }

    private void addFormula(List<Formula> formulas, DynamicObject element) {
        Formula selfFormula = this.createElementSelfFormula(element);
        if (element.getBoolean("bottom")) {
            if (EmptyCheckUtils.isNotEmpty((Object)selfFormula)) {
                formulas.add(0, selfFormula);
            }
        } else {
            Formula denghaoformula = new Formula("0", "=");
            formulas.add(0, denghaoformula);
            if (EmptyCheckUtils.isNotEmpty((Object)selfFormula)) {
                formulas.add(0, selfFormula);
            }
        }
    }

    private Formula createElementSelfFormula(DynamicObject element) {
        Formula elementSelf = new Formula("1", element.getString("name"));
        elementSelf.setCode(element.getString("number"));
        DynamicObject eleInfo = this.getEleInfo(element.getString("number"));
        if (null == eleInfo) {
            elementSelf.setValue("null");
            elementSelf.setIsEmptyField(TRUE_STRING);
            elementSelf.setIsDenominatorZero("false");
        } else {
            elementSelf.setValue(eleInfo.getString("value"));
            elementSelf.setIsDenominatorZero(eleInfo.getString(IS_DENOMINATOR_ZERO));
            elementSelf.setIsEmptyField(eleInfo.getString(IS_EMPTY_FIELD));
        }
        return elementSelf;
    }

    private boolean bindClick(FlexPanelAp labels, DynamicObject record, List<FilterElement> elements, Boolean isFirstEle) {
        List items = labels.getItems();
        if (CollectionUtils.isEmpty((Collection)items)) {
            return false;
        }
        for (ControlAp ap : items) {
            LabelAp labelAp = (LabelAp)ap;
            if (labelAp.getKey().indexOf("element") <= -1) continue;
            if (isFirstEle.booleanValue()) {
                this.getPageCache().put(ELE_DEFAULT_FIRST_CODE_KEY, labelAp.getKey());
                this.setClickColStyle(labelAp);
                this.getPageCache().put(ITEM_CLICK_KEY_CACHE, labelAp.getKey().toLowerCase());
                isFirstEle = Boolean.FALSE;
            }
            labelAp.setClickable(true);
        }
        return isFirstEle;
    }

    private void setClickColStyle(LabelAp labelAp) {
        labelAp.setForeColor("#FFFFFF");
        labelAp.setBackColor("#5582F3");
    }

    public void afterBindData(EventObject e) {
        String eledefaultfirstcodekey = this.getPageCache().get(ELE_DEFAULT_FIRST_CODE_KEY);
        if (StringUtil.isEmpty((CharSequence)eledefaultfirstcodekey)) {
            return;
        }
        String[] arr = eledefaultfirstcodekey.split("_");
        if (EmptyCheckUtils.isEmpty((Object)arr) || arr.length < 5) {
            return;
        }
        String elementid = arr[4];
        DynamicObject[] load = TdmElementGroupBusiness.getTdmElementGroupDetails2((QFilter)new QFilter("id", "in", Arrays.stream(elementid.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList())));
        if (null == load || load.length == 0) {
            return;
        }
        Map ele2EleInfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        this.initResultShowForm(load, ele2EleInfoMap);
        String isDefaultFirstEleByChat = this.getPageCache().get(DEFAULT_FIRST_ELE_BY_CHAT);
        String eleCode = isDefaultFirstEleByChat.split("_&")[2];
        this.initChart(eleCode);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().startsWith("label_")) {
            String keynew = source.getKey();
            String keyold = this.getPageCache().get("elementkey");
            if (null == keyold) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                keyold = (String)formShowParameter.getCustomParam("elementkey");
                HashMap<String, String> stylemap1 = new HashMap<String, String>(8);
                stylemap1.put("bc", "#fff");
                stylemap1.put("fc", "#5E80EB");
                this.getView().updateControlMetadata(keyold.toLowerCase(), stylemap1);
            }
            this.getPageCache().put("elementkey", keynew);
            HashMap<String, String> stylemap = new HashMap<String, String>(8);
            stylemap.put("bc", "#5582F3");
            stylemap.put("fc", "#FFFFFF");
            if (keynew != null) {
                this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
            }
        } else if (source.getKey().equals("eleinfolabel")) {
            FormShowParameter param = new FormShowParameter();
            String elementKey = this.getPageCache().get(DISPLAY_ITEM_CLICK_KEY_CACHE);
            if (EmptyCheckUtils.isEmpty((Object)elementKey)) {
                return;
            }
            String[] elementKeyArr = elementKey.split("_&");
            String trueEleCode = this.getTrueEleCode(elementKeyArr[2]);
            DynamicObject eleResult = this.getEleInfo(trueEleCode);
            if (null == eleResult) {
                return;
            }
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Object resultId = map.get("resultid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(resultId, (String)"tctrc_risk_run_result");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("number", eleResult.getString("element"));
            String orgid = ((DynamicObject)this.getModel().getValue("runorg")).getString("id");
            customParams.put("orgid", orgid);
            customParams.put("sssjq", DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("startdate")));
            customParams.put("sssjz", DateUtils.getLastDateOfMonth((Date)dynamicObject.getDate("enddate")));
            customParams.put("runtime", dynamicObject.getDate("runtime"));
            customParams.put("eleval", eleResult.get("value"));
            DynamicObject[] eles = TdmElementGroupBusiness.getTdmElementGroupDetails((QFilter)new QFilter("number", "=", (Object)trueEleCode));
            if (EmptyCheckUtils.isEmpty((Object)eles)) {
                return;
            }
            boolean bottom = eles[0].getBoolean("bottom");
            param.setFormId(bottom ? "tdm_ele_bottom_info" : "tdm_element_info");
            param.setStatus(OperationStatus.VIEW);
            if (bottom) {
                Date eleenddate;
                Date elestartdate = eleResult.getDate("elestartdate");
                if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                    elestartdate = DateUtils.getFirstDateOfMonth((Date)elestartdate);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)(eleenddate = eleResult.getDate("eleenddate")))) {
                    eleenddate = DateUtils.getLastDateOfMonth((Date)eleenddate);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                    customParams.put("sssjq", elestartdate);
                }
                if (EmptyCheckUtils.isNotEmpty((Object)eleenddate)) {
                    customParams.put("sssjz", eleenddate);
                }
            }
            customParams.put("caltype", this.getModel().getValue("caltype"));
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        }
    }
}

