/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tctrc.business.tdm.TdmElementGroupBusiness;
import kd.taxc.tctrc.business.tdm.TdmElementResultBusiness;
import kd.taxc.tctrc.common.element.ElementSqlService;
import kd.taxc.tctrc.common.element.Formula;
import kd.taxc.tctrc.common.element.RiskCalSerivce;
import kd.taxc.tctrc.common.element.TimeDeviatedEnum;
import kd.taxc.tctrc.common.util.BigDecimalUtil;
import kd.taxc.tctrc.common.util.DateUtils;
import kd.taxc.tctrc.common.util.ElementUtil;
import kd.taxc.tctrc.common.util.EmptyCheckUtils;
import kd.taxc.tctrc.common.util.StringUtil;
import kd.taxc.tctrc.formplugin.result.AbstractResultPlugin;

@Deprecated
public class FigureTargetResultPlugin
extends AbstractResultPlugin
implements RowClickEventListener,
ClickListener,
ListboxClickListener {
    private static final String KEY_TARGET_POIONTLINE = "targetpointline";
    private static final String KEY_ELEMENT_POIONTLINE = "elementpointline";
    private static final String ENTITY_RUN_RESULT = "tctrc_risk_run_result";
    private static final String FIELD_RISK = "risk";
    private static final String FIELD_ASSIGNORG = "assignorg";
    private static final String FIELD_RUNORG = "runorg";
    private static final String FIELD_PLANNUMBER = "plannumber";
    private static final String FIELD_RESULT = "result";
    private static final String RISK_LEVEL_CAL_ERROR = "4";
    private static final String FIELD_LISTBOX = "listboxap";
    private static final String KEY_DICENGFLEX = "dicengflex";
    private static final String KEY_FEIDICENGFLEX = "feidicengflex";
    private static final String ELEMENT_TYPE_1 = "1";
    private static final String TYPE_RATE = "2";
    private static final String BORDER_NO_INCLUDE = "1";
    private static final String BORDER_INCLUDE = "2";
    private static final Map<String, String> RISK_SHOW_COLOR = new HashMap<String, String>(){
        {
            this.put("0", "");
            this.put("1", "linear-gradient(90deg,rgba(255,125,120,0.1) 0%,rgba(255,125,120,0.5) 50%,rgba(255,125,120,0.1) 100%)");
            this.put("2", "linear-gradient(90deg,rgba(86,141,255,0.1) 0%,rgba(86,141,255,0.5) 50%,rgba(86,141,255,0.1) 100%)");
            this.put("3", "linear-gradient(90deg,rgba(19,199,245,0.1) 0%,rgba(19,199,245,0.5) 50%,rgba(19,199,245,0.1) 100%)");
        }
    };
    private static final String ELEMENT_NAME = "elementname";
    private static final String KEY_DEVIATIONTIME = "deviationtime";
    private static Log logger = LogFactory.getLog(FigureTargetResultPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("isfirst", "isfirst");
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isNotEmpty(map.get("isemptyfielderrormsg"))) {
            this.showMessage(this.getView(), String.valueOf(map.get("isemptyfielderrormsg")));
        } else if (EmptyCheckUtils.isNotEmpty(map.get("isdenominatorzeroerrormsg"))) {
            this.showMessage(this.getView(), String.valueOf(map.get("isdenominatorzeroerrormsg")));
        }
        this.getPageCache().remove("isfirst");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Refresh) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setPageId(this.getView().getPageId());
            formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(formShowParameter);
            args.setCancel(true);
        }
    }

    @Override
    protected void init(DynamicObject riskResultDynamicObject) {
        DynamicObject riskDefineDynamicObject = riskResultDynamicObject.getDynamicObject(FIELD_RISK);
        String orgid = riskResultDynamicObject.getString("runorg.id");
        Map<String, List> resultMap = this.getTargetForPeriod(riskDefineDynamicObject.getLong("id"), riskResultDynamicObject.getDynamicObject(FIELD_RUNORG).getLong("id"), riskResultDynamicObject.getString(FIELD_PLANNUMBER), riskResultDynamicObject.getDynamicObject(FIELD_ASSIGNORG).getLong("id"), riskResultDynamicObject.getString("caltype"), riskResultDynamicObject.getDate("startdate"), riskResultDynamicObject.getDate("enddate"));
        DynamicObjectCollection dys = riskDefineDynamicObject.getDynamicObjectCollection("entryentity");
        BigDecimal bmvalue = BigDecimal.ZERO;
        ArrayList<DynamicObject> pianchaList = null;
        if (EmptyCheckUtils.isNotEmpty((Object)dys)) {
            ArrayList<DynamicObject> defaultPianchaList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> customPianchaList = new ArrayList<DynamicObject>();
            for (DynamicObject riskDefinition : dys) {
                if (EmptyCheckUtils.isEmpty((Object)riskDefinition.get("itemid")) || "0".equals(riskDefinition.get("itemid")) || EmptyCheckUtils.isEmpty((Object)riskDefinition.get("orgs1"))) {
                    defaultPianchaList.add(riskDefinition);
                    continue;
                }
                if (String.valueOf(riskDefinition.get("orgs1")).indexOf(orgid) <= -1) continue;
                customPianchaList.add(riskDefinition);
            }
            ArrayList<DynamicObject> arrayList = pianchaList = EmptyCheckUtils.isEmpty(customPianchaList) ? defaultPianchaList : customPianchaList;
            if (EmptyCheckUtils.isNotEmpty(pianchaList)) {
                Object bmvalueTemp = ((DynamicObject)pianchaList.get(0)).get("bmvalue1");
                bmvalue = BigDecimalUtil.toBigDecimal((Object)bmvalueTemp).setScale(4);
            }
        }
        String riskName = riskDefineDynamicObject.getString("name");
        Object resultValue = riskResultDynamicObject.get(FIELD_RESULT);
        if (EmptyCheckUtils.isEmpty((Object)resultValue) || "null".equalsIgnoreCase(String.valueOf(resultValue))) {
            resultValue = null;
        }
        String rlevel = riskResultDynamicObject.getString("rlevel.id");
        this.initRiskLevelShow(bmvalue, resultValue, riskDefineDynamicObject, rlevel, pianchaList);
        boolean isRateDisplay = this.checkDisplayType(riskResultDynamicObject);
        this.initChart(resultMap, riskName, KEY_TARGET_POIONTLINE, isRateDisplay);
        this.getModel().setValue("throughtitle", (Object)riskName);
        this.initTargetThrough();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String keynew = (String)formShowParameter.getCustomParam("elementkey");
        HashMap<String, String> stylemap = new HashMap<String, String>(8);
        stylemap.put("bc", "#5582F3");
        stylemap.put("fc", "#FFFFFF");
        if (keynew != null) {
            this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
        }
        if (EmptyCheckUtils.isNotEmpty(formShowParameter.getCustomParams().get("relcaltips"))) {
            this.getView().showTipNotification(String.valueOf(formShowParameter.getCustomParams().get("relcaltips")));
        }
    }

    public String replace(String s) {
        if (null != s && s.indexOf(46) > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }

    private void initRiskLevelShow(BigDecimal bmvalue, Object resultValue, DynamicObject riskDefineDynamicObject, String riskLevel, List<DynamicObject> pianchaList) {
        String resultShow = riskDefineDynamicObject.getString("resultshow");
        if ("1".equals(resultShow)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"percentleft"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"percentright"});
            this.getModel().setValue("bmvalue", (Object)bmvalue);
            this.getModel().setValue("resultvalue", EmptyCheckUtils.isEmpty((Object)resultValue) ? this.getFormatNoValueString() : BigDecimalUtil.setScale((Object)resultValue, (int)4));
        } else {
            if (EmptyCheckUtils.isEmpty((Object)resultValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"percentleft"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"percentright"});
            this.getModel().setValue("bmvalue", (Object)bmvalue.multiply(BigDecimalUtil.toBigDecimal((Object)100)).setScale(2, 4));
            this.getModel().setValue("resultvalue", EmptyCheckUtils.isEmpty((Object)resultValue) ? this.getFormatNoValueString() : BigDecimalUtil.toBigDecimal((Object)resultValue).multiply(BigDecimalUtil.toBigDecimal((Object)100)).setScale(2, 4));
        }
        boolean isRisk = false;
        if (EmptyCheckUtils.isNotEmpty(pianchaList)) {
            this.getModel().deleteEntryData("entryrisk");
            for (DynamicObject dos : pianchaList) {
                HashMap<String, String> propertiesMap;
                String rangemaxString100;
                String rangemaxString;
                BigDecimal bigDecimalRange;
                String offsetResult = null;
                String offsetType = dos.getString("offset");
                String benchMarking = dos.getString("benchmarking1");
                double bmValue = BigDecimalUtil.toBigDecimal((Object)dos.get("bmvalue1")).doubleValue();
                int index = this.getModel().createNewEntryRow("entryrisk");
                String range = dos.getString("range");
                String rangemax = dos.getString("rangemax");
                if (range == null) {
                    range = "-\u221e";
                }
                if (rangemax == null) {
                    rangemax = "+\u221e";
                }
                range = RiskCalSerivce.getRangeValueString((String)range);
                rangemax = RiskCalSerivce.getRangeValueString((String)rangemax);
                String levelid = dos.getString("rlevel.id");
                String levelname = dos.getString("rlevel.name");
                this.getModel().setValue("grade", (Object)levelname, index);
                if ("2".equals(offsetType)) {
                    if ("1".equals(benchMarking)) {
                        offsetResult = EmptyCheckUtils.isEmpty((Object)resultValue) ? "null" : Double.valueOf((Double.parseDouble(String.valueOf(resultValue)) - bmValue) / bmValue * 100.0);
                    }
                } else if ("1".equals(benchMarking)) {
                    String string = offsetResult = EmptyCheckUtils.isEmpty((Object)resultValue) ? "null" : Double.valueOf(Double.parseDouble(String.valueOf(resultValue)) - bmValue);
                }
                BigDecimal bigDecimal = BigDecimalUtil.toBigDecimal((Object)range).compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0 ? BigDecimalUtil.toBigDecimal((Object)range) : (bigDecimalRange = "2".equals(offsetType) ? BigDecimalUtil.toBigDecimal((Object)range) : BigDecimal.valueOf(bmValue).add(BigDecimalUtil.toBigDecimal((Object)range)));
                BigDecimal bigDecimalRangemax = BigDecimalUtil.toBigDecimal((Object)rangemax).compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0 ? BigDecimalUtil.toBigDecimal((Object)rangemax) : ("2".equals(offsetType) ? BigDecimalUtil.toBigDecimal((Object)rangemax) : BigDecimal.valueOf(bmValue).add(BigDecimalUtil.toBigDecimal((Object)rangemax)));
                String rangeString = bigDecimalRange.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.replace(String.valueOf(bigDecimalRange));
                String string = rangemaxString = bigDecimalRangemax.compareTo(BigDecimal.ZERO) == 0 ? "0" : this.replace(String.valueOf(bigDecimalRangemax));
                if (bigDecimalRange.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0) {
                    rangeString = "-\u221e";
                }
                if (String.valueOf(Integer.MIN_VALUE).equals(range)) {
                    rangeString = "-\u221e";
                }
                if (bigDecimalRangemax.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0) {
                    rangemaxString = "+\u221e";
                }
                String rangeString100 = bigDecimalRange.compareTo(BigDecimal.ZERO) == 0 ? "0" : rangeString;
                String string2 = rangemaxString100 = bigDecimalRangemax.compareTo(BigDecimal.ZERO) == 0 ? "0" : rangemaxString;
                if (offsetType.equalsIgnoreCase("1")) {
                    rangeString100 = BigDecimalUtil.multiplyObject((Object)rangeString100, (Object)new BigDecimal(100), (int)2).toPlainString() + "%";
                    rangemaxString100 = BigDecimalUtil.multiplyObject((Object)rangemaxString100, (Object)new BigDecimal(100), (int)2).toPlainString() + "%";
                } else {
                    rangeString100 = rangeString100 + "%";
                    rangemaxString100 = rangemaxString100 + "%";
                }
                if (bigDecimalRange.compareTo(BigDecimal.valueOf(Integer.MIN_VALUE)) <= 0) {
                    rangeString100 = "-\u221e";
                }
                if (bigDecimalRangemax.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE)) >= 0) {
                    rangemaxString100 = "+\u221e";
                }
                if ("2".equals(resultShow)) {
                    this.getModel().setValue("range", (Object)rangeString100, index);
                    this.getModel().setValue("rangemax", (Object)rangemaxString100, index);
                } else {
                    if (StringUtil.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) {
                        this.getModel().setValue("range", (Object)rangeString, index);
                    } else {
                        this.getModel().setValue("range", (Object)BigDecimalUtil.setScale((Object)rangeString, (int)4), index);
                    }
                    if (StringUtil.equals((CharSequence)rangemaxString, (CharSequence)"+\u221e")) {
                        this.getModel().setValue("rangemax", (Object)rangemaxString, index);
                    } else {
                        this.getModel().setValue("rangemax", (Object)BigDecimalUtil.setScale((Object)rangemaxString, (int)4), index);
                    }
                }
                boolean isBigThanMinBorder = false;
                boolean isSmallThanMaxBorder = false;
                if (!isRisk) {
                    isRisk = EmptyCheckUtils.isEmpty((Object)offsetResult) || "null".equalsIgnoreCase(String.valueOf(offsetResult)) ? false : this.analyzeOffSetBorder(isRisk, dos, BigDecimalUtil.toBigDecimal((Object)offsetResult).doubleValue(), isBigThanMinBorder, isSmallThanMaxBorder);
                }
                if (isRisk && !RISK_LEVEL_CAL_ERROR.equals(riskLevel)) {
                    propertiesMap = new HashMap(16);
                    HashMap propertiesMap1 = new HashMap(16);
                    HashMap pmap = new HashMap(16);
                    propertiesMap.put("bgik", RISK_SHOW_COLOR.get(levelid));
                    pmap.put("cardentryflex", propertiesMap);
                    pmap.put("cardentryflexlevel", propertiesMap1);
                    pmap.put("cardentrylineleft", propertiesMap1);
                    pmap.put("cardentrylineright", propertiesMap1);
                    pmap.put("cardentryflexsmall", propertiesMap1);
                    pmap.put("cardentryflexbig", propertiesMap1);
                    ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                    client.invokeControlMethod("entryrisk", "setCustomProperties", new Object[]{index, pmap});
                    isRisk = false;
                    continue;
                }
                propertiesMap = new HashMap<String, String>(1);
                propertiesMap.put("bgik", "linear-gradient(90deg,rgba(198,207,226,0.1) 0%,rgba(198,207,226,0.5) 50%,rgba(198,207,226,0.1) 100%)");
                HashMap<String, HashMap<String, String>> pmap = new HashMap<String, HashMap<String, String>>(1);
                pmap.put("cardentryflex", propertiesMap);
                ClientViewProxy client = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
                client.invokeControlMethod("entryrisk", "setCustomProperties", new Object[]{index, pmap});
            }
        }
    }

    private boolean analyzeOffSetBorder(boolean isRisk, DynamicObject dos, double offsetResult, boolean isBigThanMinBorder, boolean isSmallThanMaxBorder) {
        String minBorder = dos.getString("minborder");
        double ranged = RiskCalSerivce.getRangeBigDecimal((String)dos.getString("range")).doubleValue();
        String rangeString = dos.getString("range");
        String maxBorder = dos.getString("maxborder");
        double rangeMax = RiskCalSerivce.getRangeBigDecimal((String)dos.getString("rangemax")).doubleValue();
        String rangeMaxString = dos.getString("rangemax");
        if ((offsetResult > ranged || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "1".equals(minBorder)) {
            isBigThanMinBorder = true;
        } else if ((offsetResult >= ranged || StringUtils.equals((CharSequence)rangeString, (CharSequence)"-\u221e")) && "2".equals(minBorder)) {
            isBigThanMinBorder = true;
        }
        if ((offsetResult < rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "1".equals(maxBorder)) {
            isSmallThanMaxBorder = true;
        } else if ((offsetResult <= rangeMax || StringUtils.equals((CharSequence)rangeMaxString, (CharSequence)"+\u221e")) && "2".equals(maxBorder)) {
            isSmallThanMaxBorder = true;
        }
        if (isBigThanMinBorder && isSmallThanMaxBorder) {
            isRisk = true;
        }
        return isRisk;
    }

    public boolean checkDisplayType(DynamicObject runResultDynamicObject) {
        boolean isRateDisplay = false;
        DynamicObject risk = runResultDynamicObject.getDynamicObject(FIELD_RISK);
        String displayType = risk.getString("resultshow");
        if ("2".equals(displayType)) {
            isRateDisplay = true;
        }
        return isRateDisplay;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox listboxap = (Listbox)this.getControl(FIELD_LISTBOX);
        listboxap.addListboxClickListener((ListboxClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Label button = (Label)this.getControl("eleinfolabel");
        button.addClickListener((ClickListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("eleinfolabel")) {
            FormShowParameter param = new FormShowParameter();
            String elementKey = this.getPageCache().get("elementkey");
            if (EmptyCheckUtils.isEmpty((Object)elementKey)) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                elementKey = (String)formShowParameter.getCustomParam("elementkey");
            }
            if (EmptyCheckUtils.isEmpty((Object)elementKey)) {
                return;
            }
            String[] elementKeyArr = elementKey.split("_&");
            String trueEleInfo = this.findTrueEleInfo(elementKeyArr[2]);
            String[] trueEleInfoArr = trueEleInfo.split("&&&");
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Object resultId = map.get("resultid");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(resultId, (String)ENTITY_RUN_RESULT);
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("number", trueEleInfoArr[0]);
            String orgid = ((DynamicObject)this.getModel().getValue(FIELD_RUNORG)).getString("id");
            customParams.put("orgid", orgid);
            customParams.put("sssjq", DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("startdate")));
            customParams.put("sssjz", DateUtils.getLastDateOfMonth((Date)dynamicObject.getDate("enddate")));
            customParams.put("runtime", dynamicObject.getDate("runtime"));
            customParams.put("eleval", trueEleInfoArr[1]);
            DynamicObject[] eles = TdmElementGroupBusiness.getTdmElementGroupDetails((QFilter)new QFilter("number", "=", (Object)trueEleInfoArr[0]));
            if (EmptyCheckUtils.isEmpty((Object)eles)) {
                return;
            }
            boolean bottom = eles[0].getBoolean("bottom");
            if (bottom) {
                QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
                QFilter usetype = new QFilter("usetype", "=", (Object)"0");
                QFilter element = new QFilter("element", "=", (Object)trueEleInfoArr[0]);
                QFilter startdata = new QFilter("startdata", "=", (Object)DateUtils.getFirstDateOfMonth((Date)dynamicObject.getDate("startdate")));
                QFilter enddata = new QFilter("enddata", "=", (Object)DateUtils.getLastDateOfMonth((Date)dynamicObject.getDate("enddate")));
                enddata.or(new QFilter("enddata", "=", (Object)dynamicObject.getDate("enddate")));
                DynamicObject[] tdm_element_results = TdmElementResultBusiness.getTdmElementResult((QFilter)qFilter.and(usetype).and(element).and(startdata).and(enddata));
                if (null != tdm_element_results && tdm_element_results.length > 0) {
                    Date eleenddate;
                    Date elestartdate = tdm_element_results[0].getDate("elestartdate");
                    if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                        elestartdate = DateUtils.getFirstDateOfMonth((Date)elestartdate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)(eleenddate = tdm_element_results[0].getDate("eleenddate")))) {
                        eleenddate = DateUtils.getLastDateOfMonth((Date)eleenddate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)elestartdate)) {
                        customParams.put("sssjq", elestartdate);
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)eleenddate)) {
                        customParams.put("sssjz", eleenddate);
                    }
                }
            }
            customParams.put("caltype", this.getModel().getValue("caltype"));
            param.setFormId(bottom ? "tdm_ele_bottom_info" : "tdm_element_info");
            param.setStatus(OperationStatus.VIEW);
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        } else if (source.getKey().startsWith("label_")) {
            String keynew = source.getKey();
            String keyold = this.getPageCache().get("elementkey");
            if (null == keyold) {
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                keyold = (String)formShowParameter.getCustomParam("elementkey");
            }
            this.getPageCache().put("elementkey", keynew);
            HashMap<String, String> stylemap1 = new HashMap<String, String>(8);
            stylemap1.put("bc", "#fff");
            stylemap1.put("fc", "#5E80EB");
            this.getView().updateControlMetadata(keyold.toLowerCase(), stylemap1);
            HashMap<String, String> stylemap = new HashMap<String, String>(8);
            stylemap.put("bc", "#5582F3");
            stylemap.put("fc", "#FFFFFF");
            if (keynew != null) {
                this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
            }
        }
    }

    private String findTrueEleInfo(String tempEleCode) {
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isEmpty(customMap.get("eletruekeys"))) {
            throw new KDBizException("unknow exception");
        }
        List trueKeys = (List)customMap.get("eletruekeys");
        return trueKeys.stream().filter(v -> {
            String[] arr = v.split("&&&");
            return arr[0].equalsIgnoreCase(tempEleCode);
        }).findFirst().get();
    }

    private Map<String, List> getTargetForPeriod(long risk, long runorg, String plannumber, long assignorg, String caltype, Date startDate, Date endDate) {
        String year;
        String[] timeStr;
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u65e5\u671f\u96c6\u5408\u3002");
        ArrayList<String> periodList = new ArrayList<String>();
        HashMap<String, List> mapResult = new HashMap<String, List>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        Date start = new Date();
        if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(caltype)) {
            calendar.add(2, -12);
            for (int i = 0; i < 12; ++i) {
                calendar.add(2, 1);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.formatMonth((Date)calendar.getTime());
                periodList.add(dd);
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(caltype)) {
            HashMap<String, String> quarterStr = new HashMap<String, String>(){
                {
                    this.put("01", "Q1");
                    this.put("02", "Q1");
                    this.put("03", "Q1");
                    this.put("04", "Q2");
                    this.put("05", "Q2");
                    this.put("06", "Q2");
                    this.put("07", "Q3");
                    this.put("08", "Q3");
                    this.put("09", "Q3");
                    this.put("10", "Q4");
                    this.put("11", "Q4");
                    this.put("12", "Q4");
                }
            };
            calendar.add(2, -12);
            for (int i = 0; i < 4; ++i) {
                calendar.add(2, 3);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                String[] timeStr2 = dd.split("-");
                String year2 = timeStr2[0];
                String month = timeStr2[1];
                periodList.add(year2 + "-" + (String)quarterStr.get(month));
            }
        } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(caltype)) {
            calendar.add(2, -12);
            for (int i = 0; i < 2; ++i) {
                calendar.add(2, 6);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                timeStr = dd.split("-");
                year = timeStr[0];
                String half = Integer.parseInt(timeStr[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"FigureTargetResultPlugin_15", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"FigureTargetResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year + half));
            }
        } else {
            calendar.add(1, -2);
            for (int i = 0; i < 2; ++i) {
                calendar.add(1, 1);
                if (i == 0) {
                    start = calendar.getTime();
                }
                String dd = DateUtils.format((Date)calendar.getTime());
                timeStr = dd.split("-");
                year = timeStr[0];
                periodList.add(String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year));
            }
        }
        QFilter qrisk = new QFilter(FIELD_RISK, "=", (Object)risk);
        QFilter qplannumber = new QFilter(FIELD_PLANNUMBER, "=", (Object)plannumber);
        QFilter qrunorg = new QFilter(FIELD_RUNORG, "=", (Object)runorg);
        QFilter qassignorg = new QFilter(FIELD_ASSIGNORG, "=", (Object)assignorg);
        QFilter qDate = new QFilter("startdate", ">=", (Object)start);
        QFilter enddata = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth((Date)endDate));
        QFilter qcaltype = new QFilter("caltype", "=", (Object)caltype);
        qDate.and(enddata);
        QFilter[] qcoll = new QFilter[]{qrisk, qplannumber, qrunorg, qassignorg, qDate, qcaltype};
        DynamicObject[] dArr = BusinessDataServiceHelper.load((String)ENTITY_RUN_RESULT, (String)"result,startdate,isemptyfield", (QFilter[])qcoll);
        HashMap<String, String> emptyFieldMap = new HashMap<String, String>(dArr.length);
        HashMap<String, String> map = new HashMap<String, String>(dArr.length);
        for (DynamicObject d : dArr) {
            String year3;
            String[] timeStr3;
            String dateStr = DateUtils.format((Date)d.getDate("startdate"));
            if (TimeDeviatedEnum.TIME_DEVIATION_MONTH.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                String month = timeStr3[1];
                dateStr = year3 + "-" + month;
            } else if (TimeDeviatedEnum.TIME_DEVIATION_SEASON.getDeviatedType().equals(caltype)) {
                HashMap<String, String> quarterStr = new HashMap<String, String>(){
                    {
                        this.put("01", "Q1");
                        this.put("04", "Q2");
                        this.put("07", "Q3");
                        this.put("10", "Q4");
                    }
                };
                String[] timeStr4 = dateStr.split("-");
                String year4 = timeStr4[0];
                String month = timeStr4[1];
                dateStr = year4 + "-" + (String)quarterStr.get(month);
            } else if (TimeDeviatedEnum.TIME_DEVIATION_HALF_YEAR.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                String half = Integer.parseInt(timeStr3[1]) >= 7 ? ResManager.loadKDString((String)"\u4e0b\u534a", (String)"FigureTargetResultPlugin_15", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0a\u534a", (String)"FigureTargetResultPlugin_16", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]);
                dateStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year3 + half);
            } else if (TimeDeviatedEnum.TIME_DEVIATION_YEAR.getDeviatedType().equals(caltype)) {
                timeStr3 = dateStr.split("-");
                year3 = timeStr3[0];
                dateStr = String.format(ResManager.loadKDString((String)"%s\u5e74", (String)"FigureTargetResultPlugin_6", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), year3);
            }
            logger.info("dateStr:" + dateStr + ",result:" + d.getString(FIELD_RESULT) + ",isemptyfield\uff1a" + d.getString("isemptyfield"));
            map.put(dateStr, d.getString(FIELD_RESULT));
            emptyFieldMap.put(dateStr, d.getString("isemptyfield"));
        }
        ArrayList<BigDecimal> resultList = new ArrayList<BigDecimal>(periodList.size());
        ArrayList<String> isEmptyFieldList = new ArrayList<String>(periodList.size());
        for (String period : periodList) {
            String val = (String)map.get(period);
            String isEmptyFiled = (String)emptyFieldMap.get(period);
            resultList.add(BigDecimalUtil.toBigDecimal((Object)val).setScale(4, 4));
            isEmptyFieldList.add(isEmptyFiled);
        }
        mapResult.put("period", periodList);
        mapResult.put(FIELD_RESULT, resultList);
        mapResult.put("isEmptyField", isEmptyFieldList);
        logger.info("\u7ed3\u675f\u8ba1\u7b97\u65e5\u671f\u96c6\u5408\u3002getTargetForPeriod()");
        return mapResult;
    }

    private static int getDiffMonths(Date startDate, Date endDate, Date riskStart) {
        return FigureTargetResultPlugin.getDiffMonths(startDate, endDate, riskStart, false);
    }

    private void displayElementAndChart(Map<String, List> resultMap, String eleName, String control, String eleCode, String desc, int month, Map map) {
        if (null == desc || desc.isEmpty()) {
            this.getModel().setValue("elementdesc", (Object)ELEMENT_DESC_NO);
        } else {
            this.getModel().setValue("elementdesc", (Object)desc);
        }
        Label label1 = (Label)this.getView().getControl(KEY_DEVIATIONTIME);
        if (0 > month) {
            label1.setText(String.format(ResManager.loadKDString((String)"(\u6b64\u5143\u7d20\u7684\u53d6\u503c\u5411\u524d\u504f\u79fb%s\u4e2a\u6708)", (String)"FigureTargetResultPlugin_9", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Math.abs(month)));
        } else if (0 < month) {
            label1.setText(String.format(ResManager.loadKDString((String)"(\u6b64\u5143\u7d20\u7684\u53d6\u503c\u5411\u540e\u504f\u79fb%\u4e2a\u6708)", (String)"FigureTargetResultPlugin_18", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]), Math.abs(month)));
        } else {
            label1.setText("");
        }
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get("isfirst")) && ("true".equals(map.get("isEmptyField")) || "true".equals(map.get("isDenominatorZero")))) {
            this.showMessage(this.getView());
        }
        Label label = (Label)this.getView().getControl(ELEMENT_NAME);
        label.setText(eleName);
        QFilter qFilter = new QFilter("number", "=", (Object)eleCode);
        DynamicObject dynamicObject = TdmElementGroupBusiness.getTdmElementGroupSingleBus((QFilter)qFilter);
        if (null != dynamicObject) {
            boolean isScale = dynamicObject.getBoolean("typevalue");
            this.initChart(resultMap, eleName, control, isScale);
        }
    }

    public void listboxClick(ListboxEvent event) {
        this.selectListBoxFlex(event.getItemId());
    }

    private static int getDiffMonths(Date startDate, Date endDate, Date riskStart, boolean deviation) {
        if (deviation) {
            return (startDate.getYear() - riskStart.getYear()) * 12 + (startDate.getMonth() - riskStart.getMonth());
        }
        return 0;
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.initTargetThroughFormula(e);
    }

    private void initTargetThroughFormula(LoadCustomControlMetasArgs e) {
        String jsonHistory;
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        Map customerParam = formParamter.getCustomParams();
        Object result = customerParam.get("resultid");
        if (result == null) {
            return;
        }
        long resultId = (Long)result;
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)resultId, (String)ENTITY_RUN_RESULT);
        Date lastRunTime = dynamicObject.getDate("runtime");
        DynamicObject riskObject = dynamicObject.getDynamicObject(FIELD_RISK);
        String riskCode = riskObject.getString("number");
        String riskName = riskObject.getString("name");
        Date riskModifyTime = riskObject.getDate("modifytime");
        String jsonNew = riskObject.getString("json");
        if (null != riskModifyTime && riskModifyTime.compareTo(lastRunTime) > 0) {
            formParamter.setCustomParam("relcaltips", (Object)ResManager.loadKDString((String)"\u98ce\u9669\u5b9a\u4e49\u6709\u6539\u53d8\uff0c\u5efa\u8bae\u91cd\u65b0\u8ba1\u7b97\u8fd9\u6761\u98ce\u9669\u7ed3\u679c\u3002", (String)"FigureTargetResultPlugin_17", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
        }
        String json = EmptyCheckUtils.isEmpty((Object)(jsonHistory = dynamicObject.getString("json"))) ? jsonNew : jsonHistory;
        String type0 = "0";
        Date startdate = dynamicObject.getDate("startdate");
        Date enddate = dynamicObject.getDate("enddate");
        formParamter.setCustomParam("startdate", (Object)startdate);
        formParamter.setCustomParam("enddate", (Object)enddate);
        String orgid = dynamicObject.getDynamicObject(FIELD_RUNORG).getString("id");
        logger.info("startdate:" + startdate + ",enddate:" + enddate + ",riskCode:" + riskCode + ",type:" + type0 + ",orgid:" + orgid);
        Map code2EleInfoMap = ElementSqlService.queryAllEnableEleInfoMap();
        List formulasNo = RiskCalSerivce.queryFormula((String)json, (String)type0, (Date)startdate, (Date)enddate, (String)orgid, (Map)code2EleInfoMap);
        this.showErrorMsg(formulasNo, json, formParamter);
        formulasNo.forEach(formula -> logger.info("startdate:" + formula.getStartDate() + ""));
        try {
            formParamter.setCustomParam("formulasNo", (Object)SerializationUtils.toJsonString((Object)formulasNo));
        }
        catch (Exception e1) {
            logger.error("formulasNo\u516c\u5f0f\u8f6c\u6362\u51fa\u9519\u3002", (Throwable)e1);
        }
        String type1 = "1";
        logger.info("startdate:" + startdate + ",enddate:" + enddate + ",riskCode:" + riskCode + ",type:" + type1 + ",orgid:" + orgid);
        List formulas = RiskCalSerivce.queryFormula((String)json, (String)type1, (Date)startdate, (Date)enddate, (String)orgid, (Map)code2EleInfoMap);
        try {
            formParamter.setCustomParam("formulas", (Object)SerializationUtils.toJsonString((Object)formulas));
        }
        catch (Exception e1) {
            logger.error("formulas\u516c\u5f0f\u8f6c\u6362\u51fa\u9519\u3002", (Throwable)e1);
        }
        int i = 2;
        for (Formula f : formulas) {
            if ("1".equals(f.getType())) {
                formParamter.setCustomParam("eleName", (Object)f.getName());
                formParamter.setCustomParam("eleNumber", (Object)f.getCode());
                formParamter.setCustomParam("elementdesc", (Object)f.getDescribe());
                String keynew = "label_&bottom_&" + f.getCode() + "_&" + i;
                formParamter.setCustomParam("elementkey", (Object)keynew);
                break;
            }
            ++i;
        }
        this.setFormula(e, formulasNo, KEY_FEIDICENGFLEX, riskName, code2EleInfoMap);
        this.setFormula(e, formulas, KEY_DICENGFLEX, riskName, code2EleInfoMap);
    }

    private void showErrorMsg(List<Formula> formulasNo, String json, FormShowParameter formParamter) {
        Boolean isEmptyField = Boolean.TRUE;
        for (Formula formula : formulasNo) {
            if ("1".equalsIgnoreCase(formula.getType())) {
                json = ElementUtil.replaceContentToValue((String)json, (Formula)formula);
                if (!"false".equalsIgnoreCase(formula.getIsEmptyField())) continue;
                isEmptyField = Boolean.FALSE;
                continue;
            }
            if (!"3".equalsIgnoreCase(formula.getType())) continue;
            isEmptyField = Boolean.FALSE;
        }
        if (isEmptyField.booleanValue()) {
            formParamter.getCustomParams().put("isemptyfielderrormsg", this.getCalNoValueMessage());
        } else {
            String json2 = json.replaceAll("null", "0");
            Boolean isDenominatorZero = RiskCalSerivce.isDenominatorZero((String)json2);
            if (isDenominatorZero.booleanValue()) {
                formParamter.getCustomParams().put("isdenominatorzeroerrormsg", this.getCalNoValueMessage());
            }
        }
    }

    private void setFormula(LoadCustomControlMetasArgs e, List<Formula> formulas, String keyDicengflex, String riskName, Map<String, DynamicObject> code2EleInfoMap) {
        boolean isBottom = KEY_DICENGFLEX.equals(keyDicengflex);
        this.addFormula(formulas, riskName);
        FlexPanelAp flex = this.createElementLabels(riskName, formulas, e, isBottom, code2EleInfoMap);
        HashMap<String, Object> mapHead = new HashMap<String, Object>();
        ArrayList entryFlexCollectionList = new ArrayList();
        Collection firstCollection = (Collection)flex.createControl().get("items");
        entryFlexCollectionList.addAll(firstCollection);
        mapHead.put("id", keyDicengflex);
        mapHead.put("items", entryFlexCollectionList);
        e.getItems().add(mapHead);
    }

    private void addFormula(List<Formula> formulas, String riskName) {
        Formula jiahaoformula = new Formula("0", "=");
        formulas.add(0, jiahaoformula);
        Formula quotaformula = new Formula("0", riskName);
        formulas.add(0, quotaformula);
    }

    private void initTargetThrough() {
        Listbox listboxap = (Listbox)this.getControl(FIELD_LISTBOX);
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>();
        items.add(new ListboxItem(KEY_DICENGFLEX, ResManager.loadKDString((String)"\u5e95\u5c42\u5143\u7d20", (String)"FigureTargetResultPlugin_7", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        items.add(new ListboxItem(KEY_FEIDICENGFLEX, ResManager.loadKDString((String)"\u975e\u5e95\u5c42\u5143\u7d20", (String)"FigureTargetResultPlugin_8", (String)"taxc-tctrc-formplugin", (Object[])new Object[0])));
        listboxap.addItems(items);
        this.selectListBoxFlex(KEY_DICENGFLEX);
        long orgid = ((DynamicObject)this.getModel().getValue(FIELD_RUNORG)).getLong("id");
        Map customMap = this.getView().getFormShowParameter().getCustomParams();
        String elementCode = (String)customMap.get("eleNumber");
        String caltype = (String)this.getModel().getValue("caltype");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String elementKey = (String)customMap.get("elementkey");
        int eleIndex = 0;
        if (null != elementKey && !elementKey.isEmpty()) {
            eleIndex = Integer.parseInt(elementKey.split("_&")[3]);
        }
        List list = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("formulas")), List.class);
        int ii = 0;
        for (Map map : list) {
            if (eleIndex == ii && "1".equals(map.get("type")) && elementCode.equals(map.get("code"))) {
                Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("startDate"))));
                Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("endDate"))));
                String eleName = (String)map.get("name");
                Date riskStart = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
                int months = FigureTargetResultPlugin.getDiffMonths(startDate, endDate, riskStart);
                Map<String, List> resultMap = this.getElementsByPeriod(orgid, elementCode, caltype, startDate, endDate, months);
                String eleDesc = (String)customMap.get("elementdesc");
                this.displayElementAndChart(resultMap, eleName, KEY_ELEMENT_POIONTLINE, elementCode, eleDesc, months, map);
                break;
            }
            ++ii;
        }
    }

    protected FlexPanelAp createElementLabels(String flexkey, List<Formula> formulas, LoadCustomControlMetasArgs e, boolean isBottom, Map<String, DynamicObject> code2EleInfoMap) {
        List eleTrueKeys2;
        List listKeys;
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(flexkey);
        ArrayList<String> elementKeys = new ArrayList<String>();
        ArrayList<String> eleTrueKeys = new ArrayList<String>(10);
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        if (formulas != null && formulas.size() != 0) {
            for (int i = 0; i < formulas.size(); ++i) {
                Formula formula = formulas.get(i);
                boolean clickable = formula.getType().equals("1");
                String keys = this.createElementLableKey(formula, i, isBottom);
                StringBuilder value = new StringBuilder();
                String elementNumber = formula.getCode();
                DynamicObject element = code2EleInfoMap.get(elementNumber);
                boolean isRateTypeElement = false;
                if (element != null) {
                    isRateTypeElement = element.getBoolean("typevalue");
                }
                if ("true".equals(formulas.get(i).getIsEmptyField()) || "true".equals(formulas.get(i).getIsDenominatorZero())) {
                    value.append(this.getFormatNoValueString());
                } else {
                    BigDecimal decimal = BigDecimalUtil.toBigDecimal((Object)formulas.get(i).getValue());
                    if (isRateTypeElement && !isBottom) {
                        value.append(decimal.multiply(new BigDecimal("100")).setScale(2)).append('%');
                    } else {
                        value.append(BigDecimalUtil.setScale((Object)decimal, (int)4));
                    }
                }
                LabelAp label = this.createLabel(keys, StringUtils.trim((String)formulas.get(i).getName()), value.toString(), clickable);
                flex.getItems().add(label);
                elementKeys.add(keys);
                eleTrueKeys.add(elementNumber + "&&&" + value);
            }
        }
        if (null != (listKeys = (List)formParamter.getCustomParam("elementKeys"))) {
            elementKeys.addAll(listKeys);
        }
        if (null != (eleTrueKeys2 = (List)formParamter.getCustomParam("eletruekeys"))) {
            eleTrueKeys.addAll(eleTrueKeys2);
        }
        formParamter.setCustomParam("eletruekeys", eleTrueKeys);
        formParamter.setCustomParam("elementKeys", elementKeys);
        return flex;
    }

    private void selectListBoxFlex(String itemId) {
        String keyold;
        List list;
        this.getPageCache().put("listBoxId", itemId);
        long orgid = ((DynamicObject)this.getModel().getValue(FIELD_RUNORG)).getLong("id");
        String caltype = (String)this.getModel().getValue("caltype");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (itemId.equals(KEY_DICENGFLEX)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_DICENGFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_FEIDICENGFLEX});
            list = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("formulas")), List.class);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_DICENGFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_FEIDICENGFLEX});
            list = (List)SerializationUtils.fromJsonString((String)((String)customParams.get("formulasNo")), List.class);
        }
        int i = 2;
        FormShowParameter formParamter = this.getView().getFormShowParameter();
        String keynew = "";
        for (Map map : list) {
            if ("1".equals(map.get("type"))) {
                String eleDesc = (String)map.get("describe");
                String elementCode = (String)map.get("code");
                String riskName = (String)map.get("name");
                String bottomStr = itemId.equals(KEY_DICENGFLEX) ? "bottom_&" : "bottomno_&";
                keynew = "label_&" + bottomStr + elementCode + "_&" + i;
                Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("startDate"))));
                Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("endDate"))));
                Date riskStart = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
                int months = FigureTargetResultPlugin.getDiffMonths(startDate, endDate, riskStart);
                Map<String, List> resultMap = this.getElementsByPeriod(orgid, elementCode, caltype, startDate, endDate, months);
                this.displayElementAndChart(resultMap, riskName, KEY_ELEMENT_POIONTLINE, elementCode, eleDesc, months, map);
                break;
            }
            ++i;
        }
        if (null == (keyold = this.getPageCache().get("elementkey"))) {
            keyold = (String)formParamter.getCustomParam("elementkey");
        }
        this.getPageCache().put("elementkey", keynew);
        HashMap<String, String> stylemap1 = new HashMap<String, String>(8);
        stylemap1.put("bc", "#fff");
        stylemap1.put("fc", "#5E80EB");
        if (keyold != null) {
            this.getView().updateControlMetadata(keyold.toLowerCase(), stylemap1);
        }
        HashMap<String, String> stylemap = new HashMap<String, String>(8);
        stylemap.put("bc", "#5582F3");
        stylemap.put("fc", "#FFFFFF");
        this.getView().updateControlMetadata(keynew.toLowerCase(), stylemap);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.startsWith("label_")) {
            Label button = new Label();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
            long orgid = ((DynamicObject)this.getModel().getValue(FIELD_RUNORG)).getLong("id");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            List elementKeys = (List)customParams.get("elementKeys");
            String elementCode = "";
            int eleIndex = 0;
            for (String str : elementKeys) {
                if (!str.equalsIgnoreCase(key)) continue;
                elementCode = str.split("_&")[2];
                eleIndex = Integer.parseInt(str.split("_&")[3]);
                break;
            }
            String listBoxId = this.getPageCache().get("listBoxId");
            List list = new ArrayList();
            list = KEY_DICENGFLEX.equals(listBoxId) ? (List)SerializationUtils.fromJsonString((String)((String)customParams.get("formulas")), List.class) : (List)SerializationUtils.fromJsonString((String)((String)customParams.get("formulasNo")), List.class);
            int ii = 0;
            for (Map map : list) {
                if (eleIndex - 2 == ii && "1".equals(map.get("type")) && elementCode.equals(map.get("code"))) {
                    String desc = (String)map.get("describe");
                    Label label = (Label)this.getView().getControl(ELEMENT_NAME);
                    String eleName = (String)map.get("name");
                    label.setText(eleName);
                    Date startDate = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("startDate"))));
                    Date endDate = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)((String)map.get("endDate"))));
                    Date riskStart = DateUtils.stringToDate((String)((String)customParams.get("startdate")));
                    int months = FigureTargetResultPlugin.getDiffMonths(startDate, endDate, riskStart);
                    String caltype = (String)this.getModel().getValue("caltype");
                    Map<String, List> resultMap = this.getElementsByPeriod(orgid, elementCode, caltype, startDate, endDate, months);
                    this.displayElementAndChart(resultMap, eleName, KEY_ELEMENT_POIONTLINE, elementCode, desc, months, map);
                    break;
                }
                ++ii;
            }
        }
    }
}

