/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tctrc.formplugin.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class RiskCollectExplainPlugin
extends AbstractFormPlugin {
    private static final String COLLECT_ID = "collectId";
    private static final String ENTITY = "tctrc_collect_explain";
    private static final String HAS_COLLECTED = "1";
    public static final String RISK_BASE_DATA = "risk";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String riskId = (String)customParams.get("riskId");
        String riskName = (String)customParams.get("riskName");
        String collectId = (String)customParams.get(COLLECT_ID);
        this.getPageCache().put(COLLECT_ID, collectId);
        this.getModel().setValue(RISK_BASE_DATA, (Object)riskId);
        this.getModel().setValue("riskname", (Object)riskName);
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        String id = this.getPageCache().get(COLLECT_ID);
        if ("save".equals(key)) {
            DynamicObject dynamicObject = null;
            dynamicObject = null != id ? BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY) : BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            dynamicObject.set(RISK_BASE_DATA, this.getModel().getValue(RISK_BASE_DATA));
            dynamicObject.set("riskname", this.getModel().getValue("riskname"));
            dynamicObject.set("collectexplain", this.getModel().getValue("collectexplain"));
            dynamicObject.set("user", (Object)RequestContext.get().getUserId());
            dynamicObject.set("time", (Object)new Date());
            DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
            DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u85cf\u6210\u529f\u3002", (String)"RiskCollectExplainPlugin_0", (String)"taxc-tctrc-formplugin", (Object[])new Object[0]));
            String collectId = String.valueOf(result[0].getString("id"));
            this.getView().returnDataToParent((Object)collectId);
            DynamicObject riskDynamicObject = (DynamicObject)this.getModel().getValue(RISK_BASE_DATA);
            if (riskDynamicObject != null) {
                long riskId = riskDynamicObject.getLong("id");
                DynamicObject riskDefineDynamicObject = BusinessDataServiceHelper.loadSingle((Object)riskId, (String)"tctrc_risk_definition");
                riskDefineDynamicObject.set("collect", (Object)HAS_COLLECTED);
                DynamicObject[] riskDefineDynamicObjects = new DynamicObject[]{riskDefineDynamicObject};
                SaveServiceHelper.save((DynamicObject[])riskDefineDynamicObjects);
                QFilter riskIdFilter = new QFilter("risk.id", "=", (Object)riskId);
                this.updateCollectStatus("tctrc_risk_run_result", riskIdFilter);
                this.updateCollectStatus("tctrc_risk_run_list", riskIdFilter);
            }
            this.getView().close();
        }
    }

    public void updateCollectStatus(String entity, QFilter riskIdFilter) {
        DynamicObjectCollection riskResultCollection = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{riskIdFilter});
        ArrayList idList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)riskResultCollection)) {
            riskResultCollection.forEach(r -> idList.add(r.getString("id")));
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])idList.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()).toArray(), (DynamicObjectType)mainEntityType);
        Arrays.stream(objects).forEach(d -> d.set("collect", (Object)HAS_COLLECTED));
        SaveServiceHelper.save((DynamicObject[])objects);
    }
}

